<?php
class AdministratorsController extends AppController
{
	public $uses = array();

	public function beforeFilter()
	{
		parent::beforeFilter();
		$this->Auth->allow('register');
	}

	public function login()
	{
		if ($this->request->is('post'))
		{
			if ($this->Auth->login())
			{
				$this->redirect($this->Auth->redirect());
			}
			else
			{
				$this->Session->setFlash(__('Invalid username or password, try again'), 'flash_fail');
				$this->request->data['Administrator']['password'] = null;
			}
		}
	}


	public function logout()
	{
		$this->redirect($this->Auth->logout());
	}

	public function register()
    {
        if ($this->request->is('post'))
        {
            $this->Administrator->create();

            if ($this->Administrator->save($this->request->data))
            {
                $this->Session->setFlash(__('The user has been saved'),'flash_success');
                $this->redirect(array('controller' => 'pages','action' => 'home'));
            }
            else
            {
                // Create a loop with validation errors
                $this->Error->set( $this->Administrator->invalidFields() );
            }
        }
    }

	public function report($month = null)
	{
		if (is_null($month))
		{
			$month = date('F Y');
		}

	    $this->loadModel('User');
		$users = $this->User->report($month);

		// For dropdown
		$fields = array("DISTINCT DATE_FORMAT(time_in, '%M %Y') as report_date");
		$conditions = array('YEAR(time_in) > 2011');
		$group = array('report_date');
		$order = array('time_in');
		$months = Hash::extract($this->User->find('all', compact('fields', 'conditions', 'group', 'order')), '{n}.0.report_date');
		$report_months = array_combine($months, $months);

		$this->set(compact('users', 'month', 'report_months'));
	}

	/**
	 * index method
	 *
	 * @return void
	 */
	public function comments() {
		$this->loadModel('Comment');
		$this->Comment->recursive = 0;
		$this->set('comments', $this->paginate('Comment'));
	}


}