<?php
App::uses('AppController', 'Controller');
/**
 * Comments Controller
 *
 * @property Comment $Comment
 */
class CommentsController extends AppController {

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->Comment->create();
			if ($this->Comment->save($this->request->data)) {
				$this->Session->setFlash(__('Your comment has been submitted'), 'flash_success');
				$this->redirect('/');
			} else {
				$this->Session->setFlash(__('The comment could not be saved. Please, try again.'), 'flash_fail');
			}
		}
	}

/**
 * delete method
 *
 * @throws MethodNotAllowedException
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function delete($id = null) {
		if (!$this->request->is('post')) {
			throw new MethodNotAllowedException();
		}
		$this->Comment->id = $id;
		if (!$this->Comment->exists()) {
			throw new NotFoundException(__('Invalid comment'));
		}
		if ($this->Comment->delete()) {
			$this->Session->setFlash(__('Comment #%s deleted', $id), 'flash_success');
			return $this->redirect(array('controller' => 'administrators', 'action' => 'comments'));
		}
		$this->Session->setFlash(__('Comment was not deleted'), 'flash_fail');
		return $this->redirect(array('controller' => 'administrators', 'action' => 'comments'));
	}

}
