<?php 
class UsersController extends AppController
{

  public function beforeFilter()
  {
    parent::beforeFilter();
    $this->Auth->allow();
  }
	
  public function checkin()
  {
    if ($this->request->is('post')) 
    {
      $this->User->create();

      if ($this->User->save($this->request->data)) 
      {
        $this->Session->setFlash(__('You have signed in.'), 'flash_success');
        $this->redirect(array('controller' => 'pages', 'action' => 'home'));
      } 
      else 
      {   
        // Create a loop with validation errors
        $this->Error->set( $this->User->invalidFields() );
      }
    }
  }

  public function checkout($id = null)
  {
    $this->User->id = $id;
    if (!$this->User->exists()) 
    {
      throw new NotFoundException(__('Invalid volunteer/visitor log entry'));
    }

    if ($this->request->is('post'))
    {
      if ($this->User->save($this->request->data)) 
      {
        $this->Session->setFlash(__('You have signed out.'), 'flash_success');
        $this->redirect(array('controller' => 'pages', 'action' => 'home'));
      } 
      else 
      {   
        // Create a loop with validation errors
        $this->Error->set( $this->User->invalidFields() );
        return $this->redirect(array('action' => 'checkout_list'));
      }

    }
  }

  public function checkout_list()
  {
    $this->paginate = array('order' => 'time_in', 'conditions' => array("User.time_out IS NULL", "DATE(time_in) = DATE(NOW())"));
    $this->set('users', $this->paginate());
  }

  public function lookup($query=null)
  {
    $this->viewClass = 'Json';

    $fields = array('DISTINCT User.name');
    //$conditions = array("User.time_out IS NULL", "User.name LIKE '%$query%'");
    $conditions = array("User.name LIKE '$query%'");
    $data = $this->User->find('all', compact('fields', 'conditions'));
    $users = array();
    $names = Hash::extract($data, '{n}.User.name');
    foreach ($data as $user)
    {
      $u = $user['User'];
      $users[$u['name']] = str_replace($query, "<b>$query</b>", $u['name']);
    }

    $this->set(compact('users', 'names'));
    $this->set('_serialize', array('users', 'names'));
  }

  
  public function view($id = null) 
  {
    $this->User->id = $id;

    if (!$this->User->exists()) 
    {
      throw new NotFoundException(__('Invalid user'));
    }

    $this->set('user', $this->User->read(null, $id));
  }	


  public function edit($id = null) 
  {
    $this->User->id = $id;

    if (!$this->User->exists()) 
    {
      throw new NotFoundException(__('Invalid user'));
    }

    $user = $this->User->findById( $id );
    $this->set('user',$user);

    if ($this->request->is('post') || $this->request->is('put')) 
    {
      if( empty($this->request->data['User']['password']) )
      {
        unset($this->request->data['User']['password']);
      }

      if ($this->User->save($this->request->data)) 
      {
        $this->Session->setFlash(__('The user has been saved'),'flash_success');
        $this->redirect(array('action' => 'home'));
      } 
      else 
      {
        $this->Session->setFlash(__('The user could not be saved. Please, try again.'),'flash_fail');
      }
    } 
    else 
    {
      $this->request->data = $this->User->read(null, $id);
      unset($this->request->data['User']['password']);
    }
  }	

  public function delete($id = null) 
  {
    $this->User->id = $id;

    if (!$this->User->exists()) 
    {
      throw new NotFoundException(__('Invalid user'));
    }

    if ($this->User->delete()) 
    {
      $this->Session->setFlash(__('User deleted'),'flash_success');
      $this->redirect(array('action' => 'home'));
    }

    $this->Session->setFlash(__('User was not deleted'),'flash_fail');

    $this->redirect(array('action' => 'home'));
  }    
  
}
