<?php
App::uses('AuthComponent', 'Controller/Component');

class User extends AppModel
{
  public $name = 'User';

  public $validate = array(
    'name' => array(
      array(
        'rule' => array('notEmpty'),
        'message' => 'Your name is required.'
        ),
      ),
    'visit_type' => array(
      array(
        'rule' => array('notEmpty'),
        'message' => 'Visit type is required.'
        ),
      ),
    'start_date' => array(
      array(
        'rule' => array('notEmpty'),
        'message' => 'The date is required.'
        ),
      ),
    'time_in' => array(
      array(
        'rule' => array('notEmpty'),
        'message' => 'The time in is required.'
        ),
      ),
    'time_out' => array(
      array(
        'rule' => array('afterTimeIn'),
        'message' => 'The time out must be after time in.'
        ),
      ),
    );

  public function afterTimeIn($check)
  {
    $time_in = $this->field('time_in');
    return strtotime($time_in) <= strtotime($check['time_out']);
  }

  public function beforeSave()
  {
    if (isset($this->data[$this->alias]['time_in']))
    {
      $this->data[$this->alias]['time_in'] = date('c', strtotime(sprintf('%s %s', $this->data[$this->alias]['start_date'], $this->data[$this->alias]['time_in'])));
    }
    if (isset($this->data[$this->alias]['time_out']))
    {
      $this->data[$this->alias]['time_out'] = date('c', strtotime(sprintf('%s %s', date('M d, Y'), $this->data[$this->alias]['time_out'])));
    }
    return true;
  }

  public function report($date)
  {
    // Temporary field
    $this->virtualFields['minutes'] = 0;
    $this->virtualFields['cnt'] = 0;

    $fields = array(
      'User.name',
      'User.visit_type',
      'SUM(IF(User.time_out IS NULL OR User.time_in > User.time_out, 120, TIMESTAMPDIFF(MINUTE, User.time_in, User.time_out))) AS User__minutes',
      'COUNT(*) AS User__cnt'
    );
    $group = array(
      'User.visit_type',
      'User.name',
    );
    $conditions = array(
      "DATE_FORMAT(time_in, '%M %Y')" => $date,
    );
    $users = $this->find('all', compact('fields', 'conditions', 'group'));
    $results = array();

    foreach ($users as $user)
    {
      $results[$user['User']['visit_type']][] = $user;
    }

    return $results;
  }


}
