<div class="row-fluid">
<div class="comments index">
	<h2><?php echo __('Comments'); ?></h2>
	<table class="table table-bordered table-condensed table-hover">
	<thead>
	<tr>
			<th><?php echo $this->Paginator->sort('id'); ?></th>
			<th><?php echo $this->Paginator->sort('name'); ?></th>
			<th><?php echo $this->Paginator->sort('subject'); ?></th>
			<th><?php echo $this->Paginator->sort('comment'); ?></th>
			<th><?php echo $this->Paginator->sort('created'); ?></th>
			<th>Delete</th>
	</tr>
	</thead>
	<?php
	foreach ($comments as $comment): ?>
	<tr>
		<td><?php echo h($comment['Comment']['id']); ?>&nbsp;</td>
		<td><?php echo h($comment['Comment']['name']); ?>&nbsp;</td>
		<td><?php echo h($comment['Comment']['subject']); ?>&nbsp;</td>
		<td><?php echo h($comment['Comment']['comment']); ?>&nbsp;</td>
		<td><?php echo $this->Time->timeAgoInWords($comment['Comment']['created'], array('format' => 'F j, Y H:i A')); ?>&nbsp;</td>
		<td><?php echo $this->Form->postLink('Delete', array('controller' => 'comments', 'action' => 'delete', $comment['Comment']['id']), null, __('Are you sure you want to delete comment #%s?', $comment['Comment']['id'])); ?></td>
	</tr>
<?php endforeach; ?>
	</table>
	<p>
	<?php
	echo $this->Paginator->counter(array(
	'format' => __('Page {:page} of {:pages}, showing {:current} records out of {:count} total, starting on record {:start}, ending on {:end}')
	));
	?>	</p>

	<div class="pagination">
	<?php
		echo $this->Paginator->prev('«', array('tag' => 'li'), null, array('class' => 'prev disabled'));
		echo $this->Paginator->numbers(array('separator' => '', 'tag' => 'li', 'currentClass' => 'active'));
		echo $this->Paginator->next('»', array('tag' => 'li'), null, array('class' => 'next disabled'));
	?>
	</div>
</div>
</div>