<?php $months = array(8 => 'August', 'September', 'October', 'November', 'December', 1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April', 5 => 'May', 6 => 'June', 7 => 'July'); ?>
<section>
	<h2><?php echo $months[$month] ?> Report</h2>

	<?php echo $this->Form->input('month', array('value' => $month, 'label' => false, 'options' => $report_months)) ?>

	<?php foreach($users as $title => $visits): ?>

	<h4><?php echo $title ?></h4>
	<table class="table table-bordered table-condensed table-striped table-hover">
		<col width="50%"><col width="20%"><col width="10%"><col width="20%">
		<thead>
			<tr>
				<th>Name</th>
				<th>Visit Type</th>
				<th>Visit Count</th>
				<th>Minutes</th>
			</tr>
		</thead>
		<tbody>
			<?php $total = 0; ?>
			<?php foreach ($visits as $user): ?>
			<?php $u = $user['User']; ?>
			<tr>
				<td><?php echo ucwords(strtolower($u['name'])) ?></td>
				<td><?php echo $u['visit_type'] ?></td>
				<td class="text-right"><?php echo $u['cnt']; ?></td>
				<td><?php echo $u['minutes'] ?> <em>(<?php echo number_format($u['minutes'] / 60, 1) ?> hours)</em></td>
			</tr>
			<?php $total += $u['minutes'] ?>
			<?php endforeach; ?>
		</tbody>
		<tfoot>
			<tr class="success">
				<th>Total Minutes</th>
				<th>&nbsp;</th>
				<th>&nbsp;</th>
				<th><strong><?php echo number_format($total) ?> (<?php echo number_format($total / 60, 1) ?>  hours)</strong></th>
			</tr>
		</tfoot>
	</table>

	<?php endforeach; ?>

</section>

<?php $this->Html->scriptStart(array('inline' => false)) ?>
jQuery(function(){
	$('#month').change(function(){
		window.location.href = '<?php echo $this->Html->url(array('controller' => 'administrators', 'action' => 'report')) ?>/' + $(this).val();
	});
});
<?php $this->Html->scriptEnd() ?>
