<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <title><?php echo Configure::read('Application.name') ?> - <?php echo !empty($title_for_layout) ? $title_for_layout : ''; ?></title>
  <meta name="description" content="">
  <meta name="viewport" content="width=device-width">

  <!-- Place favicon.ico and apple-touch-icon.png in the root directory -->
  <style>
  body {
    padding-top: 60px;
    padding-bottom: 40px;
  }
  </style>
  <?php echo $this->Html->css('normalize.css') ?>
  <?php echo $this->Html->css('bootstrap-'.Configure::read('Layout.theme').'.min', null, array('data-extra' => 'theme')) ?>
  <?php echo $this->Html->css('bootstrap-responsive.min') ?>
  <?php echo $this->Html->css('style') ?>

  <?php echo $this->Html->script('lib/modernizr') ?>
</head>
<body>
    <!--[if lt IE 7]>
    <p class="chromeframe">You are using an outdated browser. <a href="http://browsehappy.com/">Upgrade your browser today</a> or <a href="http://www.google.com/chromeframe/?redirect=true">install Google Chrome Frame</a> to better experience this site.</p>
    <![endif]-->

    <div class="navbar navbar-fixed-top">
      <div class="navbar-inner">
        <div class="container">
          <?php echo $this->Html->link( Configure::read('Application.name') ,"/",array('class' => 'brand')) ?>
          <a class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </a>

          <div class="nav-collapse">
            <ul class="nav">
              <li class="dropdown">
              <?php echo $this->Html->link('Start Over', array('controller' => 'pages', 'action' => 'home')); ?>
              </li>
            </ul>

            <ul class="nav pull-right">
              <li id="fat-menu" class="dropdown">
                <a href="#" id="drop3" role="button" class="dropdown-toggle" data-toggle="dropdown">
                  <i class="icon-black icon-th-list"></i> 
                  <?php if (AuthComponent::user('id')) echo AuthComponent::user('username'); ?>
                  <b class="caret"></b></a> 
                <ul class="dropdown-menu" role="menu" aria-labelledby="drop3">
                  <?php if (AuthComponent::user('id')): ?>
                  <li>
                    <?php echo $this->Html->link('Report', array('controller' => 'administrators', 'action' => 'report')); ?>
                  </li>
                  <li>
                    <?php echo $this->Html->link('Comments', array('controller' => 'administrators', 'action' => 'comments')); ?>
                  </li>
                  <li>
                    <?php echo $this->Html->link('Logout', array('controller' => 'administrators', 'action' => 'logout')); ?>
                  </li>
                  <?php else: ?>
                  <li>
                    <?php echo $this->Html->link('Login', array('controller' => 'administrators', 'action' => 'login')); ?>
                  </li>
                  <?php endif; ?>
                </ul>
              </li>
            </ul>             
            </div>
          </div>
        </div>
      </div>

      <div class="container" role="main" id="main">

        <?php echo $this->Session->flash();?>
        <?php echo $this->fetch('content'); ?>

        <hr>

        <footer>
          <p>&copy; <?php echo Configure::read('Application.copyright') ?> 2012-<?php echo date('Y'); ?></p>
        </footer>

      </div> <!-- /container -->

      <script src="//ajax.googleapis.com/ajax/libs/jquery/1.8.0/jquery.min.js"></script>
      <script>window.jQuery || document.write('<script src="<?php echo $this->params->webroot ?>js/lib/jquery.min.js"><\/script>')</script>
      <?php echo $this->Html->script(
        array(
          'lib/bootstrap.min',
          'src/scripts.js'
          ));
          ?>
      <?php echo $this->fetch('script') ?>

</body>
</html>
