<?php $visit_type = array('Volunteer' => 'Volunteer', 'Visitor' => 'Visitor', 'PTA Activity' => 'PTA Activity') ?>
<?php $teachers = array(
	'OTHER' => array(
		'Other' => 'Other',
		),
	'PRESHCOOL' => array(
		'Kirsten Sessions' => 'Kirsten Sessions',
		'Jennifer Johnson, SP' => 'Jennifer Johnson, SP',
		'Brianna Hoffer' => 'Brianna Hoffer',
		),
	'KINDERGARTEN' => array(
		'Cheryl Tenney' => 'Cheryl Tenney',
		'Patricia Moss' => 'Patricia Moss',
		'Kirstin Fuhriman' => 'Kristin Fuhriman',
		'Jodee Crane' => 'Jodee Crane',
		),
	'FIRST' => array(
		'Janaly Nelson' => 'Janaly Nelson',
		'Sandra Hamblin' => 'Sandra Hamblin',
		'Royann Gregerson, DI' => 'Royann Gregerson, DI',
		'Jennifer Steed, DI' => 'Jennifer Steed, DI',
		'Harmina Van Leuven' => 'Harmina Van Leuven',
		'Lynsie Timoteo' => 'Lynsie Timoteo',
		),
	'SECOND' => array(
		'Kriss Spencer' => 'Kriss Spencer',
		'Anna Gillespie' => 'Anna Gillespie',
		'Jennifer Romiell, DI' => 'Jennifer Romiell, DI',
		'Fabiana Hansen, DI' => 'Fabiana Hansen, DI',
		'Laura Hamblin' => 'Laura Hamblin',
		'Jennifer Brown' => 'Jennifer Brown',
		),
	'THIRD' => array(
		'Cassandra Martin' => 'Cassandra Martin',
		'Danielle Finger' => 'Danielle Finger',
		'Shaye Hunseker, DI' => 'Shaye Hunseker, DI',
		'Andreia Bevilacqua, DI' => 'Andreia Bevilacqua, DI',
		'Deborah Graham' => 'Deborah Graham',
		),
	'FOURTH' => array(
		'Martianne White' => 'Martianne White',
		'Ruth Cheeseman' => 'Ruth Cheeseman',
		'Kate Walters' => 'Kate Walters',
		'Laura Ogden' => 'Laura Ogden',
		'Karen Brown' => 'Karen Brown',
		),
	'FIFTH' => array(
		'Ken Patrick' => 'Ken Patrick',
		'Melanie Fisher' => 'Melanie Fisher',
		'Curtis Cleveringa' => 'Curtis Cleveringa',
		'Diane Witt-Roper' => 'Diane Witt-Roper',
		'April Thompson' => 'April Thompson',
		),
	'SIXTH' => array(
		'Sharon Lindsay' => 'Sharon Lindsay',
		'Tiffany Anderson' => 'Tiffany Anderson',
		'Robyn Derbidge' => 'Robyn Derbidge',
		'Gwen Purcell' => 'Gwen Purcell',
		'Amanda Golesh' => 'Amanda Golesh',
		),
	);
?>

<?php echo $this->Form->create('User', array('autocomplete' => 'off', 'inputDefaults' => array('error' => false))) ?>

<section class="hero-unit">
	<fieldset>
	<legend>Sign In</legend>

	<?php echo $this->Form->input('start_date', array('value' => date('l, F j, Y'), 'label' => 'Date', 'placeholder' => 'Date')) ?>
	<?php echo $this->Form->input('name', array('placeholder' => 'Enter your name', 'class' => 'name-typeahead')) ?>
	<?php echo $this->Form->input('classroom', array('options' => $teachers, 'empty' => '- Select Teacher -', 'placeholder' => 'Enter the classroom')) ?>
	<?php echo $this->Form->input('time_in', array('type' => 'text', 'value' => date('h:i A'), 'placeholder' => 'Time In')) ?>

	<?php echo $this->Form->input('visit_type', array('options' => $visit_type, 'empty' => '- Please Select -')) ?>

	<?php echo $this->TwitForm->button('Sign In', array('class' => 'btn btn-primary')) ?>
	</fieldset>

	<?php echo $this->Form->end(); ?>
</section>

<?php $this->Html->scriptStart(array('inline' => false)) ?>
jQuery(function($){
	var users = [];

	$('.name-typeahead').typeahead({
		source: function(query, process){
			$.get('<?php echo $this->Html->url(array('action' => 'lookup')) ?>/' + query + '.json',
				function(data) {
					users = data['users'];
					process(data['names']);
				}
			);
		},
		highlighter: function(item) { return users[item]; },
		matcher: function(item) { return true; },
		items: 4,
		minLength: 2
	});
});
<?php $this->Html->scriptEnd() ?>
