<section>
	<fieldset>
		<legend>Sign Out</legend>
		<h4><?php echo date('l, F, j, Y') ?></h4>
		<table class="table table-bordered table-condensed table-hover">
			<thead>
				<tr>
					<th><?php echo $this->Paginator->sort('name'); ?></th>
					<th><?php echo $this->Paginator->sort('classroom'); ?></th>
					<th><?php echo $this->Paginator->sort('visit_type'); ?></th>
					<th><?php echo $this->Paginator->sort('time_in'); ?></th>
					<th>Time Out</th>
				</tr>
			</thead>
			<tbody>
			<?php $time_out = date('h:i A'); ?>
			<?php foreach ($users as $user): ?>
				<tr>
					<td class="save-name"><?php echo $user['User']['name']; ?></td>
					<td><?php echo $user['User']['classroom']; ?></td>
					<td><?php echo $user['User']['visit_type']; ?></td>
					<td><?php echo $this->Time->format('h:i A', $user['User']['time_in']); ?></td>
					<td>
						<?php echo $this->Form->create('User', array('url' => array('action' => 'checkout', $user['User']['id']), 'class' => 'form-inline')) ?>
						<div class="input-append">
							<?php echo $this->Form->input('time_out', array('class' => 'input-small', 'placeholder' => 'Time Out', 'type' => 'text', 'label' => false, 'div' => false, 'value' => $time_out)) ?>
							<?php echo $this->TwitForm->button('Sign Out', array('class' => 'save-time-out')) ?>
						</div>
						<?php echo $this->Form->end() ?>
					</td>
				</tr>
			<?php endforeach; ?>
			</tbody>
		</table>
		<p>
		<?php
		echo $this->Paginator->counter(array(
		'format' => __('Page {:page} of {:pages}, showing {:current} records out of {:count} total, starting on record {:start}, ending on {:end}')
		));
		?>	</p>

		<div class="pagination">
		<?php
			echo $this->Paginator->prev('«', array('tag' => 'li'), null, array('class' => 'prev disabled'));
			echo $this->Paginator->numbers(array('separator' => '', 'tag' => 'li', 'currentClass' => 'active'));
			echo $this->Paginator->next('»', array('tag' => 'li'), null, array('class' => 'next disabled'));
		?>
		</div>
	</fieldset>

</section>
 
<?php $this->Html->scriptStart(array('inline' => false)) ?>
jQuery(function($){
	$('form').submit(function(){
		name = $(this).parent().siblings('.save-name').html();
		return confirm('Save time out for ' + name + '?');
	});
});
<?php $this->Html->scriptEnd() ?>