<?php

App::uses('AppController', 'Controller');

class UsersController extends AppController
{

/**
 * beforeFilter method
 */
    public function beforeFilter()
    {
        $this->Auth->allow('login', 'register', 'assessment', 'section1', 'section2', 'thankyou');
    }

/**
 * login method
 *
 * @return void
 */
    public function login()
    {
        if ($this->request->is('post')) {
            if ($this->Auth->login()) {
                return $this->redirect($this->Auth->redirectUrl());
            } else {
                $this->Session->setFlash(__('Username or password is incorrect'), 'flash_fail');
            }
        }
    }

/**
 * logout method
 *
 * @return void
 */
    public function logout()
    {
        $this->Session->destroy();
        $this->Session->setFlash('You have successfully logged out', 'flash_success');
        $this->redirect($this->Auth->logout());
    }

/**
 * register method
 */
    public function register()
    {
        if ($this->Auth->user()) {
            $this->Session->setFlash('You are already registered and logged in!', 'flash_fail');
            $this->redirect('/');
        }

        if ($this->request->is('post')) {
            if ($this->User->save($this->request->data)) {
                $this->Session->setFlash('You account has been created!', 'flash_success');
                $this->redirect('/');
            } else {
                $this->Session->setFlash('Could not create your account.', 'flash_fail');
            }
        }
    }

/**
 * assessment method
 */
    public function assessment() {
        $this->redirect('section1');
    }

/**
 * section1 method
 */
    public function section1()
    {
        $userId = 1;

        $this->loadModel('Rating');
        if ($this->request->is('post')) {
            if ($this->Rating->saveRatings($userId, $this->request->data)) {
                $this->Session->setFlash('Your ratings have been saved.', 'flash_success');
                $this->redirect('section2');
            } else {
                $this->Session->setFlash('Could not save your ratings.', 'flash_fail');
            }
        }
        $this->request->data = $this->Rating->getRatings($userId);

        $this->loadModel('Competency');
        $options = array(
            'fields' => array(
                'Competency.name',
            ),
            'contain' => array(
                'Statement' => array(
                    'fields' => array('Statement.name'),
                    'Behavior' => array(
                        'fields' => array('Behavior.id', 'Behavior.name')
                    )
                )
            )
        );
        $competencies = $this->Competency->find('all', $options);
        $this->set(compact('competencies'));
    }

/**
 * section2 method
 */
    public function section2()
    {
        $userId = 1;

        $this->loadModel('Rating');
        if ($this->request->is('post')) {
            if ($this->Rating->saveImportance($userId, $this->request->data)) {
                $this->Session->setFlash('Your ratings have been saved.', 'flash_success');
                $this->redirect('thankyou');
            } else {
                $this->Session->setFlash('Could not save your ratings.', 'flash_fail');
            }
        }
        $this->request->data = $this->Rating->getImportance($userId);


        $this->loadModel('Rating');
        $lows = $this->Rating->getLows($userId);
        if (empty($lows)) {
            return $this->redirect('thankyou');
        }

        $this->loadModel('Behavior');
        $options = array(
            'fields' => array('Behavior.id', 'Behavior.name'),
            'conditions' => array('Behavior.id' => $lows)
        );
        $behaviors = $this->Behavior->find('all', $options);
        $this->set(compact('behaviors'));

        /*
        $this->loadModel('Competency');
        $options = array(
            'fields' => array(
                'Competency.name',
            ),
            'contain' => array(
                'Statement' => array(
                    'fields' => array('Statement.name'),
                    'Behavior' => array(
                        'fields' => array('Behavior.id', 'Behavior.name'),
                        'conditions' => array('Behavior.id' => $lows)
                    )
                )
            )
        );
        $competencies = $this->Competency->find('all', $options);
        $this->set(compact('competencies'));
        */
    }

/**
 * thankyou method
 */
    public function thankyou()
    {
    }
}
