<?php
App::uses('AppModel', 'Model');
/**
 * Rating Model
 *
 * @property User $User
 * @property Behavior $Behavior
 */
class Rating extends AppModel {

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'User' => array(
			'className' => 'User',
			'foreignKey' => 'user_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Behavior' => array(
			'className' => 'Behavior',
			'foreignKey' => 'behavior_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * getRatings method
 */
    public function getRatings($userId)
    {
        $options = array(
            'fields' => array('behavior_id', 'value'),
            'conditions' => array('user_id' => $userId)
        );
        $data['Rating'] = $this->find('list', $options);
        $options = array(
            'fields' => array('behavior_id', 'comment'),
            'conditions' => array('user_id' => $userId)
        );
        $data['Comment'] = $this->find('list', $options);

        return $data;
    }

/**
 * saveRatings method
 */
    public function saveRatings($userId, $data)
    {
        $ratings = $data['Rating'];
        $comments = $data['Comment'];

        $options = array(
            'fields' => array('behavior_id', 'id'),
            'conditions' => array('user_id' => $userId)
        );
        $current = $this->find('list', $options);
        $records = array();
        foreach ($ratings as $behaviorId => $value) {
            if ($value == '') {
                continue;
            }
            $rec = array();
            if (isset($current[$behaviorId])) {
                $rec['id'] = $current[$behaviorId];
            }
            $rec['user_id'] = $userId;
            $rec['behavior_id'] = $behaviorId;
            $rec['value'] = $value;
            $rec['comment'] = empty($comments[$behaviorId]) ? '' : $comments[$behaviorId];
            $records[] = $rec;
        }
        return $this->saveMany($records);
    }

/**
 * getLows method
 */
    public function getLows($userId) {
        $options = array(
            'fields' => array('id', 'behavior_id'),
            'conditions' => array('user_id' => $userId, array('value' => array(1,2,3)))
        );
        return $this->find('list', $options);
    }

/**
 * getImportance method
 */
    public function getImportance($userId)
    {
        $options = array(
            'fields' => array('behavior_id', 'importance'),
            'conditions' => array('user_id' => $userId)
        );
        $data['Importance'] = $this->find('list', $options);

        return $data;
    }

/**
 * saveImportance method
 */
    public function saveImportance($userId, $data)
    {
        $importances = $data['Importance'];

        $options = array(
            'fields' => array('behavior_id', 'id'),
            'conditions' => array('user_id' => $userId)
        );
        $current = $this->find('list', $options);
        $records = array();
        foreach ($importances as $behaviorId => $import) {
            if ($import == '') {
                continue;
            }
            $rec = array();
            if (isset($current[$behaviorId])) {
                $rec['id'] = $current[$behaviorId];
            }
            $rec['user_id'] = $userId;
            $rec['behavior_id'] = $behaviorId;
            $rec['importance'] = $import;
            $records[] = $rec;
        }
        return $this->saveMany($records);
    }
}
