<?php if (!AuthComponent::user('id')) return; ?>

<div id="idletimeout">
	You will be logged off in <span><!-- countdown place holder --></span>&nbsp;seconds due to inactivity.
	<a id="idletimeout-resume" href="#">Click here to continue using this web page</a>.
</div>
<?php echo $this->Html->script(array('libs/jquery.idletimer.js', 'libs/jquery.idletimeout.js'), array('inline' => false)); ?>
<?php $this->Html->scriptStart(array('inline' => false)); ?>
$.idleTimeout('#idletimeout', '#idletimeout a', {
	idleAfter: 3540,
	warningLength: 60,
	pollingInterval: 360,
	keepAliveURL: '<?php echo Router::url(array('controller' => 'users', 'action' => 'keepalive')); ?>',
	serverResponseEquals: 'OK',
	onTimeout: function(){
		$(this).slideUp();
		window.location = "<?php echo Router::url(array('controller' => 'users', 'action' => 'timeout')); ?>"
	},
	onIdle: function(){
		$(this).slideDown(); // show the warning bar
	},
	onCountdown: function( counter ){
		$(this).find("span").html( counter ); // update the counter
	},
	onResume: function(){
		$(this).slideUp(); // hide the warning bar
	}
});
<?php $this->Html->scriptEnd(); ?>
