<?php
$ratings = array(
    7 => 'Without Compare',
    6 => 'Excellent',
    5 => 'Very Good',
    4 => 'Good',
    3 => 'Mediocre',
    2 => 'Poor',
    1 => 'Extremely Poor',
    0 => 'Don’t Know',
    -1 => 'Not Applicable',
);
?>
<h1>Section 1</h1>
<p>Instructions...</p>

<?php echo $this->Form->create(); ?>
<?php foreach ($competencies as $competency): ?>
    <h3><?php echo $competency['Competency']['name']; ?></h3>

    <?php foreach ($competency['Statement'] as $statement): ?>
        <div class="panel panel-primary">
            <div class="panel-heading"><?php echo $statement['name']; ?></div>
            <table class="table table-condensed">
                <col width="80%"><col width="20%">
                <tbody>
                <?php foreach ($statement['Behavior'] as $behavior): ?>
                    <tr>
                        <td>
                            <strong style="font-size: 1.2em;"><?php echo $behavior['name']; ?></strong><br>
                            Comment/Suggestions
                            <?php echo $this->Form->input('Comment.' . $behavior['id'], array('type' => 'textarea', 'label' => false, 'rows' => 2)); ?>
                        </td>
                        <td>
                            <?php echo $this->Form->input('Rating.' . $behavior['id'], array('options' => $ratings, 'empty' => '- Select Rating -', 'label' => false)); ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endforeach; ?>

<?php endforeach; ?>
<?php echo $this->Form->button('Submit Section', array('class' => 'btn btn-success')); ?>
<?php echo $this->Form->end(); ?>
