<?php
include_once('lib/database.php');
include_once('lib/form.php');
$keys = $db->get_col("SELECT CONCAT(id, ',', mission, ',', lat, ',', lng) id, mission FROM missions ORDER BY mission");
$missions = array_combine($keys, $db->get_col(null, 1));
?>
<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"><!DOCTYPE>
	<meta name="viewport" content="initial-scale=1.0, user-scalable=no">
	<title>Where will Luke go?</title>
	<link href="css/styles.css" rel="stylesheet">
	<link href="css/chosen.css" rel="stylesheet">

	<script src="https://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false"></script>
	<script src="js/infobox.js"></script>
	<script>
		var map = null;

		function initialize() {
			//var myLatlng = new google.maps.LatLng(40.7608,-111.891);
			var myLatlng = new google.maps.LatLng(33.3528,-111.789);
			var mapOptions = {
				zoom: 9,
				center: myLatlng,
				mapTypeId: google.maps.MapTypeId.ROADMAP
			}
			map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);

			<?php
			// place all existing markers
			$guesses = $db->get_results("SELECT m.id, m.mission, m.lat, m.lng, g.name FROM missions m, guesses g WHERE m.id = g.mission_id", ARRAY_A);
			foreach ($guesses as $guess) {
				echo sprintf("placeMarker(['%s', '%s', '%s', '%s'], '%s');\n", $guess['id'], $guess['mission'], $guess['lat'], $guess['lng'], $guess['name']);
			}
			?>

			window.setTimeout(function() {
				map.setZoom(10);
      			map.panTo(myLatlng);
    		}, 1000);
		}

		google.maps.event.addDomListener(window, 'load', initialize);

		function placeMarker(mission, name) {

			var lat = mission[2];
			var lng = mission[3];
			var title = name + ': ' + mission[1];
			var marker = new google.maps.Marker({
				position: new google.maps.LatLng(lat, lng),
				map: map,
				draggable: true,
				title: title
			});

			placeInfo(marker, '<strong>' + mission[1] + '</strong><br>Guessed by: ' + name);

			return marker
		}

		function panToMarker(marker) {
			window.setTimeout(function() {
				map.setZoom(8);
      			map.panTo(marker.getPosition());
    		}, 1000);
		}

		function placeInfo(marker, text) {
			var boxText = document.createElement("div");
			boxText.style.cssText = "border: 1px solid black; margin-top: 8px; background: #ffffaa; padding: 5px; font-size: 10px; font-family: tahoma;";
			boxText.innerHTML = text;

			var myOptions = {
                 content: boxText
                ,disableAutoPan: false
                ,maxWidth: 0
                ,pixelOffset: new google.maps.Size(-13, 0)
                ,zIndex: null
                ,boxStyle: {
                  background: "url('tipbox.gif') no-repeat"
                  ,opacity: 0.7
                  ,width: "150px"
                 }
                ,closeBoxMargin: "10px 2px 2px 2px"
                ,closeBoxURL: "http://www.google.com/intl/en_us/mapfiles/close.gif"
                ,infoBoxClearance: new google.maps.Size(1, 1)
                ,isHidden: false
                ,pane: "floatPane"
                ,enableEventPropagation: false
				};

			var ib = new InfoBox(myOptions);
			ib.open(map, marker);
		}

		function saveMarker(mission, name) {
			var id = mission[0];
			$.post("save.php", { id: id, name: name })
				.done(function(data) {
					panToMarker(placeMarker(mission, name));
				});
		}

	</script>
	<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>
	<script type="text/javascript" src="js/chosen.jquery.min.js"></script>
	<script>
	jQuery(function($){
		$('select').chosen();
		$('#go').click(function(){
			var mission = $('#mission').val().split(',');
			if (mission == '') {
				alert('Please select a mission');
				return false;
			}
			var name = $('#name').val();
			if (name == '') {
				alert ('Pleae enter your name');
				return false;
			}
			$('#name').val('');
			saveMarker(mission, name);
		});
	});
	</script>
</head>
<body>
	<div id="map-canvas"></div>
	<div id="panel">
	Luke has been called to the Arizona Gilbert Mission. Reporting August 7, 2013.
	<!--
		Where will Luke go?
		<?php echo select('mission', $missions, 'Choose a mission') ?>
		<input type="text" id="name" placeholder="Your Name">
		<input type="submit" value="Go" id="go">
	-->
	</div>
</body>
</html>
