<?php $visit_type = array('Volunteer' => 'Volunteer', 'Visitor' => 'Visitor', 'PTA Activity' => 'PTA Activity') ?>
<?php $teachers = array(
	'OTHER' => array(
		'Other' => 'Other',
		'I Can Read' => 'I Can Read',
		),
	'KINDERGARTEN' => array(
		'Noelle Rizer' => 'Noelle Rizer',
		'LeeAnn Scott' => 'LeeAnn Scott',
		'Staci White' => 'Staci White',
		),
	'FIRST' => array(
		'Erika Andersen' => 'Erika Andersen',
		'Morgan Kochevar' => 'Morgan Kochevar',
		'Kasey LaFleur' => 'Kasey LaFleur',
		'Tauna Orgill' => 'Tauna Orgill',
		'Tina Price' => 'Tina Price',
		),
	'SECOND' => array(
		'Jana Conche/Nicole Williams' => 'Jana Conche/Nicole Williams',
		'Kathie Jorgensen' => 'Kathie Jorgensen',
		'Susan Warnock' => 'Susan Warnock',
		'Madison Rawle' => 'Madison Rawle',
		'Katie Wilson' => 'Katie Wilson',
		),
	'THIRD' => array(
		'Laurie Benson' => 'Laurie Benson',
		'Taylor Brown' => 'Taylor Brown',
		'Susan Stokes' => 'Susan Stokes',
		'Allyson Vietti ' => 'Allyson Vietti ',
		),
	'FOURTH' => array(
		'Angelique Boyles ' => 'Angelique Boyles ',
		'Janet Crane' => 'Janet Crane',
		'Traci Rindlisbach' => 'Traci Rindlisbach',
		'Jessica Soffe' => 'Jessica Soffe',
		),
	'FIFTH' => array(
		'Rebecca Barnhurst' => 'Rebecca Barnhurst',
		'Peggy Coupe' => 'Peggy Coupe',
		'Kristine Kimball' => 'Kristine Kimball',
		'Machelle Rogers' => 'Machelle Rogers',
		),
	'SIXTH' => array(
		'Vicki Curtis ' => 'Vicki Curtis ',
		'Sandra Darrington' => 'Sandra Darrington',
		'Kim Vance' => 'Kim Vance',
		'Linda White' => 'Linda White',
		),
	);
?>

<?php echo $this->Form->create('User', array('autocomplete' => 'off', 'inputDefaults' => array('error' => false))) ?>

<section class="hero-unit">
	<fieldset>
	<legend>Sign In</legend>

	<?php echo $this->Form->input('start_date', array('value' => date('l, F j, Y'), 'label' => 'Date', 'placeholder' => 'Date')) ?>
	<?php echo $this->Form->input('name', array('placeholder' => 'Enter your name', 'class' => 'name-typeahead')) ?>
	<?php echo $this->Form->input('classroom', array('options' => $teachers, 'empty' => '- Select Teacher -', 'placeholder' => 'Enter the classroom')) ?>
	<?php echo $this->Form->input('time_in', array('type' => 'text', 'value' => date('h:i A'), 'placeholder' => 'Time In')) ?>

	<?php echo $this->Form->input('visit_type', array('options' => $visit_type, 'empty' => '- Please Select -')) ?>

	<?php echo $this->TwitForm->button('Sign In', array('class' => 'btn btn-primary')) ?>
	</fieldset>

	<?php echo $this->Form->end(); ?>
</section>

<?php $this->Html->scriptStart(array('inline' => false)) ?>
jQuery(function($){
	var users = [];

	$('.name-typeahead').typeahead({
		source: function(query, process){
			$.get('<?php echo $this->Html->url(array('action' => 'lookup')) ?>/' + query + '.json',
				function(data) {
					users = data['users'];
					process(data['names']);
				}
			);
		},
		highlighter: function(item) { return users[item]; },
		matcher: function(item) { return true; },
		items: 4,
		minLength: 2
	});
});
<?php $this->Html->scriptEnd() ?>
