<?php
/*
Plugin Name: Shopp Analytics
Version: 1.1.1
Description: Integrates Shopp purchases with Google Analytics e-commerce features
Plugin URI: http://shopplugin.net
Author: Ingenesis Limited
Author URI: http://ingenesis.net
Requirements: Requires Shopp 1.x
*/

// Google Checkout Analytics
add_action('shopp_google_checkout_analytics', 'shopp_google_checkout_analytics');
function shopp_google_checkout_analytics() {
	if (is_shopp_page('checkout')) wp_enqueue_script('ga_post','https://checkout.google.com/files/digital/ga_post.js',array('jquery'));
	add_action('wp_footer','shopp_google_checkout_script');
}
function shopp_google_checkout_script () {
	global $Shopp;
	$account = $Shopp->Settings->get('google_ua_id');
	if(isset($account)):
	?>
<script type="text/javascript">
	var $ = jQuery, f = $('#checkout'), pt = _gat._getTracker("<?php echo $account; ?>");
	$('<div><input type="hidden" id="analyticsdata" name="analyticsdata" value=""></div>').appendTo(f);
	setUrchinInputCode(pt);
</script>
<?php 
	endif;
}

add_action('wp_footer','ShoppAnalytics');
add_action('admin_menu', 'ShoppAnalyticsAdmin');

function ShoppAnalytics () {
	global $Shopp;
	
	if (version_compare(substr(SHOPP_VERSION,0,3),'1.1') >= 0) {
		// Only process if we're in the checkout process (receipt page)
		if (function_exists('is_shopp_page') && !is_shopp_page('checkout')) return;
		if (empty($Shopp->Purchase->id)) return;

		$Purchase = new Purchase($Shopp->Purchase->id);
		$Purchase->load_purchased();
	} else {
		// For 1.0.x
		// Only process if we're in the checkout process (receipt page)
		if (function_exists('is_shopp_page') && !is_shopp_page('checkout')) return;
		// Only process if we have valid order data
		if (!isset($Shopp->Cart->data->Purchase)) return;
		if (empty($Shopp->Cart->data->Purchase->id)) return;

		$Purchase = $Shopp->Cart->data->Purchase;
	}
	
	
	$google_ua_id = $Shopp->Settings->get('google_ua_id');
	if (empty($google_ua_id)) return;
	
	?>
	<script type="text/javascript">
		var _gaq = _gaq || [];
		_gaq.push(['_setAccount', '<?php echo $google_ua_id; ?>']);
		_gaq.push(['_trackPageview']);
		_gaq.push(['_addTrans',
		    "<?php echo $Purchase->id; ?>", 								// order ID - required
		    "WebStore",                            						// affiliation or store name
		    "<?php echo number_format($Purchase->total,2); ?>",		// total
		    "<?php echo number_format($Purchase->tax,2); ?>",			// tax
		    "<?php echo number_format($Purchase->shipping,2); ?>",  // shipping
		    "<?php echo $Purchase->city; ?>",								// city
		    "<?php echo $Purchase->state; ?>",								// state
		    "<?php echo $Purchase->country; ?>"							// country
		]);
		
		// add item might be called for every item in the shopping cart
		// where your ecommerce engine loops through each item in the cart and
		// prints out _addItem for each
		<?php foreach ($Purchase->purchased as $purchased): ?>
		_gaq.push(['_addItem',
		    "<?php echo $Purchase->id; ?>",									// order ID - required
		    "<?php echo empty($purchased->sku)?							// SKU - required
				'PID-'.$purchased->product.str_pad($purchased->price,4,'0',STR_PAD_LEFT):$purchased->sku; ?>",
		    "<?php echo $purchased->name; ?>",								// product name 
		    "<?php echo $purchased->optionlabel; ?>", 					// category
		    "<?php echo number_format($purchased->unitprice,2) ?>",	// unit price
		    "<?php echo $purchased->quantity; ?>"							// quantity
		]);
		<?php endforeach; ?>
		
		_gaq.push(['_trackTrans']); //submits transaction to the Analytics servers
		
		(function() {
			var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
			ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
			var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
		})();
		
	</script>
<?php
}
function ShoppAnalyticsAdmin () {
	if ( function_exists('add_submenu_page') )
		add_submenu_page('plugins.php', __('Shopp Analytics','Shopp'), __('Shopp Analytics','Shopp'), 'manage_options', 'shopp-analytics-config', 'ShoppAnalyticsConfig');
}

function ShoppAnalyticsConfig () {
	global $Shopp;
	if ( !current_user_can('manage_options') )
		wp_die(__('You do not have sufficient permissions to access this page.'));
?>
<?php if ( isset($_POST['save']) ) : ?>
<?php
	check_admin_referer('shopp-analytics-config');
	if (version_compare(substr(SHOPP_VERSION,0,3),'1.1') >= 0) {
		$Shopp->Settings->save('google_ua_id',$_POST['settings']['google_ua_id']);
	} else {
		if (method_exists($Shopp->Flow,'settings_save()')) $Shopp->Flow->settings_save();
	}
?>
<div id="message" class="updated fade"><p><strong><?php _e('Options saved.') ?></strong></p></div>
<?php endif; ?>
<div class="wrap">
	<h2><?php _e('Shopp Analytics','Shopp'); ?></h2>
	<form name="settings" id="shopp-analytics-config" action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
		<?php wp_nonce_field('shopp-analytics-config'); ?>
	<table class="form-table"> 
		<tr class="form-required"> 
			<th scope="row" valign="top"><label for="google_ua_id"><?php _e('Google Analytics UA','Shopp'); ?></label></th> 
			<td><input type="text" name="settings[google_ua_id]" value="<?php echo attribute_escape($Shopp->Settings->get('google_ua_id')); ?>" id="google_ua_id" size="30" /><br /> 
            <?php _e('Enter your Google Analytics User Agent ID.','Shopp'); ?></td>
		</tr>
	</table>
	<p class="submit"><input type="submit" class="button-primary" name="save" value="<?php _e('Save Changes','Shopp'); ?>" /></p>
	</form>
	
</div>
<?php
}
?>