<?php
class WafpAppController
{
  function WafpAppController()
  {
    add_filter('the_content', array( &$this, 'page_route' ), 100);
    add_action('wp_enqueue_scripts', array(&$this, 'load_scripts'), 1);
    add_action('admin_enqueue_scripts', array(&$this,'load_admin_scripts'));
    add_action('wp_head', array(&$this,'load_dynamic_css'), 100);
    register_activation_hook(WAFP_PATH."/affiliate-royale.php", array( &$this, 'install' ));
    
    add_action('init', array(&$this,'parse_standalone_request'));
  }

  function setup_menus()
  {
    add_action('admin_menu', array( &$this, 'menu' ));
  }
  
  /********* INSTALL PLUGIN ***********/
  function install()
  {
    global $wafp_db, $wafp_update;
    
    $wafp_db->upgrade();
  }
  
  function menu()
  {
    global $wafp_options_controller,
           $wafp_links_controller,
           $wafp_integration_controller,
           $wafp_reports_controller,
           $wafp_update;

    if( $wafp_update->pro_is_installed_and_authorized() )
    {
      add_menu_page(__('Affiliate Royale', 'affiliate-royale'), __('Affiliate Royale', 'affiliate-royale'), 'administrator', 'affiliate-royale-reports', array( &$wafp_reports_controller, 'overview'), WAFP_IMAGES_URL . "/affiliate_royale_logo_16.png");
      add_submenu_page( 'affiliate-royale-reports', __('Reports', 'affiliate-royale'), __('Reports', 'affiliate-royale'), 'administrator', 'affiliate-royale-reports', array( &$wafp_reports_controller, 'overview' ) );
      add_submenu_page( 'affiliate-royale-reports', __('Links &amp; Banners', 'affiliate-royale'), __('Links &amp; Banners', 'affiliate-royale'), 'administrator', 'affiliate-royale-links', array( &$wafp_links_controller, 'route' ) );
      add_submenu_page( 'affiliate-royale-reports', __('Options', 'affiliate-royale'), __('Options', 'affiliate-royale'), 'administrator', 'affiliate-royale-options', array( &$wafp_options_controller, 'route' ) );
      add_submenu_page( 'affiliate-royale-reports', __('Activate', 'affiliate-royale'), __('Activate', 'affiliate-royale'), 'administrator', 'affiliate-royale-activate', array( &$this, 'display_activation_form' ) );
    }
    else
    {
      add_menu_page(__('Affiliate Royale', 'affiliate-royale'), __('Affiliate Royale', 'affiliate-royale'), 'administrator', 'affiliate-royale-activate', array( &$this, 'display_activation_form' ), WAFP_URL . "/images/affiliate-royale-16.png");
    }
  }
  
  function display_activation_form()
  {
    global $wafp_update;
    require(WAFP_VIEWS_PATH . '/shared/activation_form.php');
  }

  // Routes for wordpress pages -- we're just replacing content here folks.
  function page_route($content)
  {
    global $wafp_current_user,
           $post, 
           $wafp_options, 
           $wafp_dashboard_controller,
           $wafp_users_controller;

    switch( $post->ID )
    {  
      case $wafp_options->dashboard_page_id:
        $action = $this->get_param('action','home');
        // Start output buffering -- we want to return the output as a string
        ob_start();
        
        if($wafp_current_user)
        {
          if (isset($_POST['become_affiliate_submit'])) // (see views/wafp-dashboard/become.php)
          {
            $wafp_current_user->set_is_affiliate(true);
            $wafp_current_user->store();
          }

          if ($wafp_current_user->get_is_affiliate())
          {
            if($action=='home' or empty($action))
              $wafp_dashboard_controller->display_dashboard();
            else if($action=='links')
              $wafp_dashboard_controller->display_links();
            else if($action=='stats')
              $wafp_dashboard_controller->display_stats();
            else if($action=='payments')
              $wafp_dashboard_controller->display_payments();
          }
          else
            $wafp_dashboard_controller->display_become_affiliate(); //Added by Paul (shows if not affiliate)
        }
        else
        {
          $loginURL = get_permalink($wafp_options->login_page_id);
          if (empty($loginURL))
            $loginURL = wp_login_url();
          require( WAFP_VIEWS_PATH . "/shared/unauthorized.php" );
        }

        // Pull all the output into this variable
        $content .= ob_get_contents();
        // End and erase the output buffer (so we control where it's output)
        ob_end_clean();
        break;
      case $wafp_options->login_page_id:
        ob_start();
        $action = $this->get_param('action');
      
        if( $action and $action == 'forgot_password' )
          $wafp_users_controller->display_forgot_password_form();
        else if( $action and $action == 'wafp_process_forgot_password' )
          $wafp_users_controller->process_forgot_password_form();
        else if( $action and $action == 'reset_password')
          $wafp_users_controller->display_reset_password_form($this->get_param('mkey'),$this->get_param('u'));
        else if( $action and $action == 'wafp_process_reset_password_form')
          $wafp_users_controller->process_reset_password_form();
        else
          $wafp_users_controller->display_login_form();
      
        $content .= ob_get_contents();
        ob_end_clean();
        break;
      case $wafp_options->signup_page_id:
        ob_start();
        $wafp_users_controller->display_signup_form();
        $content .= ob_get_contents();
        ob_end_clean();
        break;
    }
    
    return $content;
  }  

  function load_scripts()
  {
    $this->enqueue_wafp_scripts();
  }
  
  function load_admin_scripts()
  {
    /*
    $admin_pages = apply_filters('wafp_admin_pages',array( 'affiliate-royale-options',
                                                           'affiliate-royale-links',
                                                           'affiliate-royale-reports',
                                                           'user-edit.php'));
    
    $curr_page = $_GET['page'];

    if(in_array($curr_page,$admin_pages))
    */
      $this->enqueue_wafp_scripts();
  }
  
  function enqueue_wafp_scripts()
  {
    global $wafp_blogurl;
        
    wp_enqueue_style( 'affiliate-royale',  WAFP_CSS_URL . '/affiliate-royale.css' );
    wp_enqueue_script( 'jquery-flot', WAFP_JS_URL . '/jquery.flot.js', array('jquery') );
    wp_enqueue_script( 'affiliate-royale', WAFP_JS_URL . '/affiliate-royale.js', array('jquery','jquery-flot') );
  }

  // The tight way to process standalone requests dogg...
  function parse_standalone_request()
  {
    global $wafp_users_controller;

    $plugin     = isset($_REQUEST['plugin'])?$_REQUEST['plugin']:'';
    $action     = isset($_REQUEST['action'])?$_REQUEST['action']:'';
    $controller = isset($_REQUEST['controller'])?$_REQUEST['controller']:'';

    $request_uri = $_SERVER['REQUEST_URI'];

    if( !empty($plugin) and $plugin == 'wafp' and 
        !empty($controller) and !empty($action) )
    {
      $this->standalone_route($controller, $action);
      exit;
    }
    else if( isset( $_POST ) and isset( $_POST['wafp_process_login_form'] ) )
      $wafp_users_controller->process_login_form();
  }

  // Routes for standalone / ajax requests
  function standalone_route($controller, $action)
  {
    global $wafp_links_controller, $wafp_transactions_controller, $wafp_reports_controller, $wafp_dashboard_controller;

    if($controller=='links')
    {
      if($action=='redirect')
        $wafp_links_controller->redirect_link( WafpAppController::get_param('l'), WafpAppController::get_param('a') );
      else if($action=='pixel')
        $wafp_links_controller->track_link( WafpAppController::get_param('a') );
      else if($action=='delete')
        $wafp_links_controller->delete_link( WafpAppController::get_param('lid') );
    }
    else if($controller=='transactions')
    {
      if($action=='track')
        $wafp_transactions_controller->track( WafpAppController::get_param('amount'),
                                              WafpAppController::get_param('order_id'),
                                              WafpAppController::get_param('prod_id'),
                                              WafpAppController::get_param('aff_id'),
                                              WafpAppController::get_param('subscr_id') );
    }
    else if( $controller=='reports' )
    {
      if($action=='admin_affiliate_stats')
        $wafp_reports_controller->admin_affiliate_stats( WafpAppController::get_param('period') );
      else if($action=='admin_affiliate_clicks')
        $wafp_reports_controller->admin_affiliate_clicks( WafpAppController::get_param('wafpage') );
      else if($action=='admin_affiliate_transactions')
        $wafp_reports_controller->admin_affiliate_transactions( WafpAppController::get_param('wafpage') );
      else if($action=='admin_affiliate_top')
        $wafp_reports_controller->admin_affiliate_top( WafpAppController::get_param('period'), WafpAppController::get_param('wafpage') );
      else if($action=='admin_affiliate_payments')
        $wafp_reports_controller->admin_affiliate_payments( WafpAppController::get_param('period') );
      else if($action=='paypal_bulk_file')
        $wafp_reports_controller->admin_paypal_bulk_file( WafpAppController::get_param('id') );
    }
    else if( $controller=='dashboard' )
    {
      if($action=='dashboard_affiliate_stats')
        $wafp_dashboard_controller->display_stats( WafpAppController::get_param('period'), false );
    }
    else
      do_action('wafp_process_route');
  }
  
  function load_language()
  {
    $path_from_plugins_folder = str_replace( ABSPATH, '', WAFP_PATH ) . '/i18n/';
    
    load_plugin_textdomain( 'affiliate-royale', false, $path_from_plugins_folder );
  }
  
  function load_dynamic_css()
  {
    global $wafp_options;
    ?>
      <style type="text/css">
      #wafp-dash-wrapper
      {
        color: #333;
        width: <?php echo $wafp_options->dash_css_width; ?>px;
      }
      #wafp-dash-wrapper img
      {
        max-width: <?php echo $wafp_options->dash_css_width; ?>px;
      }
      </style>
    <?php
  }

  // Utility function to grab the parameter whether it's a get or post
  function get_param($param, $default='')
  {
    if((!isset($_POST) or empty($_POST)) and
       (!isset($_GET) or empty($_GET)))
      return $default;

    if(!isset($_POST[$param]) and !isset($_GET[$param]))
      return $default;
  
    return (isset($_POST[$param])?$_POST[$param]:(isset($_GET[$param])?$_GET[$param]:$default));
  }
  
  function get_param_delimiter_char($link)
  { 
    return ((preg_match("#\?#",$link))?'&':'?');
  }
}
?>
