<?php

class WafpOptionsController
{
  function route()
  {
    $action = (isset($_REQUEST['action'])?$_REQUEST['action']:null);
    if($action=='process-form')
      return $this->process_form();
    else
      return $this->display_form();
  }

  function display_form()
  {
    global $wafp_options;
    if(WafpUtils::is_logged_in_and_an_admin())
    {    
      if(!$wafp_options->setup_complete)
        require(WAFP_VIEWS_PATH . '/shared/must_configure.php');
        
      if(!get_option('users_can_register'))
        require(WAFP_VIEWS_PATH . '/shared/wp_cant_register.php');
      
      require(WAFP_VIEWS_PATH . '/wafp-options/form.php');
    }
  }

  function process_form()
  {
    global $wafp_options;
    
    if(WafpUtils::is_logged_in_and_an_admin())
    {
      $errors = array();
      
      $errors = apply_filters('wafp_validate_options', $wafp_options->validate($_POST,$errors));
      
      $wafp_options->update($_POST);
      
      if( count($errors) > 0 )
        require(WAFP_VIEWS_PATH . '/shared/errors.php');
      else
      {
        do_action('wafp_process_options');
        $wafp_options->store();
        require(WAFP_VIEWS_PATH . '/wafp-options/options_saved.php');
      }
      
      if(!$wafp_options->setup_complete)
        require(WAFP_VIEWS_PATH . '/shared/must_configure.php');
        
      if(!get_option('users_can_register'))
        require(WAFP_VIEWS_PATH . '/shared/wp_cant_register.php');

      require(WAFP_VIEWS_PATH . '/wafp-options/form.php');
    }
  }
}
?>
