<?php
class WafpUsersController
{
  function __construct()
  {
    add_action('edit_user_profile', array(&$this, 'display_user_fields'));
    add_action('edit_user_profile_update', array(&$this, 'update_user_fields'));
  }
  
  function display_login_form()
  {
    global $wafp_options, $wafp_blogurl;

    extract($_POST);

    $redirect_to = ( (isset($redirect_to) and !empty($redirect_to) )?$redirect_to:get_permalink( $wafp_options->dashboard_page_id ) );
    $redirect_to = apply_filters( 'wafp-login-redirect-url', $redirect_to );

    if(!empty($wafp_options->login_page_id) and $wafp_options->login_page_id > 0)
    {
      $login_url = get_permalink($wafp_options->login_page_id);
      $login_delim = WafpAppController::get_param_delimiter_char($login_url);
      $forgot_password_url = "{$login_url}{$login_delim}action=forgot_password";
    }
    else
    {
      $login_url = "{$wafp_blogurl}/wp-login.php";
      $forgot_password_url = "{$wafp_blogurl}/wp-login.php?action=lostpassword";
    }

    if(!empty($wafp_options->signup_page_id) and $wafp_options->signup_page_id > 0)
      $signup_url = get_permalink($wafp_options->signup_page_id);
    else
      $signup_url = $wafp_blogurl . '/wp-login.php?action=register';

    if(WafpUtils::is_user_logged_in())
      require( WAFP_VIEWS_PATH . '/shared/already_logged_in.php' );
    else
    {
      if( !empty($wafp_process_login_form) and !empty($errors) )
        require( WAFP_VIEWS_PATH . "/shared/errors.php" );

      require( WAFP_VIEWS_PATH . '/shared/login_form.php' );
    }
  }

  function process_login_form()
  {
    global $wafp_options, $wafp_profiles_controller;

    $errors = WafpUser::validate_login($_POST,array());

    $errors = apply_filters('wafp-validate-login', $errors);

    extract($_POST);

    if(empty($errors))
    {
      $creds = array();
      $creds['user_login'] = $log;
      $creds['user_password'] = $pwd;
      $creds['remember'] = $rememberme;

      if(!function_exists('wp_signon'))
        require_once(ABSPATH . WPINC . '/user.php');

      wp_signon($creds);

      $redirect_to = ((!empty($redirect_to))?$redirect_to:get_permalink($wafp_options->dashboard_page_id));

      WafpUtils::wp_redirect($redirect_to);
      exit;
    }
    else
      $_POST['errors'] = $errors;
  }

  function display_signup_form()
  {
    global $wafp_options, $wafp_blogurl;

    $process = WafpAppController::get_param('wafp-process-form');

    $redirect_to = ( (isset($redirect_to) and !empty($redirect_to) )?$redirect_to:get_permalink( $wafp_options->dashboard_page_id ) );
    $redirect_to = apply_filters( 'wafp-login-redirect-url', $redirect_to );

    if(empty($process))
    {
      if(WafpUtils::is_user_logged_in())
        require( WAFP_VIEWS_PATH . '/shared/already_logged_in.php' );
      else if (!get_option('users_can_register'))
	      require( WAFP_VIEWS_PATH . '/shared/no_registration.php' );
	    else
        require( WAFP_VIEWS_PATH . '/shared/signup_form.php' );
    }
    else
      $this->process_signup_form();
  }

  function process_signup_form()
  {
    global $wafp_options, $wafp_blogname;
    $errors = WafpUser::validate_signup($_POST,array());

    $errors = apply_filters('wafp-validate-signup', $errors);

    extract($_POST);

    if(empty($errors))
    {
      $new_password = $wafp_user_password;

      $user = new WafpUser();
      $user->set_field('user_login', $user_login);
      $user->set_field('user_email', $user_email);
      $user->set_first_name($user_first_name);
      $user->set_last_name($user_last_name);
      $user->set_paypal_email($_POST[WafpUser::$paypal_email_str]);
      if($wafp_options->show_address_fields)
      {
        $user->set_address_one($_POST[WafpUser::$address_one_str]);
        $user->set_address_two($_POST[WafpUser::$address_two_str]);
        $user->set_city($_POST[WafpUser::$city_str]);
        $user->set_state($_POST[WafpUser::$state_str]);
        $user->set_zip($_POST[WafpUser::$zip_str]);
      }
      if($wafp_options->show_tax_id_fields)
      {
        $user->set_tax_id_us($_POST[WafpUser::$tax_id_us_str]);
        $user->set_tax_id_int($_POST[WafpUser::$tax_id_int_str]);
      }
      $user->set_password($wafp_user_password);
      $user->set_is_affiliate(1); // uh .. yeah, this is the affiliate signup page

      // Yeah, we're going to record affiliate parent no matter what
      //$affiliate_id = $_COOKIE['wafp_click'];
      //if(isset($affiliate_id) and $affiliate_id and is_integer($affiliate_id))
      //  $user->set_parent_id($affiliate_id);

      // Makin' it happen...
      $user->create();

      if($user->get_id())
      {
        $user->send_account_notifications($user->get_password());

        do_action('wafp-process-signup',$user->get_id());

        require( WAFP_VIEWS_PATH . "/wafp-users/signup_thankyou.php" );
      }
      else
        require( WAFP_VIEWS_PATH . "/shared/unknown_error.php" );
    }
    else
    {
      require( WAFP_VIEWS_PATH . "/shared/errors.php" );
      require( WAFP_VIEWS_PATH . '/shared/signup_form.php' );
    }
  }

  function display_forgot_password_form()
  {
    global $wafp_options, $wafp_blogurl;

    $process = WafpAppController::get_param('wafp_process_forgot_password_form');

    if(empty($process))
      require( WAFP_VIEWS_PATH . '/wafp-users/forgot_password.php' );
    else
      $this->process_forgot_password_form();
  }

  function process_forgot_password_form()
  {
    global $wafp_options;

    $errors = WafpUser::validate_forgot_password($_POST,array());

    extract($_POST);

    if(empty($errors))
    {
      $is_email = (is_email($wafp_user_or_email) and email_exists($wafp_user_or_email));

      if(!function_exists('username_exists'))
        require_once(ABSPATH . WPINC . '/registration.php');

      $is_username = username_exists($wafp_user_or_email);

      $user = new WafpUser();

      // If the username & email are identical then let's rely on it as a username first and foremost
      if($is_username)
        $user->load_user_data_by_login( $wafp_user_or_email );
      else if($is_email)
        $user->load_user_data_by_email( $wafp_user_or_email );

      if($user->get_id())
      {
        $user->send_reset_password_requested_notification();

        require( WAFP_VIEWS_PATH . "/wafp-users/forgot_password_requested.php" );
      }
      else
        require( WAFP_VIEWS_PATH . "/shared/unknown_error.php" );
    }
    else
    {
      require( WAFP_VIEWS_PATH . "/shared/errors.php" );
      require( WAFP_VIEWS_PATH . '/wafp-users/forgot_password.php' );
    }
  }

  function display_reset_password_form($wafp_key,$wafp_screenname)
  {
    $user = new WafpUser();
    $user->load_user_data_by_login( $wafp_screenname );

	$loginURL = get_permalink($wafp_options->login_page_id);
	if (empty($loginURL))
	  $loginURL = wp_login_url();

    if($user->get_id())
    {
      if($user->reset_form_key_is_valid($wafp_key))
        require( WAFP_VIEWS_PATH . '/wafp-users/reset_password.php' );
      else
        require( WAFP_VIEWS_PATH . '/shared/unauthorized.php' );
    }
    else
      require( WAFP_VIEWS_PATH . '/shared/unauthorized.php' );
  }

  function process_reset_password_form()
  {
    global $wafp_options;
    $errors = WafpUser::validate_reset_password($_POST,array());

    extract($_POST);

    if(empty($errors))
    {
      $user = new WafpUser();
      $user->load_user_data_by_login( $wafp_screenname );

      if($user->get_id())
      {
        $user->set_password_and_send_notifications($wafp_key, $wafp_user_password);

        require( WAFP_VIEWS_PATH . "/wafp-users/reset_password_thankyou.php" );
      }
      else
        require( WAFP_VIEWS_PATH . "/shared/unknown_error.php" );
    }
    else
    {
      require( WAFP_VIEWS_PATH . "/shared/errors.php" );
      require( WAFP_VIEWS_PATH . '/wafp-users/reset_password.php' );
    }
  }
  
  public function display_user_fields( $wpuser )
  {
    global $wafp_options;
    $user = new WafpUser( $wpuser->ID );
    
    if( WafpUtils::is_logged_in_and_an_admin() and
        is_a($user, 'WafpUser') )
    {
      if( isset($_POST['wafp_override_enabled']) and 
          isset($_POST['wafp_override']) and
          !empty($_POST['wafp_override']))
        $wafp_override = $_POST['wafp_override'];
      else
        $wafp_override = get_user_meta($user->get_id(), 'wafp_override', true);
      
      if( isset($_POST[WafpUser::$is_affiliate_str]) )
        $is_affiliate = true;
      else
        $is_affiliate = $user->is_affiliate();
        
      if ($wafp_options->show_tax_id_fields)
      {
        if ( isset($_POST[WafpUser::$tax_id_us_str]) )
          $tax_id_us = $_POST[WafpUser::$tax_id_us_str];
        else
          $tax_id_us = $user->get_tax_id_us();
        
        if ( isset($_POST[WafpUser::$tax_id_int_str]) )
          $tax_id_int = $_POST[WafpUser::$tax_id_int_str];
        else
          $tax_id_int = $user->get_tax_id_int();
      }

      if($wafp_options->show_address_fields)
      {
        if ( isset($_POST[WafpUser::$address_one_str]) )
          $address_one = $_POST[WafpUser::$address_one_str];
        else
          $address_one = $user->get_address_one();
        
        if ( isset($_POST[WafpUser::$address_two_str]) )
          $address_two = $_POST[WafpUser::$address_two_str];
        else
          $address_two = $user->get_address_two();
        
        if ( isset($_POST[WafpUser::$city_str]) )
          $city = $_POST[WafpUser::$city_str];
        else
          $city = $user->get_city();
        
        if ( isset($_POST[WafpUser::$state_str]) )
          $state = $_POST[WafpUser::$state_str];
        else
          $state = $user->get_state();
        
        if ( isset($_POST[WafpUser::$zip_str]) )
          $zip = $_POST[WafpUser::$zip_str];
        else
          $zip = $user->get_zip();
      }

      $hidden_str   = ($wafp_override?"":" wafp-hidden");
      $selected_str = ($wafp_override?' checked="checked"':'');
      $affiliate_selected_str = ($is_affiliate?' checked="checked"':'');
      
      require(WAFP_VIEWS_PATH . "/wafp-users/admin_profile.php");
    }
  }

  public function update_user_fields( $user_id )
  {
    if( WafpUtils::is_logged_in_and_an_admin() )
    {
      update_user_meta($user_id, WafpUser::$is_affiliate_str, isset($_POST[WafpUser::$is_affiliate_str]));

      if(isset($_POST['wafp_override_enabled']) )
        update_user_meta($user_id, 'wafp_override', $_POST['wafp_override']);
      else
        delete_user_meta($user_id, 'wafp_override');
        
      if ( isset($_POST[WafpUser::$tax_id_us_str]) )
        update_user_meta($user_id, WafpUser::$tax_id_us_str, $_POST[WafpUser::$tax_id_us_str]);
      
      if ( isset($_POST[WafpUser::$tax_id_int_str]) )
        update_user_meta($user_id, WafpUser::$tax_id_int_str, $_POST[WafpUser::$tax_id_int_str]);
      
      if ( isset($_POST[WafpUser::$tax_id_int_str]) )
        update_user_meta($user_id, WafpUser::$tax_id_int_str, $_POST[WafpUser::$tax_id_int_str]);
      
      if ( isset($_POST[WafpUser::$address_one_str]) )
        update_user_meta($user_id, WafpUser::$address_one_str, $_POST[WafpUser::$address_one_str]);
      
      if ( isset($_POST[WafpUser::$address_two_str]) )
        update_user_meta($user_id, WafpUser::$address_two_str, $_POST[WafpUser::$address_two_str]);
      
      if ( isset($_POST[WafpUser::$city_str]) )
        update_user_meta($user_id, WafpUser::$city_str, $_POST[WafpUser::$city_str]);

      if ( isset($_POST[WafpUser::$state_str]) )
        update_user_meta($user_id, WafpUser::$state_str, $_POST[WafpUser::$state_str]);

      if ( isset($_POST[WafpUser::$zip_str]) )
        update_user_meta($user_id, WafpUser::$zip_str, $_POST[WafpUser::$zip_str]);
    }
  }
}
?>
