<?php
  /*
   Plugin Name: Awesome Buttons
   Plugin URI: http://vanskyhawk.com/awesome-buttons
   Description: short code for awesome buttons
   Author: Brad Van Skyhawk
   Version:
   Author URI: http://brad.vanskyhawk.com/
   */
  
  define('BST_PLUGIN_NAME', "awesome-buttons");
  $bst_script_url = get_option('home') . '/index.php?plugin=awesome';
  define('BST_PATH', WP_PLUGIN_DIR . '/' . BST_PLUGIN_NAME);
  define('BST_IMAGES_PATH', BST_PATH . '/images');
  define('BST_CSS_PATH', BST_PATH . '/css');
  define('BST_JS_PATH', BST_PATH . '/js');
  define('BST_URL', plugins_url($path = '/' . BST_PLUGIN_NAME));
  define('BST_IMAGES_URL', BST_URL . '/images');
  define('BST_CSS_URL', BST_URL . '/css');
  define('BST_JS_URL', BST_URL . '/js');
  define('BST_SCRIPT_URL', $bst_script_url);
  
  class AwesomeButtons
  {
      var $plugin;
      
      /**
       * constructor - setup the short codes
       *
       * @return void
       * @author Brad Van Skyhawk
       **/
      function __construct()
      {
          $this->plugin = basename(dirname(__FILE__));
          add_action('wp_print_styles', array($this, 'add_stylesheet'));
          add_shortcode('awesome-button', array($this, 'link'));
          add_shortcode('awesome-link', array($this, 'link'));
          add_shortcode('bst-link', array($this, 'link'));
          
          // bst short codes
          add_shortcode('bst-register', array($this, 'register'));
          add_shortcode('bst-shipping', array($this, 'shipping'));
          add_shortcode('bst-offer', array($this, 'offer'));
          add_shortcode('bst-clear-cart', array($this, 'cart_clear'));
          add_shortcode('bst-select', array($this, 'select'));
          add_shortcode('bst-panel', array($this, 'panel'));
      }
      
      /**
       * Short Code - [bst-home-panel]
       * Include a panel in the current page with special formatting.
       *
       * @param $atts
       * @return string
       **/
      function panel($atts, $content = null)
      {
          // Setup the attributes
          $defaults = array(
          	'background_color' => '#ffffff',
          	'title' => null,
          	'title_image' => null,
          );
          $atts = shortcode_atts($defaults, $atts);
          
          if ($atts['title_image'])
          {
	        $upload_dir = wp_upload_dir();
          	$atts['title'] = sprintf('<img src="%s/%s">', $upload_dir['baseurl'], $atts['title_image']);
          }
          extract($atts);

          ob_start();
          include('panel.php');
          $markup = ob_get_contents();
          ob_end_clean();
          
          return $markup;
      }
      
      /**
       * Short Code - [bst-select]
       * The new volume select screen
       *
       * @param $atts
       * @return string
       **/
      function select($atts)
      {
      	$defaults = array(
      		'href' => '/store/volumes-2-4/',
      	);
			extract(shortcode_atts($defaults, $atts));

          ob_start();
          include('select.php');
          $markup = ob_get_contents();
          ob_end_clean();
          
          return $markup;
      }
      
      /**
       * Short Code - [bst-clear-cart]
       * Empty the shopping cart
       *
       * @param $atts - short code attributes
       * @return void
       **/
      function cart_clear($atts)
      {
          global $Shopp;
          
          // Clear the cart
          if (isset($Shopp->Order->Cart))
          {
              $Shopp->Order->Cart->clear();
          }
      }
      
      /**
       * Short Code - [bst-offer]
       * Handle the offer page.
       *
       * @param $atts - short code attributes
       * @return string
       **/
      function offer($atts)
      {
          global $Shopp;
          
          // Clear the cart
          if (isset($Shopp->Order->Cart))
          {
              $Shopp->Order->Cart->clear();
          }
          
          // Setup the attributes
          $defaults = array('no_option' => 0);
          shortcode_atts($defaults, $atts);
          
          if (empty($Shopp->Product->id))
          {
              if (isset($atts['product_name']))
              {
                  $Shopp->Product = new Product($atts['product_name'], 'name');
              }
              elseif (isset($atts['product_slug']))
              {
                  $Shopp->Product = new Product($atts['product_slug'], 'slug');
              }
              elseif (isset($atts['product_id']))
              {
                  $Shopp->Product = new Product($atts['product_id']);
              }
          }
          
          ob_start();
          include('offer.php');
          $markup = ob_get_contents();
          ob_end_clean();
          
          return $markup;
      }
      
      /**
       * Short Code - [bst-shipping]
       * Handle the shipping page.
       *
       * @param $atts - short code attributes
       * @return string
       **/
      function shipping($atts)
      {
          global $Shopp;
          if (!empty($_POST))
          {
              $Shopp->Order->Shipping->method = $_POST['offer'];
              $Shopp->Order->Cart->retotal = true;
              $Shopp->Order->Cart->totals();
              echo '<meta http-equiv="REFRESH" content="0;url=' . $_POST['redirect'] . '">';
              echo '<script javascript="text/javascript">window.location="' . $_POST['redirect'] . '"></script>';
              exit;
          }
          ob_start();
          include('shipping.php');
          $markup = ob_get_contents();
          ob_end_clean();
          
          return $markup;
      }
      
      /**
       * Short Code - [bst-register]
       * Handle the initial product selection and contact information.
       *
       * @param $atts - short code attributes
       * @return string
       **/
      function register($atts)
      {
          global $Shopp;
          
          // Clear the cart
          if (isset($Shopp->Order->Cart))
          {
              $Shopp->Order->Cart->clear();
          }
          
          // Build the form
          $defaults = array('label' => 'Save & Continue &lqoa;', 'href' => '#', );
          shortcode_atts($defaults, $atts);
          
          if (empty($Shopp->Product->id))
          {
              if (isset($atts['product_name']))
              {
                  $Shopp->Product = new Product($atts['product_name'], 'name');
                  $Shopp->Order->Shipping->method = 'Standard Shipping';
              }
              elseif (isset($atts['product_slug']))
              {
                  $Shopp->Product = new Product($atts['product_slug'], 'slug');
                  $Shopp->Order->Shipping->method = 'Standard Shipping';
              }
              elseif (isset($atts['product_id']))
              {
                  $Shopp->Product = new Product($atts['product_id']);
                  $Shopp->Order->Shipping->method = 'Standard Shipping';
              }
              else
              {
                  $markup = "";
              }
          }
          if ($Shopp->Product->variations == 'on')
          {
              $atts['variations'] = 0;
          }
          
          ob_start();
          include('register.php');
          $markup = ob_get_contents();
          ob_end_clean();
          
          return $markup;
      }
      
      /**
       * display a button
       *
       * @return void
       * @author Brad Van Skyhawk
       **/
      function button($atts, $content = null)
      {
          // Set up defaults
          $defaults = array('left' => 0, 'top' => 0, 'color' => null, 'size' => null, 'href' => 'checkout', 'quantity' => 1, );
          shortcode_atts($defaults, $atts);
          
          // Setup class
          $class[] = 'awesome';
          if (!empty($atts['color']))
          {
              $class[] = $atts['color'];
          }
          if (!empty($atts['size']))
          {
              $class[] = $atts['size'];
          }
          $class = implode(' ', $class);
          
          $format = '<input class="%s" value="%s" />';
          
          // Build a add to cart form
          if (isset($atts['product_id']) or isset($atts['product_slug']) or isset($atts['product_name']) or isset($atts['remove_product_slug']))
          {
              global $Shopp;
              
              if (isset($atts['product_name']))
              {
                  $Shopp->Product = new Product($atts['product_name'], 'name');
                  $prod = $atts['product_name'];
              }
              elseif (isset($atts['product_slug']))
              {
                  $Shopp->Product = new Product($atts['product_slug'], 'slug');
                  $prod = $atts['product_slug'];
              }
              elseif (isset($atts['product_id']))
              {
                  $Shopp->Product = new Product($atts['product_id']);
                  $prod = $atts['product_id'];
              }
              
              if (empty($Shopp->Product->id))
              {
              		echo 'Product not found!', " ($prod)";
              		$markup = "";
              }
              
              if ($Shopp->Product->variations == 'on')
              {
                  $atts['variations'] = 0;
              }
              
              ob_start();
              include('product-form.php');
              $markup = ob_get_contents();
              ob_end_clean();
          }
          else
          {
              $markup = sprintf($format, $class, $content);
          }
          
          // Place the button
          if (!empty($atts['left']) or !empty($atts['top']))
          {
              $markup = sprintf('<div style="position: absolute; top: %dpx; left: %dpx">', $atts['top'], $atts['left']) . $markup . '</div>';
          }
          
          return $markup;
      }
      
      /**
       * display a link
       *
       * @return void
       * @author Brad Van Skyhawk
       **/
      function link($atts, $content = null)
      {
          // if product_id, should be button
          if (isset($atts['product_id']) or isset($atts['product_slug']) or isset($atts['product_name']))
          {
              return $this->button($atts, $content);
          }
          
          $defaults = array('left' => null, 'top' => null, 'color' => null, 'size' => null, 'target' => null, 'href' => '#', 'utmx_section' => null);
          shortcode_atts($defaults, $atts);
          
          // Setup class
          $class[] = 'awesome';
          if (!empty($atts['color']))
          {
              $class[] = $atts['color'];
          }
          if (!empty($atts['size']))
          {
              $class[] = $atts['size'];
          }
          $class = implode(' ', $class);
          
          $format = '<a href="%s" class="%s">%s</a>';
          if (!empty($atts['left']) or !empty($atts['top']))
          {
              $format = sprintf('<div style="position: absolute; top: %dpx; left: %dpx">', $atts['top'], $atts['left']) . $format . '</div>';
          }
          
          return sprintf($format, $atts['href'], $class, $content);
      }
     
      /**
       * Include the stylesheet
       */
      function add_stylesheet()
      {
          require_once('php-browser-detection.php');
          
          //if (0)
          if (is_lt_IE8())
          {
              $style_url = BST_URL . '/style-ie.css';
              $style_file = BST_PATH . '/style-ie.css';
          }
          else
          {
              $style_url = BST_URL . '/style.css';
              $style_file = BST_PATH . '/style.css';
          }
          if (file_exists($style_file))
          {
              wp_register_style('awesome-style', $style_url);
              wp_enqueue_style('awesome-style');
          }
      }
  }
  
  $awesome_buttons = new AwesomeButtons();
  
  function pr($out, $continue = false)
  {
      echo '<pre>';
      print_r($out);
      echo '</pre>';
      if (!$continue)
          exit;
  }
