<?php
/*
Plugin Name: Baby Signing Time Email List
Plugin URI: http://vanskyhawk.com/bst-contact/
Description: List of contacts for the home page
Author: Brad Van Skyhawk
Version: 0.2
Author URI: http://brad.vanskyhawk.com/
*/

class BSTContact 
{
	/**
	 * Setup the hooks
	 **/
	function __construct()
	{
		register_activation_hook(__FILE__, array($this, 'activate'));
	}
	
	/**
	 * Activate handler
	 **/
	function activate()
	{
		global $wpdb;

		$table_name = $wpdb->prefix . 'bst_contacts';

		if ( $wpdb->get_var('SHOW TABLES LIKE ' . $table_name) != $table_name )
		{
			$sql = 'CREATE TABLE ' . $table_name . '( 
				id INTEGER(10) UNSIGNED AUTO_INCREMENT,
				first_name VARCHAR (255),
				last_name VARCHAR (255),
				email VARCHAR (255),
				ipaddress VARCHAR (255),
				user_agent VARCHAR (255),
				hit_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY  (id) )';
		
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);
		
			add_option('bst_contacts_database_version','1.0');
		}
	}
}

function bstc_option_page()
{
	echo '<div class="wrap">';
	screen_icon();
	echo '<h2>BST Contact List Page</h2>';
	$rows = read_file();
	echo '<table border="1"><tr><th>Date</th><th>First Name</th><th>Last Name</th><th>Email Address</th><th>IP Address</th><th>Purchase</th></tr>';
	foreach ($rows as $r)
	{
		if ($r['purchased'] == 'Yes')
		{
			echo '<tr style="background-color: aqua" align="center"><td>';
		}
		else
		{
			echo '<tr align="center"><td>';
		}
		echo implode('</td><td>', $r);
		echo '</td></tr>';
	}
   echo '</table>';
	echo '</div>';
}

function read_file()
{
	global $wpdb;
	
	$excludes = array('shon.burns@gmail.com', 'karyburns@gmail.com', 'karyburns@brightwagon.com', 'bburns@brightwagon.com', 'brad@vanskyhawk.com', 'brad@vanskyhawk.org', 'mblyman@gmail.com', 'shon9burns@yahoo.com', 'brettburns1959@msn.com', 'test@test.com', 'sbkatb@yahoo.com', 'tanya1249@gmail.com', 'test@bb.com');
	$keys = array('date','firstname','lastname','email','ip');
	$rows = array();
	if (($handle = fopen("/var/www/html/vanskyhawk.net/bst.csv", "r")) !== false)
	{
		while (($data = fgetcsv($handle, 1000, ",")) !== false) 
		{
			$line = array_combine($keys, $data);
			$email = $line['email'];
			$line['date'] = date('M d, Y', strtotime($line['date']));
			$line['email'] = sprintf('<a href="mailto:%s">%s</a>', $line['email'], $line['email']);
			$line['ip'] = sprintf('<a href="http://www.ip2location.com/%s" target="_blank">%s</a>', $line['ip'], $line['ip']);
			$line['purchased'] = $wpdb->get_var("SELECT * FROM wp_shopp_purchase WHERE email = '$email'") ? 'Yes' : 'No';
			if (!empty($email) and !in_array($email, $excludes))
			{
				$rows[$email] = $line;
			}
    	}
		fclose($handle);
	}
	
	return $rows;
}

function bstc_plugin_menu()
{
	add_options_page('BST Contact Settings','BST Contacts', 'manage_options', 'bst-contact', 'bstc_option_page');
}
add_action('admin_menu', 'bstc_plugin_menu');
