<?php
/*
Plugin Name: OrderMotion
Plugin URI: http://vanskyhawk.com/order-motion
Description: Submits order to OrderMotion after shopp_process_order
Author: Brad Van Skyhawk
Version: 1.0
Author URI: http://brad.vanskyhawk.com/
*/

class OrderMotionPost {

	function __construct()
	{
		$this->actions();
	}
	
	/**
	 * Add hooks and filters
	 */
	function actions()
	{
		add_action('shopp_init_checkout', array(&$this, 'init_checkout'));
		add_action('shopp_checkout_processed', array(&$this, 'checkout_processed'));
		add_action('shopp_order_success', array(&$this,'order_success'));
		add_filter('shopp_billing_postcode_required', array(&$this, 'billing_postcode'));

		// Handle coupon codes
		add_action('shopp_download_request', array(&$this, 'download_request'));
		add_shortcode('bst-coupon-code', array(&$this, 'coupon_code'));
		
		// Verify cart contents
		add_action('shopp_init', array(&$this, 'cart_request'));
	}
	
	function billing_postcode($empty)
	{
		$regex = array(
            'CA' => '/\\A\\b[ABCEGHJKLMNPRSTVXY][0-9][A-Z][ ]?[0-9][A-Z][0-9]\\b\\z/i',
            'US' => '/\\A\\b[0-9]{5}(?:-[0-9]{4})?\\b\\z/i',
            'default' => '/\\A\\b[0-9]{5}(?:-[0-9]{4})?\\b\\z/i' // Same as US.
        );
		$country = $_POST['billing']['country'];
		$postcode = $_POST['billing']['postcode'];
		if (!isset($regex[$country]))
		{
			$country = 'default';
		}
		return !preg_match($regex[$country], $postcode);
	}
	
	/**
	 * Redirect the download
	 */
	function download_request($Purchased)
	{
		$_SESSION['_download_sku'] = $this->sku2sku($Purchased->sku);
		shopp_redirect('/ondemand/?_=' . $Purchased->dkey);
	}
	
	/**
	 * Converts the real sku into the download sku
	 */
	function sku2sku($sku)
	{
		$skus = array(
			'bstplayer1' => array(
				'bstplayer1', 'bstprintplyr'
			),
			'bstplayer2' => array(
				'bstplayer2', 'bst1-4bkplyr', 'bst-deluxeplyr', 'bstprintpack', 'bst-deluxe2', 'bst1-4dvdfcplyr'
			),
		);
		
		foreach ($skus as $dsku => $nsku)
		{
			if (in_array(strtolower($sku), $nsku))
			{
				return $dsku;
			}
		}
		
		return null;
	}
		
	/**
	 * Show the coupon code if exists
	 */
	function coupon_code()
	{
		if (isset($_GET['_']))
		{
			global $wpdb;
			
			$table = 'wp_bst_couponcodes';
			$dkey = $_GET['_'];
			$sku = $_SESSION['_download_sku'];
			$sql = "SELECT code FROM $table WHERE dkey = '$dkey'";
			$code = $wpdb->get_var($sql);
			
			// has not been used
			if (empty($code))
			{
				$sql = "SELECT code FROM $table WHERE dkey = '' AND sku = '$sku'";
				$code = $wpdb->get_var($sql);
				
				// assign code
				$wpdb->query("UPDATE $table SET dkey = '$dkey' WHERE code = '$code'");
			}
			if (!empty($code))
			{
				echo '<style>#coupon-code{ font-size: 14px; text-align: center; padding: 20px; border: 3px #6cb5e5 solid; background-color: #feec93; }</style>';
				echo '<div id="coupon-code">This is your coupon code: <strong>' . $code . '</strong></div>';
			}
		}
	}
		
	/**
	 * Filter the shipping options
	 */
	function init_checkout()
	{
		global $Shopp;
		
		$ship = $Shopp->Order->Shipping;
		
		// don't know where we are going yet.
		if (empty($ship->country)) return;
		
		if ($ship->country == 'US')
		{
			if (!in_array($ship->state, array('AK','HI')))
			{
				// bst-deluxe free shipping
				$freeshipping = false;
				foreach ($Shopp->Order->Cart->contents as $cart)
				{
					if ($cart->sku == 'bst-deluxeplyr' and $cart->slug == 'bst-deluxeplyr')
					{
						$freeshipping = true;
						$Shopp->Order->Shipping->method = 'Free Shipping';
						break;
					}
				}
			}
		}
		$Shopp->Order->Cart->retotal = true;
		$Shopp->Order->Cart->totals();
	}
	
	/**
	 * Save the card number for passing to OrderMotion
	 */
	function checkout_processed()
	{
		global $Shopp;
		$Shopp->Order->Billing->cardsave = $Shopp->Order->Billing->card;
		$Shopp->Order->Billing->cvvsave = $Shopp->Order->Billing->cvv;
	}	
	
	/**
	 * Order was successful, send to OrderMotion
	 */
	function order_success($purchase)
	{
		// add to purchase email list
		$this->cc_add_contact($purchase->email, $purchase->firstname, $purchase->lastname, 4);
		$this->cc_remove_contact($purchase->email, 2);
		$this->cc_edit_contact($purchase->email, $purchase->subtotal, $purchase->freight, $purchase->tax, $purchase->total, $purchase->discount);
		
		global $Shopp;
		$purchase->card = $Shopp->Order->Billing->cardsave;
		$purchase->cvv = $Shopp->Order->Billing->cvvsave;
		$purchase->authcode = $Shopp->Response->authcode;
		$purchase->slug = 
		$this->send($purchase);
	}
	
	/**
	 * Add the Customer and Billing info the the session.
	 */
	function cart_request()
	{
		global $Shopp;
		
		// Save customer data
		if (isset($_REQUEST['bst']) and $_REQUEST['bst'] == 'register')
		{
			if (empty($Shopp->Order->Customer))
			{
				$Shopp->Order->Customer = new Customer();
			}
			$Shopp->Order->Customer->updates($_POST);

			if (empty($Shopp->Order->Billing))
			{
				$Shopp->Order->Billing = new Billing();
			}
			$Shopp->Order->Billing->updates($_POST['billing']);
						
			error_log(date('r') . ': ' . print_r($_POST, true) . "\n" , 3, '/var/data/post.log');
			error_log(sprintf('"%s","%s","%s","%s","%s"' . "\n", date('r'), $_POST['firstname'], $_POST['lastname'], $_POST['email'], $_SERVER['REMOTE_ADDR']), 3, '/var/data/bst.csv');
			
			// Add to constant contact
			$this->cc_add_contact($_POST['email'], $_POST['firstname'], $_POST['lastname'], 2);

			if (isset($_REQUEST['redirect']))
			{
				shopp_redirect($_REQUEST['redirect']);
				exit;
			}
		}
		   	
		// Remove product from cart
		if (isset($_REQUEST['bst-remove']))
		{
			foreach ($Shopp->Order->Cart->contents as $key => $item)
			{
				if ($item->sku == $_REQUEST['bst-remove'])
				{
					$Shopp->Order->Cart->remove($key);
				}
			}
		}
		
		// special select page
		$buyall = 'bst-deluxeplyr';
		if (isset($_REQUEST['bst']) and $_REQUEST['bst'] == 'select')
		{
			global $Shopp;
			$price = false;
			
			if (isset($_REQUEST['buy-all']))
			{
				$Product = new Product($buyall, 'slug');
				$Shopp->Order->Cart->add(1, $Product, $price);
			}
			else if (isset($_REQUEST['buy-checked']))
			{
				if (count($_REQUEST['volume']) == 0)
				{
					return;
				}
				else if (count($_REQUEST['volume']) == 4)
				{
					$Product = new Product($buyall, 'slug');
					$Shopp->Order->Cart->add(1, $Product, $price);
				}
				else
				{
					foreach ($_REQUEST['volume'] as $item)
					{
						$Product = new Product($item, 'slug');
						$Shopp->Order->Cart->add(1, $Product, $price);
					}
				}
			}
						
			// redirect if needed
			if (isset($_REQUEST['redirect']))
			{
				shopp_redirect($_REQUEST['redirect']);
				exit;
			}
		}
				
	}
	
	/**
	 * Send to constant contact
	 */
	function cc_add_contact($email, $firstname, $lastname, $list)
	{
		include_once('constant_contact.php');
		$contact = array('EmailAddress' => $email, 'FirstName' => $firstname, 'LastName' => $lastname, 'OptInSource' => 'ACTION_BY_CUSTOMER');
		$api = new constant_contact('brightwagon','braydMan6','7a98415c-cf9a-401c-912c-f268170d40ce');
		$contact_id = $api->search_contact_by_email($email);
		if ($contact_id)
		{
			$api->add_subscription($contact_id, $list);
		}
		else
		{
			$api->add_contact($contact, array($list));
		}
	}
	
	/**
	 * Remove an email from a constant contact list.
	 */
	function cc_remove_contact($email, $list)
	{
		include_once('constant_contact.php');
		$api = new constant_contact('brightwagon','braydMan6','7a98415c-cf9a-401c-912c-f268170d40ce');
		$contact_id = $api->search_contact_by_email($email);
		if ($contact_id)
		{
			$api->remove_subscription($contact_id, $list);
		}
	}
	
	/**
	 * Add purchase information
	 */
	function cc_edit_contact($email, $subtotal, $freight, $tax, $total, $discount)
	{
		include_once('constant_contact.php');
		$api = new constant_contact('brightwagon','braydMan6','7a98415c-cf9a-401c-912c-f268170d40ce');
		$contact_id = $api->search_contact_by_email($email);
		if ($contact_id)
		{
			$contact = array(
				'CustomField1' => $subtotal,
				'CustomField2' => $freight,
				'CustomField3' => $tax,
				'CustomField4' => $total,
				'CustomField5' => $discount,
			);
			$api->edit_contact($contact_id, $contact);
		}
	}
	
	
	/**
	 * Set the order to OMX
	 */
	function send($purchase, $verify=false)
	{	
		include('omx.php');
		
		$settings = array(
		'authtoken' => 'd75f6b54047c70434e0983706643040e533ec11b24340611f04f770b5fc0301a3fb1c96525231ab00cd62047fd0bc4b06eb253d1ba788c8031990d3a304b0c0b7e1085da7fac5b333e7b5c0e08b94047350ad750502eec96139cf09fca9c095fd0486709e6f0d3f42dcd26fcef2b7a2a052c504e790a75f02a1c64d5e9dd9f1',
		'apiurl' => 'https://api.omx.ordermotion.com/hdde/xml/udi.asp',
		'keycode' => 'BST-TV-LF',
		'verify_flag' => $verify ? 'True' : 'False',
		'queue_flag' => 'True',
		);
		
		// Build the order
		$xml = new OMX('1.0', 'UTF-8');
		$xml->formatOutput = true;
		
		$root = $xml->newElement('UDOARequest', '', 'version', '2.00');
		
		$udiparam = $xml->newElement('UDIParameter');
		$udiparam->appendChild($xml->newElement('Parameter', $settings['authtoken'], 'key', 'UDIAuthToken'));
		$udiparam->appendChild($xml->newElement('Parameter', $settings['keycode'], 'key', 'Keycode'));
		$udiparam->appendChild($xml->newElement('Parameter', $settings['verify_flag'], 'key', 'VerifyFlag'));
		$udiparam->appendChild($xml->newElement('Parameter', $settings['queue_flag'], 'key', 'QueueFlag'));
		$root->appendChild($udiparam);
	
		$header = $xml->newElement('Header');
		/* For affiliate
		$xml->newElement('SiteID', '?');
		$xml->newElement('ClickID', '?');
		*/
		$header->appendChild($xml->newElement('OrderDate', date('Y-m-d H:i:s')));
		$header->appendChild($xml->newElement('OriginType', '3'));
		$header->appendChild($xml->newElement('CustomerIP', $purchase->ip));
		$header->appendChild($xml->newElement('StoreCode', 'ONLINE'));
		$header->appendChild($xml->newElement('OrderID', $purchase->id));
		$root->appendChild($header);
		
		$customer = $xml->newElement('Customer');
		$address = $xml->newElement('Address', '', 'type', 'BillTo');
		$address->appendChild($xml->newElement('TitleCode', '0'));
		$address->appendChild($xml->newElement('Firstname', $purchase->firstname));
		$address->appendChild($xml->newElement('Lastname', $purchase->lastname));
		$address->appendChild($xml->newElement('Address1', $purchase->address));
		$address->appendChild($xml->newElement('Address2', $purchase->xaddress));
		$address->appendChild($xml->newElement('City', $purchase->city));
		$address->appendChild($xml->newElement('State', $purchase->state));
		$address->appendChild($xml->newElement('ZIP', $purchase->postcode));
		$address->appendChild($xml->newElement('TLD', $purchase->country));
		$address->appendChild($xml->newElement('PhoneNumber', $purchase->phone));
		$address->appendChild($xml->newElement('Email', $purchase->email));
		$customer->appendChild($address);
		$root->appendChild($customer);
		
		$shippingInfo = $xml->newElement('ShippingInformation', '');
		$shippingInfo->appendChild($xml->newElement('MethodCode', $this->ship_method($purchase->shipmethod, $this->with_sku($purchase->purchased, array('BSTSTCOMBO1PCON','BSTSTCOMBO3P')))));
		$shippingInfo->appendChild($xml->newElement('ShippingAmount', $purchase->freight));
		if (!empty($purchase->shipaddress) && !empty($purchase->shippostcode)) {
			$address = $xml->newElement('Address', '', 'type', 'ShipTo');
			$address->appendChild($xml->newElement('TitleCode', '0'));
			$address->appendChild($xml->newElement('Firstname', $purchase->firstname));
			$address->appendChild($xml->newElement('Lastname', $purchase->lastname));
			$address->appendChild($xml->newElement('Address1', $purchase->shipaddress));
			$address->appendChild($xml->newElement('Address2', $purchase->shipxaddress));
			$address->appendChild($xml->newElement('City', $purchase->shipcity));
			$address->appendChild($xml->newElement('State', $purchase->shipstate));
			$address->appendChild($xml->newElement('ZIP', $purchase->shippostcode));
			$address->appendChild($xml->newElement('TLD', $purchase->shipcountry));
			$shippingInfo->appendChild($address);
		}
		$root->appendChild($shippingInfo);
		
		$paymentType = $xml->newElement('Payment', '', 'type', '1');
		$paymentType->appendChild($xml->newElement('BuyerEmail', $purchase->email));
		$paymentType->appendChild($xml->newElement('GiftCertificateCode', ''));
		$paymentType->appendChild($xml->newElement('CardNumber', $purchase->card));
		$paymentType->appendChild($xml->newElement('CardVerification', $purchase->cvv));
		$paymentType->appendChild($xml->newElement('CardExpDateMonth', date('m', $purchase->cardexpires)));
		$paymentType->appendChild($xml->newElement('CardExpDateYear', date('Y', $purchase->cardexpires)));
		$paymentType->appendChild($xml->newElement('RealTimeCreditCardProcessing', 'False'));
		$paymentType->appendChild($xml->newElement('CardStatus', 11));
		$paymentType->appendChild($xml->newElement('CardAuthCode', $purchase->cardauth));
		$paymentType->appendChild($xml->newElement('CardTransactionID', $purchase->txnid));
	
		// Find payment plan
		$payment_plan = $this->payment_plan($purchase);
		$paymentType->appendChild($xml->newElement('PaymentPlanID', $payment_plan));
		$root->appendChild($paymentType);
		
		$orderDetail = $xml->newElement('OrderDetail', '');
		$number = 1;
		$discount = round($purchase->discount, 2);
		foreach ($purchase->purchased as $item)
		{
			$lineItem = $xml->newElement('LineItem', '', 'lineNumber', $number++);
			$lineItem->appendChild($xml->newElement('ItemCode', strtoupper($item->sku)));
			$lineItem->appendChild($xml->newElement('Quantity', $item->quantity));
			/*
			$standing_order = $this->standing_order($item);
			if ($standing_order)
			{
				$lineItem->appendChild($xml->newElement('StandingOrder', '', 'configurationID', $standing_order));
			}
			*/
			if ($discount)
			{
				$linetotal = $item->unitprice * $item->quantity;
			   if ($linetotal < $discount)
			   {
					$lineItem->appendChild($xml->newElement('UnitPrice', 0));
					$discount -= $linetotal;
			   }
			   else
			   {
					$lineItem->appendChild($xml->newElement('UnitPrice', round($item->unitprice - ($discount / $item->quantity), 2)));
					$discount = 0;
			   }
			}
			else
			{
				// Override order motion price
				$lineItem->appendChild($xml->newElement('UnitPrice', round($item->unitprice, 2)));
			}
			$orderDetail->appendChild($lineItem);
		}
		$root->appendChild($orderDetail);
		
		$xml->appendChild($root);
	
		/*
		$file = '/var/tmp/omx/' . $purchase->id . '.xml';
		//file_put_contents($file, $xml->saveXML());
		
		if (!class_exists( 'WP_Http' )) include_once( ABSPATH . WPINC. '/class-http.php' );
		$request = new WP_Http();
		$content = $request->request($settings['apiurl'], array('method' => 'POST', 'body' => $xml->saveXML()));

		// crypted file		
		$crypted = $file . '.crypt';
		$pass = 'equ1n0x';
		$method = 'aes128';
    	file_put_contents($crypted, openssl_encrypt ($xml->saveXML(), $method, $pass));
		
		// save response
		$response = $file . '.rsp';
		file_put_contents($response, $content['body']);
		*/

		echo '<pre>';
		echo htmlentities($xml->saveXML());
		exit;
	}
	
	/**
	 *	Build a dummy purchase record
	 */
	function build_purchase()
	{
		global $Shopp;
		
		$Purchase = new Purchase();
		$Purchase->copydata($Shopp->Order);
		$Purchase->copydata($Shopp->Order->Customer);
		$Purchase->copydata($Shopp->Order->Billing);
		$Purchase->copydata($Shopp->Order->Shipping,'ship');
		$Purchase->copydata($Shopp->Order->Cart->Totals);
		$Purchase->customer = $Shopp->Order->Customer->id;
		$Purchase->billing = $Shopp->Order->Billing->id;
		$Purchase->shipping = $Shopp->Order->Shipping->id;
		$Purchase->freight = $Shopp->Order->Cart->Totals->shipping;
		$Purchase->ip = $Shopp->Shopping->ip;

		foreach($Shopp->Order->Cart->contents as $Item) 
		{
			$Purchased = new Purchased();
			$Purchased->copydata($Item);
			$Purchased->price = $Item->option->id;
			$Purchased->purchase = $Purchase->id;
			$Purchase->purchased[] = $Purchased;
		}

		return $Purchase;
	}
	
	/**
	 * Copy data to created purchase object
	 */
	function copydata($Object,$prefix="") 
	{
		$ignores = array("_datatypes","_table","_key","_lists","id","created","modified");
		foreach(get_object_vars($Object) as $property => $value) 
		{
			$property = $prefix.$property;
			if (property_exists($this,$property) &&
				!in_array($property,$ignores))
				$this->{$property} = $value;
		}
	}
	
	
	/**
	 * Get the shipping method
	 */
	function ship_method($ship_method, $has_combo)
	{
		switch (true)
		{
			case strpos($ship_method, 'Standard') !== false:
				$sm = 1;
				break;
				
			case strpos($ship_method, 'Rush') !== false:
				$sm = 8;
				break;
				
			case strpos($ship_method, 'Canada') !== false:
				$sm = 5;
				break;
				
			case strpos($ship_method, 'AK') !== false:
				$sm = 6;
				break;
				
			default:
				$sm = 1;
				break;

		}
		return $sm;
	}
	
	function with_sku($purchased, $sku)
	{
		foreach ($purchased as $item)
		{
			if ((is_array($sku) and in_array($item->sku, $sku)) or ($item->sku == $sku))
			{
				return true;
			}
		}
		return false;
	}
	
	/**
	 * Return the standing order id for this item.
	 */
	function standing_order($item)
	{
		$standing_order = array(
		'ST1V4-6KIT' => 6,
		'BST1-KIT' => 8,
		'BSTSTCOMBO1PCON' => 16,
		);
		$sku = strtoupper($item->sku);
		if (isset($standing_order[$sku]))
		{
			return $standing_order[$sku];
		}
		return 0;
	}
	
	/**
	 * Return the payment plan for this order
	 */
	function payment_plan($purchase)
	{
		foreach ($purchase->purchased as $item)
		{
			if (strtolower($item->sku) == 'bst-deluxeplyr' and round($item->unitprice, 2) == '39.95')
			{
				return 13;
			}
		}
		return 0;
	}
	
	/**
	 * Dump variable and exit
	 */
	private function pr($string, $continue=false)
	{
		echo '<pre>';
		print_r($string);
		echo '</pre>';
		if ($continue==false) exit;
	}
	

}

$omp = new OrderMotionPost();