<?php
  /*
   Plugin Name: Shopp Affiliates
   Version: 1.7
   Description: Integrates Shopp purchases with Google or SAS Affliliate Networks
   Plugin URI: http://shopplugin.net
   Author: Brad Van Skyhawk
   Author URI: http://vanskyhawk.com/
   Requirements: Requires Shopp 1.x
   */
  
  /*
   Modifcation History
   Aug 5, 2001 - Initial code for Google Affiliates
   Aug 12, 2011 - Added Share A Sale Affiliates
   Aug 16, 2011 - Changed amount to include discount and exclude shipping and tax
   Oct 11, 2011 - Added ShoppSocially scripts
   Nov 2, 2011 - Added product images to ShoppSocially
   */
  
  class ShoppAffiliates
  {
  		/**
  		 * Constructor - setup the class
  		 */
      function __construct()
      {
          $this->actions();
      }
      
      /**
       * Set up actions for the plugin
       *
       * @return void
       * @author Brad Van Skyhawk
       **/
      function actions()
      {
          add_action('wp_footer', array($this, 'pixel'));
          add_action('admin_menu', array($this, 'admin'));
      }
      
      /**
       * Write the pixel
       *
       * @return void
       * @author Brad Van Skyhawk
       **/
      function pixel()
      {
          global $Shopp;
          
          // Check for click id and save it
          if (isset($_REQUEST['clickid']))
          {
              if (!isset($_SESSION))
              {
                  session_start();
              }
              $_SESSION['clickid'] = $_REQUEST['clickid'];
          }
          
          // Only process if we're in the checkout process (receipt page)
          if (function_exists('is_shopp_page') && !is_shopp_page('checkout'))
          {
              return;
          }
          
          // Get the purchase record from Shopp
          if (version_compare(substr(SHOPP_VERSION, 0, 3), '1.1') >= 0)
          {
				  // For > 1.0
				  // Only Process if we have valid order data
              if (empty($Shopp->Purchase->id))
              {
                  return;
              }
              $Purchase = new Purchase($Shopp->Purchase->id);
              $Purchase->load_purchased();
          }
          else
          {
              // For 1.0.x
              // Only process if we have valid order data
              if (!isset($Shopp->Cart->data->Purchase) or empty($Shopp->Cart->data->Purchase->id))
              {
                  return;
              }
              $Purchase = $Shopp->Cart->data->Purchase;
          }
                    
          // Get purchase information
          $oid = $Purchase->id;
          
          // Get click id (Google) if exists
          if (!isset($_SESSION))
          {
              session_start();
          }
          $clickid = $_SESSION['clickid'];
          
          // Get all of the order information
          $amt = 0;
          foreach ($Purchase->purchased as $purchased)
          {
              $sku[] = $purchased->sku;
              $quantity[] = $purchased->quantity;
              $category[] = $purchased->optionlabel;
              $price[] = number_format($purchased->unitprice, 2);
              $amt += $purchased->unitprice;
          }
          $prdsku = implode('^', $sku);
          $prdqn = implode('^', $quantity);
          $prdcatid = implode('^', $category);
          $prdpr = implode('^', $price);
          $amt = number_format($amt - $Purchase->discount, 2);
          
          //////////////////////////////////////////////////////////////////////
          // Google pixel     
          $advertiser_id = $Shopp->Settings->get('google_advertiser_id');
          if (!empty($advertiser_id))
          {
              $pixel = '<img src="https://gan.doubleclick.net/gan_conversion?advid=%s&event_type=transaction&oid=%s&amt=%s&prdsku=%s&prdqn=%s&prdpr=%s&prdcatid=%s&clickid=%s" width="1" height="1">';
              echo sprintf($pixel, $advertiser_id, $oid, $amt, $prdsku, $prdqn, $prdpr, $prdcatid, $clickid);
          }
          
          //////////////////////////////////////////////////////////////////////
          // SAS pixel
          $merchant_id = $Shopp->Settings->get('sas_merchant_id');
          if (!empty($merchant_id))
          {
              $pixel = '<img src="https://shareasale.com/sale.cfm?amount=%s&tracking=%s&transtype=sale&merchantID=%s" width="1" height="1">';
              echo sprintf($pixel, $amt, $oid, $merchant_id);
          }
          
          //////////////////////////////////////////////////////////////////////
          // ShopSocially
          $partner_id = $Shopp->Settings->get('ss_partner_id');
          if (!empty($partner_id))
          {
          	  global $wpdb;
				  $default = 'https://www.babysigningtime.com/wp-content/uploads/bst_logo_web.png';

              echo '<div id="ssFrame"></div>';
              echo '<script language="javascript" type="text/javascript" src="https://shopsocially.com/js/all.js"></script>';
				  echo '<script language="javascript" type="text/javascript">';
				  echo sprintf('ss_mi.init({partner_id: "%s", order_id:"%s"});', $partner_id, $oid);
				  echo 'ss_mi.add_products([';
				  $total = count($Purchase->purchased);
				  $row = 0;
				  foreach ($Purchase->purchased as $purchased)
				  {
				  		$sku = strtolower($purchased->sku);
				  		$img = $wpdb->get_var("SELECT guid FROM $wpdb->posts WHERE post_title = '$sku' AND post_type = 'attachment'");
				  		if (empty($img))
				  		{
				  			$img = $default;
				  		}
				  	   $row++;
				  		echo '{';
				  		
				  		echo "prod_page_url:'https://www.babysigningtime.com/',";
				  		echo "prod_img_url:'$img',";
				  		echo sprintf("prod_title:'%s',", $purchased->name);
				  		echo "prod_currency:'USD',";
        				echo sprintf("prod_price:'%s'", number_format($purchased->unitprice, 2));
				  		
				  		if ($row == $total)
				  		{
				  		   echo '}';
				  		}
				  		else
				  		{
				  			echo '},';
				  		}
				  }
				  echo ']);';
              echo "ss_mi.load_ssFrame({div_id: 'ssFrame'});";
			     echo '</script>';
          }
      }
      
      /**
       * Admin menu setup
       *
       * @return void
       * @author Brad Van Skyhawk
       **/
      function admin()
      {
          if (function_exists('add_submenu_page'))
          {
              add_submenu_page('plugins.php', __('Shopp Affiliates', 'Shopp'), __('Shopp Affiliates', 'Shopp'), 'manage_options', 'shopp-affiliates-config', array($this, 'config'));
          }
      }
      
      /**
       * Configuration
       *
       * @return void
       * @author Brad Van Skyhawk
       **/
   function config () 
   {
   	global $Shopp;
   	if (!current_user_can('manage_options'))
   	{
   		wp_die(__('You do not have sufficient permissions to access this page.'));
		}
   ?>
   <?php if ( isset($_POST['save']) ) : ?>
   <?php
   	check_admin_referer('shopp-affiliates-config');
   	if (version_compare(substr(SHOPP_VERSION,0,3),'1.1') >= 0) 
   	{
   		$Shopp->Settings->save('google_advertiser_id',$_POST['settings']['google_advertiser_id']);
   		$Shopp->Settings->save('sas_merchant_id',$_POST['settings']['sas_merchant_id']);
   		$Shopp->Settings->save('ss_partner_id',$_POST['settings']['ss_partner_id']);
   	} 
   	else 
   	{
   		if (method_exists($Shopp->Flow,'settings_save()')) $Shopp->Flow->settings_save();
   	}
   ?>
   <div id="message" class="updated fade"><p><strong><?php _e('Options saved.') ?></strong></p></div>
   <?php endif; ?>
   <div class="wrap">
   	<h2><?php _e('Shopp Affiliates','Shopp'); ?></h2>
   	<form name="settings" id="shopp-affiliates-config" action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
   		<?php wp_nonce_field('shopp-affiliates-config'); ?>
   	<table class="form-table"> 
   		<tr class="form-required"> 
   			<th scope="row" valign="top"><label for="google_advertiser_id"><?php _e('Google Advertiser ID','Shopp'); ?></label></th> 
   			<td><input type="text" name="settings[google_advertiser_id]" value="<?php echo attribute_escape($Shopp->Settings->get('google_advertiser_id')); ?>" id="google_advertiser_id" size="30" /><br /> 
               <?php _e('Enter your Google Affiliate Network Advertiser ID.','Shopp'); ?></td>
   		</tr>
   		<tr class="form-required"> 
   			<th scope="row" valign="top"><label for="sas_merchant_id"><?php _e('SAS Merchant ID','Shopp'); ?></label></th> 
   			<td><input type="text" name="settings[sas_merchant_id]" value="<?php echo attribute_escape($Shopp->Settings->get('sas_merchant_id')); ?>" id="sas_merchant_id" size="30" /><br /> 
               <?php _e('Enter your Share A Sale Merchant ID.','Shopp'); ?></td>
   		</tr>
   		<tr class="form-required"> 
   			<th scope="row" valign="top"><label for="ss_partner_id"><?php _e('ShopSocially Partner ID','Shopp'); ?></label></th> 
   			<td><input type="text" name="settings[ss_partner_id]" value="<?php echo attribute_escape($Shopp->Settings->get('ss_partner_id')); ?>" id="ss_partner_id" size="30" /><br /> 
               <?php _e('Enter your ShoppSocially Parnter ID.','Shopp'); ?></td>
   		</tr>
   	</table>
   	<p class="submit"><input type="submit" class="button-primary" name="save" value="<?php _e('Save Changes','Shopp'); ?>" /></p>
   	</form>

   </div>
   <?php
   }
}

$sgan1 = new ShoppAffiliates();
