<?php
/*
Plugin Name: Shopp / Baby Signing Time Handler
Plugin URI: http://vanskyhawk.com/
Description: Special functionality for intergration with BST and Shopp.
Author: Brad Van Skyhawk
Version: 0.1
Author URI: http://vanskyhawk.com/
*/

define('BST_PLUGIN_NAME', 'Shopp / BST Handler');

class ShoppBSTHandler 
{
	private $url;
	private $plugin_dir;
	
	/**
 	* constructor
 	*
 	* @return void
 	* @author Brad Van Skyhawk
 	**/
	function __construct()
	{
		$this->plugin_dir = WP_PLUGIN_DIR . '/' . dirname(plugin_basename(__FILE__));
		
		if (!session_id()) session_start();
		
		// Setup links
		// TODO: add these options to admin
		$home = get_option('home');
		$this->url['try'] = $home . '/store/trialoffer/';
		$this->url['buy'] = $home . '/store/buynow/';
		$this->url['shop'] = $home . '/store/';
		$this->url['login'] = $home . '/store/account/?acct';
		$this->url['register'] = $home . '/store/register/';
		$this->url['offer'] = $home . '/select-offer/';
		
		// Setup actions
		add_action('init', array($this, 'handle_request'));
		add_action('shopp_logged_out', array($this, 'after_logout'));
		
		// Setup filters
		add_filter('shopp_recover_password_message', array($this, 'recover_password_message'));
		
		// Setup shortcode handler
		add_shortcode('bst-register', array($this, 'shortcode_register'));
		
		// Testing actions
//		add_action('shopp_default_scripts', array($this, 'test'));
	}
	
	function test($out)
	{
		echo '<pre>';
		print_r($out);
		exit;
	}
	
	function shortcode_info()
	{
		if(isset($_POST['action']) and $_POST['action'] == 'process')
		{
			process_form();
		}
		else
		{
			display_form();
		}
	}

	/**
	 *
	 */
	function shortcode_register()
	{
		shopp_enqueue_script('checkout');
		// Get posted data
		if (!empty($_POST))
		{
			$_POST['phone'] = preg_replace('/[^\d\(\)\-+\. (ext|x)]/','',$_POST['phone']);

			echo '<pre>';
			print_r($_POST);
			echo '</pre>';
		}
		
		$form = '/register.php';
		$default_template = $this->plugin_dir . '/views/register.php';
		$custom_template = SHOPP_TEMPLATES . '/register.php';
		
		// Wrap in shopp div for styling
		echo '<div id="shopp">';
		if (file_exists($custom_template))
		{
			include($custom_template);
		}
		else
		{
			include($default_template);
		}
		echo '</div>';
	}
	
	/**
	 * Modify the recover password email to be more clear.
	 *
	 * @return mixed
	 */	
	function recover_password_message($text)
	{
		  $text[8] = 'To reset your password click the link below and a new temporary password will be sent to you, otherwise just ignore this email and nothing will happen.';
		  return $text;
	}
	
	/**
 	* page handler
 	*
 	* @return void
 	* @author Brad Van Skyhawk
 	**/
	function handle_request()
	{
		global $Shopp;
		
		if (strstr($_SERVER['REQUEST_URI'], 'store'))
		{
			if (isset($_REQUEST['offer']))
			{
				wp_mail('brad@vanskyhawk.com', 'Cart Info', "\nSESSION\n" . print_r($_SESSION, true));
				$_SESSION['_bst']['_sess'] = session_id();
				$_SESSION['_bst']['_cart'][] = $_REQUEST['offer'];
			}
			//wp_mail('brad@vanskyhawk.com', 'URL Info', "\nSERVER\n" . print_r($_SERVER, true) . "\nREQUEST:\n" . print_r($_REQUEST, true) . "\nSESSION_ID:\n" . session_id());
		}
		
		// Verification
		if (!isset($Shopp))
		{
			$this->error_message(BST_PLUGIN_NAME . ': Shopp must be activated to use.');
			return;
		}		
		if ($Shopp->Settings->registry['account_system'] == 'none') 
		{
 			$this->error_message(BST_PLUGIN_NAME . ': Shopp "Customer Accounts" is set to "No Accounts", so user registrations is disabled.');
 			return;
		}
		
		// Setup
		$plugin = $this->isor($_REQUEST['plugin']);
		
		if ($plugin == 'shopp-bst-handler')
		{
 	 	$action  	= $this->isor($_REQUEST['action']);
 	  	
 			// Offer select
			if ($action == 'order')
			{
				$offer = $this->isor($_REQUEST['offer']);
				if ($offer)
				{
 		  		shopp_safe_redirect($this->url[$offer]);
					exit;					
				}
			}
			
			
			// Login and account creation
			if (isset($_POST['process-login']))
			{
				$have_password = $this->isor($_REQUEST['have-password']);
 		  		$user = $this->isor($_REQUEST['account-login']);
				$pass = $this->isor($_REQUEST['password-login']);
				
				if ($have_password == 'no' and !empty($user) and empty($pass))
				{
					$email = urlencode($user);
					shopp_safe_redirect(add_query_string("email=$email", $this->url['register']));
 		  			exit;
				}
			}
		}	
			
	}	
	
	/**
 	* After logout redirect to offer page.
 	*/
	function after_logout()
	{
		shopp_safe_redirect($this->url['offer']);
		exit;
	}
	
	/**
 	* Show admin error messages
 	*
 	* @return void
 	* @author Brad Van Skyhawk
 	**/
	function error_message($error)
	{
		require('views/errors.php');
	}
	
	/**
 	* Helper function
 	*/
	private function isor($val)
	{
		return isset($val) ? $val : null;
	}
	
}

$bst = new ShoppBSTHandler();

