<?php
/*
Plugin Name: Shopp Dashboard Widget
Plugin URI: http://vanskyhawk.com/
Description: Graph the total order amount for the last week
Author: Brad Van Skyhawk
Version: 0.1
Author URI: http://vanskyhawk.com/
*/

// Function that output's the contents of the dashboard widget
function sogw_dashboard_widget_function($args=null) 
{
	global $Shopp;
	$db = DB::get();
	$defaults = array(
		'before_widget' => '',
		'before_title' => '',
		'widget_name' => '',
		'after_title' => '',
		'after_widget' => ''
	);
	if (!$args) $args = array();
	$args = array_merge($defaults,$args);
	if (!empty($args)) extract( $args, EXTR_SKIP );

	echo $before_widget;

	echo $before_title;
	echo $widget_name;
	echo $after_title;
	
	$purchasetable = DatabaseObject::tablename(Purchase::$table);
	$purchasedtable = DatabaseObject::tablename(Purchased::$table);

	global $sogw_toggle;
	if ($sogw_toggle)
	{
		$Orders = $db->query("SELECT DATE_FORMAT(created, '%b-%d') day, ROUND(SUM(total),2) total, COUNT(*) number FROM 	$purchasetable WHERE txnstatus='CHARGED' GROUP BY 1 ORDER BY created DESC LIMIT 14");
	}
	else
	{
		$Orders = $db->query("SELECT DATE_FORMAT(created, '%b') day, ROUND(SUM(total),2) total, COUNT(*) number FROM 	$purchasetable WHERE txnstatus='CHARGED' GROUP BY 1 ORDER BY created DESC LIMIT 8");
	}
	
	include_once('widget-view.php');
	
	echo $after_widget;
}

// Function that beeng used in the action hook
function sogw_add_dashboard_widgets() 
{
	global $sogw_toggle;
	$sogw_toggle = date('B') % 2;

	if ($sogw_toggle)
	{
		wp_add_dashboard_widget('sogw_dashboard_widget', 'Shopp Orders for Last 14 Days', 'sogw_dashboard_widget_function');
	}
	else
	{
		wp_add_dashboard_widget('sogw_dashboard_widget', 'Shopp Orders for Last 8 Months', 'sogw_dashboard_widget_function');
	}
}

// Register the new dashboard widget into the 'wp_dashboard_setup' action
add_action('wp_dashboard_setup', 'sogw_add_dashboard_widgets' );
