<?php
/**
 * Baby Signing Time Weight Tiers
 *
 * Provides shipping calculations based on order amount tiers
 *
 * @author Brad Van Skyhawk
 * @version 1.7
 * @copyright The Van Skyhawk Group, 5 April 2010
 * @package shopp
 * @since 1.7 dev
 * @subpackage BSTWeight
 *
 * $Id$
 **/

class BSTWeight extends ShippingFramework implements ShippingModule {

	var $weight = 0;

	function init () {
		$this->weight = 0;
	}

	function methods () {
		return array(
			'us' => __("BST - US Only","Shopp"), 
			'ca' => __("BST - Canada Only","Shopp"), 
			'ak' => __("BST - AK,HI,PR", "Shopp"),
			);
	}
	
	function calcitem ($id,$Item) {
		$this->weight += $Item->weight*$Item->quantity;
	}

	function calculate ($options,$Order) 
	{
		$country = $Order->Shipping->country;
		$state = $Order->Shipping->state;
		foreach ($this->rates as $rate) 
		{
			$column = $this->ratecolumn($rate);
			list($module,$method) = explode("::",$rate['method']);
			$addrate = false;
			
			if ($country == 'US')
			{
				if (in_array($state, array('AK','HI')))
				{
					if ($method == 'ak')
					{
						$addrate = true;
					}
				}
				else if ($method == 'us')
				{
					$addrate = true;
				}
			}
			else if ($country == 'CA' and $method == 'ca')
			{
				$addrate = true;
			}
			else if ($country == 'PR' and $method == 'ak')
			{
				$addrate = true;
			}
			
			foreach ($rate['max'] as $id => $value) 
			{
				if (!(int)$value) $rate['amount'] = $rate[$column][$id];
				if ($this->weight <= $value) 
				{
					$rate['amount'] = $rate[$column][$id];
					break;
				}
			}
			if ($addrate)
			{
				$options[$rate['name']] = new ShippingOption($rate);
			}
		}
		
		return $options;
	}

	function ui () {
		global $Shopp;
		?>
var BSTWeightRange = function (methodid,table,rates) {
	table.empty();
	var headingsRow = $('<tr class="headings"/>').appendTo(table);

	$('<th scope="col" class="units"><label for="max-'+methodid+'-0"><?php echo addslashes(__('By Weight','Shopp')); ?> (<?php echo $Shopp->Settings->get('weight_unit'); ?>)</label></th>').appendTo(headingsRow);
	$.each(domesticAreas,function(key,area) {
		$('<th scope="col"><label for="'+area+'-'+methodid+'-0">'+area+'</label></th>').appendTo(headingsRow);
	});
	$('<th scope="col"><label for="'+region+'-'+methodid+'-0">'+region+'</label></th>').appendTo(headingsRow);
	$('<th scope="col"><label for="worldwide-'+methodid+'-0"><?php echo addslashes(__('Worldwide','Shopp')); ?></label></th>').appendTo(headingsRow);
	$('<th scope="col">').appendTo(headingsRow);

	if (rates && rates['max']) {
		$.each(rates['max'],function(rowid,rate) {
			var row = AddBSTWeightRange(methodid,table,rates);
			row.appendTo(table);
			quickSelects();
		});
	} else {
		var row = AddBSTWeightRange(methodid,table);
		row.appendTo(table);
		quickSelects();
	}
}

function AddBSTWeightRange (methodid,table,rates) {
	var rows = $(table).find('tbody').children().not('tr.headings');
	var id = rows.length;

	var row = $('<tr/>');

	var unitCell = $('<td class="units"></td>').appendTo(row);
	$('<label for="max-'+methodid+'-'+id+'"><?php echo addslashes(__("Up to","Shopp")); ?> <label>').appendTo(unitCell);
	if (rates && rates['max'] && rates['max'][id] !== false) value = rates['max'][id];
	else if (id > 1) value = "+";
	else value = 1;
	var maxInput = $('<input type="text" name="settings[shipping_rates]['+methodid+'][max][]" class="selectall right" size="7" id="max-'+methodid+'-'+id+'" tabindex="'+(methodid+1)+'02" />').change(function() {
		this.value = (this.value == "+" || this.value == ">")?this.value:formatNumber(this.value);
	}).val((value=="+"||value==">")?value:formatNumber(new Number(value))).appendTo(unitCell);

	$('<span class="weightunit"></span>').html(weight_units+' = ').appendTo(unitCell);

	$.each(domesticAreas,function(key,area) {
		var inputCell = $('<td/>').appendTo(row);
		if (!isNaN(key)) key = area;
		if (rates && rates[key] && rates[key][id]) value = rates[key][id];
		else value = 0;
		$('<input type="text" name="settings[shipping_rates]['+methodid+']['+key+'][]" id="'+area+'-'+methodid+'-'+id+'" class="selectall right" size="7" tabindex="'+(methodid+1)+'04" />').change(function() {
			this.value = asMoney(this.value);
		}).val(asMoney(new Number(value))).appendTo(inputCell);
	});

	var inputCell = $('<td/>').appendTo(row);
	if (rates && rates[region] && rates[region][id]) value = rates[region][id];
	else value = 0;
	$('<input type="text" name="settings[shipping_rates]['+methodid+']['+region+'][]"  id="'+region+'-'+methodid+'-'+id+'" class="selectall right" size="7" tabindex="'+(methodid+1)+'05" />').change(function() {
		this.value = asMoney(this.value);
	}).val(asMoney(new Number(value))).appendTo(inputCell);

	var inputCell = $('<td/>').appendTo(row);
	if (rates && rates['Worldwide'] && rates['Worldwide'][id]) value = rates['Worldwide'][id];
	else value = 0;
	worldwideInput = $('<input type="text" name="settings[shipping_rates]['+methodid+'][Worldwide][]" id="worldwide-'+methodid+'-'+id+'"  class="selectall right" size="7" tabindex="'+(methodid+1)+'06" />').change(function() {
		this.value = asMoney(this.value);
	}).val(asMoney(new Number(value))).appendTo(inputCell);

	var rowCtrlCell = $('<td class="rowctrl" />').appendTo(row);
	var deleteButton = $('<button type="button" name="delete"></button>').appendTo(rowCtrlCell);
	if (rows.length == 0) {
		deleteButton.attr('class','disabled');
		deleteButton.attr('disabled','disabled');
	}
	deleteButton.click(function() {
		$(row).remove();
	});
	$('<img src="<?php echo SHOPP_PLUGINURI; ?>/core/ui/icons/delete.png" width="16" height="16" />').appendTo(deleteButton);
	var addButton = $('<button type="button" name="add" tabindex="'+(methodid+1)+'07"></button>').appendTo(rowCtrlCell);
	$('<img src="<?php echo SHOPP_PLUGINURI; ?>/core/ui/icons/add.png" width="16" height="16" />').appendTo(addButton);
	addButton.click(function() {
		insertedRow = AddBSTWeightRange(methodid,table);
		$(insertedRow).insertAfter($(row));
		quickSelects();
	});

	return row;

}

methodHandlers.register('<?php echo get_class($this); ?>::us',BSTWeightRange);
methodHandlers.register('<?php echo get_class($this); ?>::ca',BSTWeightRange);
methodHandlers.register('<?php echo get_class($this); ?>::ak',BSTWeightRange);

		<?php
	}

} // end flatrates class

