<?php
if(!defined('ABSPATH')) {die('You are not allowed to call this page directly.');}
/** This is a special controller that handles all of the MemberPress specific
  * functions for the Affiliate Program.
  */
class WafpECommerceController {

  /**
   * the constructor. setup hooks and filters.
   */
  function WafpECommerceController() {
    add_action( 'wpsc_confirm_checkout', array( &$this, 'confirm_checkout' ));        
    add_filter( 'wpsc_paypal_standard_notify_url', array( &$this, 'send_click' ));
    add_filter( 'wpsc_paypal_express_notify_url', array( &$this, 'send_click' ));
  }

  /**
   * Track this e-commerce transaction
   *
   * @return void
   * @author Brad Van Skyhawk
   **/
  function confirm_checkout( $purchase_id )
  {
    global $wpdb;
    
    // Get the subtotal
    $purch_sql = $wpdb->prepare( "SELECT SUM(price) FROM `".WPSC_TABLE_CART_CONTENTS."` WHERE `purchaseid`=%d", $purchase_id );
  	$subtotal = $wpdb->get_var( $purch_sql );
  	
  	// Set the cookie, if passed from paypal
    if (isset($_REQUEST['wafp_click']))
    {
      $_COOKIE['wafp_click'] = $_REQUEST['wafp_click'];
    }
    WafpTransaction::track( $subtotal, $purchase_id, __('E-Commerce Purchase', 'affiliate-royale') );
  }

  /**
   * Pass the click id to paypal. Then we get it back later
   *
   * @return string
   * @author Brad Van Skyhawk
   */
  function send_click( $url )
  {
    return $url . '&wafp_click=' . $_COOKIE['wafp_click'];
  }
  
}

