<?php
if(!defined('ABSPATH')) {die('You are not allowed to call this page directly.');}
/** This is a special controller that handles all of the MemberPress specific
  * functions for the Affiliate Program.
  */
class WafpShoppController {

  function WafpShoppController()
  {
    add_action( 'shopp_order_success', array(&$this,'track_transaction') ); 
    
	 if (class_exists('ShoppingObject'))
	 {
      add_action( 'shopp_order_notifications', array(&$this, 'notify') );
      
      // put the affiliate id in the Shopp session
      if (isset($_COOKIE['wafp_click']))
      {
      	$affiliate_id = $_COOKIE['wafp_click'];
         ShoppingObject::store('wafp_affiliate_id', $affiliate_id);         
      }
	 }
  }

  /**
   * Track the paypal transaction using Shopp session
   */
  public function notify()
  {
    // Code from Shopp PayPal gateway
    // Cancel processing if this is not a PayPal Website Payments Standard/Express Checkout IPN
    if (isset($_POST['txn_type']) && $_POST['txn_type'] != "cart") return false;

    $target = false;
    if (isset($_POST['txn_id']) && !isset($_POST['parent_txn_id']))
    {
      $target = $_POST['txn_id'];
    }
    else if (!empty($_POST['parent_txn_id']))
    {
      $target = $_POST['parent_txn_id'];
    }

    // No transaction target: invalid IPN, silently ignore the message
    if (!$target) return;

    $Purchase = new Purchase($target,'txnid');

    // Purchase record exists, track it
    if ($Purchase->txnid == $target && !empty($Purchase->id)) 
    {
      // Get the affiliate id from the Shopp session
      global $Shopp;
	   $Shopp->resession($_POST['custom']);
	   $_COOKIE['wafp_click'] = $Shopp->Shopping->data->wafp_affiliate_id;
      WafpTransaction::track( $Purchase->subtotal - $Purchase->discount, $Purchase->id, __('Shopp Purchase', 'affiliate-royale') );
    }
  }

  /* Tracks when a transaction completes */
  public function track_transaction($Purchase)
  {
    WafpTransaction::track( $Purchase->subtotal - $Purchase->discount, $Purchase->id, __('Shopp Purchase', 'affiliate-royale') );
  }
  
}
