<?php
// Make sure this script can oly be run on the command line
if(!defined('STDIN'))
{
  echo "You're unauthorized to view this page.";
  die;
}

require_once('../../../wp-load.php');

require_once(ABSPATH . WPINC . '/user.php');

// SETUP
$wpdb->query('BEGIN');

define('WAFP_TEST_MODE',true);
define('WAFP_VERBOSE_TEST_MODE',false);

// Active assert and make it quiet
assert_options(ASSERT_ACTIVE, 1);
assert_options(ASSERT_WARNING, 0);
assert_options(ASSERT_QUIET_EVAL, 1);

// Set up the callback
assert_options(ASSERT_CALLBACK, 'my_assert_handler');

// Lets add 4 users to test this shiz on
$person1_id = wp_create_user( 'person1', 'person-1', 'person-1@email.org' );
$person2_id = wp_create_user( 'person2', 'person-2', 'person-2@email.org' );
$person3_id = wp_create_user( 'person3', 'person-3', 'person-3@email.org' );
$person4_id = wp_create_user( 'person4', 'person-4', 'person-4@email.org' );

$person1 = new WafpUser($person1_id);
$person2 = new WafpUser($person2_id);
$person3 = new WafpUser($person3_id);
$person4 = new WafpUser($person4_id);

$person1->set_is_affiliate(true);
$person2->set_is_affiliate(true);
$person3->set_is_affiliate(true);
$person4->set_is_affiliate(true);

$person2->set_referrer($person1_id);
$person3->set_referrer($person2_id);
$person4->set_referrer($person3_id);

$person1->set_first_name('Person');
$person2->set_first_name('Person');
$person3->set_first_name('Person');
$person4->set_first_name('Person');

$person1->set_last_name('One');
$person2->set_last_name('Two');
$person3->set_last_name('Three');
$person4->set_last_name('Four');

#update_user_meta($person3_id, 'wafp_override', array(25.00, 10.00, 15.00));
#$person3->set_recurring(false);

$person1->store();
$person2->store();
$person3->store();
$person4->store();

// Reload these things now that they've been altered
$person1 = new WafpUser($person1_id);
$person2 = new WafpUser($person2_id);
$person3 = new WafpUser($person3_id);
$person4 = new WafpUser($person4_id);

// Override some options
$wafp_options->commission = array(25.00, 10.00, 15.00);

// Run all the tests in the tests folder
echo "Loading tests in folder: " . WAFP_TESTS_PATH . "\n";
foreach ( glob(WAFP_TESTS_PATH . '/*.php') as $filename)
  require_once($filename);

// TEARDOWN
// We just roll everything back -- clean as a whistle
$wpdb->query('ROLLBACK');

global $test_passed;
$test_passed = true;

function assert_true($assertion)
{
  echo ".";
  assert($assertion);
}

function begin_test()
{
  global $test_passed;
  $test_passed = true;
}

function finish_test()
{
  global $test_passed;
  if($test_passed) {
    echo "  --Test PASSED!\n";
  }
  else {
    echo "  --Test FAILED!\n";
  }
}

// Create a handler function
function my_assert_handler($file, $line, $code)
{
  global $test_passed;
  $test_passed = false;

  echo "  --assert failed:\n" .
       "      File '$file'\n" .
       "      Line '$line'\n" .
       "      Code '$code'\n";
}