<?php
// Make sure this script can oly be run on the command line
if(!defined('STDIN'))
{
  echo "You're unauthorized to view this page.";
  die;
}

echo "\n******Testing WafpTransaction model\n";
//track( $amount, $order_id, $product_id='', $user_id='', $subscription_id='', $response='' )

/************* WafpTransaction#track 1 level commission on parentless affiliate *************/
echo "\n- [Testing] WafpTransaction#track 1 level commission on parentless affiliate\n";

begin_test();
$old_commission = $wafp_options->commission;
$wafp_options->commission = array(25.00);

$_COOKIE['wafp_click'] = $person1_id;
$transaction_id = WafpTransaction::track( 50.00, '1234asdf0987lkjh2xxx' );

$transaction_results = $wpdb->get_results("SELECT * FROM $wafp_db->transactions WHERE id=$transaction_id");
assert('$transaction_results !== false'); // Make sure the record exists
assert('count($transaction_results) == 1'); // No duh
$commissions_results = $wpdb->get_results("SELECT * FROM $wafp_db->commissions WHERE transaction_id=$transaction_id");
assert('$commissions_results !== false'); // Make sure the record exists
assert('count($commissions_results) == 1');

// Make sure commissions recorded correctly
assert('$commissions_results[0]->affiliate_id == $person1_id');
assert('$commissions_results[0]->commission_level == 0');
assert('(float)$commissions_results[0]->commission_percentage == 25.0');
assert('$commissions_results[0]->commission_amount == 12.50');

// Make sure affiliate_ids recorded correctly
assert('$transaction_results[0]->affiliate_id == $person1_id');

$wafp_options->commission = $old_commission;

finish_test();

/************* WafpTransaction#track 1 level commission on affiliate with parent *************/
echo "\n- [Testing] WafpTransaction#track 1 level commission on affiliate with parent\n";

begin_test();
$old_commission = $wafp_options->commission;
$wafp_options->commission = array(25.00);

$_COOKIE['wafp_click'] = $person2_id;
$transaction_id = WafpTransaction::track( 50.00, '1234asdf0987lkjh2yyy' );

$transaction_results = $wpdb->get_results("SELECT * FROM $wafp_db->transactions WHERE id=$transaction_id");
assert('$transaction_results !== false'); // Make sure the record exists
assert('count($transaction_results) == 1'); // No duh
$commissions_results = $wpdb->get_results("SELECT * FROM $wafp_db->commissions WHERE transaction_id=$transaction_id");
assert('$commissions_results !== false'); // Make sure the record exists
assert('count($commissions_results) == 1');

// Make sure commissions recorded correctly
assert('$commissions_results[0]->affiliate_id == $person2_id');
assert('$commissions_results[0]->commission_level == 0');
assert('(float)$commissions_results[0]->commission_percentage == 25.0');
assert('$commissions_results[0]->commission_amount == 12.50');

// Make sure affiliate_ids recorded correctly
assert('$transaction_results[0]->affiliate_id == $person2_id');

$wafp_options->commission = $old_commission;

finish_test();

/************* WafpTransaction#track new order with aff cookie set *************/
echo "\n- [Testing] WafpTransaction#track new order with aff cookie set\n";
begin_test();
$_COOKIE['wafp_click'] = $person4_id;
$transaction_id = WafpTransaction::track( 50.00, '1234asdf0987lkjh1' );

$transaction_results = $wpdb->get_results("SELECT * FROM $wafp_db->transactions WHERE id=$transaction_id");
assert('$transaction_results !== false'); // Make sure the record exists
assert('count($transaction_results) == 1'); // No duh
$commissions_results = $wpdb->get_results("SELECT * FROM $wafp_db->commissions WHERE transaction_id=$transaction_id");
assert('$commissions_results !== false'); // Make sure the record exists
assert('count($commissions_results) == 3');

// Make sure commissions recorded correctly
assert('$commissions_results[0]->affiliate_id == $person4_id');
assert('$commissions_results[0]->commission_level == 0');
assert('(float)$commissions_results[0]->commission_percentage == 25.0');
assert('$commissions_results[0]->commission_amount == 12.50');

assert('$commissions_results[1]->affiliate_id == $person3_id');
assert('$commissions_results[1]->commission_level == 1');
assert('(float)$commissions_results[1]->commission_percentage == 10.0');
assert('$commissions_results[1]->commission_amount == 5.00');

assert('$commissions_results[2]->affiliate_id == $person2_id');
assert('$commissions_results[2]->commission_level == 2');
assert('(float)$commissions_results[2]->commission_percentage == 15.0');
assert('$commissions_results[2]->commission_amount == 7.50');

// Make sure affiliate_ids recorded correctly
assert('$transaction_results[0]->affiliate_id == $person4_id');

finish_test();

/************* WafpTransaction#track new order with aff cookie set (same id as $current_user) should not track commissions if userid = affid *************/
echo "\n- [Testing] WafpTransaction#track new order with aff cookie set (same id as \$current_user) should not track commissions if userid = affid \n";
begin_test();
$_COOKIE['wafp_click'] = $person4_id;

global $current_user;
$current_user = new WP_User($person4_id);

$transaction_id = WafpTransaction::track( 50.00, '1234asdf0987lkjh15' );

$transaction_results = $wpdb->get_results("SELECT * FROM $wafp_db->transactions WHERE id=$transaction_id");
assert('$transaction_results !== false'); // Make sure the record exists
assert('count($transaction_results) == 1'); // Duh
$commissions_results = $wpdb->get_results("SELECT * FROM $wafp_db->commissions WHERE transaction_id=$transaction_id");
assert('$commissions_results !== false'); // Make sure the record exists
assert('empty($commissions_results)'); // Make sure its empty

// Make sure affiliate_ids recorded correctly
assert('$transaction_results[0]->affiliate_id != $person4_id');

wp_logout();
finish_test();


/************* WafpTransaction#track new order without aff cookie set *************/
echo "\n- [Testing] WafpTransaction#track new order without aff cookie set\n";
begin_test();
unset($_COOKIE['wafp_click']);
$transaction_id = WafpTransaction::track( 50.00, '1234asdf0987lkjh2' );

$transaction_results = $wpdb->get_results("SELECT * FROM $wafp_db->transactions WHERE id=$transaction_id");
assert('$transaction_results !== false'); // Make sure the record exists
assert('count($transaction_results) == 1'); // No duh
$commissions_results = $wpdb->get_results("SELECT * FROM $wafp_db->commissions WHERE transaction_id=$transaction_id");
assert('$commissions_results !== false'); // Make sure the record exists
assert('count($commissions_results) == 0'); // No commissions should have been recorded

// Make sure affiliate_ids recorded correctly
assert('empty($transaction_results[0]->affiliate_id)');

finish_test();


/************* WafpTransaction#track new subscription order with aff cookie set *************/
echo "\n- [Testing] WafpTransaction#track new subscription order with aff cookie set\n";
begin_test();
$_COOKIE['wafp_click'] = $person3_id;
$transaction_id = WafpTransaction::track( 50.00, '1234asdf0987lkjh3', 'Membership Site', $person4_id, 'subscr_1234asdf0987lkjh3' );

$transaction_results = $wpdb->get_results("SELECT * FROM $wafp_db->transactions WHERE id=$transaction_id");
assert('$transaction_results !== false'); // Make sure the record exists
assert('count($transaction_results) == 1'); // No duh
$commissions_results = $wpdb->get_results("SELECT * FROM $wafp_db->commissions WHERE transaction_id=$transaction_id");
assert('$commissions_results !== false'); // Make sure the record exists
assert('count($commissions_results) == 3');

// Make sure commissions recorded correctly
assert('$commissions_results[0]->affiliate_id == $person3_id');
assert('$commissions_results[0]->commission_level == 0');
assert('(float)$commissions_results[0]->commission_percentage == 25.0');
assert('$commissions_results[0]->commission_amount == 12.50');

assert('$commissions_results[1]->affiliate_id == $person2_id');
assert('$commissions_results[1]->commission_level == 1');
assert('(float)$commissions_results[1]->commission_percentage == 10.0');
assert('$commissions_results[1]->commission_amount == 5.00');

assert('$commissions_results[2]->affiliate_id == $person1_id');
assert('$commissions_results[2]->commission_level == 2');
assert('(float)$commissions_results[2]->commission_percentage == 15.0');
assert('$commissions_results[2]->commission_amount == 7.50');

// Make sure affiliate_ids recorded correctly
assert('$transaction_results[0]->affiliate_id == $person3_id');

finish_test();

/************* WafpTransaction#track new re-occurring subscription order with user_id set *************/
echo "\n- [Testing] WafpTransaction#track new re-occurring subscription order with user_id set\n";
begin_test();
unset($_COOKIE['wafp_click']);
$transaction_id = WafpTransaction::track( 50.00, '1234asdf0987lkjh4', 'Membership Site', $person4_id, 'subscr_1234asdf0987lkjh3' );

$transaction_results = $wpdb->get_results("SELECT * FROM $wafp_db->transactions WHERE id=$transaction_id");
assert('$transaction_results !== false'); // Make sure the record exists
assert('count($transaction_results) == 1'); // No duh
$commissions_results = $wpdb->get_results("SELECT * FROM $wafp_db->commissions WHERE transaction_id=$transaction_id");
assert('$commissions_results !== false'); // Make sure the record exists
assert('count($commissions_results) == 3');

// Make sure commissions recorded correctly
assert('$commissions_results[0]->affiliate_id == $person3_id');
assert('$commissions_results[0]->commission_level == 0');
assert('(float)$commissions_results[0]->commission_percentage == 25.0');
assert('$commissions_results[0]->commission_amount == 12.50');

assert('$commissions_results[1]->affiliate_id == $person2_id');
assert('$commissions_results[1]->commission_level == 1');
assert('(float)$commissions_results[1]->commission_percentage == 10.0');
assert('$commissions_results[1]->commission_amount == 5.00');

assert('$commissions_results[2]->affiliate_id == $person1_id');
assert('$commissions_results[2]->commission_level == 2');
assert('(float)$commissions_results[2]->commission_percentage == 15.0');
assert('$commissions_results[2]->commission_amount == 7.50');

// Make sure affiliate_ids recorded correctly
assert('$transaction_results[0]->affiliate_id == $person3_id');

finish_test();


/************* WafpTransaction#track new re-occurring subscription order without user_id set *************/
echo "\n- [Testing] WafpTransaction#track new re-occurring subscription order without user_id set\n";
begin_test();
unset($_COOKIE['wafp_click']);

// We should be able to still get to the affiliate id without the user_id when we've got a subscription id
$transaction_id = WafpTransaction::track( 50.00, '1234asdf0987lkjh5', 'Membership Site', '', 'subscr_1234asdf0987lkjh3' );

$transaction_results = $wpdb->get_results("SELECT * FROM $wafp_db->transactions WHERE id=$transaction_id");
assert('$transaction_results !== false'); // Make sure the record exists
assert('count($transaction_results) == 1'); // No duh
$commissions_results = $wpdb->get_results("SELECT * FROM $wafp_db->commissions WHERE transaction_id=$transaction_id");
assert('$commissions_results !== false'); // Make sure the record exists
assert('count($commissions_results) == 3');

// Make sure commissions recorded correctly
assert('$commissions_results[0]->affiliate_id == $person3_id');
assert('$commissions_results[0]->commission_level == 0');
assert('(float)$commissions_results[0]->commission_percentage == 25.0');
assert('$commissions_results[0]->commission_amount == 12.50');

assert('$commissions_results[1]->affiliate_id == $person2_id');
assert('$commissions_results[1]->commission_level == 1');
assert('(float)$commissions_results[1]->commission_percentage == 10.0');
assert('$commissions_results[1]->commission_amount == 5.00');

assert('$commissions_results[2]->affiliate_id == $person1_id');
assert('$commissions_results[2]->commission_level == 2');
assert('(float)$commissions_results[2]->commission_percentage == 15.0');
assert('$commissions_results[2]->commission_amount == 7.50');

// Make sure affiliate_ids recorded correctly
assert('$transaction_results[0]->affiliate_id == $person3_id');

finish_test();


/************* WafpTransaction#track existing order *************/
echo "\n- [Testing] WafpTransaction#track existing order\n";
begin_test();
unset($_COOKIE['wafp_click']);

// We should be able to still get to the affiliate id without the user_id
$transaction_id = WafpTransaction::track( 50.00, '1234asdf0987lkjh5' );

assert('empty($transaction_id)'); // Make sure the record exists

finish_test();

/************* WafpTransaction#track existing order *************/
echo "\n- [Testing] WafpTransaction#track existing order\n";
begin_test();
$_COOKIE['wafp_click'] = $person3_id;

// We should be able to still get to the affiliate id without the user_id
$transaction_id = WafpTransaction::track( 47, 10404367, 'Manager Membership', $person4_id );

$transaction_results = $wpdb->get_results("SELECT * FROM $wafp_db->transactions WHERE id=$transaction_id");
assert('!empty($transaction_id)'); // Make sure the record exists
print_r($transaction_results);

finish_test();
