<?php
// Make sure this script can oly be run on the command line
if(!defined('STDIN'))
{
  echo "You're unauthorized to view this page.";
  die;
}

echo "\n******Testing WafpUser model\n";

/************* WafpUser#get_affiliates *************/
echo "\n- [Testing] WafpUser#get_affiliates\n";
begin_test();
// Not testing compression yet since we aren't using it yet
$person4_affs_mock = array($person4,$person3,$person2); // only 3 commission levels
$person3_affs_mock = array($person3,$person2,$person1);
$person2_affs_mock = array($person2,$person1);
$person1_affs_mock = array($person1);

assert('$person1->get_affiliates(true) == $person1_affs_mock');
assert('$person2->get_affiliates(true) == $person2_affs_mock');
assert('$person3->get_affiliates(true) == $person3_affs_mock');
assert('$person4->get_affiliates(true) == $person4_affs_mock');

finish_test();


/************* WafpUser#get_commission_percentage *************/
echo "\n- [Testing] WafpUser#get_commission_percentage\n";
begin_test();
// Override the commission for person3 on level 2
update_user_meta($person3_id, 'wafp_override', array(25.00,38.00,15.00));

assert('$person1->get_commission_percentage(0) === 25.00');
assert('$person1->get_commission_percentage(1) === 10.00');
assert('$person1->get_commission_percentage(2) === 15.00');

assert('$person2->get_commission_percentage(0) === 25.00');
assert('$person2->get_commission_percentage(1) === 10.00');
assert('$person2->get_commission_percentage(2) === 15.00');

assert('$person3->get_commission_percentage(0) === 25.00');
assert('$person3->get_commission_percentage(1) === 38.00'); // User Override in place here
assert('$person3->get_commission_percentage(2) === 15.00');

assert('$person4->get_commission_percentage(0) === 25.00');
assert('$person4->get_commission_percentage(1) === 10.00');
assert('$person4->get_commission_percentage(2) === 15.00');
assert('$person4->get_commission_percentage(3) === false'); // Out of bounds should return false

finish_test();


/************* WafpUser#calculate_commission *************/
echo "\n- [Testing] WafpUser#calculate_commission\n";
begin_test();

assert('WafpUtils::format_float($person1->calculate_commission(100.00,0)) === "25.00"');
assert('WafpUtils::format_float($person1->calculate_commission(1000.00,1)) === "100.00"');
assert('WafpUtils::format_float($person1->calculate_commission(200.00,2)) === "30.00"');
assert('WafpUtils::format_float($person2->calculate_commission(150.00,0)) === "37.50"');
assert('WafpUtils::format_float($person2->calculate_commission(300.00,1)) === "30.00"');
assert('WafpUtils::format_float($person2->calculate_commission(100.00,2)) === "15.00"');
assert('WafpUtils::format_float($person3->calculate_commission(200.00,0)) === "50.00"');
assert('WafpUtils::format_float($person3->calculate_commission(100.00,1)) === "38.00"'); // User Override in place here
assert('WafpUtils::format_float($person3->calculate_commission(100.00,2)) === "15.00"');
assert('WafpUtils::format_float($person4->calculate_commission(10.00,0)) === "2.50"');
assert('WafpUtils::format_float($person4->calculate_commission(16.00,1)) === "1.60"');
assert('WafpUtils::format_float($person4->calculate_commission(100.00,2)) === "15.00"');
assert('WafpUtils::format_float($person4->calculate_commission(100.00,3)) === false'); // Out of bounds should return false

finish_test();


/************* WafpUser#get_commission_percentages *************/
echo "\n- [Testing] WafpUser#get_commission_percentages\n";
begin_test();
$person4_commission_percents_mock = array(25.00,38.00,15.00); // only 3 commission levels
$person3_commission_percents_mock = array(25.00,10.00,15.00);
$person2_commission_percents_mock = array(25.00,10.00);
$person1_commission_percents_mock = array(25.00);

assert('$person1->get_commission_percentages(true) == $person1_commission_percents_mock');
assert('$person2->get_commission_percentages(true) == $person2_commission_percents_mock');
assert('$person3->get_commission_percentages(true) == $person3_commission_percents_mock');
assert('$person4->get_commission_percentages(true) == $person4_commission_percents_mock');

finish_test();


/************* WafpUser#calculate_commissions *************/
echo "\n- [Testing] WafpUser#calculate_commissions\n";
begin_test();
$sa = array(1432.11, 13.18, 1.45, 56.00);
$person4_commissions_mock = array( ($sa[3]*25.00/100.00),
                                   ($sa[3]*38.00/100.00),
                                   ($sa[3]*15.00/100.00) ); // only 3 commission levels
$person3_commissions_mock = array( ($sa[2]*25.00/100.00),
                                   ($sa[2]*10.00/100.00),
                                   ($sa[2]*15.00/100.00) );
$person2_commissions_mock = array( ($sa[1]*25.00/100.00),
                                   ($sa[1]*10.00/100.00) );
$person1_commissions_mock = array( ($sa[0]*25.00/100.00) );

assert('$person1->calculate_commissions($sa[0],true) == $person1_commissions_mock');
assert('$person2->calculate_commissions($sa[1],true) == $person2_commissions_mock');
assert('$person3->calculate_commissions($sa[2],true) == $person3_commissions_mock');
assert('$person4->calculate_commissions($sa[3],true) == $person4_commissions_mock');

finish_test();


/************* WafpUser#get_commission_percentages_total *************/
echo "\n- [Testing] WafpUser#get_commission_percentages_total\n";
begin_test();

assert('$person1->get_commission_percentages_total(true) == 25.00');
assert('$person2->get_commission_percentages_total(true) == 35.00');
assert('$person3->get_commission_percentages_total(true) == 50.00');
assert('$person4->get_commission_percentages_total(true) == 78.00');

finish_test();


/************* WafpUser#calculate_commissions_total *************/
echo "\n- [Testing] WafpUser#calculate_commissions_total\n";
begin_test();

$person1_commission_total_mock = ($sa[0]*25.00/100.00);
$person2_commission_total_mock = ($sa[1]*35.00/100.00);
$person3_commission_total_mock = ($sa[2]*50.00/100.00);
$person4_commission_total_mock = ($sa[3]*78.00/100.00);

assert('WafpUtils::format_float($person1->calculate_commissions_total($sa[0],true)) == WafpUtils::format_float($person1_commission_total_mock)');
assert('WafpUtils::format_float($person2->calculate_commissions_total($sa[1],true)) == WafpUtils::format_float($person2_commission_total_mock)');
assert('WafpUtils::format_float($person3->calculate_commissions_total($sa[2],true)) == WafpUtils::format_float($person3_commission_total_mock)');
assert('WafpUtils::format_float($person4->calculate_commissions_total($sa[3],true)) == WafpUtils::format_float($person4_commission_total_mock)');

finish_test();


/************* WafpUser#calculate_commissions_total *************/
echo "\n- [Testing] WafpUser#send_account_notification\n";
begin_test();

$person1->send_account_notifications('booyah');
$person2->send_account_notifications('booyah', false);
$person3->send_account_notifications('', false);
$person3->send_account_notifications('', true, false);

finish_test();

/************* WafpUser#affiliate_datatable *************/
echo "\n- [Testing] WafpUser#affiliate_datatable\n";
begin_test();

echo WafpUser::affiliate_datatable();

finish_test();

/************* WafpReport#last_n_days_stats *************/
echo "\n- [Testing] WafpUser#last_n_days_stats\n";
begin_test();

print_r(WafpReport::last_n_days_stats());

finish_test();
