<?php
/**
* Menu page for the s2Member plugin ( Restriction Options page ).
*
* Copyright: © 2009-2011
* {@link http://www.websharks-inc.com/ WebSharks, Inc.}
* ( coded in the USA )
*
* Released under the terms of the GNU General Public License.
* You should have received a copy of the GNU General Public License,
* along with this software. In the main directory, see: /licensing/
* If not, see: {@link http://www.gnu.org/licenses/}.
*
* @package s2Member\Menu_Pages
* @since 3.0
*/
if (realpath (__FILE__) === realpath ($_SERVER["SCRIPT_FILENAME"]))
	exit ("Do not access this file directly.");
/**/
if (!class_exists ("c_ws_plugin__s2member_menu_page_res_ops"))
	{
		/**
		* Menu page for the s2Member plugin ( Restriction Options page ).
		*
		* @package s2Member\Menu_Pages
		* @since 110531
		*/
		class c_ws_plugin__s2member_menu_page_res_ops
			{
				public function __construct ()
					{
						echo '<div class="wrap ws-menu-page">' . "\n";
						/**/
						echo '<div id="icon-plugins" class="icon32"><br /></div>' . "\n";
						echo '<h2>s2Member® Restriction Options</h2>' . "\n";
						/**/
						echo '<table class="ws-menu-page-table">' . "\n";
						echo '<tbody class="ws-menu-page-table-tbody">' . "\n";
						echo '<tr class="ws-menu-page-table-tr">' . "\n";
						echo '<td class="ws-menu-page-table-l">' . "\n";
						/**/
						echo '<form method="post" name="ws_plugin__s2member_options_form" id="ws-plugin--s2member-options-form">' . "\n";
						echo '<input type="hidden" name="ws_plugin__s2member_options_save" id="ws-plugin--s2member-options-save" value="' . esc_attr (wp_create_nonce ("ws-plugin--s2member-options-save")) . '" />' . "\n";
						echo '<input type="hidden" name="ws_plugin__s2member_configured" id="ws-plugin--s2member-configured" value="1" />' . "\n";
						/**/
						do_action ("ws_plugin__s2member_during_res_ops_page_before_left_sections", get_defined_vars ());
						/**/
						if (apply_filters ("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_post_level_access", true, get_defined_vars ()))
							{
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_post_level_access", get_defined_vars ());
								/**/
								echo '<div class="ws-menu-page-group" title="Post Access Restrictions">' . "\n";
								/**/
								echo '<div class="ws-menu-page-section ws-plugin--s2member-post-level-access-section">' . "\n";
								echo '<h3>Post Level Access Restrictions ( optional )</h3>' . "\n";
								echo '<p>Here you can specify Posts that are restricted to certain Membership Access Levels. s2Member also supports Custom <a href="http://codex.wordpress.org/Post_Types" target="_blank" rel="external">Post Types</a> here. If you have a theme or plugin installed, which has enabled Custom Post Types <em>( i.e. Music/Videos or something else )</em>, you can put the IDs for those Posts here.</p>' . "\n";
								echo '<p><em><strong>*Note*</strong> Protecting individual Posts, ONLY protects the Permalinks for those Posts. It is still possible for excerpts of protected content to be seen in search results generated by WordPress®, feeds, and Archive views; such as your Home Page, inside a Category listing, or through other queries formulated by your theme. This is the intended functionality. Excerpts are a great way to "tease" public visitors. In other words, public visitors may have access to excerpts introduced by your theme, but any attempt to view the full Post ( i.e. the Permalink ) will result in an automatic redirect to your Membership Options Page; requiring registration.</em></p>' . "\n";
								echo '<p><em><strong>*Note*</strong> If you would like to protect many Posts at once ( including Archive views ), you can use Category Level Restrictions, Tag Level Restrictions, or have a look down below at s2Member\'s options for "Alternative View Protection", which deals with search results, as well as feeds.</em></p>' . "\n";
								echo ((!is_multisite () || !c_ws_plugin__s2member_utils_conds::is_multisite_farm () || is_main_site ()) && !$GLOBALS["WS_PLUGIN__"]["wp_show_ids"]) ? '<p><em><strong>*Tip*</strong> Can\'t find your Post IDs? Get <a href="http://www.primothemes.com/post/product/wp-show-ids-plugin/" target="_blank" rel="external">WP Show IDs</a>.</em></p>' . "\n" : '';
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_post_level_access", get_defined_vars ());
								/**/
								echo '<table class="form-table">' . "\n";
								echo '<tbody>' . "\n";
								/**/
								for ($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
									{
										echo '<tr>' . "\n";
										/**/
										echo '<th>' . "\n";
										echo '<label for="ws-plugin--s2member-level' . $n . '-posts">' . "\n";
										echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'Posts That Require Highest Level #' . $n . ':' . "\n" : 'Posts That Require Level #' . $n . ' Or Higher:' . "\n";
										echo '</label>' . "\n";
										echo '</th>' . "\n";
										/**/
										echo '</tr>' . "\n";
										echo '<tr>' . "\n";
										/**/
										echo '<td>' . "\n";
										echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_level' . $n . '_posts" id="ws-plugin--s2member-level' . $n . '-posts" value="' . format_to_edit ($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level" . $n . "_posts"]) . '" /><br />' . "\n";
										echo 'Post IDs in comma-delimited format. Example: <code>1,2,3,34,8,21</code> — or you can type: <code>all</code>.<br />' . "\n";
										echo 'You can also include all Post IDs of a specific <a href="http://codex.wordpress.org/Post_Types" target="_blank" rel="external">Post Type</a>. Ex: <code>1,2,3,34,all-newspapers</code>.<br />' . "\n";
										echo '<em>( which protects several Post IDs, and <code>all</code> Posts of type: <code>newspaper</code> )</em>' . "\n";
										echo '</td>' . "\n";
										/**/
										echo '</tr>' . "\n";
									}
								/**/
								echo '</tbody>' . "\n";
								echo '</table>' . "\n";
								echo '</div>' . "\n";
								/**/
								echo '</div>' . "\n";
								/**/
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_post_level_access", get_defined_vars ());
							}
						/**/
						if (apply_filters ("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_page_level_access", true, get_defined_vars ()))
							{
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_page_level_access", get_defined_vars ());
								/**/
								echo '<div class="ws-menu-page-group" title="Page Access Restrictions">' . "\n";
								/**/
								echo '<div class="ws-menu-page-section ws-plugin--s2member-page-level-access-section">' . "\n";
								echo '<h3>Page Level Access Restrictions ( optional )</h3>' . "\n";
								echo '<p>Here you can specify Pages that are restricted to certain Membership Access Levels.</p>' . "\n";
								echo ((!is_multisite () || !c_ws_plugin__s2member_utils_conds::is_multisite_farm () || is_main_site ()) && !$GLOBALS["WS_PLUGIN__"]["wp_show_ids"]) ? '<p><em><strong>*Tip*</strong> Can\'t find your Page IDs? Get <a href="http://www.primothemes.com/post/product/wp-show-ids-plugin/" target="_blank" rel="external">WP Show IDs</a>.</em></p>' . "\n" : '';
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_page_level_access", get_defined_vars ());
								/**/
								echo '<table class="form-table">' . "\n";
								echo '<tbody>' . "\n";
								/**/
								for ($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
									{
										echo '<tr>' . "\n";
										/**/
										echo '<th>' . "\n";
										echo '<label for="ws-plugin--s2member-level' . $n . '-pages">' . "\n";
										echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'Pages That Require Highest Level #' . $n . ':' . "\n" : 'Pages That Require Level #' . $n . ' Or Higher:' . "\n";
										echo '</label>' . "\n";
										echo '</th>' . "\n";
										/**/
										echo '</tr>' . "\n";
										echo '<tr>' . "\n";
										/**/
										echo '<td>' . "\n";
										echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_level' . $n . '_pages" id="ws-plugin--s2member-level' . $n . '-pages" value="' . format_to_edit ($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level" . $n . "_pages"]) . '" /><br />' . "\n";
										echo 'Page IDs in comma-delimited format. Example: <code>1,2,3,34,8,21</code> — or you can type: <code>all</code>.' . "\n";
										echo '</td>' . "\n";
										/**/
										echo '</tr>' . "\n";
									}
								/**/
								echo '</tbody>' . "\n";
								echo '</table>' . "\n";
								echo '</div>' . "\n";
								/**/
								echo '</div>' . "\n";
								/**/
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_page_level_access", get_defined_vars ());
							}
						/**/
						if (apply_filters ("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_tag_level_access", true, get_defined_vars ()))
							{
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_tag_level_access", get_defined_vars ());
								/**/
								echo '<div class="ws-menu-page-group" title="Tag Access Restrictions">' . "\n";
								/**/
								echo '<div class="ws-menu-page-section ws-plugin--s2member-tag-level-access-section">' . "\n";
								echo '<h3>Tag Level Access Restrictions ( optional )</h3>' . "\n";
								echo '<p>Here you can specify Tags that are restricted to certain Membership Access Levels. This is very similar to Category Level Access. When you restrict access to a Tag Archive, it also restricts access to any Post having that Tag; even if a Post has other Tags. <em>*Tip*</em> ... Tags can be applied to any Post, without affecting your Category structure at all. If you\'d like to use Tags with Pages, get <a href="http://wordpress.org/extend/plugins/page-tagger/" target="_blank" rel="external">Page Tagger</a>.</p>' . "\n";
								echo '<p>Tags are caSe sensitive. The Tag <code>members only</code> is NOT the same as <code>Members Only</code>.</p>' . "\n";
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_tag_level_access", get_defined_vars ());
								/**/
								echo '<table class="form-table">' . "\n";
								echo '<tbody>' . "\n";
								/**/
								for ($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
									{
										echo '<tr>' . "\n";
										/**/
										echo '<th>' . "\n";
										echo '<label for="ws-plugin--s2member-level' . $n . '-ptags">' . "\n";
										echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'Tags That Require Highest Level #' . $n . ':' . "\n" : 'Tags That Require Level #' . $n . ' Or Higher:' . "\n";
										echo '</label>' . "\n";
										echo '</th>' . "\n";
										/**/
										echo '</tr>' . "\n";
										echo '<tr>' . "\n";
										/**/
										echo '<td>' . "\n";
										echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_level' . $n . '_ptags" id="ws-plugin--s2member-level' . $n . '-ptags" value="' . format_to_edit ($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level" . $n . "_ptags"]) . '" /><br />' . "\n";
										echo 'Tags in comma-delimited format. Example: ' . (($n === 0) ? '<code>free,subscribers only</code>' : '<code>members,members only</code>') . ' — or you can type: <code>all</code>.' . "\n";
										echo '</td>' . "\n";
										/**/
										echo '</tr>' . "\n";
									}
								/**/
								echo '</tbody>' . "\n";
								echo '</table>' . "\n";
								echo '</div>' . "\n";
								/**/
								echo '</div>' . "\n";
								/**/
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_tag_level_access", get_defined_vars ());
							}
						/**/
						if (apply_filters ("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_category_level_access", true, get_defined_vars ()))
							{
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_category_level_access", get_defined_vars ());
								/**/
								echo '<div class="ws-menu-page-group" title="Category Access Restrictions">' . "\n";
								/**/
								echo '<div class="ws-menu-page-section ws-plugin--s2member-category-level-access-section">' . "\n";
								echo '<h3>Category Level Access Restrictions ( optional )</h3>' . "\n";
								echo '<p>Here you can specify Categories that are restricted to certain Membership Access Levels. Category restrictions are a bit more complex. When you restrict access to a Category, it also restricts access to any child Categories it may have <em>( aka: sub-Categories )</em>. In other words, restricting a Category, protects a Category Archive, all of its child Category Archives, and any Posts contained within the Category, or its child Categories. This is a VERY powerful form of protection, so please be careful. It\'s very easy to protect too much content by accident.</p>' . "\n";
								echo ((!is_multisite () || !c_ws_plugin__s2member_utils_conds::is_multisite_farm () || is_main_site ()) && !$GLOBALS["WS_PLUGIN__"]["wp_show_ids"]) ? '<p><em><strong>*Tip*</strong> Can\'t find your Category IDs? Get <a href="http://www.primothemes.com/post/product/wp-show-ids-plugin/" target="_blank" rel="external">WP Show IDs</a>.</em></p>' . "\n" : '';
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_category_level_access", get_defined_vars ());
								/**/
								echo '<table class="form-table">' . "\n";
								echo '<tbody>' . "\n";
								/**/
								for ($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
									{
										echo '<tr>' . "\n";
										/**/
										echo '<th>' . "\n";
										echo '<label for="ws-plugin--s2member-level' . $n . '-catgs">' . "\n";
										echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'Categories That Require Highest Level #' . $n . ':' . "\n" : 'Categories That Require Level #' . $n . ' Or Higher:' . "\n";
										echo '</label>' . "\n";
										echo '</th>' . "\n";
										/**/
										echo '</tr>' . "\n";
										echo '<tr>' . "\n";
										/**/
										echo '<td>' . "\n";
										echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_level' . $n . '_catgs" id="ws-plugin--s2member-level' . $n . '-catgs" value="' . format_to_edit ($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level" . $n . "_catgs"]) . '" /><br />' . "\n";
										echo 'Category IDs in comma-delimited format. Example: <code>1,2,3,34,8,21</code> — or you can type: <code>all</code>.' . "\n";
										echo '</td>' . "\n";
										/**/
										echo '</tr>' . "\n";
										/**/
										echo '<tr>' . "\n";
									}
								/**/
								echo '</tbody>' . "\n";
								echo '</table>' . "\n";
								echo '</div>' . "\n";
								/**/
								echo '</div>' . "\n";
								/**/
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_category_level_access", get_defined_vars ());
							}
						/**/
						if (apply_filters ("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_uri_level_access", true, get_defined_vars ()))
							{
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_uri_level_access", get_defined_vars ());
								/**/
								echo '<div class="ws-menu-page-group" title="URI Restrictions ( typical w/BuddyPress )">' . "\n";
								/**/
								echo '<div class="ws-menu-page-section ws-plugin--s2member-uri-level-access-section">' . "\n";
								echo '<h3>URI Level Access Restrictions ( optional )</h3>' . "\n";
								echo '<p>Here you can specify URIs <em>( or word fragments found in URIs )</em> that are restricted to certain Membership Access Levels. Control over URIs is a little more complex. This section is intended for advanced webmasters only. That being said, here are the basics... A <code>REQUEST_URI</code>, is the portion of a <code>URL</code> that comes immediately after the domain. This is a URL <code>http://www.example.com/path/to/file.php</code>, and this is the URI: <code>/path/to/file.php</code>. In other words, a <code>REQUEST_URI</code> is the full path to a real <em>( or virtual )</em> directory and/or file on your domain.</p>' . "\n";
								echo '<p>In the fields below, you can provide a list <em>( one per line )</em> of URIs on your site that should be off-limits based on Membership Level. You can also use word fragments instead of a full URI. If a word fragment is found anywhere in the URI, it will be protected. Wildcards and other regex patterns are NOT supported here, and therefore you don\'t need to escape special characters or anything. Please note, these ARE caSe sensitive. You must be specific with respect to case sensitivity. The word fragment <code>some-path/</code> would NOT match a URI that contains <code>some-Path/</code>. <em>A few <a href="#" onclick="alert(\'URI Replacement Codes:\\n\\n%%current_user_login%% = The current User\\\'s Username, lowercase.\\n%%current_user_id%% = The current User\\\'s ID.\\n%%current_user_level%% = The current User\\\'s s2Member Level.\\n%%current_user_role%% = The current User\\\'s WordPress® Role.' . ((!is_multisite () || !c_ws_plugin__s2member_utils_conds::is_multisite_farm () || is_main_site ()) ? '\\n%%current_user_ccaps%% = The current User\\\'s Custom Capabilities.' : '') . '\\n%%current_user_logins%% = Number of times the current User has logged in.\\n\\nFor example, if you\\\'re using BuddyPress, and want to protect BuddyPress Groups, you could add URI protection, like this: /members/%%current_user_login%%/groups/\'); return false;">Replacement Codes</a> are also supported here.</em></p>' . "\n";
								echo '<p><em><strong>*BuddyPress ( and similar )*</strong> URI Restrictions work great with plugins like BuddyPress that add new areas to your site ( where those new areas are NOT necessarily a Post/Page/Tag/Category ). In other words, anytime you\'d like to protect a specific feature offered by BuddyPress ( or other plugins ), you\'ll need to nail down specific word fragments found in the URIs associated with those areas. For instance, with BuddyPress you might have: [ <a href="#" onclick="alert(\'/members/\\n/groups/\\n/blogs/\\n/activity/\\n/messages/\\n/profile/\\n/friends/\\n/settings/\'); return false;">click for example</a> ].</em></p>' . "\n";
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_uri_level_access", get_defined_vars ());
								/**/
								echo '<table class="form-table">' . "\n";
								echo '<tbody>' . "\n";
								/**/
								for ($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
									{
										echo '<tr>' . "\n";
										/**/
										echo '<th>' . "\n";
										echo '<label for="ws-plugin--s2member-level' . $n . '-ruris">' . "\n";
										echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'URIs That Require Highest Level #' . $n . ':' . "\n" : 'URIs That Require Level #' . $n . ' Or Higher:' . "\n";
										echo '</label>' . "\n";
										echo '</th>' . "\n";
										/**/
										echo '</tr>' . "\n";
										echo '<tr>' . "\n";
										/**/
										echo '<td>' . "\n";
										echo '<textarea name="ws_plugin__s2member_level' . $n . '_ruris" id="ws-plugin--s2member-level' . $n . '-ruris" rows="3" wrap="off" spellcheck="false">' . format_to_edit ($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level" . $n . "_ruris"]) . '</textarea><br />' . "\n";
										echo 'URIs and/or word fragments found in URIs. One per line please.' . "\n";
										echo '</td>' . "\n";
										/**/
										echo '</tr>' . "\n";
									}
								/**/
								echo '</tbody>' . "\n";
								echo '</table>' . "\n";
								echo '</div>' . "\n";
								/**/
								echo '</div>' . "\n";
								/**/
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_uri_level_access", get_defined_vars ());
							}
						/**/
						if (apply_filters ("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_query_level_access", true, get_defined_vars ()))
							{
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_query_level_access", get_defined_vars ());
								/**/
								echo '<div class="ws-menu-page-group" title="Alternative View Protection ( please read )">' . "\n";
								/**/
								echo '<div class="ws-menu-page-section ws-plugin--s2member-query-level-access-section">' . "\n";
								echo '<h3>Alternative View Protection ( optional / experimental )</h3>' . "\n";
								echo '<p>s2Member protects Categories, Tags, Posts, Pages, Files, URIs &amp; more. BUT, even with all of those security restrictions, it\'s still possible for protected content excerpts to be seen through XML feeds, in search results generated by WordPress®; and/or <em>( depending on your theme )</em>, possibly in other Archive views; which might include: Posts by Author, Posts by Date, a list of featured items formulated by your theme, OR even through other widgets/plugins adding functionality to your site. ~ We refer to all of these collectively, as "Alternative Views".</p>' . "\n";
								echo '<p>Using the options below, you can tell s2Member to protect some <em>( or all )</em> of these "Alternative Views", by filtering WordPress® database queries for you. s2Member can automatically hide protected content that is NOT available to the current User/Member. In other words, s2Member is capable of pre-filtering ALL database queries, so that excerpts of protected content will not be allowed to slip through. This is marked "experimental", because we\'re still testing this against MANY widget/plugin/theme combinations. Please <a href="' . esc_attr (c_ws_plugin__s2member_readmes::parse_readme_value ("Forum URI")) . '" target="_blank">report</a> all bugs.</p>' . "\n";
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_uri_level_access", get_defined_vars ());
								/**/
								echo '<table class="form-table">' . "\n";
								echo '<tbody>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<th>' . "\n";
								echo '<label for="ws-plugin--s2member-filter-wp-query">' . "\n";
								echo 'Protect Alternative Views?' . "\n";
								echo '</label>' . "\n";
								echo '</th>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<td>' . "\n";
								echo '<div class="ws-menu-page-scrollbox" style="height:105px;">' . "\n";
								echo '<input type="hidden" name="ws_plugin__s2member_filter_wp_query[]" value="update-signal" />' . "\n";
								foreach (array ("all" => "<strong>Filter ALL WordPress® queries</strong>; protecting all Alternative Views.", "searches" => "&#9492;&#9472; Searches ( hide protected content in search results )", "feeds" => "&#9492;&#9472; Feeds ( hide protected content in standard XML/RSS/ATOM feeds )", "comment-feeds" => "&#9492;&#9472; Comment Feeds ( hide comments associated with protected content, in comment feeds )", "nav-menus" => "&#9492;&#9472; Nav Menus ( hide protected content in menus generated with <em>WordPress® -> Appearance -> Menus</em> )") as $ws_plugin__s2member_temp_s_value => $ws_plugin__s2member_temp_s_label)
									echo '<input type="checkbox" name="ws_plugin__s2member_filter_wp_query[]" id="ws-plugin--s2member-filter-wp-query-' . esc_attr (preg_replace ("/[^a-z0-9_\-]/", "-", $ws_plugin__s2member_temp_s_value)) . '" value="' . esc_attr ($ws_plugin__s2member_temp_s_value) . '"' . ((in_array ($ws_plugin__s2member_temp_s_value, $GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["filter_wp_query"])) ? ' checked="checked"' : '') . ' /> <label for="ws-plugin--s2member-filter-wp-query-' . esc_attr (preg_replace ("/[^a-z0-9_\-]/", "-", $ws_plugin__s2member_temp_s_value)) . '">' . $ws_plugin__s2member_temp_s_label . '</label><br />' . "\n";
								echo '</div>' . "\n";
								echo '<strong>Attn Developers:</strong> Filters can be suppressed dynamically, using this technique:<br />' . "\n";
								echo '<code><a href="http://codex.wordpress.org/Function_Reference/query_posts" target="_blank" rel="external">query_posts</a>("suppress_filters=true");</code><br />' . "\n";
								echo '<code><a href="http://codex.wordpress.org/Function_Reference/get_posts" target="_blank" rel="external">get_posts</a>()</code> auto-suppresses filters.<br />' . "\n";
								echo 'Also see <a href="http://www.primothemes.com/forums/viewtopic.php?f=40&t=12453#src_doc_attach_s2member_query_filters%28%29" target="_blank" rel="external">this article</a> in the s2Member® Codex.' . "\n";
								echo '</td>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '</tbody>' . "\n";
								echo '</table>' . "\n";
								echo '</div>' . "\n";
								/**/
								echo '</div>' . "\n";
								/**/
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_query_level_access", get_defined_vars ());
							}
						/**/
						if (apply_filters ("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_sp_access", true, get_defined_vars ()))
							{
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_sp_access", get_defined_vars ());
								/**/
								echo '<div class="ws-menu-page-group" title="Specific Post/Page Access Restrictions">' . "\n";
								/**/
								echo '<div class="ws-menu-page-section ws-plugin--s2member-sp-access-section">' . "\n";
								echo '<h3>Specific Post/Page Access Restrictions ( optional )</h3>' . "\n";
								echo '<p>s2Member now supports an additional layer of functionality <em>( very powerful )</em>, which allows you to sell access to specific Posts/Pages that you\'ve created in WordPress®. Specific Post/Page Access works independently from Member Level Access. That is, you can sell an unlimited number of Posts/Pages using "Buy Now" Buttons, and your Customers will NOT be required to have a Membership Account with your site in order to receive access. If they are already a Member, that\'s fine, but they won\'t need to be.</p>' . "\n";
								echo '<p>In other words, Customers will NOT need to login, just to receive access to the Specific Post/Page they purchased access to. s2Member will immediately redirect the Customer to the Specific Post/Page after checkout is completed successfully. An email is also sent to the Customer with a link ( see: <code>s2Member -> PayPal® Options -> Specific Post/Page Email</code> ). Authentication is handled automatically through self-expiring links, good for 72 hours by default.</p>' . "\n";
								echo '<p>Specific Post/Page Access, is sort of like selling a product. Only, instead of shipping anything to the Customer, you just give them access to a specific Post/Page on your site; one that you created in WordPress®. A Specific Post/Page that is protected by s2Member, might contain a download link for your eBook, access to file &amp; music downloads, access to additional support services, and the list goes on and on. The possibilities with this are endless; as long as your digital product can be delivered through access to a WordPress® Post/Page that you\'ve created.</p>' . "\n";
								echo '<p>Very simple. All you do is protect the Specific Post/Page IDs that are being sold on your site. Then, you can go to <code>s2Member -> PayPal® Buttons -> Specific Post/Page</code> to generate "Buy Now" Buttons that you can insert into your WordPress® Editor, and make available on your site. The Button Generator for s2Member, will even let you Package Additional Posts/Pages together into one transaction.</p>' . "\n";
								echo ((!is_multisite () || !c_ws_plugin__s2member_utils_conds::is_multisite_farm () || is_main_site ()) && !$GLOBALS["WS_PLUGIN__"]["wp_show_ids"]) ? '<p><em><strong>*Tip*</strong> Can\'t find your Post/Page IDs? Get <a href="http://www.primothemes.com/post/product/wp-show-ids-plugin/" target="_blank" rel="external">WP Show IDs</a>.</em></p>' . "\n" : '';
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_sp_access", get_defined_vars ());
								/**/
								echo '<table class="form-table">' . "\n";
								echo '<tbody>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<th>' . "\n";
								echo '<label for="ws-plugin--s2member-specific-ids">' . "\n";
								echo 'Specific Post/Page IDs Being Sold On Your Site:' . "\n";
								echo '</label>' . "\n";
								echo '</th>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<td>' . "\n";
								echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_specific_ids" id="ws-plugin--s2member-specific-ids" value="' . format_to_edit ($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["specific_ids"]) . '" /><br />' . "\n";
								echo 'Post/Page IDs in comma-delimited format. Example: <code>1,2,3,34,8,21</code> * Note... the word <code>all</code> does NOT work here. Also, please be careful not to create a conflict with other Access Restrictions. If you are going to sell Specific Post/Page Access, you should enter specific Post/Page IDs here; and <strong>make SURE that you\'ve NOT already protected any of these Posts/Pages with Member Level Access Restrictions</strong>. In other words, if you configure s2Member, in such as a way, that a Post/Page requires Membership Level Access, you cannot sell that same Post/Page through Specific Post/Page Access. Doing so, would create a conflict. Customers that purchased Specific Post/Page Access, would be unable to access the Post/Page - without also having a Membership. Not good. So please be careful.' . "\n";
								echo '</td>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '</tbody>' . "\n";
								echo '</table>' . "\n";
								echo '</div>' . "\n";
								/**/
								echo '</div>' . "\n";
								/**/
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_sp_access", get_defined_vars ());
							}
						/**/
						if (apply_filters ("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_brute_force_restrictions", true, get_defined_vars ()))
							{
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_brute_force_restrictions", get_defined_vars ());
								/**/
								echo '<div class="ws-menu-page-group" title="Brute Force IP/Login Restrictions">' . "\n";
								/**/
								echo '<div class="ws-menu-page-section ws-plugin--s2member-brute-force-restrictions-section">' . "\n";
								echo '<h3>Brute Force IP/Login Restrictions ( prevents username/password guessing )</h3>' . "\n";
								echo '<input type="button" id="ws-plugin--s2member-brute-force-restrictions-reset-button" value="Reset Brute Force Logs" class="ws-menu-page-right" style="min-width:175px;" />' . "\n";
								echo '<p>As with any Membership system, it is possible for someone to try and guess Username/Password combinations by attempting a <a href="http://en.wikipedia.org/wiki/Brute-force_attack" target="_blank" rel="external">Brute Force Attack</a>; whereby multiple/repeated logins are strategically attempted with various Username/Password combinations until a correct guess is made. It is NOT likely that you\'ll be attacked in this way, but it\'s still a good idea to protect your system; just in case somebody tries this. s2Member thwarts this behavior by monitoring failed login attempts that occur within a short period of time. Whenever s2Member detects an IP address <em>( i.e. a remote user )</em> that is consistently failing to enter a valid Username/Password, a temporary ban is created; preventing additional attempts from taking place for 30 minutes. This temporary ban, will ONLY affect the offending IP address.</p>' . "\n";
								echo '<p><em>*Note* an empty IP address ( associated with someone browsing anonymously ), is also considered a unique IP address, so it cannot circumvent s2Member\'s security.</em></p>' . "\n";
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_ip_restrictions", get_defined_vars ());
								/**/
								echo '<table class="form-table">' . "\n";
								echo '<tbody>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<th>' . "\n";
								echo '<label for="ws-plugin--s2member-max-failed-login-attempts">' . "\n";
								echo 'Maximum Failed Login Attempts:' . "\n";
								echo '</label>' . "\n";
								echo '</th>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<td>' . "\n";
								echo '<select name="ws_plugin__s2member_max_failed_login_attempts" id="ws-plugin--s2member-max-failed-login-attempts">' . "\n";
								$ws_plugin__s2member_temp_s = apply_filters ("ws_plugin__s2member_track_failed_logins__exp_time", "30 minutes");
								echo '<option value="1"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 1) ? ' selected="selected"' : '') . '>Allow 1 failed login attempt ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="2"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 2) ? ' selected="selected"' : '') . '>Allow 2 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="3"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 3) ? ' selected="selected"' : '') . '>Allow 3 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="4"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 4) ? ' selected="selected"' : '') . '>Allow 4 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="5"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 5) ? ' selected="selected"' : '') . '>Allow 5 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="10"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 10) ? ' selected="selected"' : '') . '>Allow 10 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="20"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 20) ? ' selected="selected"' : '') . '>Allow 20 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="30"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 30) ? ' selected="selected"' : '') . '>Allow 30 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="40"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 40) ? ' selected="selected"' : '') . '>Allow 40 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="50"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 50) ? ' selected="selected"' : '') . '>Allow 50 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="75"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 75) ? ' selected="selected"' : '') . '>Allow 75 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="100"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 100) ? ' selected="selected"' : '') . '>Allow 100 failed login attempts ( then punish for ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="0"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 0) ? ' selected="selected"' : '') . '>Allow infinite failed logins ( Brute Force Restrictions disabled )</option>' . "\n";
								echo '</select><br />' . "\n";
								echo 'When/if you change this, you should also <strong>Reset Brute Force Logs</strong> ( click button above ).' . "\n";
								echo (!is_multisite () || !c_ws_plugin__s2member_utils_conds::is_multisite_farm () || is_main_site ()) ? '<br /><br />The default period of "30 minutes" could be modified through this WordPress® Filter:<br /><code>ws_plugin__s2member_track_failed_logins__exp_time</code>' . "\n" : '';
								echo '</td>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '</tbody>' . "\n";
								echo '</table>' . "\n";
								echo '</div>' . "\n";
								/**/
								echo '</div>' . "\n";
								/**/
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_ip_restrictions", get_defined_vars ());
							}
						/**/
						if (apply_filters ("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_ip_restrictions", true, get_defined_vars ()))
							{
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_ip_restrictions", get_defined_vars ());
								/**/
								echo '<div class="ws-menu-page-group" title="Unique IP Access Restrictions">' . "\n";
								/**/
								echo '<div class="ws-menu-page-section ws-plugin--s2member-ip-restrictions-section">' . "\n";
								echo '<h3>Unique IP Access Restrictions ( prevents username/link sharing )</h3>' . "\n";
								echo '<input type="button" id="ws-plugin--s2member-ip-restrictions-reset-button" value="Reset IP Restriction Logs" class="ws-menu-page-right" style="min-width:175px;" />' . "\n";
								echo '<p>As with any Membership system, it is possible for one Member to signup, and then share their Username with someone else; or even post it online for the whole world to see. This is known as Link Sharing <em>( aka: Username Sharing )</em>. It is NOT likely that you\'ll be attacked in this way, but it\'s still a good idea to protect your system; just in case somebody tries this. s2Member\'s IP Restrictions work for Membership Level Access <em>( account logins )</em>, Specific Post/Page Access, Registration Links, and other secure Entry Points. In all cases, the rules are simple. A single Username, Access Link, and/or Entry Point ... is only valid for a certain number of unique IP addresses. Once that limit is reached, s2Member assumes there has been a security breach. At that time, s2Member will place a temporary ban <em>( preventing access )</em> to a Specific Post/Page, or to an account associated with a particular Username. This temporary ban, will ONLY affect the offending Link and/or Username associated with the security breach. You can fine-tune this behavior, using the options below.</p>' . "\n";
								echo '<p><em>*Note* an empty IP address ( associated with someone browsing anonymously ), is also considered a unique IP address, so it cannot circumvent s2Member\'s security.</em></p>' . "\n";
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_ip_restrictions", get_defined_vars ());
								/**/
								echo '<table class="form-table">' . "\n";
								echo '<tbody>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<th>' . "\n";
								echo '<label for="ws-plugin--s2member-max-ip-restriction">' . "\n";
								echo 'Maximum Unique IP Addresses Allowed:' . "\n";
								echo '</label>' . "\n";
								echo '</th>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<td>' . "\n";
								echo '<select name="ws_plugin__s2member_max_ip_restriction" id="ws-plugin--s2member-max-ip-restriction">' . "\n";
								$ws_plugin__s2member_temp_s = apply_filters ("ws_plugin__s2member_ip_restrictions__concurrency_time_per_ip", "30 days");
								echo '<option value="1"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 1) ? ' selected="selected"' : '') . '>Allow up to 1 unique IP per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="2"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 2) ? ' selected="selected"' : '') . '>Allow up to 2 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="3"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 3) ? ' selected="selected"' : '') . '>Allow up to 3 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="4"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 4) ? ' selected="selected"' : '') . '>Allow up to 4 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="5"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 5) ? ' selected="selected"' : '') . '>Allow up to 5 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="10"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 10) ? ' selected="selected"' : '') . '>Allow up to 10 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="20"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 20) ? ' selected="selected"' : '') . '>Allow up to 20 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="30"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 30) ? ' selected="selected"' : '') . '>Allow up to 30 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="40"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 40) ? ' selected="selected"' : '') . '>Allow up to 40 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="50"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 50) ? ' selected="selected"' : '') . '>Allow up to 50 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="75"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 75) ? ' selected="selected"' : '') . '>Allow up to 75 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="100"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 100) ? ' selected="selected"' : '') . '>Allow up to 100 different IPs per Customer ( every ' . $ws_plugin__s2member_temp_s . ' )</option>' . "\n";
								echo '<option value="0"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 0) ? ' selected="selected"' : '') . '>Allow infinite IPs ( all IP Restrictions are disabled )</option>' . "\n";
								echo '</select>' . "\n";
								echo (!is_multisite () || !c_ws_plugin__s2member_utils_conds::is_multisite_farm () || is_main_site ()) ? '<br />The default period of "30 days" could be modified through this WordPress® Filter:<br /><code>ws_plugin__s2member_ip_restrictions__concurrency_time_per_ip</code>' . "\n" : '';
								echo '</td>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<th>' . "\n";
								echo '<label for="ws-plugin--s2member-max-ip-restriction-time">' . "\n";
								echo 'Security Breach Timeout Period:' . "\n";
								echo '</label>' . "\n";
								echo '</th>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '<tr>' . "\n";
								/**/
								echo '<td>' . "\n";
								echo '<select name="ws_plugin__s2member_max_ip_restriction_time" id="ws-plugin--s2member-max-ip-restriction-time">' . "\n";
								echo '<option value="300"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 300) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 5 mins )</option>' . "\n";
								echo '<option value="900"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 900) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 15 mins )</option>' . "\n";
								echo '<option value="1800"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 1800) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 30 mins )</option>' . "\n";
								echo '<option value="3600"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 3600) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 1 hour )</option>' . "\n";
								echo '<option value="7200"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 7200) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 2 hours )</option>' . "\n";
								echo '<option value="14400"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 14400) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 4 hours )</option>' . "\n";
								echo '<option value="21600"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 21600) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 6 hours )</option>' . "\n";
								echo '<option value="28800"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 28800) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 8 hours )</option>' . "\n";
								echo '<option value="43200"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 43200) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 12 hours )</option>' . "\n";
								echo '<option value="86400"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 86400) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 24 hours )</option>' . "\n";
								echo '<option value="172800"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 172800) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 2 days )</option>' . "\n";
								echo '<option value="345600"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 345600) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 4 days )</option>' . "\n";
								echo '<option value="604800"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 604800) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 1 week )</option>' . "\n";
								echo '<option value="1209600"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 1209600) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 2 weeks )</option>' . "\n";
								echo '<option value="2629743"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 2629743) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 1 month )</option>' . "\n";
								echo '<option value="5259487"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 5259487) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 2 months )</option>' . "\n";
								echo '<option value="7889231"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 7889231) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 3 months )</option>' . "\n";
								echo '<option value="15778463"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 15778463) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 6 months )</option>' . "\n";
								echo '<option value="31556926"' . (($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 31556926) ? ' selected="selected"' : '') . '>If limit is exceeded ( punish for 1 year )</option>' . "\n";
								echo '</select><br />' . "\n";
								echo 'When/if you change this, you should also <strong>Reset IP Restriction Logs</strong> ( click button above ).' . "\n";
								echo '</td>' . "\n";
								/**/
								echo '</tr>' . "\n";
								echo '</tbody>' . "\n";
								echo '</table>' . "\n";
								echo '</div>' . "\n";
								/**/
								echo '</div>' . "\n";
								/**/
								do_action ("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_ip_restrictions", get_defined_vars ());
							}
						/**/
						do_action ("ws_plugin__s2member_during_res_ops_page_after_left_sections", get_defined_vars ());
						/**/
						echo '<div class="ws-menu-page-hr"></div>' . "\n";
						/**/
						echo '<p class="submit"><input type="submit" class="button-primary" value="Save All Changes" /></p>' . "\n";
						/**/
						echo '</form>' . "\n";
						/**/
						echo '</td>' . "\n";
						/**/
						echo '<td class="ws-menu-page-table-r">' . "\n";
						c_ws_plugin__s2member_menu_pages_rs::display ();
						echo '</td>' . "\n";
						/**/
						echo '</tr>' . "\n";
						echo '</tbody>' . "\n";
						echo '</table>' . "\n";
						/**/
						echo '</div>' . "\n";
					}
			}
	}
/**/
new c_ws_plugin__s2member_menu_page_res_ops ();
?>