<?php
/**
* ShoppProductThemeAPI - Provided theme api tags.
*
* @version 1.0
* @since 1.2
* @package shopp
* @subpackage ShoppProductThemeAPI
*
**/

/**
 * Provides shopp('product') template API functionality
 *
 * @author Jonathan Davis, John Dillick
 * @since 1.2
 *
 **/
class ShoppProductThemeAPI implements ShoppAPI {
	static $context = 'Product';
	static $register = array(
		'addons' => 'addons',
		'addtocart' => 'add_to_cart',
		'buynow' => 'buy_now',
		'categories' => 'categories',
		'category' => 'category',
		'coverimage' => 'coverimage',
		'description' => 'description',
		'donation' => 'quantity',
		'amount' => 'quantity',
		'quantity' => 'quantity',
		'found' => 'found',
		'freeshipping' => 'free_shipping',
		'gallery' => 'gallery',
		'hasaddons' => 'has_addons',
		'hascategories' => 'has_categories',
		'hassavings' => 'has_savings',
		'hasvariations' => 'has_variations',
		'hasimages' => 'has_images',
		'hasspecs' => 'has_specs',
		'hastags' => 'has_tags',
		'id' => 'id',
		'image' => 'image',
		'thumbnail' => 'image',
		'images' => 'images',
		'incart' => 'in_cart',
		'incategory' => 'in_category',
		'input' => 'input',
		'isfeatured' => 'is_featured',
		'link' => 'url',
		'url' => 'url',
		'name' => 'name',
		'onsale' => 'on_sale',
		'outofstock' => 'out_of_stock',
		'price' => 'price',
		'saleprice' => 'saleprice',
		'relevance' => 'relevance',
		'savings' => 'savings',
		'slug' => 'slug',
		'spec' => 'spec',
		'specs' => 'specs',
		'summary' => 'summary',
		'stock' => 'stock',
		'tag' => 'tag',
		'tagged' => 'tagged',
		'tags' => 'tags',
		'taxrate' => 'taxrate',
		'type' => 'type',
		'variation' => 'variation',
		'variations' => 'variations',
		'weight' => 'weight'
	);

	static function _apicontext () { return 'product'; }

	/**
	 * _setobject - returns the global context object used in the shopp('product') call
	 *
	 * @author John Dillick
	 * @since 1.2
	 *
	 **/
	static function _setobject ($Object, $object) {
		if ( is_object($Object) && is_a($Object, 'Product') ) return $Object;

		if ( strtolower($object) != 'product' ) return $Object; // not mine, do nothing
		else {
			return ShoppProduct();
		}
	}

	function addons ($result, $options, $O) {
		global $Shopp;
		$string = "";

		if (!isset($options['mode'])) {
			if (!$O->priceloop) {
				reset($O->prices);
				$O->priceloop = true;
			} else next($O->prices);
			$Oprice = current($O->prices);

			if ($Oprice && $Oprice->type == "N/A")
				next($O->prices);

			if ($Oprice && $Oprice->context != "addon")
				next($O->prices);

			if (current($O->prices) !== false) return true;
			else {
				$O->priceloop = false;
				return false;
			}
			return true;
		}

		if ($O->outofstock) return false; // Completely out of stock, hide menus
		if (!isset($options['taxes'])) $options['taxes'] = null;

		$defaults = array(
			'defaults' => '',
			'disabled' => 'show',
			'before_menu' => '',
			'after_menu' => ''
			);

		$options = array_merge($defaults,$options);

		if (!isset($options['label'])) $options['label'] = "on";
		if (!isset($options['required'])) $options['required'] = __('You must select the options for this item before you can add it to your shopping cart.','Shopp');
		if ($options['mode'] == "single") {
			if (!empty($options['before_menu'])) $string .= $options['before_menu']."\n";
			if (value_is_true($options['label'])) $string .= '<label for="product-options'.$O->id.'">'. __('Options','Shopp').': </label> '."\n";

			$string .= '<select name="products['.$O->id.'][price]" id="product-options'.$O->id.'">';
			if (!empty($options['defaults'])) $string .= '<option value="">'.$options['defaults'].'</option>'."\n";

			foreach ($O->prices as $pricetag) {
				if ($pricetag->context != "addon") continue;

				if (isset($options['taxes']))
					$taxrate = shopp_taxrate(value_is_true($options['taxes']),$pricetag->tax,$O);
				else $taxrate = shopp_taxrate(null,$pricetag->tax,$O);
				$currently = ($pricetag->sale == "on")?$pricetag->promoprice:$pricetag->price;
				$disabled = ($pricetag->inventory == "on" && $pricetag->stock == 0)?' disabled="disabled"':'';

				$price = '  ('.money($currently).')';
				if ($pricetag->type != "N/A")
					$string .= '<option value="'.$pricetag->id.'"'.$disabled.'>'.$pricetag->label.$price.'</option>'."\n";
			}

			$string .= '</select>';
			if (!empty($options['after_menu'])) $string .= $options['after_menu']."\n";

		} else {
			if (!isset($O->options['a'])) return;

			$taxrate = shopp_taxrate($options['taxes'],true,$O);

			// Index addon prices by option
			$pricing = array();
			foreach ($O->prices as $pricetag) {
				if ($pricetag->context != "addon") continue;
				$pricing[$pricetag->options] = $pricetag;
			}

			foreach ($O->options['a'] as $id => $menu) {
				if (!empty($options['before_menu'])) $string .= $options['before_menu']."\n";
				if (value_is_true($options['label'])) $string .= '<label for="options-'.$menu['id'].'">'.$menu['name'].'</label> '."\n";
				$category_class = isset($Shopp->Category->slug)?'category-'.$Shopp->Category->slug:'';
				$string .= '<select name="products['.$O->id.'][addons][]" class="'.$category_class.' product'.$O->id.' addons" id="addons-'.$menu['id'].'">';
				if (!empty($options['defaults'])) $string .= '<option value="">'.$options['defaults'].'</option>'."\n";
				foreach ($menu['options'] as $key => $option) {

					$pricetag = $pricing[$option['id']];

					if (isset($options['taxes']))
						$taxrate = shopp_taxrate(value_is_true($options['taxes']),$pricetag->tax,$O);
					else $taxrate = shopp_taxrate(null,$pricetag->tax,$O);

					$currently = ($pricetag->sale == "on")?$pricetag->promoprice:$pricetag->price;
					if ($taxrate > 0) $currently = $currently+($currently*$taxrate);
					$string .= '<option value="'.$option['id'].'">'.$option['name'].' (+'.money($currently).')</option>'."\n";
				}

				$string .= '</select>';
			}
			if (!empty($options['after_menu'])) $string .= $options['after_menu']."\n";

		}

		return $string;
	}

	function add_to_cart ($result, $options, $O) {
		if (!isset($options['class'])) $options['class'] = "addtocart";
		else $options['class'] .= " addtocart";
		if (!isset($options['value'])) $options['value'] = __("Add to Cart","Shopp");
		$string = "";

		if ($O->outofstock)
			return '<span class="outofstock">'.esc_html(shopp_setting('outofstock_text')).'</span>';

		if (isset($options['redirect']) && !isset($options['ajax']))
			$string .= '<input type="hidden" name="redirect" value="'.esc_attr($options['redirect']).'" />';

		$string .= '<input type="hidden" name="products['.$O->id.'][product]" value="'.$O->id.'" />';

		if (!empty($O->prices[0]) && $O->prices[0]->type != "N/A")
			$string .= '<input type="hidden" name="products['.$O->id.'][price]" value="'.$O->prices[0]->id.'" />';

		$collection = isset(ShoppCollection()->slug)?shopp('collection','get-slug'):false;
		if (!empty($collection)) {
			$string .= '<input type="hidden" name="products['.$O->id.'][category]" value="'.esc_attr($collection).'" />';
		}

		$string .= '<input type="hidden" name="cart" value="add" />';
		if (isset($options['ajax'])) {
			if ($options['ajax'] == "html") $options['class'] .= ' ajax-html';
			else $options['class'] .= " ajax";
			$string .= '<input type="hidden" name="ajax" value="true" />';
			$string .= '<input type="button" name="addtocart" '.inputattrs($options).' />';
		} else {
			$string .= '<input type="submit" name="addtocart" '.inputattrs($options).' />';
		}

		return $string;
	}

	function buy_now ($result, $options, $O) {
		if (!isset($options['value'])) $options['value'] = __("Buy Now","Shopp");
		return self::addtocart($result, $options, $O);
	}

	function categories ($result, $options, $O) {
		if (!isset($O->_categories_loop)) {
			reset($O->categories);
			$O->_categories_loop = true;
		} else next($O->categories);

		if (current($O->categories) !== false) return true;
		else {
			unset($O->_categories_loop);
			return false;
		}
	}

	function category ($result, $options, $O) {
		$category = current($O->categories);
		if (isset($options['show'])) {
			if ($options['show'] == "id") return $category->id;
			if ($options['show'] == "slug") return $category->slug;
		}
		return $category->name;
	}

	function coverimage ($result, $options, $O) {
		// Force select the first loaded image
		unset($options['id']);
		$options['index'] = 0;
		return self::image($result, $options, $O);
	}

	function description ($result, $options, $O) { return apply_filters('shopp_product_description',$O->description); }

	function found ($result, $options, $O) {
		if (empty($O->id)) return false;
		$loadable = array('prices','coverimages','images','specs','tags','categories','summary');
		if (isset($options['load'])) $options['load'] = explode(',',$options['load']);
		$load = array_intersect($loadable,$options['load']);
		if (empty($load)) $load = array('summary','prices','images','specs','tags','categories');
		$O->load_data($load);
		return true;
	}

	function free_shipping ($result, $options, $O) {
		if (empty($O->prices)) $O->load_data(array('prices'));
		return $O->freeshipping;
	}

	function gallery ($result, $options, $O) {
		global $Shopp;
		if (empty($O->images)) $O->load_data(array('images'));
		if (empty($O->images)) return false;
		$styles = '';
		$_size = 240;
		$_width = shopp_setting('gallery_small_width');
		$_height = shopp_setting('gallery_small_height');

		if (!$_width) $_width = $_size;
		if (!$_height) $_height = $_size;

		$defaults = array(

			// Layout settings
			'margins' => 20,
			'rowthumbs' => false,
			// 'thumbpos' => 'after',

			// Preview image settings
			'p.size' => false,
			'p.width' => false,
			'p.height' => false,
			'p.fit' => false,
			'p.sharpen' => false,
			'p.quality' => false,
			'p.bg' => false,
			'p.link' => true,
			'rel' => '',

			// Thumbnail image settings
			'thumbsize' => false,
			'thumbwidth' => false,
			'thumbheight' => false,
			'thumbfit' => false,
			'thumbsharpen' => false,
			'thumbquality' => false,
			'thumbbg' => false,

			// Effects settings
			'zoomfx' => 'shopp-zoom',
			'preview' => 'click',
			'colorbox' => '{}'


		);
		$optionset = array_merge($defaults,$options);

		// Translate dot names
		$options = array();
		$keys = array_keys($optionset);
		foreach ($keys as $key)
			$options[str_replace('.','_',$key)] = $optionset[$key];
		extract($options);

		if ($p_size > 0)
			$_width = $_height = $p_size;

		$width = $p_width > 0?$p_width:$_width;
		$height = $p_height > 0?$p_height:$_height;

		$preview_width = $width;

		$previews = '<ul class="previews">';
		$firstPreview = true;

		// Find the max dimensions to use for the preview spacing image
		$maxwidth = $maxheight = 0;
		foreach ($O->images as $img) {
			$scale = $p_fit?false:array_search($p_fit,$img->_scaling);
			$scaled = $img->scaled($width,$height,$scale);
			$maxwidth = max($maxwidth,$scaled['width']);
			$maxheight = max($maxheight,$scaled['height']);
		}

		if ($maxwidth == 0) $maxwidth = $width;
		if ($maxheight == 0) $maxheight = $height;

		$p_link = value_is_true($p_link);

		foreach ($O->images as $img) {

			$scale = $p_fit?array_search($p_fit,$img->_scaling):false;
			$sharpen = $p_sharpen?min($p_sharpen,$img->_sharpen):false;
			$quality = $p_quality?min($p_quality,$img->_quality):false;
			$fill = $p_bg?hexdec(ltrim($p_bg,'#')):false;
			$scaled = $img->scaled($width,$height,$scale);

			if ($firstPreview) { // Adds "filler" image to reserve the dimensions in the DOM
				$href = shoppurl(SHOPP_PERMALINKS?trailingslashit('000'):'000','images');
				$previews .= '<li id="preview-fill"'.(($firstPreview)?' class="fill"':'').'>';
				$previews .= '<img src="'.add_query_string("$maxwidth,$maxheight",$href).'" alt=" " width="'.$maxwidth.'" height="'.$maxheight.'" />';
				$previews .= '</li>';
			}
			$title = !empty($img->title)?' title="'.esc_attr($img->title).'"':'';
			$alt = esc_attr(!empty($img->alt)?$img->alt:$img->filename);

			$previews .= '<li id="preview-'.$img->id.'"'.(($firstPreview)?' class="active"':'').'>';

			$href = shoppurl(SHOPP_PERMALINKS?trailingslashit($img->id).$img->filename:$img->id,'images');
			if ($p_link) $previews .= '<a href="'.$href.'" class="gallery product_'.$O->id.' '.$options['zoomfx'].'"'.(!empty($rel)?' rel="'.$rel.'"':'').''.$title.'>';
			// else $previews .= '<a name="preview-'.$img->id.'">'; // If links are turned off, leave the <a> so we don't break layout
			$previews .= '<img src="'.add_query_string($img->resizing($width,$height,$scale,$sharpen,$quality,$fill),shoppurl($img->id,'images')).'"'.$title.' alt="'.$alt.'" width="'.$scaled['width'].'" height="'.$scaled['height'].'" />';
			if ($p_link) $previews .= '</a>';
			$previews .= '</li>';
			$firstPreview = false;
		}
		$previews .= '</ul>';

		$thumbs = "";
		$twidth = $preview_width+$margins;

		if (count($O->images) > 1) {
			$default_size = 64;
			$_thumbwidth = shopp_setting('gallery_thumbnail_width');
			$_thumbheight = shopp_setting('gallery_thumbnail_height');
			if (!$_thumbwidth) $_thumbwidth = $default_size;
			if (!$_thumbheight) $_thumbheight = $default_size;

			if ($thumbsize > 0) $thumbwidth = $thumbheight = $thumbsize;

			$width = $thumbwidth > 0?$thumbwidth:$_thumbwidth;
			$height = $thumbheight > 0?$thumbheight:$_thumbheight;

			$firstThumb = true;
			$thumbs = '<ul class="thumbnails">';
			foreach ($O->images as $img) {
				$scale = $thumbfit?array_search($thumbfit,$img->_scaling):false;
				$sharpen = $thumbsharpen?min($thumbsharpen,$img->_sharpen):false;
				$quality = $thumbquality?min($thumbquality,$img->_quality):false;
				$fill = $thumbbg?hexdec(ltrim($thumbbg,'#')):false;
				$scaled = $img->scaled($width,$height,$scale);

				$title = !empty($img->title)?' title="'.esc_attr($img->title).'"':'';
				$alt = esc_attr(!empty($img->alt)?$img->alt:$img->name);

				$thumbs .= '<li id="thumbnail-'.$img->id.'" class="preview-'.$img->id.(($firstThumb)?' first':'').'">';
				$thumbs .= '<img src="'.add_query_string($img->resizing($width,$height,$scale,$sharpen,$quality,$fill),shoppurl($img->id,'images')).'"'.$title.' alt="'.$alt.'" width="'.$scaled['width'].'" height="'.$scaled['height'].'" />';
				$thumbs .= '</li>'."\n";
				$firstThumb = false;
			}
			$thumbs .= '</ul>';

		}
		if ($rowthumbs > 0) $twidth = ($width+$margins+2)*(int)$rowthumbs;

		$result = '<div id="gallery-'.$O->id.'" class="gallery">'.$previews.$thumbs.'</div>';
		$script = "\t".'ShoppGallery("#gallery-'.$O->id.'","'.$preview.'"'.($twidth?",$twidth":"").');';
		add_storefrontjs($script);

		return $result;
	}

	function has_addons ($result, $options, $O) { return ($O->addons == "on" && !empty($O->options['a'])); }

	function has_categories ($result, $options, $O) {
		if (empty($O->categories)) $O->load_data(array('categories'));
		if (count($O->categories) > 0) return true; else return false;
	}

	function has_images ($result, $options, $O) {
		if (empty($O->images)) $O->load_data(array('images'));
		return (!empty($O->images));
	}

	function has_savings ($result, $options, $O) { return (str_true($O->sale) && $O->min['saved'] > 0); }

	function has_specs ($result, $options, $O) {
		if (empty($O->specs)) $O->load_data(array('specs'));
		if (count($O->specs) > 0) {
			$O->merge_specs();
			return true;
		} else return false;
	}

	function has_tags ($result, $options, $O) {
		if (empty($O->tags)) $O->load_data(array('tags'));
		if (count($O->tags) > 0) return true; else return false;
	}

	function has_variations ($result, $options, $O) {
		if (0 == $O->options) $O->load_data(array('summary','meta','prices'));
		return ('on' == $O->variants && (!empty($O->options['v']) || !empty($O->options)));
	}

	function id ($result, $options, $O) { return $O->id; }

	/**
	 * Renders a product image
	 *
	 * @see the image() method from theme/catalog.php
	 * @author Jonathan Davis
	 * @since 1.2
	 *
	 * @return string
	 **/
	function image ($result, $options, $O) {
		if (!self::has_images($result, $options, $O)) return '';
		return ShoppCatalogThemeAPI::image($result, $options, $O);
	}

	function images ($result, $options, $O) {
		if (!$O->images) return false;
		if (!isset($O->_images_loop)) {
			reset($O->images);
			$O->_images_loop = true;
		} else next($O->images);

		if (current($O->images) !== false) return true;
		else {
			unset($O->_images_loop);
			return false;
		}
	}

	// @todo Add Theme API documentation for shopp('product','in-cart')
	function in_cart ($result, $options, $O) {
		$Order = ShoppOrder();
		$cartitems = $Order->Cart->contents;
		if (empty($cartitems)) return false;
		foreach ((array)$cartitems as $Item)
			if ($Item->product == $O->id) return true;
	}

	function in_category ($result, $options, $O) {
		if (empty($O->categories)) $O->load_data(array('categories'));
		if (isset($options['id'])) $field = "id";
		if (isset($options['name'])) $field = "name";
		if (isset($options['slug'])) $field = "slug";
		foreach ($O->categories as $category)
			if ($category->{$field} == $options[$field]) return true;
		return false;
	}

	function input ($result, $options, $O) {
		$select_attrs = array('title','required','class','disabled','required','size','tabindex','accesskey');
		$submit_attrs = array('title','class','value','disabled','tabindex','accesskey');

		if (!isset($options['type']) ||
			($options['type'] != "menu" && $options['type'] != "textarea" && !valid_input($options['type']))) $options['type'] = "text";
		if (!isset($options['name'])) return "";
		if ($options['type'] == "menu") {
			$result = '<select name="products['.$O->id.'][data]['.$options['name'].']" id="data-'.$options['name'].'-'.$O->id.'"'.inputattrs($options,$select_attrs).'>';
			if (isset($options['options']))
				$menuoptions = preg_split('/,(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))/',$options['options']);
			if (is_array($menuoptions)) {
				foreach($menuoptions as $option) {
					$selected = "";
					$option = trim($option,'"');
					if (isset($options['default']) && $options['default'] == $option)
						$selected = ' selected="selected"';
					$result .= '<option value="'.$option.'"'.$selected.'>'.$option.'</option>';
				}
			}
			$result .= '</select>';
		} elseif ($options['type'] == "textarea") {
			if (isset($options['cols'])) $cols = ' cols="'.$options['cols'].'"';
			if (isset($options['rows'])) $rows = ' rows="'.$options['rows'].'"';
			$result .= '<textarea name="products['.$O->id.'][data]['.$options['name'].']" id="data-'.$options['name'].'-'.$O->id.'"'.$cols.$rows.inputattrs($options).'>'.$options['value'].'</textarea>';
		} else {
			$result = '<input type="'.$options['type'].'" name="products['.$O->id.'][data]['.$options['name'].']" id="data-'.$options['name'].'-'.$O->id.'"'.inputattrs($options).' />';
		}

		return $result;
	}

	function is_featured ($result, $options, $O) { return ($O->featured == "on"); }

	function name ($result, $options, $O) { return apply_filters('shopp_product_name',$O->name); }

	function on_sale ($result, $options, $O) {
		if (empty($O->prices)) $O->load_data(array('prices','summary'));
		if (empty($O->prices)) return false;
		return str_true($O->sale);
	}

	function out_of_stock ($result, $options, $O) {
		global $Shopp;
		if ($O->outofstock) {
			$label = isset($options['label'])?$options['label']:shopp_setting('outofstock_text');
			$string = '<span class="outofstock">'.$label.'</span>';
			return $string;
		} else return false;
	}

	function price ($result, $options, $O) {
		// if (empty($O->prices)) $O->load_data(array('prices'));
		$defaults = array(
			'taxes' => null,
			'starting' => '',
			'property' => 'price'
		);
		$options = array_merge($defaults,$options);
		extract($options);

		if (!is_null($taxes)) $taxes = value_is_true($taxes);

		if (!str_true($O->sale)) $property = 'price';
		$min = $O->min[$property];
		$mintax = $O->min[$property.'_tax'];

		$max = $O->max[$property];
		$maxtax = $O->max[$property.'_tax'];

		$taxrate = shopp_taxrate($taxes,$mintax,$O);

		if ('saleprice' == $property) $pricetag = $O->min['saleprice'];
		else $pricetag = $O->min['price'];

		if ($min != $max) {
			$taxrate = shopp_taxrate($taxes,true,$O);
			$mintax = $mintax?$min*$taxrate:0;
			$maxtax = $maxtax?$max*$taxrate:0;

			if ($min == $max) return money($min+$mintax);
			else {
				if (!empty($starting)) return "$starting ".money($min+$mintax);
				return money($min+$mintax)." &mdash; ".money($max+$maxtax);
			}
		} else return money($pricetag+($pricetag*$taxrate));
	}

	function saleprice ($result, $options, $O) {
		$options['property'] = 'saleprice';
		return self::price($result, $options, $O);
	}

	function quantity ($result, $options, $O) {
		if ($O->outofstock) return false;

		$inputs = array('text','menu');
		$defaults = array(
			'value' => 1,
			'input' => 'text', // accepts text,menu
			'labelpos' => 'before',
			'label' => '',
			'options' => '1-15,20,25,30,40,50,75,100',
			'size' => 3
		);
		$options = array_merge($defaults,$options);
		$_options = $options;
		extract($options);

		unset($_options['label']); // Interferes with the text input value when passed to inputattrs()
		$labeling = '<label for="quantity-'.$O->id.'">'.$label.'</label>';

		if (!isset($O->_prices_loop)) reset($O->prices);
		$variation = current($O->prices);
		if ('Download' == $variation->type && str_true(shopp_setting('download_quantity'))) return '';
		$_ = array();

		if ("before" == $labelpos) $_[] = $labeling;
		if ("menu" == $input) {
			if (str_true($O->inventory) && isset($O->max['stock']) && $O->max['stock'] == 0) return "";

			if (strpos($options,",") !== false) $options = explode(",",$options);
			else $options = array($options);

			$qtys = array();
			foreach ((array)$options as $v) {
				if (strpos($v,"-") !== false) {
					$v = explode("-",$v);
					if ($v[0] >= $v[1]) $qtys[] = $v[0];
					else for ($i = $v[0]; $i < $v[1]+1; $i++) $qtys[] = $i;
				} else $qtys[] = $v;
			}
			$_[] = '<select name="products['.$O->id.'][quantity]" id="quantity-'.$O->id.'">';
			foreach ($qtys as $qty) {
				$amount = $qty;
				$selection = (isset($O->quantity))?$O->quantity:1;
				if ($variation->type == "Donation" && $variation->donation['var'] == "on") {
					if ($variation->donation['min'] == "on" && $amount < $variation->price) continue;
					$amount = money($amount);
					$selection = $variation->price;
				} else {
					if (str_true($O->inventory) && $amount > $O->max['stock']) continue;
				}
				$selected = ($qty==$selection)?' selected="selected"':'';
				$_[] = '<option'.$selected.' value="'.$qty.'">'.$amount.'</option>';
			}
			$_[] = '</select>';
		} elseif (valid_input($input)) {
			if ($variation->type == "Donation" && $variation->donation['var'] == "on") {
				if ($variation->donation['min']) $_options['value'] = $variation->price;
				$_options['class'] .= " currency";
			}
			$_[] = '<input type="'.$input.'" name="products['.$O->id.'][quantity]" id="quantity-'.$O->id.'"'.inputattrs($_options).' />';
		}

		if ("after" == $labelpos) $_[] = $labeling;
		return join("\n",$_);
	}

	function relevance ($result, $options, $O) { return (string)$O->score; }

	function savings ($result, $options, $O) {
		if (empty($O->prices)) $O->load_data(array('prices'));
		if (!isset($options['taxes'])) $options['taxes'] = null;

		$taxrate = shopp_taxrate($options['taxes']);
		$range = false;

		if (!isset($options['show'])) $options['show'] = '';
		if ($options['show'] == "%" || $options['show'] == "percent") {
			if ($O->options > 1) {
				if (round($O->min['savings']) != round($O->max['savings'])) {
					$range = array($O->min['savings'],$O->max['savings']);
					sort($range);
				}
				if (!$range) return percentage($O->min['savings'],array('precision' => 0)); // No price range
				else return percentage($range[0],array('precision' => 0))." &mdash; ".percentage($range[1],array('precision' => 0));
			} else return percentage($O->max['savings'],array('precision' => 0));
		} else {
			if ($O->options > 1) {
				if (round($O->min['saved']) != round($O->max['saved'])) {
					$range = array($O->min['saved'],$O->max['saved']);
					sort($range);
				}
				if (!$range) return money($O->min['saved']+($O->min['saved']*$taxrate)); // No price range
				else return money($range[0]+($range[0]*$taxrate))." &mdash; ".money($range[1]+($range[1]*$taxrate));
			} else return money($O->max['saved']+($O->max['saved']*$taxrate));
		}
	}

	function slug ($result, $options, $O) { return $O->slug; }

	function spec ($result, $options, $O) {
		$defaults = array(
			'separator' => ': ',
			'delimiter' => ', ',
			'name' => false,
			'index' => false,
			'content' => false,
		);
		$options = array_merge($defaults,$options);
		extract($options);

		$string = '';

		if ($name && isset($O->specs[$name])) {
			$spec = $O->specs[$name];
			if (is_array($spec)) {
				if ($index) {
					foreach ($spec as $id => $item)
						if (($id+1) == $index) $content = $item->value;
				} else {
					$values = array();
					foreach ($spec as $item) $values[] = $item->value;
					$content = join($delimiter,$values);
				}
			} else $content = $spec->value;

			return apply_filters('shopp_product_spec',$content);
		}

		// Spec loop handling
		$spec = current($O->specs);
		if (is_array($spec->value)) $spec->value = join($delimiter,$spec->value);

		if ($name && $content)
			$string = $spec->name.$separator.apply_filters('shopp_product_spec',$spec->value);
		elseif ($name) $string = $spec->name;
		elseif ($content) $string = apply_filters('shopp_product_spec',$spec->value);
		else $string = $spec->name.$separator.apply_filters('shopp_product_spec',$spec->value);
		return $string;
	}

	function specs ($result, $options, $O) {
		if (!isset($O->_specs_loop)) {
			reset($O->specs);
			$O->_specs_loop = true;
		} else next($O->specs);

		if (current($O->specs) !== false) return true;
		else {
			unset($O->_specs_loop);
			return false;
		}
	}

	function stock ($result, $options, $O) { return (int)$O->stock; }

	function summary ($result, $options, $O) { return apply_filters('shopp_product_summary',$O->summary); }

	function tag ($result, $options, $O) {
		$tag = current($O->tags);
		if (isset($options['show'])) {
			if ($options['show'] == "id") return $tag->id;
		}
		return $tag->name;
	}

	function tagged ($result, $options, $O) {
		if (empty($O->tags)) $O->load_data(array('tags'));
		if (isset($options['id'])) $field = "id";
		if (isset($options['name'])) $field = "name";
		foreach ($O->tags as $tag)
			if ($tag->{$field} == $options[$field]) return true;
		return false;
	}

	function tags ($result, $options, $O) {
		if (!isset($O->_tags_loop)) {
			reset($O->tags);
			$O->_tags_loop = true;
		} else next($O->tags);

		if (current($O->tags) !== false) return true;
		else {
			unset($O->_tags_loop);
			return false;
		}
	}

	function taxrate ($result, $options, $O) { return shopp_taxrate(null,true,$O); }

	function type ($result, $options, $O) {
		if (empty($O->prices)) $O->load_data(array('prices'));

		if (1 == count($O->prices))
			return $O->prices[0]->type;

		$types = array();
		foreach ($O->prices as $price)
			if ('N/A' != $price->type) $types[$price->type] = $price->type;

		return join(',',$types);
	}

	function url ($result, $options, $O) { return shoppurl( SHOPP_PRETTYURLS?$O->slug:array(Product::$posttype=>$O->slug) ); }

	function variation ($result, $options, $O) {
		global $Shopp;
		$variation = current($O->prices);

		if (!isset($options['taxes'])) $options['taxes'] = null;
		else $options['taxes'] = value_is_true($options['taxes']);
		$taxrate = shopp_taxrate($options['taxes'],$variation->tax,$O);

		$weightunit = (isset($options['units']) && !value_is_true($options['units']) ) ? false : shopp_setting('weight_unit');

		$string = '';
		if (array_key_exists('id',$options)) $string .= $variation->id;
		if (array_key_exists('label',$options)) $string .= $variation->label;
		if (array_key_exists('type',$options)) $string .= $variation->type;
		if (array_key_exists('sku',$options)) $string .= $variation->sku;
		if (array_key_exists('price',$options)) $string .= money($variation->price+($variation->price*$taxrate));
		if (array_key_exists('saleprice',$options)) {
			if (isset($options['promos']) && !value_is_true($options['promos'])) {
				$string .= money($variation->saleprice+($variation->saleprice*$taxrate));
			} else $string .= money($variation->promoprice+($variation->promoprice*$taxrate));
		}
		if (array_key_exists('stock',$options)) $string .= $variation->stock;
		if (array_key_exists('weight',$options)) $string .= round($variation->weight, 3) . ($weightunit ? " $weightunit" : false);
		if (array_key_exists('shipfee',$options)) $string .= money(floatvalue($variation->shipfee));
		if (array_key_exists('sale',$options)) return ($variation->sale == "on");
		if (array_key_exists('shipping',$options)) return ($variation->shipping == "on");
		if (array_key_exists('tax',$options)) return ($variation->tax == "on");
		if (array_key_exists('inventory',$options)) return ($variation->inventory == "on");
		return $string;
	}

	function variations ($result, $options, $O) {
		global $Shopp;
		$string = "";

		if (!isset($options['mode'])) {
			if (!isset($O->_prices_loop)) {
				reset($O->prices);
				$O->_prices_loop = true;
			} else next($O->prices);
			$price = current($O->prices);

			if ($price && ($price->type == 'N/A' || $price->context != 'variation'))
				next($O->prices);

			if (current($O->prices) !== false) return true;
			else {
				unset($O->_prices_loop);
				return false;
			}
			return true;
		}

		if ($O->outofstock) return false; // Completely out of stock, hide menus
		if (!isset($options['taxes'])) $options['taxes'] = null;

		$defaults = array(
			'defaults' => '',
			'disabled' => 'show',
			'pricetags' => 'show',
			'before_menu' => '',
			'after_menu' => '',
			'label' => 'on',
			'required' => __('You must select the options for this item before you can add it to your shopping cart.','Shopp')
			);
		$options = array_merge($defaults,$options);

		if ($options['mode'] == "single") {
			if (!empty($options['before_menu'])) $string .= $options['before_menu']."\n";
			if (value_is_true($options['label'])) $string .= '<label for="product-options'.$O->id.'">'. __('Options', 'Shopp').': </label> '."\n";

			$string .= '<select name="products['.$O->id.'][price]" id="product-options'.$O->id.'">';
			if (!empty($options['defaults'])) $string .= '<option value="">'.$options['defaults'].'</option>'."\n";

			foreach ($O->prices as $pricetag) {
				if ($pricetag->context != "variation") continue;

				if (!isset($options['taxes']))
					$taxrate = shopp_taxrate(null,$pricetag->tax);
				else $taxrate = shopp_taxrate(value_is_true($options['taxes']),$pricetag->tax);
				$currently = ($pricetag->sale == "on")?$pricetag->promoprice:$pricetag->price;
				$disabled = ($pricetag->inventory == "on" && $pricetag->stock == 0)?' disabled="disabled"':'';

				$price = '  ('.money($currently).')';
				if ($pricetag->type != "N/A")
					$string .= '<option value="'.$pricetag->id.'"'.$disabled.'>'.$pricetag->label.$price.'</option>'."\n";
			}
			$string .= '</select>';
			if (!empty($options['after_menu'])) $string .= $options['after_menu']."\n";

		} else {
			if (!isset($O->options)) return;

			$menuoptions = $O->options;
			if (!empty($O->options['v'])) $menuoptions = $O->options['v'];

			$baseop = shopp_setting('base_operations');
			$precision = $baseop['currency']['format']['precision'];

			if (!isset($options['taxes']))
				$taxrate = shopp_taxrate(null,true,$O);
			else $taxrate = shopp_taxrate(value_is_true($options['taxes']),true,$O);

			$pricekeys = array();
			foreach ($O->pricekey as $key => $pricing) {
				$filter = array('');
				$_ = new StdClass();
				if ($pricing->type != "Donation")
					$_->p = ((isset($pricing->sale)
								&& str_true($pricing->onsale) )?
									(float)$pricing->promoprice:
									(float)$pricing->price);
				$_->i = ($pricing->inventory == "on");
				$_->s = ($pricing->inventory == "on")?$pricing->stock:false;
				$_->tax = ($pricing->tax == "on");
				$_->t = $pricing->type;
				$pricekeys[$key] = $_;
			}

			ob_start();
?><?php if (!empty($options['defaults'])): ?>
sjss.opdef = true;
<?php endif; ?>
<?php if (!empty($options['required'])): ?>
sjss.opreq = "<?php echo $options['required']; ?>";
<?php endif; ?>
if ( ! pricetags ) var pricetags = new Array();
pricetags[<?php echo $O->id; ?>] = <?php echo json_encode($pricekeys); ?>;
new ProductOptionsMenus('select<?php if (!empty($Shopp->Category->slug)) echo ".category-".$Shopp->Category->slug; ?>.product<?php echo $O->id; ?>.options',{<?php if ($options['disabled'] == "hide") echo "disabled:false,"; ?><?php if ($options['pricetags'] == "hide") echo "pricetags:false,"; ?><?php if (!empty($taxrate)) echo "taxrate:$taxrate,"?>prices:pricetags[<?php echo $O->id; ?>]});
<?php
			$script = ob_get_contents();
			ob_end_clean();

			add_storefrontjs($script);

			foreach ($menuoptions as $id => $menu) {
				if (!empty($options['before_menu'])) $string .= $options['before_menu']."\n";
				if (value_is_true($options['label'])) $string .= '<label for="options-'.$menu['id'].'">'.$menu['name'].'</label> '."\n";
				$category_class = isset($Shopp->Category->slug)?'category-'.$Shopp->Category->slug:'';
				$string .= '<select name="products['.$O->id.'][options][]" class="'.$category_class.' product'.$O->id.' options" id="options-'.$menu['id'].'">';
				if (!empty($options['defaults'])) $string .= '<option value="">'.$options['defaults'].'</option>'."\n";
				foreach ($menu['options'] as $key => $option)
					$string .= '<option value="'.$option['id'].'">'.$option['name'].'</option>'."\n";

				$string .= '</select>';
			}
			if (!empty($options['after_menu'])) $string .= $options['after_menu']."\n";
		}

		return $string;
	}

	function weight ($result, $options, $O) {
		global $Shopp;
		if(empty($O->prices)) $O->load_data(array('prices'));
		$defaults = array(
			'unit' => shopp_setting('weight_unit'),
			'min' => $O->min['weight'],
			'max' => $O->max['weight'],
			'units' => true,
			'convert' => false
		);
		$options = array_merge($defaults,$options);
		extract($options);

		if(!isset($O->min['weight'])) return false;

		if ($convert !== false) {
			$min = convert_unit($min,$convert);
			$max = convert_unit($max,$convert);
			if (is_null($units)) $units = true;
			$unit = $convert;
		}

		$range = false;
		if ($min != $max) {
			$range = array($min,$max);
			sort($range);
		}

		$string = ($min == $max)?round($min,3):round($range[0],3)." - ".round($range[1],3);
		$string .= value_is_true($units) ? " $unit" : "";
		return $string;
	}

}

?>