-- MySQL dump 10.11
--
-- Host: localhost    Database: wildflower
-- ------------------------------------------------------
-- Server version	5.0.51a-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `categories` (
  `id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) default NULL,
  `lft` int(11) default NULL,
  `rght` int(11) default NULL,
  `slug` varchar(255) collate utf8_unicode_ci NOT NULL,
  `title` varchar(255) collate utf8_unicode_ci NOT NULL,
  `description` varchar(255) collate utf8_unicode_ci default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `parent_id` (`parent_id`),
  KEY `tree_left` (`lft`),
  KEY `tree_right` (`rght`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,NULL,1,4,'php5','PHP5',''),(2,NULL,7,8,'rails','Rails',''),(4,NULL,5,6,'no-meaning','No meaning','For posts without meaning.'),(14,1,2,3,'personal-develompent','Personal Development','');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_posts`
--

DROP TABLE IF EXISTS `categories_posts`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `categories_posts` (
  `category_id` int(11) NOT NULL,
  `post_id` int(11) NOT NULL,
  KEY `category_id` (`category_id`,`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `categories_posts`
--

LOCK TABLES `categories_posts` WRITE;
/*!40000 ALTER TABLE `categories_posts` DISABLE KEYS */;
INSERT INTO `categories_posts` VALUES (1,2),(1,8),(1,21),(1,24),(2,21),(2,24),(4,2),(4,24),(14,1),(14,22),(14,27);
/*!40000 ALTER TABLE `categories_posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comments`
--

DROP TABLE IF EXISTS `comments`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `comments` (
  `id` int(11) NOT NULL auto_increment,
  `post_id` int(11) NOT NULL,
  `name` varchar(255) collate utf8_unicode_ci NOT NULL,
  `email` char(80) collate utf8_unicode_ci NOT NULL,
  `url` char(80) collate utf8_unicode_ci default NULL,
  `content` text collate utf8_unicode_ci NOT NULL,
  `spam` tinyint(1) NOT NULL default '0',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `post_id` (`post_id`),
  KEY `spam` (`spam`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `comments`
--

LOCK TABLES `comments` WRITE;
/*!40000 ALTER TABLE `comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `messages` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) collate utf8_unicode_ci NOT NULL,
  `email` varchar(100) collate utf8_unicode_ci NOT NULL,
  `phone` varchar(100) collate utf8_unicode_ci NOT NULL,
  `content` text collate utf8_unicode_ci,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `subject` varchar(255) collate utf8_unicode_ci default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Stores all contact form communication';
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `pages` (
  `id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) default NULL,
  `lft` int(11) default NULL,
  `rght` int(11) default NULL,
  `level` int(3) NOT NULL default '0' COMMENT 'Page level in the tree hierarchy',
  `slug` varchar(255) collate utf8_unicode_ci NOT NULL COMMENT 'URL friendly page name',
  `url` varchar(255) collate utf8_unicode_ci NOT NULL COMMENT 'Full URL relative to root of the application',
  `title` varchar(255) collate utf8_unicode_ci NOT NULL,
  `content` text collate utf8_unicode_ci,
  `description_meta_tag` text collate utf8_unicode_ci,
  `keywords_meta_tag` text collate utf8_unicode_ci,
  `draft` tinyint(1) NOT NULL default '0',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `sidebar_content` text collate utf8_unicode_ci,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `parent_id` (`parent_id`),
  KEY `lft` (`lft`),
  KEY `rght` (`rght`),
  KEY `draft` (`draft`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=MyISAM AUTO_INCREMENT=164 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (52,NULL,1,4,0,'home-features','/','Home & Features','<ul id=\"home-feature-list\">\n<li id=\"feature-cake\">Content management system and application platform build on <a href=\"http://www.cakephp.org\">CakePHP</a> framework and <a href=\"http://jquery.com\">jQuery</a> Javascript library.</li>\n<li id=\"feature-standards\">Standards based.</li>\n<li id=\"feature-open-source\">Open source.</li>\n<li>User friendly.</li>\n<li><img src=\"/uploads/unit-tests-not.gif\" alt=\"unit-tests-not.gif\" /></li>\n<li>Requires up-to-date LAMP stacks. PHP 5.2+, MySQL 4.1+, mod_rewrite.</li>\n<li><a href=\"/feature-tour\">More features</a></li>\n</ul>\n<p class=\"download\"><a href=\"http://wildflower.googlecode.com/files/wildflower10a.zip\"><strong>Download now</strong><br /> Wildflower 1.0a, released 29th February 2008</a></p>','Content management system and application platform build on CakePHP framework and jQuery Javascript library.',NULL,0,'2008-02-26 16:09:00','2008-07-24 17:25:57',NULL,NULL),(53,NULL,11,16,0,'feature-tour','/feature-tour','Feature tour','<h3>Ease of use</h3>\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.</p>\n<h3>File manager</h3>\n<p>Upload any file type. You can categorize your uploads using tags.</p>\n<p><img src=\"/wildflower/img/thumb/All_falls_down-1440x900.jpg/120/120/1\" alt=\"\" /><img src=\"/wildflower/img/thumb/Igaer-1400x1050.jpg/120/120/1\" alt=\"\" /><img src=\"/wildflower/img/thumb/All_falls_down-1440x900.jpg/120/120/1\" alt=\"\" /><img src=\"/wildflower/img/thumb/Step_forward_little_tommy-1400x1050.jpg/120/120/1\" alt=\"\" /></p>\n<h3>Revisions</h3>\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.</p>','',NULL,1,'2008-02-26 17:44:00','2008-08-26 17:08:36','',1),(54,NULL,5,6,0,'documentation','/documentation','Documentation','<p><em>This section is slowly being filled up. Please be patient.</em></p>\r\n<p>Since a new release of Wildflower is on the way, with a lot of core changes, <strong>the following</strong> is intended for the code you can <a href=\"http://code.google.com/p/wildflower/source/checkout\">check out from Google Code</a>.</p>\r\n<h3>Who is it for?</h3>\r\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):</p>\r\n<ul>\r\n<li>Code separation. Understand the difference between view and bussiness logic.</li>\r\n<li>RESTful architecture.</li>\r\n<li>Unit testing.</li>\r\n<li>The heart of Wildflower is the CakePHP framework.</li>\r\n</ul>\r\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?</p>\r\n<h3>Requirements</h3>\r\n<ul>\r\n<li>Apache web server with mod_rewrite</li>\r\n<li>PHP 5.2+</li>\r\n<li>MySQL 4.1+</li>\r\n<li>If you want to use the <a href=\"http://code.google.com/p/ruckusing/\">Ruckusing database migrations</a> you need PEAR\'s MDB2 and Log packages<br /></li>\r\n</ul>\r\n<h3>Fresh installation</h3>\r\n<ol>\r\n<li>Extract the archive. Place the <em>wildflower</em> directory inside your web servers documents folder.</li>\r\n<li>Create a new MySQL database (<em>utf8_unicode_ci</em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower/config/sql/wildflower.sql</em>.</li>\r\n<li>Edit the <em>app/config/database.php</em> file with your database connection details.</li>\r\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app</em> directory. When a new release of Wildflower comes, you simply replace the <em>cake</em>, <em>vendors</em> and <em>wildflower</em> directories.</li>\r\n</ol>\r\n<h3>Installing to an existing CakePHP application</h3>\r\n<ol>\r\n<li>Extract the archive and place the <em>wildflower/wildflower</em> directory inside your application root.</li>\r\n<li>Just include the Wildflower <em>bootstrap.php</em> file located at <em>/wildflower/config/bootstrap.php</em> in your <em>/app/config/bootstrap.php</em>.</li>\r\n<li>Load the SQL dump file <em>app/config/sql/wildflower.sql</em>&nbsp;into your database.</li>\r\n<li>Set up some routes. Check the <em>wildflower/config/routes.php</em> file for the default WF routes.<br /></li>\r\n</ol>\r\n<h3>Basic principles</h3>\r\n<p>A modern website usually consist of \"static\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.</p>\r\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>/app</em> directory. By mirroring any view file from the wildflower/views folder inside app/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.</p>\r\n<h3>A real world example of building a site with some custom functionality</h3>\r\n<p>Imagine you want to build a simple site with the following requirements:</p>\r\n<ul>\r\n<li>Content managed \"static\" pages</li>\r\n<li>Contact form</li>\r\n<li>Home page with four boxes with different content and each content managed</li>\r\n</ul>\r\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model/view/controller that will handle the custom functionality.</p>\r\n<h4>Step 1: Create a new database table</h4>\r\n<p>todo.</p>\r\n<h4>Step 2: Create the MVC files</h4>\r\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\"http://www.littlehart.net/atthekeyboard/2008/08/05/dynamic-models-in-cakephp-12/\">dynamic models</a>. So let\'s create our controller. We\'ll create a file in <em>app/controllers/</em> called <em>home_page_boxes_controller.php</em> and put some code into it:</p>\r\n<pre>&lt;?php<br />class HomePageBoxesController extends AppController {<br />&nbsp;&nbsp;&nbsp; <br />&nbsp;&nbsp;&nbsp; function beforeFilter() {<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br />&nbsp;&nbsp;&nbsp; }<br /><br />&nbsp;&nbsp;&nbsp; function admin_index() {<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br />&nbsp;&nbsp;&nbsp; }<br />&nbsp;&nbsp;&nbsp; <br />&nbsp;&nbsp;&nbsp; function admin_update() {<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br />&nbsp;&nbsp;&nbsp; }<br />&nbsp;&nbsp;&nbsp; <br />&nbsp;&nbsp;&nbsp; function index() {<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br />&nbsp;&nbsp;&nbsp; }<br />&nbsp;&nbsp;&nbsp; <br />}<br /></pre>\r\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes</em> under <em>app/views/</em> . Under this folder add <em>admin_index.ctp</em> and <em>index.ctp</em> files.</p>\r\n<p><em>admin_index.ctp</em> could look like this:</p>\r\n<pre>&lt;h2&gt;Homepage Boxes&lt;/h2&gt;<br /><br />&lt;?php<br />    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br />    <br />    for ($i = 0; $i &lt; 4; $i++) {<br />        echo <br />        $form-&gt;input(\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\", <br />            array(\'type\' =&gt; \'textbox\', <br />                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br />                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br /&gt;\', \'class\' =&gt; \'box-fck\')),<br />        $form-&gt;submit(\'Save\');<br />    }<br />    <br />    echo $form-&gt;end();<br />?&gt;<br /></pre>\r\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the <em>index.ctp</em> file:</p>\r\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br /><br />&lt;div class=\"home-box\"&gt;<br />    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br />&lt;/div&gt;<br /><br />&lt;?php } ?&gt;<br /></pre>\r\n<p>This will display the four boxes and their content.</p>\r\n<p>Now <strong>copy</strong> the <em>/wildflower/views/layout/admin_default.ctp</em> to <em>/app/views/layouts/</em> . There you can modify the file and add a link to our new home page boxes admin screen to the admin main menu. I\'ll leave this step to you. Remember: <strong>Every Wildflower view file that you mirror inside your app/views will be used instead of the original</strong>.</p>\r\n<h4>Step 3: Routes</h4>\r\n<p>Finally we need to let Cake know that we want to display the HomePageBoxesController::index() action when browsing to <em>your-site.com </em>root. Modify the first two routes in <em>app/config/routes.php</em> like this:</p>\r\n<pre>Router::connect(\'/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br />Router::connect(\'/app/webroot/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br /></pre>\r\n<p>Maybe you\'re wondering about the second route. On some server configurations Cake incorrectly detects the site root (/) as <em>/app/webroot</em> . This fixes it. If you don\'t experience this problem (the home page works fine without the second route) you can remove the route.</p>\r\n<p>As you can see, Wildflower enables you to use all the CakePHP power together with the out of the box functionality.</p>','',NULL,0,'2008-02-27 16:20:00','2008-09-09 21:01:36','',1),(64,53,12,15,1,'features-and-pages','/feature-tour/features-and-pages','Code, code, code','<p class=\"cake-debug\">Hello world <a href=\"#title\">how</a> are we today.</p>\r\n<h2 class=\"cake-debug\">Heading &lt;h2&gt;</h2>\r\n<p style=\"padding-left: 30px;\">This option enables you to specify a custom CSS file that extends the theme content <span style=\"background-color: #ff9900;\">CSS</span>. This <span style=\"color: #ff6600;\">CSS</span> file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.</p>\r\n<p class=\"cake-debug\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.</p>\r\n<p class=\"cake-debug\"><img src=\"/wildflower/img/thumb/vetton_ru_501.jpg/120/120/1\" alt=\"\" /><img src=\"/wildflower/img/thumb/All_falls_down-1440x900.jpg/120/120/1\" alt=\"\" /><img src=\"/wildflower/img/thumb/Step_forward_little_tommy-1400x1050.jpg/120/120/1\" alt=\"\" /><br /><span style=\"text-decoration: line-through;\">strike me</span></p>','',NULL,0,'2008-07-01 16:40:00','2008-08-11 12:11:19','',1),(79,64,13,14,2,'a-page-about-nothing','/feature-tour/features-and-pages/a-page-about-nothing','A page about nothing','<p>Hello hello hello.</p>\r\n<p>This is a brand new site. Arial.</p>\r\n<p><img src=\"/uploads/Step_forward_little_tommy-1400x1050.jpg\" alt=\"\" />Yop...</p>\r\n<p><img src=\"/wildflower/img/thumb/All_falls_down-1440x900.jpg/120/120/1\" alt=\"\" /></p>\r\n<p>&nbsp;</p>','',NULL,0,'2008-07-02 20:29:00','2008-08-28 13:07:58','',1),(83,NULL,7,8,0,'bugs','/bugs','Bugs','<ul>\n<li>Post can be viewed even if draft</li>\n<li>Add new category parent select box shows parents that should not be available</li>\n<li>When trying to edit a non existent page an SQL error is shown</li>\n<li>Public search should not search in drafts</li>\n<li>Upload::create does not fill short_name</li>\n<li>Image browser CSS rf &amp; IE7 fixing</li>\n<li>Image browser can be open multiple times and get\'s fcked up</li>\n<li>I deleted a comment an another one got deleted</li>\n<li>Preview does not render home template</li>\n<li>Deleting a comment a clicking cancel deletes the comment!</li>\n</ul>\n<p>Opera bugs:</p>\n<ul>\n<li>live search cancel...</li>\n</ul>','',NULL,0,'2008-07-07 08:43:00','2008-09-02 13:12:55','',1),(162,NULL,19,20,0,'page-abc','/page-abc','Page ABC','<p>page abbbbcccc</p>','',NULL,0,'2008-08-17 18:25:00','2008-08-17 18:25:46','',1),(158,NULL,17,18,0,'wf-is-the-best','/wf-is-the-best','Wf is the best','<p>1234 54534 asdas</p>','',NULL,0,'2008-08-08 22:26:00','2008-08-26 19:31:31','',1),(116,NULL,9,10,0,'todo-enhancements','/todo-enhancements','TODO, Enhancements','<ul>\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br /></li>\n<li>Google sitemaps generation</li>\n<li>SWFupload</li>\n<li>Password strength check from Wordpress</li>\n<li>Shift click on list to select more items</li>\n<li>Pages list drag and drop</li>\n<li>JLM compression and caching</li>\n<li>File manager folders</li>\n</ul>\n<p><img src=\"/wildflower/img/thumb/The_night_is_coming-1400x1050.jpg/120/120/1\" alt=\"\" /></p>','',NULL,0,'2008-07-15 20:44:00','2008-08-17 06:32:32','<p>helo</p>',1),(157,52,2,3,1,'test-page','/home-features/test-page','test page','<p>I want candy!</p>','',NULL,0,'2008-08-08 18:21:00','2008-08-12 16:44:08','',1),(163,NULL,21,22,0,'my-new-page','/my-new-page','my new page',NULL,NULL,NULL,1,'2008-09-09 21:06:38','2008-09-09 21:06:38',NULL,NULL);
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `posts` (
  `id` int(11) NOT NULL auto_increment,
  `slug` varchar(255) collate utf8_unicode_ci NOT NULL,
  `title` varchar(255) collate utf8_unicode_ci NOT NULL,
  `content` text collate utf8_unicode_ci,
  `user_id` int(11) NOT NULL COMMENT 'ID of the author of the post.',
  `description_meta_tag` text collate utf8_unicode_ci,
  `keywords_meta_tag` text collate utf8_unicode_ci,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `draft` int(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `slug` (`slug`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'a-shiny-new-post','There are not many posts out there','<div id=\"lipsum\">\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In imperdiet odio in augue. Sed pharetra. Nullam faucibus odio. Nam rhoncus tristique augue. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer congue dapibus metus. Phasellus sed elit sodales orci iaculis tincidunt. Duis hendrerit, nulla eu hendrerit fermentum, diam sapien commodo enim, sed rutrum purus sapien sed pede. Phasellus vitae quam. Morbi aliquam, leo vitae consectetuer consectetuer, ligula diam volutpat eros, imperdiet egestas nulla tortor ac dui. Etiam feugiat, dui nec pharetra pharetra, erat augue vulputate sapien, ut tristique lacus felis at eros. Pellentesque eu erat. Nullam aliquet mollis dolor. Ut est orci, tempus pellentesque, semper sit amet, scelerisque in, quam. Aliquam consequat, orci nec ullamcorper condimentum, nibh ligula dictum nulla, eget pulvinar velit lacus sit amet nulla. Etiam semper faucibus mi. Aenean nunc sapien, venenatis vitae, dapibus sit amet, auctor non, lacus. Phasellus porttitor ante sit amet turpis. Vestibulum nec erat. Maecenas eros.</p>\n<p>Nullam quis nulla non sapien interdum varius. Cras hendrerit elementum leo. Fusce tincidunt, justo eu eleifend elementum, ante arcu blandit dolor, quis ullamcorper dui tellus sit amet quam. Vestibulum vulputate. Morbi mi odio, consectetuer ut, vulputate vitae, tristique ut, ipsum. Donec ipsum tortor, pulvinar a, pulvinar eget, commodo non, odio. Nullam dolor. Aliquam erat volutpat. Phasellus libero. Vivamus luctus lobortis libero. Ut ut elit. Sed elementum quam nec arcu. Nam id tellus non odio fermentum convallis. Nam a lacus.</p>\n<p>Phasellus ante arcu, gravida a, lobortis sit amet, volutpat non, velit. Nulla consectetuer quam gravida nulla. Integer eu purus. Morbi sit amet nunc. Mauris vehicula lacus ac lectus. Proin tortor nisl, faucibus non, molestie nec, tincidunt non, justo. Suspendisse massa lectus, hendrerit aliquam, elementum et, iaculis non, nunc. Etiam non dui. Morbi gravida massa sollicitudin ipsum. Suspendisse magna ante, facilisis ac, sagittis et, placerat et, diam. Fusce facilisis, nulla ac accumsan facilisis, mi nisi tristique quam, malesuada pulvinar neque leo ut augue. Mauris dui.</p>\n<p>Etiam nec risus at leo ullamcorper lobortis. In rhoncus massa ac velit. Nullam mollis consequat ligula. Integer iaculis, enim sed cursus hendrerit, neque dolor hendrerit erat, dignissim egestas quam quam vel quam. Etiam tellus libero, molestie non, mattis in, venenatis sed, dui. Proin non nisl ut massa ullamcorper interdum. Aliquam erat volutpat. Sed gravida. Quisque quis magna. Quisque non metus. Nullam euismod suscipit elit. Vivamus quis risus. Phasellus ut lectus. Nunc velit sem, viverra sed, convallis eu, convallis a, nisl. Maecenas bibendum orci in enim. Sed orci. Nullam adipiscing pellentesque purus. Sed risus orci, consequat nec, ornare sed, condimentum semper, mi. Fusce hendrerit, justo non volutpat pretium, neque mauris placerat est, id pretium mauris libero id eros.</p>\n<p>Sed risus mi, vestibulum ac, tincidunt at, condimentum id, tortor. Donec non mauris sed leo auctor auctor. Nullam facilisis. Quisque eu ipsum. Donec quis sem. Morbi rutrum magna in justo. Vestibulum eu orci. Praesent placerat, ipsum eget bibendum vulputate, velit dolor ultrices metus, tempus congue est lorem a eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nam consectetuer erat et urna.</p>\n</div>',1,'bla bla bla','','2008-09-11 14:48:00','2008-08-17 18:12:03',0),(2,'another-new-post','Another new post','<p>And now we do this... 13456</p>',1,'',NULL,'2006-09-11 14:48:00','2008-08-26 19:27:45',0),(21,'today-i-ve-build-a-lot','Today I\'ve build a lot','<p>It\'s<img src=\"/wildflower/img/thumb/Little_World-1400x1050.jpg/120/120/1\" alt=\"\" /> true.<img src=\"/wildflower/img/thumb/Fantasia-1600x1200.jpg/120/120/1\" alt=\"\" /></p>',1,'',NULL,'2007-08-11 18:01:00','2008-08-26 17:19:55',1),(8,'use-base','use Base','<p>1234</p>\n<p><img src=\"/wildflower/img/thumb/Fantasia-1600x1200.jpg/120/120/1\" alt=\"\" /></p>',1,'',NULL,'2007-07-12 11:05:00','2008-08-26 19:23:55',1),(22,'lol-post','lol post','',1,'',NULL,'2006-10-17 17:59:00','2008-08-26 19:22:06',0),(23,'loool-post','loool post','<p>dasdas</p>',1,'',NULL,'2008-08-17 17:59:00','2008-08-17 18:41:40',0),(24,'hmm','hmm','<p>1234<img src=\"/wildflower/img/thumb/The_night_is_coming-1400x1050.jpg/120/120/1\" alt=\"\" /></p>',1,'',NULL,'2008-08-17 17:59:00','2008-08-20 19:08:02',0),(25,'test','test','<p><img src=\"/wildflower/img/thumb/vetton_ru_501.jpg/120/120/1\" alt=\"\" /><img src=\"/wildflower/img/thumb/Good_Vibrations-1440x900.jpg/120/120/1\" alt=\"\" /></p>\n<p>Abcdedfgh.</p>',1,'',NULL,'2008-08-17 18:02:00','2008-09-13 13:25:44',0),(26,'lala-lala-la','lala lala la',NULL,0,NULL,NULL,'2008-08-17 18:53:46','2008-08-17 18:53:46',0),(27,'my-new-post','my new post','',1,'',NULL,'2008-09-09 21:04:00','2008-09-13 13:29:02',0),(28,'my-new-post-1','my new post',NULL,0,NULL,NULL,'2008-09-09 21:06:33','2008-09-09 21:06:33',1),(29,'safari','safari',NULL,0,NULL,NULL,'2008-09-09 21:06:49','2008-09-09 21:06:49',1);
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `revisions` (
  `id` int(11) NOT NULL auto_increment,
  `type` enum('page','post') collate utf8_unicode_ci NOT NULL,
  `node_id` int(11) NOT NULL,
  `content` text collate utf8_unicode_ci NOT NULL,
  `revision_number` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `type` (`type`,`node_id`)
) ENGINE=MyISAM AUTO_INCREMENT=296 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
INSERT INTO `revisions` VALUES (1,'page',106,'{\"Page\":{\"title\":\"to be deleted\"}}',1,1,'2008-07-11 14:50:43'),(2,'post',4,'{\"Post\":{\"title\":\"Gonna tame the post edit\",\"content\":\"<p>Ola lala.<\\/p>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-11 17:07:09'),(3,'post',4,'{\"Post\":{\"title\":\"Gonna tame the post edit\",\"content\":\"<p>Ola lala. 123<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-11 17:08:54'),(4,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>There is a bug with revisions. When the content is empty it\'s get populated with data.<\\/li>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-11 17:12:56'),(5,'post',2,'{\"Post\":{\"title\":\"Another new post\",\"content\":\"<div id=\\\"lipsum\\\">\\r\\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In imperdiet odio in augue. Sed pharetra. Nullam faucibus odio. Nam rhoncus tristique augue. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer congue dapibus metus. Phasellus sed elit sodales orci iaculis tincidunt. Duis hendrerit, nulla eu hendrerit fermentum, diam sapien commodo enim, sed rutrum purus sapien sed pede. Phasellus vitae quam. Morbi aliquam, leo vitae consectetuer consectetuer, ligula diam volutpat eros, imperdiet egestas nulla tortor ac dui. Etiam feugiat, dui nec pharetra pharetra, erat augue vulputate sapien, ut tristique lacus felis at eros. Pellentesque eu erat. Nullam aliquet mollis dolor. Ut est orci, tempus pellentesque, semper sit amet, scelerisque in, quam. Aliquam consequat, orci nec ullamcorper condimentum, nibh ligula dictum nulla, eget pulvinar velit lacus sit amet nulla. Etiam semper faucibus mi. Aenean nunc sapien, venenatis vitae, dapibus sit amet, auctor non, lacus. Phasellus porttitor ante sit amet turpis. Vestibulum nec erat. Maecenas eros.<\\/p>\\r\\n<p>Nullam quis nulla non sapien interdum varius. Cras hendrerit elementum leo. Fusce tincidunt, justo eu eleifend elementum, ante arcu blandit dolor, quis ullamcorper dui tellus sit amet quam. Vestibulum vulputate. Morbi mi odio, consectetuer ut, vulputate vitae, tristique ut, ipsum. Donec ipsum tortor, pulvinar a, pulvinar eget, commodo non, odio. Nullam dolor. Aliquam erat volutpat. Phasellus libero. Vivamus luctus lobortis libero. Ut ut elit. Sed elementum quam nec arcu. Nam id tellus non odio fermentum convallis. Nam a lacus.<\\/p>\\r\\n<p>Phasellus ante arcu, gravida a, lobortis sit amet, volutpat non, velit. Nulla consectetuer quam gravida nulla. Integer eu purus. Morbi sit amet nunc. Mauris vehicula lacus ac lectus. Proin tortor nisl, faucibus non, molestie nec, tincidunt non, justo. Suspendisse massa lectus, hendrerit aliquam, elementum et, iaculis non, nunc. Etiam non dui. Morbi gravida massa sollicitudin ipsum. Suspendisse magna ante, facilisis ac, sagittis et, placerat et, diam. Fusce facilisis, nulla ac accumsan facilisis, mi nisi tristique quam, malesuada pulvinar neque leo ut augue. Mauris dui.<\\/p>\\r\\n<p>Etiam nec risus at leo ullamcorper lobortis. In rhoncus massa ac velit. Nullam mollis consequat ligula. Integer iaculis, enim sed cursus hendrerit, neque dolor hendrerit erat, dignissim egestas quam quam vel quam. Etiam tellus libero, molestie non, mattis in, venenatis sed, dui. Proin non nisl ut massa ullamcorper interdum. Aliquam erat volutpat. Sed gravida. Quisque quis magna. Quisque non metus. Nullam euismod suscipit elit. Vivamus quis risus. Phasellus ut lectus. Nunc velit sem, viverra sed, convallis eu, convallis a, nisl. Maecenas bibendum orci in enim. Sed orci. Nullam adipiscing pellentesque purus. Sed risus orci, consequat nec, ornare sed, condimentum semper, mi. Fusce hendrerit, justo non volutpat pretium, neque mauris placerat est, id pretium mauris libero id eros.<\\/p>\\r\\n<p>Sed risus mi, vestibulum ac, tincidunt at, condimentum id, tortor. Donec non mauris sed leo auctor auctor. Nullam facilisis. Quisque eu ipsum. Donec quis sem. Morbi rutrum magna in justo. Vestibulum eu orci. Praesent placerat, ipsum eget bibendum vulputate, velit dolor ultrices metus, tempus congue est lorem a eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nam consectetuer erat et urna.<\\/p>\\r\\n<\\/div>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-11 17:29:23'),(6,'post',2,'{\"Post\":{\"title\":\"Another new post\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-11 17:32:35'),(7,'post',2,'{\"Post\":{\"title\":\"Another new post\",\"content\":\"<p>And now we do this...<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-11 17:33:34'),(8,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>There is a bug with revisions. When the content is empty it\'s get populated with data.<\\/li>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-11 17:58:04'),(9,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>There is a bug with revisions. When the content is empty it\'s get populated with data.<\\/li>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-11 17:58:33'),(10,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>There is a bug with revisions. When the content is empty it\'s get populated with data.<\\/li>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing and revision and the current rev should be marked<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',4,1,'2008-07-11 17:58:39'),(11,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>There is a bug with revisions. When the content is empty it\'s get populated with data.<\\/li>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',5,1,'2008-07-11 17:58:44'),(12,'post',5,'{\"Post\":{\"title\":\"A new post\"}}',1,1,'2008-07-11 17:59:05'),(13,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>There is a bug with revisions. When the content is empty it\'s get populated with data.<\\/li>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',6,1,'2008-07-11 20:14:43'),(14,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',7,1,'2008-07-11 21:30:21'),(15,'post',6,'{\"Post\":{\"title\":\"dsda\"}}',1,1,'2008-07-11 21:30:25'),(16,'page',107,'{\"Page\":{\"title\":\"sad\"}}',1,1,'2008-07-11 21:30:40'),(17,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',8,1,'2008-07-11 21:32:50'),(18,'post',7,'{\"Post\":{\"title\":\"A new posting from IE7\"}}',1,1,'2008-07-12 11:05:16'),(19,'post',8,'{\"Post\":{\"title\":\"use Base\"}}',1,1,'2008-07-12 11:05:58'),(20,'post',9,'{\"Post\":{\"title\":\"use base 2\"}}',1,1,'2008-07-12 11:06:19'),(21,'page',104,'{\"Page\":{\"title\":\"new page from IE7\",\"content\":\"\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-12 13:07:18'),(22,'page',103,'{\"Page\":{\"title\":\"draft page\",\"content\":\"\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-12 13:07:27'),(23,'page',64,'{\"Page\":{\"title\":\"Features and pages 2\",\"content\":\"<p><b>asdadas<\\/b><\\/p>\\r\\n<p>Collapased toolbar is cool.<\\/p>\\r\\n<pre class=\\\"cake-debug\\\">\\r\\nArray\\r\\n(\\r\\n    [PageTest] =&gt; Array\\r\\n        (\\r\\n            [id] =&gt; 2\\r\\n            [parent_id] =&gt; 3\\r\\n            [lft] =&gt; 4\\r\\n            [rght] =&gt; 5\\r\\n            [level] =&gt; 0\\r\\n            [slug] =&gt; simple\\r\\n            [url] =&gt; \\/article-1\\/simple\\r\\n            [title] =&gt; Simple\\r\\n            [content] =&gt; Lorem ipsum dolor sit amer. 123. \\u010d\\u013e\\u017e+&aacute;\\u013e&scaron;&yacute;&iacute;.11_?\\r\\n            [description_meta_tag] =&gt; Some description tag\\r\\n            [keywords_meta_tag] =&gt; \\r\\n            [draft] =&gt; 0\\r\\n            [created] =&gt; 2007-03-18 10:39:23\\r\\n            [updated] =&gt; 2008-07-06 13:51:14\\r\\n        )\\r\\n\\r\\n)\\r\\n<\\/pre>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-12 13:24:18'),(24,'page',64,'{\"Page\":{\"title\":\"Features and pages\",\"content\":\"<p><b>asdadas<\\/b><\\/p>\\r\\n<p>Collapased toolbar is cool.<\\/p>\\r\\n<pre class=\\\"cake-debug\\\">\\r\\nArray\\r\\n(\\r\\n    [PageTest] =&gt; Array\\r\\n        (\\r\\n            [id] =&gt; 2\\r\\n            [parent_id] =&gt; 3\\r\\n            [lft] =&gt; 4\\r\\n            [rght] =&gt; 5\\r\\n            [level] =&gt; 0\\r\\n            [slug] =&gt; simple\\r\\n            [url] =&gt; \\/article-1\\/simple\\r\\n            [title] =&gt; Simple\\r\\n            [content] =&gt; Lorem ipsum dolor sit amer. 123. \\u010d\\u013e\\u017e+&aacute;\\u013e&scaron;&yacute;&iacute;.11_?\\r\\n            [description_meta_tag] =&gt; Some description tag\\r\\n            [keywords_meta_tag] =&gt; \\r\\n            [draft] =&gt; 0\\r\\n            [created] =&gt; 2007-03-18 10:39:23\\r\\n            [updated] =&gt; 2008-07-06 13:51:14\\r\\n        )\\r\\n\\r\\n)\\r\\n<\\/pre>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-12 13:24:27'),(25,'page',108,'{\"Page\":{\"title\":\"delete me\"}}',1,1,'2008-07-12 13:43:32'),(26,'page',109,'{\"Page\":{\"title\":\"delete me too\"}}',1,1,'2008-07-12 13:43:37'),(27,'page',110,'{\"Page\":{\"title\":\"delete me too\"}}',1,1,'2008-07-12 13:43:44'),(28,'page',111,'{\"Page\":{\"title\":\"delete me too\"}}',1,1,'2008-07-12 13:44:38'),(29,'page',112,'{\"Page\":{\"title\":\"delete me too\"}}',1,1,'2008-07-12 13:44:42'),(30,'page',113,'{\"Page\":{\"title\":\"delete me too 323\"}}',1,1,'2008-07-12 13:44:45'),(31,'page',114,'{\"Page\":{\"title\":\"asda\"}}',1,1,'2008-07-12 13:45:41'),(32,'page',114,'{\"Page\":{\"title\":\"asda\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-12 13:45:45'),(33,'post',8,'{\"Post\":{\"title\":\"use Base\",\"content\":\"<p>1234<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-12 13:50:45'),(34,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n    <li>Revisions list missing .list-item<\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',9,1,'2008-07-12 20:48:17'),(35,'post',1,'{\"Post\":{\"title\":\"A shiny new post\",\"content\":\"<div id=\\\"lipsum\\\">\\r\\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In imperdiet odio in augue. Sed pharetra. Nullam faucibus odio. Nam rhoncus tristique augue. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer congue dapibus metus. Phasellus sed elit sodales orci iaculis tincidunt. Duis hendrerit, nulla eu hendrerit fermentum, diam sapien commodo enim, sed rutrum purus sapien sed pede. Phasellus vitae quam. Morbi aliquam, leo vitae consectetuer consectetuer, ligula diam volutpat eros, imperdiet egestas nulla tortor ac dui. Etiam feugiat, dui nec pharetra pharetra, erat augue vulputate sapien, ut tristique lacus felis at eros. Pellentesque eu erat. Nullam aliquet mollis dolor. Ut est orci, tempus pellentesque, semper sit amet, scelerisque in, quam. Aliquam consequat, orci nec ullamcorper condimentum, nibh ligula dictum nulla, eget pulvinar velit lacus sit amet nulla. Etiam semper faucibus mi. Aenean nunc sapien, venenatis vitae, dapibus sit amet, auctor non, lacus. Phasellus porttitor ante sit amet turpis. Vestibulum nec erat. Maecenas eros.<\\/p>\\r\\n<p>Nullam quis nulla non sapien interdum varius. Cras hendrerit elementum leo. Fusce tincidunt, justo eu eleifend elementum, ante arcu blandit dolor, quis ullamcorper dui tellus sit amet quam. Vestibulum vulputate. Morbi mi odio, consectetuer ut, vulputate vitae, tristique ut, ipsum. Donec ipsum tortor, pulvinar a, pulvinar eget, commodo non, odio. Nullam dolor. Aliquam erat volutpat. Phasellus libero. Vivamus luctus lobortis libero. Ut ut elit. Sed elementum quam nec arcu. Nam id tellus non odio fermentum convallis. Nam a lacus.<\\/p>\\r\\n<p>Phasellus ante arcu, gravida a, lobortis sit amet, volutpat non, velit. Nulla consectetuer quam gravida nulla. Integer eu purus. Morbi sit amet nunc. Mauris vehicula lacus ac lectus. Proin tortor nisl, faucibus non, molestie nec, tincidunt non, justo. Suspendisse massa lectus, hendrerit aliquam, elementum et, iaculis non, nunc. Etiam non dui. Morbi gravida massa sollicitudin ipsum. Suspendisse magna ante, facilisis ac, sagittis et, placerat et, diam. Fusce facilisis, nulla ac accumsan facilisis, mi nisi tristique quam, malesuada pulvinar neque leo ut augue. Mauris dui.<\\/p>\\r\\n<p>Etiam nec risus at leo ullamcorper lobortis. In rhoncus massa ac velit. Nullam mollis consequat ligula. Integer iaculis, enim sed cursus hendrerit, neque dolor hendrerit erat, dignissim egestas quam quam vel quam. Etiam tellus libero, molestie non, mattis in, venenatis sed, dui. Proin non nisl ut massa ullamcorper interdum. Aliquam erat volutpat. Sed gravida. Quisque quis magna. Quisque non metus. Nullam euismod suscipit elit. Vivamus quis risus. Phasellus ut lectus. Nunc velit sem, viverra sed, convallis eu, convallis a, nisl. Maecenas bibendum orci in enim. Sed orci. Nullam adipiscing pellentesque purus. Sed risus orci, consequat nec, ornare sed, condimentum semper, mi. Fusce hendrerit, justo non volutpat pretium, neque mauris placerat est, id pretium mauris libero id eros.<\\/p>\\r\\n<p>Sed risus mi, vestibulum ac, tincidunt at, condimentum id, tortor. Donec non mauris sed leo auctor auctor. Nullam facilisis. Quisque eu ipsum. Donec quis sem. Morbi rutrum magna in justo. Vestibulum eu orci. Praesent placerat, ipsum eget bibendum vulputate, velit dolor ultrices metus, tempus congue est lorem a eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nam consectetuer erat et urna.<\\/p>\\r\\n<\\/div>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-12 21:01:56'),(36,'post',10,'{\"Post\":{\"title\":\"delete me\"}}',1,1,'2008-07-12 21:36:33'),(37,'post',5,'{\"Post\":{\"title\":\"A new post\",\"content\":\"<p>Ola ola<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-13 10:55:45'),(38,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n    <li>Revisions list missing .list-item<\\/li>\\r\\n    <li>Dashboard should show only approved comments<\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',10,1,'2008-07-13 11:48:06'),(39,'post',11,'{\"Post\":{\"title\":\"Robo\"}}',1,1,'2008-07-13 20:24:49'),(40,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Search results can\'t be selected and manipulated.<\\/li>\\r\\n    <li>Page list tree branch delete - go back to a nested list.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n    <li>Revisions list missing .list-item<\\/li>\\r\\n    <li>Dashboard should show only approved comments<\\/li>\\r\\n    <li>Public search should not search in drafts<\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',11,1,'2008-07-14 08:15:38'),(41,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>New pages without body should be created as drafts.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n    <li>Revisions list missing .list-item<\\/li>\\r\\n    <li>Public search should not search in drafts<\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',12,1,'2008-07-14 08:17:48'),(42,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n    <li>Revisions list missing .list-item<\\/li>\\r\\n    <li>Public search should not search in drafts<\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',13,1,'2008-07-14 08:17:57'),(43,'post',12,'{\"Post\":{\"title\":\"Delete me #1\"}}',1,1,'2008-07-14 08:18:07'),(44,'post',13,'{\"Post\":{\"title\":\"Delete me too #2\"}}',1,1,'2008-07-14 08:18:14'),(45,'page',115,'{\"Page\":{\"title\":\"111\"}}',1,1,'2008-07-14 08:18:46'),(46,'post',14,'{\"Post\":{\"title\":\"post\"}}',1,1,'2008-07-14 08:18:57'),(47,'post',15,'{\"Post\":{\"title\":\"123\"}}',1,1,'2008-07-14 08:21:10'),(48,'post',16,'{\"Post\":{\"title\":\"34\"}}',1,1,'2008-07-14 08:21:13'),(49,'post',16,'{\"Post\":{\"title\":\"34 delete\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-14 08:21:27'),(50,'post',15,'{\"Post\":{\"title\":\"123 delete\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-14 08:21:36'),(51,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n    <li>Revisions list missing .list-item<\\/li>\\r\\n    <li>Public search should not search in drafts<\\/li>\\r\\n    <li>Uploading and existing filename should rename<\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',14,1,'2008-07-14 14:38:43'),(52,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n    <li>Revisions list missing .list-item<\\/li>\\r\\n    <li>Public search should not search in drafts<\\/li>\\r\\n    <li>Upload edit<\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',15,1,'2008-07-15 09:59:33'),(53,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n    <li>Revisions list missing .list-item<\\/li>\\r\\n    <li>Public search should not search in drafts<\\/li>\\r\\n    <li>Upload edit<\\/li>\\r\\n    <li>Revisions save even if the content is identical to prev.<\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',16,1,'2008-07-15 20:25:03'),(54,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\"}}',1,1,'2008-07-15 20:44:28'),(55,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<p>Try replacing FCK with TinyMCE.<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-15 20:45:03'),(56,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\r\\n    <li>Revision when a page is created is not needed since it has no body.<\\/li>\\r\\n    <li>Highlight styles from FCKconfig are missing. Error shows when using the <b>Find<\\/b> feature.<\\/li>\\r\\n    <li>Remove Lucida Sans as second font for FCKeditor.<\\/li>\\r\\n    <li>When Revisions is empty does not slideUp\\/Down.<\\/li>\\r\\n    <li>Post can be viewed even if draft<\\/li>\\r\\n    <li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\r\\n    <li>Add new category parent select box shows parents that should not be available<\\/li>\\r\\n    <li>When trying to edit a non existent page an SQL error is shown<\\/li>\\r\\n    <li>Revisions list missing .list-item<\\/li>\\r\\n    <li>Public search should not search in drafts<\\/li>\\r\\n    <li>Upload edit<\\/li>\\r\\n    <li>Revisions save even if the content is identical to prev.<\\/li>\\r\\n    <li><b>When I deleted all WF sites at once some were not deleted!!!<\\/b><\\/li>\\r\\n<\\/ul>\\r\\n<p>Opera bugs:<\\/p>\\r\\n<ul>\\r\\n    <li>live search cancel<\\/li>\\r\\n    <li>FCKeditor height<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',17,1,'2008-07-16 10:44:08'),(57,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\r\\n    <li>Try replacing FCK with TinyMCE.<\\/li>\\r\\n    <li>Add keyboard shortcuts<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-18 13:35:40'),(58,'page',117,'{\"Page\":{\"title\":\"Stuff that matters\"}}',1,1,'2008-07-19 11:11:44'),(59,'page',117,'{\"Page\":{\"title\":\"Stuff that matters\",\"content\":\"<p>Hello worlds.<\\/p>\\r\\n<div class=\\\"col-7\\\">\\r\\n<p class=\\\"intro\\\">The latest stable release of WordPress (Version 2.6) is available in two formats from the links to your right. If you have no idea what to do with this download, we recommend signing up with one of our <a href=\\\"http:\\/\\/wordpress.org\\/hosting\\/\\\">web hosting partners<\\/a> that offers a one click install of WordPress or <a href=\\\"http:\\/\\/wordpress.com\\/\\\">getting a free account on WordPress.com<\\/a>.<\\/p>\\r\\n<h3>What&rsquo;s Next?<\\/h3>\\r\\n<p>With our famous 5-minute installation, setting up WordPress for the first time is simple. We&rsquo;ve created a <a href=\\\"http:\\/\\/codex.wordpress.org\\/Installing_WordPress\\\">handy guide<\\/a> to see you through the installation process. If you\'re upgrading your existing installation, we\'ve got a <a href=\\\"http:\\/\\/codex.wordpress.org\\/Upgrading_WordPress\\\">guide for that<\\/a>, too. And should you run into any trouble along the way, our <a href=\\\"http:\\/\\/wordpress.org\\/support\\/\\\">support forums<\\/a> are a great resource, where seasoned WordPress experts volunteer their time to help you get the most out of your&nbsp;blog.<\\/p>\\r\\n<\\/div>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 11:12:20'),(60,'page',118,'{\"Page\":{\"title\":\"Delete me\"}}',1,1,'2008-07-19 11:27:39'),(61,'page',118,'{\"Page\":{\"title\":\"Delete me\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 11:27:54'),(62,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n    <li>Apache web server with mod_rewrite<\\/li>\\r\\n    <li>PHP 5.2+<\\/li>\\r\\n    <li>MySQL 4.1+<\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>\\r\\n    <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>\\r\\n    <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>\\r\\n    <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application ROOT.<\\/li>\\r\\n    <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>\\r\\n    <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>&nbsp;<\\/p>\\r\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-19 11:41:00'),(63,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n    <li>Apache web server with mod_rewrite<\\/li>\\r\\n    <li>PHP 5.2+<\\/li>\\r\\n    <li>MySQL 4.1+<\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>\\r\\n    <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>\\r\\n    <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>\\r\\n    <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application root.<\\/li>\\r\\n    <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>\\r\\n    <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>Wildflower uses the additional MVC paths feature of CakePHP framework. It\'s sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <i>\\/app<\\/i> directory. This is a great way to customize any aspect of the CMS, especially exteding the admin interface with additional sections or customizing existing ones to the site\'s needs.<\\/p>\\r\\n<p>&nbsp;<\\/p>\\r\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 11:46:21'),(64,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n    <li>Apache web server with mod_rewrite<\\/li>\\r\\n    <li>PHP 5.2+<\\/li>\\r\\n    <li>MySQL 4.1+<\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>\\r\\n    <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>\\r\\n    <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>\\r\\n    <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application root.<\\/li>\\r\\n    <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>\\r\\n    <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>Wildflower uses the additional MVC paths feature of CakePHP framework. It\'s sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <i>\\/app<\\/i> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs.<\\/p>\\r\\n<p>&nbsp;<\\/p>\\r\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-19 11:46:43'),(65,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n    <li>Apache web server with mod_rewrite<\\/li>\\r\\n    <li>PHP 5.2+<\\/li>\\r\\n    <li>MySQL 4.1+<\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>\\r\\n    <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>\\r\\n    <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>\\r\\n    <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application root.<\\/li>\\r\\n    <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>\\r\\n    <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>Wildflower uses the additional MVC paths feature of CakePHP framework. It\'s sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <i>\\/app<\\/i> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower files.<\\/p>\\r\\n<p>&nbsp;<\\/p>\\r\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',4,1,'2008-07-19 11:47:27'),(66,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n    <li>Apache web server with mod_rewrite<\\/li>\\r\\n    <li>PHP 5.2+<\\/li>\\r\\n    <li>MySQL 4.1+<\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>\\r\\n    <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>\\r\\n    <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>\\r\\n    <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application root.<\\/li>\\r\\n    <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>\\r\\n    <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>Wildflower uses the additional MVC paths feature of CakePHP framework. It\'s sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <i>\\/app<\\/i> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower files.<\\/p>\\r\\n<p>A modern website usually consist of &quot;static&quot; pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site with the help of a rapid development framework--CakePHP.<\\/p>\\r\\n<p>&nbsp;<\\/p>\\r\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',5,1,'2008-07-19 11:55:20'),(67,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n    <li>Apache web server with mod_rewrite<\\/li>\\r\\n    <li>PHP 5.2+<\\/li>\\r\\n    <li>MySQL 4.1+<\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>\\r\\n    <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>\\r\\n    <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>\\r\\n    <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application root.<\\/li>\\r\\n    <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>\\r\\n    <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>Wildflower uses the additional MVC paths feature of CakePHP framework. It\'s sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <i>\\/app<\\/i> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower files.<\\/p>\\r\\n<p>A modern website usually consist of &quot;static&quot; pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site with fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\r\\n<p>&nbsp;<\\/p>\\r\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',6,1,'2008-07-19 11:55:55'),(68,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n    <li>Apache web server with mod_rewrite<\\/li>\\r\\n    <li>PHP 5.2+<\\/li>\\r\\n    <li>MySQL 4.1+<\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>\\r\\n    <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>\\r\\n    <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>\\r\\n    <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application root.<\\/li>\\r\\n    <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>\\r\\n    <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>A modern website usually consist of &quot;static&quot; pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site with fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\r\\n<p>Wildflower uses the additional MVC paths feature of CakePHP framework. It\'s sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <i>\\/app<\\/i> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower files.<\\/p>\",\"description_meta_tag\":\"\"}}',7,1,'2008-07-19 11:56:25'),(69,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n    <li>Apache web server with mod_rewrite<\\/li>\\r\\n    <li>PHP 5.2+<\\/li>\\r\\n    <li>MySQL 4.1+<\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>\\r\\n    <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>\\r\\n    <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>\\r\\n    <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application root.<\\/li>\\r\\n    <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>\\r\\n    <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>A modern website usually consist of &quot;static&quot; pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\r\\n<p>Wildflower uses the additional MVC paths feature of CakePHP framework. It\'s sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <i>\\/app<\\/i> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower files.<\\/p>\",\"description_meta_tag\":\"\"}}',8,1,'2008-07-19 11:57:05'),(70,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n    <li>Apache web server with mod_rewrite<\\/li>\\r\\n    <li>PHP 5.2+<\\/li>\\r\\n    <li>MySQL 4.1+<\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>\\r\\n    <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>\\r\\n    <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>\\r\\n    <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n    <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application root.<\\/li>\\r\\n    <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>\\r\\n    <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>A modern website usually consist of &quot;static&quot; pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\r\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <i>\\/app<\\/i> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower files.<\\/p>\",\"description_meta_tag\":\"\"}}',9,1,'2008-07-19 11:57:34'),(71,'page',81,'{\"Page\":{\"title\":\"Friendly robots\",\"content\":\"<p>This is a page about the most friedly robots. They give presents by day. 123<\\/p>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-19 12:44:10'),(72,'page',81,'{\"Page\":{\"title\":\"Friendly robots\",\"content\":\"<p>This is a page about the most friedly robots. They give presents by day.<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 12:46:57'),(73,'page',81,'{\"Page\":{\"title\":\"Friendly robots 712312\",\"content\":\"<p>This is a page about the most friedly robots. They give presents by day. <\\/p><p>&nbsp;<\\/p><p>HOooly smoke.<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-19 12:50:11'),(74,'page',81,'{\"Page\":{\"title\":\"Friendly robots 712312\",\"content\":\"<p>This is a page about the most friedly robots. They give presents by day.<\\/p><p>&nbsp;<\\/p><p>HOooly smoke.<\\/p>\",\"description_meta_tag\":\"Aleluja.\"}}',4,1,'2008-07-19 12:50:47'),(75,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p> <h3>Requirements<\\/h3> <ul>     <li>Apache web server with mod_rewrite<\\/li>     <li>PHP 5.2+<\\/li>     <li>MySQL 4.1+<\\/li> <\\/ul> <h3>Fresh installation<\\/h3> <ol>     <li>Extract the archive. Place the <i>wildflower<\\/i> directory inside your apache document root.<\\/li>     <li>Create a new MySQL database (preferably use <i>utf8_unicode_ci<\\/i> collation) and into this new database import the SQL file <i>app\\/config\\/sql\\/wildflower.sql<\\/i>.<\\/li>     <li>Edit the <i>app\\/config\\/database.php<\\/i> file with your database connection details.<\\/li>     <li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <i>app<\\/i> directory. When a new release of Wildflower comes, you simply update the <i>cake<\\/i>, <i>vendors<\\/i> and <i>wildflower<\\/i> directories.<\\/li> <\\/ol> <h3>Installing to an existing CakePHP application<\\/h3> <ol>     <li>Extract the archive and place the <i>wildflower\\/wildflower<\\/i> directory inside your application root.<\\/li>     <li>Just include the Wildflower <i>bootstrap.php<\\/i> file located at <i>\\/wildflower\\/config\\/bootstrap.php<\\/i> in your <i>\\/app\\/config\\/bootstrap.php<\\/i>.<\\/li>     <li>Load the SQL dump file <i>app\\/config\\/sql\\/wildflower.sql<\\/i> to your existing database.<\\/li> <\\/ol> <h3>Basic principles<\\/h3> <p>A modern website usually consist of &quot;static&quot; pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p> <p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <i>\\/app<\\/i> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower files.<\\/p>\",\"description_meta_tag\":\"\"}}',10,1,'2008-07-19 13:04:19'),(76,'page',81,'{\"Page\":{\"title\":\"Friendly robots\",\"content\":\"<p>This is a page about the most friedly robots.<\\/p>\\r\\n<p>&nbsp;<\\/p>\\r\\n<p>HOooly smoke.<\\/p>\",\"description_meta_tag\":\"Aleluja.\"}}',5,1,'2008-07-19 13:10:26'),(77,'page',81,'{\"Page\":{\"title\":\"Friendly robots\",\"content\":\"<p>This is a page about the most friedly robots.<\\/p> <p>&nbsp;<\\/p> <p>HOooly smoke.<\\/p>\",\"description_meta_tag\":\"Aleluja.\"}}',6,1,'2008-07-19 13:16:48'),(78,'page',81,'{\"Page\":{\"title\":\"Friendly robots 123\",\"content\":\"<p>This is a page about the most friedly robots.<\\/p> <p>&nbsp;<\\/p> <p>HOooly smoke.<\\/p>\",\"description_meta_tag\":\"Aleluja.\"}}',7,1,'2008-07-19 13:17:24'),(79,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3> <p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p> <p><img src=\\\"\\/uploads\\/page-edit.jpg\\\" alt=\\\"page-edit.jpg\\\"><\\/p> <h3>File manager<\\/h3> <p>Upload any file type. You can categorize your uploads using tags.<\\/p> <p><img src=\\\"\\/uploads\\/files-manager.jpg\\\" alt=\\\"files-manager.jpg\\\"><\\/p> <h3>Revisions<\\/h3> <p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-19 13:19:29'),(80,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3> <p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p> <p><img alt=\\\"page-edit.jpg\\\" src=\\\"\\/uploads\\/page-edit.jpg\\\"><\\/p> <h3>File manager<\\/h3> <p>Upload any file type. You can categorize your uploads using tags.<\\/p> <p><img alt=\\\"files-manager.jpg\\\" src=\\\"\\/uploads\\/files-manager.jpg\\\"><\\/p> <h3>Revisions<\\/h3> <p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 13:22:43'),(81,'post',2,'{\"Post\":{\"title\":\"Another new post\",\"content\":\"<p>And now we do this... 13<\\/p>\",\"description_meta_tag\":\"\"}}',4,1,'2008-07-19 13:22:55'),(82,'page',119,'{\"Page\":{\"title\":\"asdasdas\"}}',1,1,'2008-07-19 13:33:23'),(83,'page',119,'{\"Page\":{\"title\":\"asdasdas\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 13:33:29'),(84,'page',120,'{\"Page\":{\"title\":\"Hol ah\"}}',1,1,'2008-07-19 13:33:36'),(85,'page',121,'{\"Page\":{\"title\":\"123\"}}',1,1,'2008-07-19 13:33:46'),(86,'page',121,'{\"Page\":{\"title\":\"123\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 13:34:22'),(87,'page',121,'{\"Page\":{\"title\":\"123\",\"content\":\"<p>asdasdas<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-19 13:34:25'),(88,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3> <p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p> <p><img src=\\\"\\/uploads\\/page-edit.jpg\\\" alt=\\\"page-edit.jpg\\\"><\\/p> <h3>File manager<\\/h3> <p>Upload any file type. You can categorize your uploads using tags.<\\/p> <p><img src=\\\"\\/uploads\\/files-manager.jpg\\\" alt=\\\"files-manager.jpg\\\"><\\/p> <h3>Revisions<\\/h3> <p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-19 15:37:56'),(89,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>     <li>Try replacing FCK with TinyMCE.<\\/li>     <li>Add keyboard shortcuts<\\/li><li>Flash file uploader<\\/li> <\\/ul>\",\"description_meta_tag\":\"\"}}',4,1,'2008-07-19 15:39:22'),(90,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>     <li>Try replacing FCK with TinyMCE.<\\/li>     <li>Add keyboard shortcuts<\\/li><li>Flash file uploader<\\/li><li>Editor drag resizing<\\/li> <\\/ul>\",\"description_meta_tag\":\"\"}}',5,1,'2008-07-19 15:39:47'),(91,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\r\\n    <li>Try replacing FCK with TinyMCE.<\\/li>\\r\\n    <li>Add keyboard shortcuts<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',6,1,'2008-07-19 15:41:36'),(92,'post',17,'{\"Post\":{\"title\":\"mysqlsock\"}}',1,1,'2008-07-19 16:28:15'),(93,'post',17,'{\"Post\":{\"title\":\"mysqlsock\",\"content\":\"<p>is a strange thing<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 16:28:29'),(94,'page',64,'{\"Page\":{\"title\":\"Features and pages\",\"content\":\"<p><b>asdadas<\\/b><\\/p> <p>Collapased toolbar is cool.<\\/p> <pre class=\\\"cake-debug\\\">\\r\\nArray\\r(\\r    [PageTest] =&gt; Array\\r        (\\r            [id] =&gt; 2\\r            [parent_id] =&gt; 3\\r            [lft] =&gt; 4\\r            [rght] =&gt; 5\\r            [level] =&gt; 0\\r            [slug] =&gt; simple\\r            [url] =&gt; \\/article-1\\/simple\\r            [title] =&gt; Simple\\r            [content] =&gt; Lorem ipsum dolor sit amer. 123. \\u010d\\u013e\\u017e+&aacute;\\u013e&scaron;&yacute;&iacute;.11_?\\r            [description_meta_tag] =&gt; Some description tag\\r            [keywords_meta_tag] =&gt; \\r            [draft] =&gt; 0\\r            [created] =&gt; 2007-03-18 10:39:23\\r            [updated] =&gt; 2008-07-06 13:51:14\\r        )\\r\\r)\\r<\\/pre>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-19 17:24:20'),(95,'page',122,'{\"Page\":{\"title\":\"new page\"}}',1,1,'2008-07-19 18:49:43'),(96,'page',123,'{\"Page\":{\"title\":\"no revision please\"}}',1,1,'2008-07-19 18:54:11'),(97,'page',126,'{\"Page\":{\"title\":\"asdasd\"}}',1,1,'2008-07-19 18:56:12'),(98,'page',124,'{\"Page\":{\"title\":\"123\",\"content\":\"<p>asdasd<\\/p>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-19 19:19:48'),(99,'page',124,'{\"Page\":{\"title\":\"123\",\"content\":\"<p>asdasd 1<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 19:20:20'),(100,'post',5,'{\"Post\":{\"title\":\"A new post\",\"content\":\"<p>Have fun with this new editor.<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-19 19:56:06'),(101,'post',5,'{\"Post\":{\"title\":\"A new post\",\"content\":\"<p>Have fun with this new editor. 213123<\\/p>\",\"description_meta_tag\":\"\"}}',4,1,'2008-07-19 19:57:11'),(102,'post',5,'{\"Post\":{\"title\":\"A new post 3\",\"content\":\"<p>Have fun with this new editor. 213123 asdsadas<\\/p>\",\"description_meta_tag\":\"\"}}',5,1,'2008-07-19 19:57:24'),(103,'post',5,'{\"Post\":{\"title\":\"A new post 3\",\"content\":\"<p>Have fun with this new editor.<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>sadasd<\\/p>\",\"description_meta_tag\":\"\"}}',6,1,'2008-07-19 19:58:12'),(104,'page',127,'{\"Page\":{\"title\":\"delete me\"}}',1,1,'2008-07-19 21:05:58'),(105,'page',128,'{\"Page\":{\"title\":\"123\"}}',1,1,'2008-07-19 21:06:16'),(106,'page',129,'{\"Page\":{\"title\":\"dele\"}}',1,1,'2008-07-19 21:08:09'),(107,'post',18,'{\"Post\":{\"title\":\"del me\"}}',1,1,'2008-07-19 21:08:29'),(108,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Revisions list missing .list-item<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload edit<\\/li>\\n<li>Revisions save even if the content is identical to prev.<\\/li>\\n<li><strong>When I deleted all WF sites at once some were not deleted!!!<\\/strong><\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<li>FCKeditor height<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',18,1,'2008-07-19 21:09:08'),(109,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload edit<\\/li>\\n<li>Revisions save even if the content is identical to prev.<\\/li>\\n<li><strong>When I deleted all WF sites at once some were not deleted!!!<\\/strong><\\/li>\\n<li>Post have no Publish button<strong><br \\/><\\/strong><\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',19,1,'2008-07-19 21:53:40'),(110,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload edit<\\/li>\\n<li>Revisions save even if the content is identical to prev.<\\/li>\\n<li><strong>When I deleted all WF sites at once some were not deleted!!!<\\/strong><\\/li>\\n<li>Post have no Publish button<\\/li>\\n<li>Upload::create does not fill short_name<strong><br \\/><\\/strong><\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',20,1,'2008-07-19 21:55:46'),(111,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',7,1,'2008-07-19 21:58:01'),(112,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts<\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<\\/ul>\\n<blockquote>\\n<p>Code is poetry.<\\/p>\\n<\\/blockquote>\",\"description_meta_tag\":\"\"}}',8,1,'2008-07-19 21:58:31'),(113,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts<\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<\\/ul>\\n<blockquote>\\n<p>Code is poetry.<\\/p>\\n<\\/blockquote>\",\"description_meta_tag\":\"\"}}',9,1,'2008-07-19 22:04:01'),(114,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload edit<\\/li>\\n<li>Revisions save even if the content is identical to prev.<\\/li>\\n<li><strong>When I deleted all WF sites at once some were not deleted! Appears to be the ones following a tree.<br \\/><\\/strong><\\/li>\\n<li>Post have no Publish button<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>A new revision should be added to the rev list after AJAX save<strong><br \\/><\\/strong><\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',21,1,'2008-07-19 22:05:41'),(115,'page',130,'{\"Page\":{\"title\":\"tree\"}}',1,1,'2008-07-19 22:05:50'),(116,'page',131,'{\"Page\":{\"title\":\"subtrre\"}}',1,1,'2008-07-19 22:05:58'),(117,'page',131,'{\"Page\":{\"title\":\"subtrre\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 22:06:03'),(118,'page',132,'{\"Page\":{\"title\":\"subtree2\"}}',1,1,'2008-07-19 22:06:10'),(119,'page',132,'{\"Page\":{\"title\":\"subtree2\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 22:06:16'),(120,'page',133,'{\"Page\":{\"title\":\"after tree 1\"}}',1,1,'2008-07-19 22:06:21'),(121,'page',134,'{\"Page\":{\"title\":\"after tree 2\"}}',1,1,'2008-07-19 22:06:27'),(122,'page',134,'{\"Page\":{\"title\":\"after tree 2\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-19 22:08:17'),(123,'page',135,'{\"Page\":{\"title\":\"after tree real\"}}',1,1,'2008-07-19 22:08:24'),(124,'page',136,'{\"Page\":{\"title\":\"asdasd\"}}',1,1,'2008-07-20 09:46:48'),(125,'page',136,'{\"Page\":{\"title\":\"asdasd\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-20 09:46:55'),(126,'page',137,'{\"Page\":{\"title\":\"stuff\"}}',1,1,'2008-07-20 09:46:59'),(127,'page',138,'{\"Page\":{\"title\":\"another stuff\"}}',1,1,'2008-07-20 09:47:05'),(128,'page',139,'{\"Page\":{\"title\":\"123\"}}',1,1,'2008-07-20 09:47:10'),(129,'page',139,'{\"Page\":{\"title\":\"123\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-20 09:47:17'),(130,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<\\/ul>\\n<blockquote>\\n<p>Code is poetry.<\\/p>\\n<\\/blockquote>\",\"description_meta_tag\":\"\"}}',10,1,'2008-07-20 09:48:51'),(131,'page',140,'{\"Page\":{\"title\":\"123\"}}',1,1,'2008-07-20 09:58:52'),(132,'page',140,'{\"Page\":{\"title\":\"123\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-20 09:58:57'),(133,'page',141,'{\"Page\":{\"title\":\"324324\"}}',1,1,'2008-07-20 09:59:00'),(134,'page',141,'{\"Page\":{\"title\":\"324324\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-20 09:59:05'),(135,'page',142,'{\"Page\":{\"title\":\"last\"}}',1,1,'2008-07-20 09:59:09'),(136,'page',143,'{\"Page\":{\"title\":\"asdasdas\"}}',1,1,'2008-07-20 10:06:37'),(137,'page',144,'{\"Page\":{\"title\":\"sadasd\"}}',1,1,'2008-07-20 10:06:40'),(138,'page',144,'{\"Page\":{\"title\":\"sadasd\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-20 10:06:46'),(139,'page',145,'{\"Page\":{\"title\":\"asdasdas\"}}',1,1,'2008-07-20 10:06:50'),(140,'page',145,'{\"Page\":{\"title\":\"asdasdas\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-20 10:06:57'),(141,'page',146,'{\"Page\":{\"title\":\"last\"}}',1,1,'2008-07-20 10:07:01'),(142,'page',147,'{\"Page\":{\"title\":\"least\"}}',1,1,'2008-07-20 10:07:05'),(143,'page',148,'{\"Page\":{\"title\":\"123asdas\"}}',1,1,'2008-07-20 10:10:49'),(144,'page',148,'{\"Page\":{\"title\":\"123asdas\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-20 10:10:55'),(145,'page',149,'{\"Page\":{\"title\":\"213213\"}}',1,1,'2008-07-20 10:11:00'),(146,'page',149,'{\"Page\":{\"title\":\"213213\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-20 10:11:05'),(147,'page',150,'{\"Page\":{\"title\":\"213123\"}}',1,1,'2008-07-20 10:11:08'),(148,'page',64,'{\"Page\":{\"title\":\"Features and pages\",\"content\":\"<p><strong>asdadas<\\/strong><\\/p>\\n<p>Collapased toolbar is cool.<img title=\\\"Cool\\\" src=\\\"..\\/..\\/..\\/js\\/tiny_mce\\/plugins\\/emotions\\/img\\/smiley-cool.gif\\\" border=\\\"0\\\" alt=\\\"Cool\\\" \\/><\\/p>\\n<pre class=\\\"cake-debug\\\">Array<br \\/>(<br \\/>    [PageTest] =&gt; Array<br \\/>        (<br \\/>            [id] =&gt; 2<br \\/>            [parent_id] =&gt; 3<br \\/>            [lft] =&gt; 4<br \\/>            [rght] =&gt; 5<br \\/>            [level] =&gt; 0<br \\/>            [slug] =&gt; simple<br \\/>            [url] =&gt; \\/article-1\\/simple<br \\/>            [title] =&gt; Simple<br \\/>            [content] =&gt; Lorem ipsum dolor sit amer. 123. \\u010d\\u013e\\u017e+&aacute;\\u013e&scaron;&yacute;&iacute;.11_?<br \\/>            [description_meta_tag] =&gt; Some description tag<br \\/>            [keywords_meta_tag] =&gt; <br \\/>            [draft] =&gt; 0<br \\/>            [created] =&gt; 2007-03-18 10:39:23<br \\/>            [updated] =&gt; 2008-07-06 13:51:14<br \\/>        )<br \\/><br \\/>)<br \\/><\\/pre>\",\"description_meta_tag\":\"\"}}',4,1,'2008-07-20 11:22:52'),(149,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p>&nbsp;<\\/p>\\n<pre class=\\\"cake-debug\\\">Array<br \\/>(<br \\/>    [PageTest] =&gt; Array<br \\/>        (<br \\/>            [id] =&gt; 2<br \\/>            [parent_id] =&gt; 3<br \\/>            [lft] =&gt; 4<br \\/>            [rght] =&gt; 5<br \\/>            [level] =&gt; 0<br \\/>            [slug] =&gt; simple<br \\/>            [url] =&gt; \\/article-1\\/simple<br \\/>            [title] =&gt; Simple<br \\/>            [content] =&gt; Lorem ipsum dolor sit amer. 123. \\u010d\\u013e\\u017e+&aacute;\\u013e&scaron;&yacute;&iacute;.11_?<br \\/>            [description_meta_tag] =&gt; Some description tag<br \\/>            [keywords_meta_tag] =&gt; <br \\/>            [draft] =&gt; 0<br \\/>            [created] =&gt; 2007-03-18 10:39:23<br \\/>            [updated] =&gt; 2008-07-06 13:51:14<br \\/>        )<br \\/><br \\/>)<br \\/><\\/pre>\",\"description_meta_tag\":\"\"}}',5,1,'2008-07-20 15:34:41'),(150,'page',151,'{\"Page\":{\"title\":\"hej\"}}',1,1,'2008-07-20 17:24:49'),(151,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',11,1,'2008-07-20 17:25:20'),(152,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p>Array<\\/p>\\n<pre class=\\\"cake-debug\\\">(<br \\/>    [PageTest] =&gt; Array<br \\/>        (<br \\/>            [id] =&gt; 2<br \\/>            [parent_id] =&gt; 3<br \\/>            [lft] =&gt; 4<br \\/>            [rght] =&gt; 5<br \\/>            [level] =&gt; 0<br \\/>            [slug] =&gt; simple<br \\/>            [url] =&gt; \\/article-1\\/simple<br \\/>            [title] =&gt; Simple<br \\/>            [content] =&gt; Lorem ipsum dolor sit amer. 123. \\u010d\\u013e\\u017e+&aacute;\\u013e&scaron;&yacute;&iacute;.11_?<br \\/>            [description_meta_tag] =&gt; Some description tag<br \\/>            [keywords_meta_tag] =&gt; <br \\/>            [draft] =&gt; 0<br \\/>            [created] =&gt; 2007-03-18 10:39:23<br \\/>            [updated] =&gt; 2008-07-06 13:51:14<br \\/>        )<br \\/><br \\/>)<br \\/><\\/pre>\",\"description_meta_tag\":\"\"}}',6,1,'2008-07-20 17:27:04'),(153,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p>Array<\\/p>\\n<p class=\\\"cake-debug\\\">(<br \\/> [PageTest] =&gt; Array<br \\/> (<br \\/> [id] =&gt; 2<br \\/> [parent_id] =&gt; 3<br \\/> [lft] =&gt; 4<br \\/> [rght] =&gt; 5<br \\/> [level] =&gt; 0<br \\/> [slug] =&gt; simple<br \\/> [url] =&gt; \\/article-1\\/simple<br \\/> [title] =&gt; Simple<br \\/> [content] =&gt; Lorem ipsum dolor sit amer. 123. \\u010d\\u013e\\u017e+&aacute;\\u013e&scaron;&yacute;&iacute;.11_?<br \\/> [description_meta_tag] =&gt; Some description tag<br \\/> [keywords_meta_tag] =&gt; <br \\/> [draft] =&gt; 0<br \\/> [created] =&gt; 2007-03-18 10:39:23<br \\/> [updated] =&gt; 2008-07-06 13:51:14<br \\/> )<br \\/><br \\/>)<br \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',7,1,'2008-07-20 17:36:24'),(154,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world how are we today.<\\/p>\\n<p>This option enables you to specify a custom CSS file that extends the theme content CSS. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',8,1,'2008-07-20 17:47:11'),(155,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world how are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<br \\/><\\/h2>\\n<p>This option enables you to specify a custom CSS file that extends the theme content CSS. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',9,1,'2008-07-20 17:47:43'),(156,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your apache document root.<\\/li>\\n<li>Create a new MySQL database (preferably use <em>utf8_unicode_ci<\\/em> collation) and into this new database import the SQL file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply update the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your existing database.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <em>\\/app<\\/em> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower files.<\\/p>\",\"description_meta_tag\":\"\"}}',11,1,'2008-07-20 17:51:26'),(157,'post',19,'{\"Post\":{\"title\":\"123\"}}',1,1,'2008-07-20 17:52:37'),(158,'post',20,'{\"Post\":{\"title\":\"123 delete\"}}',1,1,'2008-07-20 17:52:47'),(159,'page',152,'{\"Page\":{\"title\":\"123\"}}',1,1,'2008-07-20 17:53:40'),(160,'post',19,'{\"Post\":{\"title\":\"123\",\"content\":\"<p>asdasdsadas<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-20 23:54:04'),(161,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload edit<\\/li>\\n<li>Revisions save even if the content is identical to prev - haven\'t seen lately, more investigation.<\\/li>\\n<li>Post have no Publish button<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>A new revision should be added to the rev list after AJAX save<strong><br \\/><\\/strong><\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',22,1,'2008-07-23 20:01:15'),(162,'post',1,'{\"Post\":{\"title\":\"A shiny new post 123\",\"content\":\"<div id=\\\"lipsum\\\">\\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In imperdiet odio in augue. Sed pharetra. Nullam faucibus odio. Nam rhoncus tristique augue. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer congue dapibus metus. Phasellus sed elit sodales orci iaculis tincidunt. Duis hendrerit, nulla eu hendrerit fermentum, diam sapien commodo enim, sed rutrum purus sapien sed pede. Phasellus vitae quam. Morbi aliquam, leo vitae consectetuer consectetuer, ligula diam volutpat eros, imperdiet egestas nulla tortor ac dui. Etiam feugiat, dui nec pharetra pharetra, erat augue vulputate sapien, ut tristique lacus felis at eros. Pellentesque eu erat. Nullam aliquet mollis dolor. Ut est orci, tempus pellentesque, semper sit amet, scelerisque in, quam. Aliquam consequat, orci nec ullamcorper condimentum, nibh ligula dictum nulla, eget pulvinar velit lacus sit amet nulla. Etiam semper faucibus mi. Aenean nunc sapien, venenatis vitae, dapibus sit amet, auctor non, lacus. Phasellus porttitor ante sit amet turpis. Vestibulum nec erat. Maecenas eros.<\\/p>\\n<p>Nullam quis nulla non sapien interdum varius. Cras hendrerit elementum leo. Fusce tincidunt, justo eu eleifend elementum, ante arcu blandit dolor, quis ullamcorper dui tellus sit amet quam. Vestibulum vulputate. Morbi mi odio, consectetuer ut, vulputate vitae, tristique ut, ipsum. Donec ipsum tortor, pulvinar a, pulvinar eget, commodo non, odio. Nullam dolor. Aliquam erat volutpat. Phasellus libero. Vivamus luctus lobortis libero. Ut ut elit. Sed elementum quam nec arcu. Nam id tellus non odio fermentum convallis. Nam a lacus.<\\/p>\\n<p>Phasellus ante arcu, gravida a, lobortis sit amet, volutpat non, velit. Nulla consectetuer quam gravida nulla. Integer eu purus. Morbi sit amet nunc. Mauris vehicula lacus ac lectus. Proin tortor nisl, faucibus non, molestie nec, tincidunt non, justo. Suspendisse massa lectus, hendrerit aliquam, elementum et, iaculis non, nunc. Etiam non dui. Morbi gravida massa sollicitudin ipsum. Suspendisse magna ante, facilisis ac, sagittis et, placerat et, diam. Fusce facilisis, nulla ac accumsan facilisis, mi nisi tristique quam, malesuada pulvinar neque leo ut augue. Mauris dui.<\\/p>\\n<p>Etiam nec risus at leo ullamcorper lobortis. In rhoncus massa ac velit. Nullam mollis consequat ligula. Integer iaculis, enim sed cursus hendrerit, neque dolor hendrerit erat, dignissim egestas quam quam vel quam. Etiam tellus libero, molestie non, mattis in, venenatis sed, dui. Proin non nisl ut massa ullamcorper interdum. Aliquam erat volutpat. Sed gravida. Quisque quis magna. Quisque non metus. Nullam euismod suscipit elit. Vivamus quis risus. Phasellus ut lectus. Nunc velit sem, viverra sed, convallis eu, convallis a, nisl. Maecenas bibendum orci in enim. Sed orci. Nullam adipiscing pellentesque purus. Sed risus orci, consequat nec, ornare sed, condimentum semper, mi. Fusce hendrerit, justo non volutpat pretium, neque mauris placerat est, id pretium mauris libero id eros.<\\/p>\\n<p>Sed risus mi, vestibulum ac, tincidunt at, condimentum id, tortor. Donec non mauris sed leo auctor auctor. Nullam facilisis. Quisque eu ipsum. Donec quis sem. Morbi rutrum magna in justo. Vestibulum eu orci. Praesent placerat, ipsum eget bibendum vulputate, velit dolor ultrices metus, tempus congue est lorem a eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nam consectetuer erat et urna.<\\/p>\\n<\\/div>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-23 20:04:03'),(163,'post',1,'{\"Post\":{\"title\":\"A shiny new post 123\",\"content\":\"<div id=\\\"lipsum\\\">\\r\\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In imperdiet odio in augue. Sed pharetra. Nullam faucibus odio. Nam rhoncus tristique augue. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer congue dapibus metus. Phasellus sed elit sodales orci iaculis tincidunt. Duis hendrerit, nulla eu hendrerit fermentum, diam sapien commodo enim, sed rutrum purus sapien sed pede. Phasellus vitae quam. Morbi aliquam, leo vitae consectetuer consectetuer, ligula diam volutpat eros, imperdiet egestas nulla tortor ac dui. Etiam feugiat, dui nec pharetra pharetra, erat augue vulputate sapien, ut tristique lacus felis at eros. Pellentesque eu erat. Nullam aliquet mollis dolor. Ut est orci, tempus pellentesque, semper sit amet, scelerisque in, quam. Aliquam consequat, orci nec ullamcorper condimentum, nibh ligula dictum nulla, eget pulvinar velit lacus sit amet nulla. Etiam semper faucibus mi. Aenean nunc sapien, venenatis vitae, dapibus sit amet, auctor non, lacus. Phasellus porttitor ante sit amet turpis. Vestibulum nec erat. Maecenas eros.<\\/p>\\r\\n<p>Nullam quis nulla non sapien interdum varius. Cras hendrerit elementum leo. Fusce tincidunt, justo eu eleifend elementum, ante arcu blandit dolor, quis ullamcorper dui tellus sit amet quam. Vestibulum vulputate. Morbi mi odio, consectetuer ut, vulputate vitae, tristique ut, ipsum. Donec ipsum tortor, pulvinar a, pulvinar eget, commodo non, odio. Nullam dolor. Aliquam erat volutpat. Phasellus libero. Vivamus luctus lobortis libero. Ut ut elit. Sed elementum quam nec arcu. Nam id tellus non odio fermentum convallis. Nam a lacus.<\\/p>\\r\\n<p>Phasellus ante arcu, gravida a, lobortis sit amet, volutpat non, velit. Nulla consectetuer quam gravida nulla. Integer eu purus. Morbi sit amet nunc. Mauris vehicula lacus ac lectus. Proin tortor nisl, faucibus non, molestie nec, tincidunt non, justo. Suspendisse massa lectus, hendrerit aliquam, elementum et, iaculis non, nunc. Etiam non dui. Morbi gravida massa sollicitudin ipsum. Suspendisse magna ante, facilisis ac, sagittis et, placerat et, diam. Fusce facilisis, nulla ac accumsan facilisis, mi nisi tristique quam, malesuada pulvinar neque leo ut augue. Mauris dui.<\\/p>\\r\\n<p>Etiam nec risus at leo ullamcorper lobortis. In rhoncus massa ac velit. Nullam mollis consequat ligula. Integer iaculis, enim sed cursus hendrerit, neque dolor hendrerit erat, dignissim egestas quam quam vel quam. Etiam tellus libero, molestie non, mattis in, venenatis sed, dui. Proin non nisl ut massa ullamcorper interdum. Aliquam erat volutpat. Sed gravida. Quisque quis magna. Quisque non metus. Nullam euismod suscipit elit. Vivamus quis risus. Phasellus ut lectus. Nunc velit sem, viverra sed, convallis eu, convallis a, nisl. Maecenas bibendum orci in enim. Sed orci. Nullam adipiscing pellentesque purus. Sed risus orci, consequat nec, ornare sed, condimentum semper, mi. Fusce hendrerit, justo non volutpat pretium, neque mauris placerat est, id pretium mauris libero id eros.<\\/p>\\r\\n<p>Sed risus mi, vestibulum ac, tincidunt at, condimentum id, tortor. Donec non mauris sed leo auctor auctor. Nullam facilisis. Quisque eu ipsum. Donec quis sem. Morbi rutrum magna in justo. Vestibulum eu orci. Praesent placerat, ipsum eget bibendum vulputate, velit dolor ultrices metus, tempus congue est lorem a eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nam consectetuer erat et urna.<\\/p>\\r\\n<\\/div>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-23 20:21:04'),(164,'page',153,'{\"Page\":{\"title\":\"Code child\"}}',1,1,'2008-07-23 20:33:45'),(165,'page',153,'{\"Page\":{\"title\":\"Code child\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-23 20:33:50'),(166,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\n<p><img src=\\\"..\\/..\\/..\\/..\\/uploads\\/page-edit.jpg\\\" alt=\\\"page-edit.jpg\\\" \\/><\\/p>\\n<h3>File manager<\\/h3>\\n<p>Upload any file type. You can categorize your uploads using tags.<\\/p>\\n<p><img src=\\\"..\\/..\\/..\\/..\\/uploads\\/files-manager.jpg\\\" alt=\\\"files-manager.jpg\\\" \\/><\\/p>\\n<h3><img src=\\\"..\\/..\\/..\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" width=\\\"120\\\" height=\\\"120\\\" \\/><\\/h3>\\n<h3>Revisions<\\/h3>\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',4,1,'2008-07-23 22:02:15'),(167,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\n<p><img src=\\\"..\\/..\\/..\\/..\\/uploads\\/page-edit.jpg\\\" alt=\\\"page-edit.jpg\\\" \\/><\\/p>\\n<h3>File manager<\\/h3>\\n<p>Upload any file type. You can categorize your uploads using tags. <img title=\\\"Foot in mouth\\\" src=\\\"..\\/..\\/..\\/js\\/tiny_mce\\/plugins\\/emotions\\/img\\/smiley-foot-in-mouth.gif\\\" border=\\\"0\\\" alt=\\\"Foot in mouth\\\" \\/><\\/p>\\n<p><img src=\\\"..\\/..\\/..\\/..\\/uploads\\/files-manager.jpg\\\" alt=\\\"files-manager.jpg\\\" \\/><\\/p>\\n<h3><img src=\\\"..\\/..\\/..\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" width=\\\"120\\\" height=\\\"120\\\" \\/><\\/h3>\\n<h3>Revisions<\\/h3>\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',5,1,'2008-07-23 22:20:42'),(168,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\n<p>&nbsp;<\\/p>\\n<h3>File manager<\\/h3>\\n<p>Upload any file type. You can categorize your uploads using tags. <img title=\\\"Foot in mouth\\\" src=\\\"..\\/..\\/..\\/js\\/tiny_mce\\/plugins\\/emotions\\/img\\/smiley-foot-in-mouth.gif\\\" border=\\\"0\\\" alt=\\\"Foot in mouth\\\" \\/><\\/p>\\n<p>&nbsp;<\\/p>\\n<h3><img src=\\\"..\\/..\\/..\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" width=\\\"120\\\" height=\\\"120\\\" \\/><\\/h3>\\n<h3>Revisions<\\/h3>\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',6,1,'2008-07-23 22:27:50'),(169,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\n<h3>File manager<\\/h3>\\n<p>Upload any file type. You can categorize your uploads using tags. <img title=\\\"Foot in mouth\\\" src=\\\"..\\/..\\/..\\/js\\/tiny_mce\\/plugins\\/emotions\\/img\\/smiley-foot-in-mouth.gif\\\" border=\\\"0\\\" alt=\\\"Foot in mouth\\\" \\/><\\/p>\\n<h3><img src=\\\"..\\/..\\/..\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" width=\\\"120\\\" height=\\\"120\\\" \\/><\\/h3>\\n<h3>Revisions<\\/h3>\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',7,1,'2008-07-24 00:15:49'),(170,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload edit<\\/li>\\n<li>Revisions save even if the content is identical to prev - haven\'t seen lately, more investigation.<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>A new revision should be added to the rev list after AJAX save<strong><br \\/><\\/strong><\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',23,1,'2008-07-24 09:56:54'),(171,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',12,1,'2008-07-24 10:01:49'),(172,'page',79,'{\"Page\":{\"title\":\"A page about nothing\",\"content\":\"<p>Hello hello hello.<\\/p>\\r\\n<p>This is a brand new site. Arial.<\\/p>\\r\\n<p><img src=\\\"..\\/..\\/..\\/uploads\\/Step_forward_little_tommy-1400x1050.jpg\\\" alt=\\\"\\\" \\/><\\/p>\\r\\n<p>&nbsp;<\\/p>\\r\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',1,1,'2008-07-24 17:07:34'),(173,'page',79,'{\"Page\":{\"title\":\"A page about nothing\",\"content\":\"<p>Hello hello hello.<\\/p>\\n<p>This is a brand new site. Arial.<\\/p>\\n<p><img src=\\\"\\/uploads\\/Step_forward_little_tommy-1400x1050.jpg\\\" alt=\\\"\\\" \\/><\\/p>\\n<p><img src=\\\"\\/wildflower\\/uploads\\/Step_forward_little_tommy-1400x1050.jpg\\\" alt=\\\"\\\" \\/><\\/p>\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-07-24 17:15:52'),(174,'page',79,'{\"Page\":{\"title\":\"A page about nothing\",\"content\":\"<p>Hello hello hello.<\\/p>\\n<p>This is a brand new site. Arial.<\\/p>\\n<p><img src=\\\"\\/uploads\\/Step_forward_little_tommy-1400x1050.jpg\\\" alt=\\\"\\\" \\/><\\/p>\\n<p><img src=\\\"\\/wildflower\\/uploads\\/All_falls_down-1440x900.jpg\\\" alt=\\\"\\\" \\/><\\/p>\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-24 17:23:53'),(175,'page',52,'{\"Page\":{\"title\":\"Home & Features\",\"content\":\"<ul id=\\\"home-feature-list\\\">\\n<li id=\\\"feature-cake\\\">Content management system and application platform build on <a href=\\\"http:\\/\\/www.cakephp.org\\\">CakePHP<\\/a> framework and <a href=\\\"http:\\/\\/jquery.com\\\">jQuery<\\/a> Javascript library.<\\/li>\\n<li id=\\\"feature-standards\\\">Standards based.<\\/li>\\n<li id=\\\"feature-open-source\\\">Open source.<\\/li>\\n<li id=\\\"feature-open-source\\\"><img src=\\\"uploads\\/All_falls_down-1440x900.jpg\\\" alt=\\\"\\\" \\/><\\/li>\\n<li id=\\\"feature-open-source\\\"><img src=\\\"uploads\\/Little_World-1400x1050.jpg\\\" alt=\\\"\\\" \\/><\\/li>\\n<li>User friendly.<\\/li>\\n<li><img src=\\\"\\/uploads\\/unit-tests-not.gif\\\" alt=\\\"unit-tests-not.gif\\\" \\/><\\/li>\\n<li>Requires up-to-date LAMP stacks. PHP 5.2+, MySQL 4.1+, mod_rewrite.<\\/li>\\n<li><a href=\\\"\\/feature-tour\\\">More features<img src=\\\"uploads\\/Step_forward_little_tommy-1400x1050.jpg\\\" alt=\\\"\\\" \\/><\\/a><\\/li>\\n<\\/ul>\\n<p class=\\\"download\\\"><a href=\\\"http:\\/\\/wildflower.googlecode.com\\/files\\/wildflower10a.zip\\\"><strong>Download now<\\/strong><br \\/> Wildflower 1.0a, released 29th February 2008<\\/a><\\/p>\",\"description_meta_tag\":\"Content management system and application platform build on CakePHP framework and jQuery Javascript library.\"}}',1,1,'2008-07-24 17:25:28'),(176,'page',52,'{\"Page\":{\"title\":\"Home & Features\",\"content\":\"<ul id=\\\"home-feature-list\\\">\\n<li id=\\\"feature-cake\\\">Content management system and application platform build on <a href=\\\"http:\\/\\/www.cakephp.org\\\">CakePHP<\\/a> framework and <a href=\\\"http:\\/\\/jquery.com\\\">jQuery<\\/a> Javascript library.<\\/li>\\n<li id=\\\"feature-standards\\\">Standards based.<\\/li>\\n<li id=\\\"feature-open-source\\\">Open source.<\\/li>\\n<li>User friendly.<\\/li>\\n<li><img src=\\\"\\/uploads\\/unit-tests-not.gif\\\" alt=\\\"unit-tests-not.gif\\\" \\/><\\/li>\\n<li>Requires up-to-date LAMP stacks. PHP 5.2+, MySQL 4.1+, mod_rewrite.<\\/li>\\n<li><a href=\\\"\\/feature-tour\\\">More features<\\/a><\\/li>\\n<\\/ul>\\n<p class=\\\"download\\\"><a href=\\\"http:\\/\\/wildflower.googlecode.com\\/files\\/wildflower10a.zip\\\"><strong>Download now<\\/strong><br \\/> Wildflower 1.0a, released 29th February 2008<\\/a><\\/p>\",\"description_meta_tag\":\"Content management system and application platform build on CakePHP framework and jQuery Javascript library.\"}}',2,1,'2008-07-24 17:25:57'),(177,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world how are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<br \\/><\\/h2>\\n<p>This option enables you to specify a custom CSS file that extends the theme content CSS. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/Spiked.gif\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/The_night_is_coming-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Fantasia-1600x1200.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/tea43_v1_wide.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',10,1,'2008-07-26 19:29:17'),(178,'post',8,'{\"Post\":{\"title\":\"use Base\",\"content\":\"<p>1234<\\/p>\\r\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Fantasia-1600x1200.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-26 19:32:27'),(179,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list draf and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',13,1,'2008-07-26 19:44:03'),(180,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list draf and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',14,1,'2008-07-26 19:46:04'),(181,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your apache document root.<\\/li>\\n<li>Create a new MySQL database (preferably use <em>utf8_unicode_ci<\\/em> collation) and into this new database import the SQL file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply update the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to override any controller, model or view by mirroring the specific file in her <em>\\/app<\\/em> directory. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower files.<\\/p>\",\"description_meta_tag\":\"\"}}',12,1,'2008-07-26 19:48:26'),(182,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\r\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\r\\n<h3>File manager<\\/h3>\\r\\n<p>Upload any file type. You can categorize your uploads using tags.<\\/p>\\r\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Igaer-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\\r\\n<h3>Revisions<\\/h3>\\r\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',8,1,'2008-07-26 19:50:26'),(183,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\r\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\r\\n<h3>File manager<\\/h3>\\r\\n<p>Upload any file type. You can categorize your uploads using tags.<\\/p>\\r\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Igaer-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\\r\\n<h3>Revisions<\\/h3>\\r\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',9,1,'2008-07-26 20:26:04'),(184,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world how are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<br \\/><\\/h2>\\n<p>This option enables you to specify a custom CSS file that extends the theme content CSS. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Lush-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',11,1,'2008-07-27 10:29:55'),(185,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\r\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\r\\n<h3>File manager<\\/h3>\\r\\n<p>Upload any file type. You can categorize your uploads using tags.<\\/p>\\r\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Igaer-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/The_night_is_coming-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\\r\\n<h3>Revisions<\\/h3>\\r\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',10,1,'2008-07-27 12:22:25'),(186,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload edit<\\/li>\\n<li>Revisions save even if the content is identical to prev - haven\'t seen lately, more investigation.<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>A new revision should be added to the rev list after AJAX save<\\/li>\\n<li>Shift+Tab from withing TinyMCE<strong><br \\/><\\/strong><\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',24,1,'2008-07-27 12:47:02'),(187,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload edit<\\/li>\\n<li>Revisions save even if the content is identical to prev - haven\'t seen lately, more investigation.<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>A new revision should be added to the rev list after AJAX save<\\/li>\\n<li>Shift+Tab from withing TinyMCE<\\/li>\\n<li>Image browser CSS rf &amp; IE7 fixing<br \\/><\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',25,1,'2008-07-27 12:56:07'),(188,'page',154,'{\"Page\":{\"title\":\"test 123\"}}',1,1,'2008-07-31 18:31:02'),(189,'post',4,'{\"Post\":{\"title\":\"Gonna tame the post edit\",\"content\":\"<p>Ola lala. 123<\\/p>\\r\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Good_Vibrations-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/The_night_is_coming-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-07-31 18:32:04'),(190,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload edit<\\/li>\\n<li>Revisions save even if the content is identical to prev - haven\'t seen lately, more investigation.<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>A new revision should be added to the rev list after AJAX save<\\/li>\\n<li>Shift+Tab from withing TinyMCE<\\/li>\\n<li>Image browser CSS rf &amp; IE7 fixing<\\/li>\\n<li>Image browser can be open multiple times and get\'s fcked up<\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',26,1,'2008-08-01 09:23:10'),(191,'page',155,'{\"Page\":{\"title\":\"Lazy\"}}',1,1,'2008-08-04 22:23:58'),(192,'page',156,'{\"Page\":{\"title\":\"Lazy\"}}',1,1,'2008-08-04 22:23:59'),(193,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world how are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<br \\/><\\/h2>\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content CSS. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Lush-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',12,1,'2008-08-06 08:41:15'),(194,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world how are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<br \\/><\\/h2>\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Lush-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',13,1,'2008-08-06 08:41:40'),(195,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world <a href=\\\"#title\\\">how<\\/a> are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\"><a name=\\\"title\\\"><\\/a>Heading &lt;h2&gt;<br \\/><\\/h2>\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Lush-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',14,1,'2008-08-06 08:42:16'),(196,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\n<h3>File manager<\\/h3>\\n<p>Upload any file type. You can categorize your uploads using tags.<\\/p>\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Igaer-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/The_night_is_coming-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\\n<h3>Revisions<\\/h3>\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',11,1,'2008-08-06 12:43:55'),(197,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world <a href=\\\"#title\\\">how<\\/a> are we today.<\\/p>\\r\\n<h2 class=\\\"cake-debug\\\"><a name=\\\"title\\\"><\\/a>Heading &lt;h2&gt;<\\/h2>\\r\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\r\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\r\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Lush-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',15,1,'2008-08-06 12:51:40'),(198,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world <a href=\\\"#title\\\">how<\\/a> are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\"><a name=\\\"title\\\"><\\/a>Heading &lt;h2&gt;<\\/h2>\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Lush-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',16,1,'2008-08-06 16:39:42'),(199,'page',64,'{\"Page\":{\"title\":\"Code, code, code 1\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world <a href=\\\"#title\\\">how<\\/a> are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\"><a name=\\\"title\\\"><\\/a>Heading &lt;h2&gt;<\\/h2>\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Lush-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',17,1,'2008-08-06 16:55:23'),(200,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\n<h3>File manager<\\/h3>\\n<p>Upload any file type. You can categorize your uploads using tags.<\\/p>\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Igaer-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/The_night_is_coming-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\\n<h3>Revisions<\\/h3>\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',12,1,'2008-08-06 17:02:35'),(201,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',15,1,'2008-08-06 18:50:48'),(202,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\r\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br><\\/li>\\r\\n<li>Google sitemaps generation<\\/li>\\r\\n<li>SWFupload<\\/li>\\r\\n<li>Password strength check from Wordpress<\\/li>\\r\\n<li>Shift click on list to select more items<\\/li>\\r\\n<li>Pages list drag and drop<\\/li>\\r\\n<li>JLM compression and caching<\\/li>\\r\\n<li>File manager folders<\\/li>\\r\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',16,1,'2008-08-06 19:28:52'),(203,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',17,1,'2008-08-06 19:28:58'),(204,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders sada<br \\/><\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',18,1,'2008-08-06 19:30:10'),(205,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders<br \\/><\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',19,1,'2008-08-06 19:30:27'),(206,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders 123<br \\/><\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',20,1,'2008-08-06 19:31:08'),(207,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders<br \\/><\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',21,1,'2008-08-06 19:31:16'),(208,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements 123\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders<br \\/><\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',22,1,'2008-08-06 19:32:20'),(209,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders<br \\/><\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',23,1,'2008-08-06 19:32:29'),(210,'page',64,'{\"Page\":{\"title\":\"Code, code, code 1\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world <a href=\\\"#title\\\">how<\\/a> are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<\\/h2>\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This CSS file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Lush-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',18,1,'2008-08-06 20:22:49'),(211,'page',64,'{\"Page\":{\"title\":\"Code, code, code 1\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world <a href=\\\"#title\\\">how<\\/a> are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<\\/h2>\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This <span style=\\\"color: #ff6600;\\\">CSS<\\/span> file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Lush-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',19,1,'2008-08-06 20:23:25'),(212,'page',64,'{\"Page\":{\"title\":\"Code, code, code 1\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world <a href=\\\"#title\\\">how<\\/a> are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<\\/h2>\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This <span style=\\\"color: #ff6600;\\\">CSS<\\/span> file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',20,1,'2008-08-06 20:24:35'),(213,'page',79,'{\"Page\":{\"title\":\"A page about nothing\",\"content\":\"<p>Hello hello hello.<\\/p>\\r\\n<p>This is a brand new site. Arial.<\\/p>\\r\\n<p><img src=\\\"\\/uploads\\/Step_forward_little_tommy-1400x1050.jpg\\\" alt=\\\"\\\" \\/><\\/p>\\r\\n<p><img src=\\\"\\/wildflower\\/uploads\\/All_falls_down-1440x900.jpg\\\" alt=\\\"\\\" \\/><\\/p>\\r\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',4,1,'2008-08-06 20:27:11'),(214,'page',79,'{\"Page\":{\"title\":\"A page about nothing\",\"content\":\"<p>Hello hello hello.<\\/p>\\n<p>This is a brand new site. Arial.<\\/p>\\n<p><img src=\\\"\\/uploads\\/Step_forward_little_tommy-1400x1050.jpg\\\" alt=\\\"\\\" \\/><\\/p>\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',5,1,'2008-08-06 20:27:53'),(215,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your apache document root.<\\/li>\\n<li>Create a new MySQL database (preferably use <em>utf8_unicode_ci<\\/em> collation) and into this new database import the SQL file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply update the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\",\"description_meta_tag\":\"\"}}',13,1,'2008-08-07 10:30:51'),(216,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p>This section is slowly being filled up. Please be patient.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your apache document root.<\\/li>\\n<li>Create a new MySQL database (preferably use <em>utf8_unicode_ci<\\/em> collation) and into this new database import the SQL file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply update the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\",\"description_meta_tag\":\"\"}}',14,1,'2008-08-07 10:38:29'),(217,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your apache document root.<\\/li>\\n<li>Create a new MySQL database (preferably use <em>utf8_unicode_ci<\\/em> collation) and into this new database import the SQL file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply update the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\",\"description_meta_tag\":\"\"}}',15,1,'2008-08-07 10:38:49'),(218,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your apache document root.<\\/li>\\n<li>Create a new MySQL database (preferably use <em>utf8_unicode_ci<\\/em> collation) and into this new database import the SQL file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply update the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\",\"description_meta_tag\":\"\"}}',16,1,'2008-08-07 10:44:12'),(219,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply update the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\",\"description_meta_tag\":\"\"}}',17,1,'2008-08-07 10:48:33'),(220,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\",\"description_meta_tag\":\"\"}}',18,1,'2008-08-07 10:50:20'),(221,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\",\"description_meta_tag\":\"\"}}',19,1,'2008-08-07 10:51:17'),(222,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\",\"description_meta_tag\":\"\"}}',20,1,'2008-08-07 10:53:23'),(223,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create the MVC files<\\/h4>\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',21,1,'2008-08-07 11:00:54'),(224,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports dynamic models.<\\/p>\",\"description_meta_tag\":\"\"}}',22,1,'2008-08-07 11:07:36'),(225,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\",\"description_meta_tag\":\"\"}}',23,1,'2008-08-07 11:13:31'),(226,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em><\\/p>\",\"description_meta_tag\":\"\"}}',24,1,'2008-08-07 11:26:30'),(227,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\",\"description_meta_tag\":\"\"}}',25,1,'2008-08-07 11:27:36'),(228,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p>admin_index.ctp could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with 4 TinyMCE editors each handling one box.<\\/p>\",\"description_meta_tag\":\"\"}}',26,1,'2008-08-07 11:31:15'),(229,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p>admin_index.ctp could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with 4 TinyMCE editors each handling one box.<\\/p>\",\"description_meta_tag\":\"\"}}',27,1,'2008-08-07 11:33:05'),(230,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p>admin_index.ctp could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the index.ctp file:<\\/p>\\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br \\/><br \\/>&lt;div class=\\\"home-box\\\"&gt;<br \\/>    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br \\/>&lt;\\/div&gt;<br \\/><br \\/>&lt;?php } ?&gt;<br \\/><\\/pre>\\n<p>This will display the four boxes and their content.<\\/p>\",\"description_meta_tag\":\"\"}}',28,1,'2008-08-07 11:36:55'),(231,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p><em>admin_index.ctp<\\/em> could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the <em>index.ctp<\\/em> file:<\\/p>\\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br \\/><br \\/>&lt;div class=\\\"home-box\\\"&gt;<br \\/>    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br \\/>&lt;\\/div&gt;<br \\/><br \\/>&lt;?php } ?&gt;<br \\/><\\/pre>\\n<p>This will display the four boxes and their content.<\\/p>\",\"description_meta_tag\":\"\"}}',29,1,'2008-08-07 11:37:14'),(232,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p><em>admin_index.ctp<\\/em> could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the <em>index.ctp<\\/em> file:<\\/p>\\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br \\/><br \\/>&lt;div class=\\\"home-box\\\"&gt;<br \\/>    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br \\/>&lt;\\/div&gt;<br \\/><br \\/>&lt;?php } ?&gt;<br \\/><\\/pre>\\n<p>This will display the four boxes and their content.<\\/p>\\n<p>Now <strong>copy<\\/strong> the <em>\\/wildflower\\/views\\/layout\\/admin_default.ctp<\\/em> to <em>\\/app\\/views\\/layouts\\/<\\/em> . There you can modify the file and add a link to our new home page boxes admin screen to the admin main menu. I\'ll leave this step to you.<\\/p>\\n<h4>Step 3: Routes<\\/h4>\\n<p>Finally we need to let Cake know that we want to display the HomePageBoxesController::index() action when browsing to <em>your-site.com <\\/em>root.<\\/p>\",\"description_meta_tag\":\"\"}}',30,1,'2008-08-07 11:42:46'),(233,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p><em>admin_index.ctp<\\/em> could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the <em>index.ctp<\\/em> file:<\\/p>\\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br \\/><br \\/>&lt;div class=\\\"home-box\\\"&gt;<br \\/>    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br \\/>&lt;\\/div&gt;<br \\/><br \\/>&lt;?php } ?&gt;<br \\/><\\/pre>\\n<p>This will display the four boxes and their content.<\\/p>\\n<p>Now <strong>copy<\\/strong> the <em>\\/wildflower\\/views\\/layout\\/admin_default.ctp<\\/em> to <em>\\/app\\/views\\/layouts\\/<\\/em> . There you can modify the file and add a link to our new home page boxes admin screen to the admin main menu. I\'ll leave this step to you.<\\/p>\\n<h4>Step 3: Routes<\\/h4>\\n<p>Finally we need to let Cake know that we want to display the HomePageBoxesController::index() action when browsing to <em>your-site.com <\\/em>root. Modify the first to routes in <em>app\\/config\\/routes.php<\\/em> like this:<\\/p>\\n<pre>Router::connect(\'\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/>Router::connect(\'\\/app\\/webroot\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/><\\/pre>\\n<p>Maybe you\'re wondering about the second route. On some server configurations Cake incorrectly detects the site root (\\/) as <em>\\/app\\/webroot<\\/em> . This fixes it. If you don\'t experience this problem (the home page works fine without the second route) you can remove the route.<\\/p>\",\"description_meta_tag\":\"\"}}',31,1,'2008-08-07 12:00:10'),(234,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p><em>admin_index.ctp<\\/em> could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the <em>index.ctp<\\/em> file:<\\/p>\\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br \\/><br \\/>&lt;div class=\\\"home-box\\\"&gt;<br \\/>    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br \\/>&lt;\\/div&gt;<br \\/><br \\/>&lt;?php } ?&gt;<br \\/><\\/pre>\\n<p>This will display the four boxes and their content.<\\/p>\\n<p>Now <strong>copy<\\/strong> the <em>\\/wildflower\\/views\\/layout\\/admin_default.ctp<\\/em> to <em>\\/app\\/views\\/layouts\\/<\\/em> . There you can modify the file and add a link to our new home page boxes admin screen to the admin main menu. I\'ll leave this step to you.<\\/p>\\n<h4>Step 3: Routes<\\/h4>\\n<p>Finally we need to let Cake know that we want to display the HomePageBoxesController::index() action when browsing to <em>your-site.com <\\/em>root. Modify the first two routes in <em>app\\/config\\/routes.php<\\/em> like this:<\\/p>\\n<pre>Router::connect(\'\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/>Router::connect(\'\\/app\\/webroot\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/><\\/pre>\\n<p>Maybe you\'re wondering about the second route. On some server configurations Cake incorrectly detects the site root (\\/) as <em>\\/app\\/webroot<\\/em> . This fixes it. If you don\'t experience this problem (the home page works fine without the second route) you can remove the route.<\\/p>\",\"description_meta_tag\":\"\"}}',32,1,'2008-08-07 12:00:52'),(235,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p><em>admin_index.ctp<\\/em> could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the <em>index.ctp<\\/em> file:<\\/p>\\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br \\/><br \\/>&lt;div class=\\\"home-box\\\"&gt;<br \\/>    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br \\/>&lt;\\/div&gt;<br \\/><br \\/>&lt;?php } ?&gt;<br \\/><\\/pre>\\n<p>This will display the four boxes and their content.<\\/p>\\n<p>Now <strong>copy<\\/strong> the <em>\\/wildflower\\/views\\/layout\\/admin_default.ctp<\\/em> to <em>\\/app\\/views\\/layouts\\/<\\/em> . There you can modify the file and add a link to our new home page boxes admin screen to the admin main menu. I\'ll leave this step to you. Remember: <strong>Every Wildflower view file that you mirror inside your app\\/views will be used instead of the original<\\/strong>.<\\/p>\\n<h4>Step 3: Routes<\\/h4>\\n<p>Finally we need to let Cake know that we want to display the HomePageBoxesController::index() action when browsing to <em>your-site.com <\\/em>root. Modify the first two routes in <em>app\\/config\\/routes.php<\\/em> like this:<\\/p>\\n<pre>Router::connect(\'\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/>Router::connect(\'\\/app\\/webroot\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/><\\/pre>\\n<p>Maybe you\'re wondering about the second route. On some server configurations Cake incorrectly detects the site root (\\/) as <em>\\/app\\/webroot<\\/em> . This fixes it. If you don\'t experience this problem (the home page works fine without the second route) you can remove the route.<\\/p>\\n<p>I hope this<\\/p>\",\"description_meta_tag\":\"\"}}',33,1,'2008-08-07 12:02:18'),(236,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes the following is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p><em>admin_index.ctp<\\/em> could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the <em>index.ctp<\\/em> file:<\\/p>\\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br \\/><br \\/>&lt;div class=\\\"home-box\\\"&gt;<br \\/>    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br \\/>&lt;\\/div&gt;<br \\/><br \\/>&lt;?php } ?&gt;<br \\/><\\/pre>\\n<p>This will display the four boxes and their content.<\\/p>\\n<p>Now <strong>copy<\\/strong> the <em>\\/wildflower\\/views\\/layout\\/admin_default.ctp<\\/em> to <em>\\/app\\/views\\/layouts\\/<\\/em> . There you can modify the file and add a link to our new home page boxes admin screen to the admin main menu. I\'ll leave this step to you. Remember: <strong>Every Wildflower view file that you mirror inside your app\\/views will be used instead of the original<\\/strong>.<\\/p>\\n<h4>Step 3: Routes<\\/h4>\\n<p>Finally we need to let Cake know that we want to display the HomePageBoxesController::index() action when browsing to <em>your-site.com <\\/em>root. Modify the first two routes in <em>app\\/config\\/routes.php<\\/em> like this:<\\/p>\\n<pre>Router::connect(\'\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/>Router::connect(\'\\/app\\/webroot\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/><\\/pre>\\n<p>Maybe you\'re wondering about the second route. On some server configurations Cake incorrectly detects the site root (\\/) as <em>\\/app\\/webroot<\\/em> . This fixes it. If you don\'t experience this problem (the home page works fine without the second route) you can remove the route.<\\/p>\\n<p>As you can see, Wildflower enables you to use all the CakePHP power together with the out of the box functionality.<\\/p>\",\"description_meta_tag\":\"\"}}',34,1,'2008-08-07 12:03:47'),(237,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes, <strong>the following<\\/strong> is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\n<h3>Who is it for?<\\/h3>\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\n<ul>\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\n<li>RESTful architecture.<\\/li>\\n<li>Unit testing.<\\/li>\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\n<\\/ul>\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\n<h3>Requirements<\\/h3>\\n<ul>\\n<li>Apache web server with mod_rewrite<\\/li>\\n<li>PHP 5.2+<\\/li>\\n<li>MySQL 4.1+<\\/li>\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\n<\\/ul>\\n<h3>Fresh installation<\\/h3>\\n<ol>\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\n<\\/ol>\\n<h3>Installing to an existing CakePHP application<\\/h3>\\n<ol>\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\n<\\/ol>\\n<h3>Basic principles<\\/h3>\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\n<ul>\\n<li>Content managed \\\"static\\\" pages<\\/li>\\n<li>Contact form<\\/li>\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\n<\\/ul>\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\n<h4>Step 1: Create a new database table<\\/h4>\\n<p>todo.<\\/p>\\n<h4>Step 2: Create the MVC files<\\/h4>\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\n<p><em>admin_index.ctp<\\/em> could look like this:<\\/p>\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the <em>index.ctp<\\/em> file:<\\/p>\\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br \\/><br \\/>&lt;div class=\\\"home-box\\\"&gt;<br \\/>    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br \\/>&lt;\\/div&gt;<br \\/><br \\/>&lt;?php } ?&gt;<br \\/><\\/pre>\\n<p>This will display the four boxes and their content.<\\/p>\\n<p>Now <strong>copy<\\/strong> the <em>\\/wildflower\\/views\\/layout\\/admin_default.ctp<\\/em> to <em>\\/app\\/views\\/layouts\\/<\\/em> . There you can modify the file and add a link to our new home page boxes admin screen to the admin main menu. I\'ll leave this step to you. Remember: <strong>Every Wildflower view file that you mirror inside your app\\/views will be used instead of the original<\\/strong>.<\\/p>\\n<h4>Step 3: Routes<\\/h4>\\n<p>Finally we need to let Cake know that we want to display the HomePageBoxesController::index() action when browsing to <em>your-site.com <\\/em>root. Modify the first two routes in <em>app\\/config\\/routes.php<\\/em> like this:<\\/p>\\n<pre>Router::connect(\'\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/>Router::connect(\'\\/app\\/webroot\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/><\\/pre>\\n<p>Maybe you\'re wondering about the second route. On some server configurations Cake incorrectly detects the site root (\\/) as <em>\\/app\\/webroot<\\/em> . This fixes it. If you don\'t experience this problem (the home page works fine without the second route) you can remove the route.<\\/p>\\n<p>As you can see, Wildflower enables you to use all the CakePHP power together with the out of the box functionality.<\\/p>\",\"description_meta_tag\":\"\"}}',35,1,'2008-08-07 12:04:39'),(238,'page',157,'{\"Page\":{\"title\":\"test page\"}}',1,1,'2008-08-08 18:21:24'),(239,'page',157,'{\"Page\":{\"title\":\"test page\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-08-08 18:21:36'),(240,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders123<br \\/><\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',24,1,'2008-08-08 18:26:19'),(241,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders1234<br \\/><\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',25,1,'2008-08-08 18:26:22'),(242,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders<br \\/><\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',26,1,'2008-08-08 18:26:31'),(243,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>A new revision should be added to the rev list after AJAX save<\\/li>\\n<li>Shift+Tab from withing TinyMCE<\\/li>\\n<li>Image browser CSS rf &amp; IE7 fixing<\\/li>\\n<li>Image browser can be open multiple times and get\'s fcked up<\\/li>\\n<li>I deleted a comment an another one got deleted<\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',27,1,'2008-08-08 22:22:31'),(244,'page',158,'{\"Page\":{\"title\":\"Wf is the best\"}}',1,1,'2008-08-08 22:26:56'),(245,'page',158,'{\"Page\":{\"title\":\"Wf is the best\",\"content\":\"<p>1234 54534<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-08-11 11:39:02'),(246,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Revision when a page is created is not needed since it has no body.<\\/li>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Revision list should be rolled down when viewing a revision and the current rev should be marked<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>A new revision should be added to the rev list after AJAX save<\\/li>\\n<li>Shift+Tab from withing TinyMCE<\\/li>\\n<li>Image browser CSS rf &amp; IE7 fixing<\\/li>\\n<li>Image browser can be open multiple times and get\'s fcked up<\\/li>\\n<li>I deleted a comment an another one got deleted<\\/li>\\n<li>Preview does not render home template<\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',28,1,'2008-08-11 11:59:19'),(247,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world <a href=\\\"#title\\\">how<\\/a> are we today.<\\/p>\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<\\/h2>\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This <span style=\\\"color: #ff6600;\\\">CSS<\\/span> file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',21,1,'2008-08-11 12:11:17'),(248,'page',64,'{\"Page\":{\"title\":\"Code, code, code\",\"content\":\"<p class=\\\"cake-debug\\\">Hello world <a href=\\\"#title\\\">how<\\/a> are we today.<\\/p>\\r\\n<h2 class=\\\"cake-debug\\\">Heading &lt;h2&gt;<\\/h2>\\r\\n<p style=\\\"padding-left: 30px;\\\">This option enables you to specify a custom CSS file that extends the theme content <span style=\\\"background-color: #ff9900;\\\">CSS<\\/span>. This <span style=\\\"color: #ff6600;\\\">CSS<\\/span> file is the one used within the editor (the editable area). This option can also be a comma separated list of URLs.<\\/p>\\r\\n<p class=\\\"cake-debug\\\">If you specify a relative path, it is resolved in relation to the URL of the (HTML) file that includes TinyMCE, NOT relative to TinyMCE itself.<\\/p>\\r\\n<p class=\\\"cake-debug\\\"><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><br \\/><span style=\\\"text-decoration: line-through;\\\">strike me<\\/span><\\/p>\",\"description_meta_tag\":\"\"}}',22,1,'2008-08-11 12:11:19'),(249,'post',1,'{\"Post\":{\"title\":\"A shiny new post 45\",\"content\":\"<div id=\\\"lipsum\\\">\\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In imperdiet odio in augue. Sed pharetra. Nullam faucibus odio. Nam rhoncus tristique augue. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer congue dapibus metus. Phasellus sed elit sodales orci iaculis tincidunt. Duis hendrerit, nulla eu hendrerit fermentum, diam sapien commodo enim, sed rutrum purus sapien sed pede. Phasellus vitae quam. Morbi aliquam, leo vitae consectetuer consectetuer, ligula diam volutpat eros, imperdiet egestas nulla tortor ac dui. Etiam feugiat, dui nec pharetra pharetra, erat augue vulputate sapien, ut tristique lacus felis at eros. Pellentesque eu erat. Nullam aliquet mollis dolor. Ut est orci, tempus pellentesque, semper sit amet, scelerisque in, quam. Aliquam consequat, orci nec ullamcorper condimentum, nibh ligula dictum nulla, eget pulvinar velit lacus sit amet nulla. Etiam semper faucibus mi. Aenean nunc sapien, venenatis vitae, dapibus sit amet, auctor non, lacus. Phasellus porttitor ante sit amet turpis. Vestibulum nec erat. Maecenas eros.<\\/p>\\n<p>Nullam quis nulla non sapien interdum varius. Cras hendrerit elementum leo. Fusce tincidunt, justo eu eleifend elementum, ante arcu blandit dolor, quis ullamcorper dui tellus sit amet quam. Vestibulum vulputate. Morbi mi odio, consectetuer ut, vulputate vitae, tristique ut, ipsum. Donec ipsum tortor, pulvinar a, pulvinar eget, commodo non, odio. Nullam dolor. Aliquam erat volutpat. Phasellus libero. Vivamus luctus lobortis libero. Ut ut elit. Sed elementum quam nec arcu. Nam id tellus non odio fermentum convallis. Nam a lacus.<\\/p>\\n<p>Phasellus ante arcu, gravida a, lobortis sit amet, volutpat non, velit. Nulla consectetuer quam gravida nulla. Integer eu purus. Morbi sit amet nunc. Mauris vehicula lacus ac lectus. Proin tortor nisl, faucibus non, molestie nec, tincidunt non, justo. Suspendisse massa lectus, hendrerit aliquam, elementum et, iaculis non, nunc. Etiam non dui. Morbi gravida massa sollicitudin ipsum. Suspendisse magna ante, facilisis ac, sagittis et, placerat et, diam. Fusce facilisis, nulla ac accumsan facilisis, mi nisi tristique quam, malesuada pulvinar neque leo ut augue. Mauris dui.<\\/p>\\n<p>Etiam nec risus at leo ullamcorper lobortis. In rhoncus massa ac velit. Nullam mollis consequat ligula. Integer iaculis, enim sed cursus hendrerit, neque dolor hendrerit erat, dignissim egestas quam quam vel quam. Etiam tellus libero, molestie non, mattis in, venenatis sed, dui. Proin non nisl ut massa ullamcorper interdum. Aliquam erat volutpat. Sed gravida. Quisque quis magna. Quisque non metus. Nullam euismod suscipit elit. Vivamus quis risus. Phasellus ut lectus. Nunc velit sem, viverra sed, convallis eu, convallis a, nisl. Maecenas bibendum orci in enim. Sed orci. Nullam adipiscing pellentesque purus. Sed risus orci, consequat nec, ornare sed, condimentum semper, mi. Fusce hendrerit, justo non volutpat pretium, neque mauris placerat est, id pretium mauris libero id eros.<\\/p>\\n<p>Sed risus mi, vestibulum ac, tincidunt at, condimentum id, tortor. Donec non mauris sed leo auctor auctor. Nullam facilisis. Quisque eu ipsum. Donec quis sem. Morbi rutrum magna in justo. Vestibulum eu orci. Praesent placerat, ipsum eget bibendum vulputate, velit dolor ultrices metus, tempus congue est lorem a eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nam consectetuer erat et urna.<\\/p>\\n<\\/div>\",\"description_meta_tag\":\"\"}}',4,1,'2008-08-11 12:20:20'),(250,'post',1,'{\"Post\":{\"title\":\"A shiny new post 45\",\"content\":\"<div id=\\\"lipsum\\\">\\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In imperdiet odio in augue. Sed pharetra. Nullam faucibus odio. Nam rhoncus tristique augue. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer congue dapibus metus. Phasellus sed elit sodales orci iaculis tincidunt. Duis hendrerit, nulla eu hendrerit fermentum, diam sapien commodo enim, sed rutrum purus sapien sed pede. Phasellus vitae quam. Morbi aliquam, leo vitae consectetuer consectetuer, ligula diam volutpat eros, imperdiet egestas nulla tortor ac dui. Etiam feugiat, dui nec pharetra pharetra, erat augue vulputate sapien, ut tristique lacus felis at eros. Pellentesque eu erat. Nullam aliquet mollis dolor. Ut est orci, tempus pellentesque, semper sit amet, scelerisque in, quam. Aliquam consequat, orci nec ullamcorper condimentum, nibh ligula dictum nulla, eget pulvinar velit lacus sit amet nulla. Etiam semper faucibus mi. Aenean nunc sapien, venenatis vitae, dapibus sit amet, auctor non, lacus. Phasellus porttitor ante sit amet turpis. Vestibulum nec erat. Maecenas eros.<\\/p>\\n<p>Nullam quis nulla non sapien interdum varius. Cras hendrerit elementum leo. Fusce tincidunt, justo eu eleifend elementum, ante arcu blandit dolor, quis ullamcorper dui tellus sit amet quam. Vestibulum vulputate. Morbi mi odio, consectetuer ut, vulputate vitae, tristique ut, ipsum. Donec ipsum tortor, pulvinar a, pulvinar eget, commodo non, odio. Nullam dolor. Aliquam erat volutpat. Phasellus libero. Vivamus luctus lobortis libero. Ut ut elit. Sed elementum quam nec arcu. Nam id tellus non odio fermentum convallis. Nam a lacus.<\\/p>\\n<p>Phasellus ante arcu, gravida a, lobortis sit amet, volutpat non, velit. Nulla consectetuer quam gravida nulla. Integer eu purus. Morbi sit amet nunc. Mauris vehicula lacus ac lectus. Proin tortor nisl, faucibus non, molestie nec, tincidunt non, justo. Suspendisse massa lectus, hendrerit aliquam, elementum et, iaculis non, nunc. Etiam non dui. Morbi gravida massa sollicitudin ipsum. Suspendisse magna ante, facilisis ac, sagittis et, placerat et, diam. Fusce facilisis, nulla ac accumsan facilisis, mi nisi tristique quam, malesuada pulvinar neque leo ut augue. Mauris dui.<\\/p>\\n<p>Etiam nec risus at leo ullamcorper lobortis. In rhoncus massa ac velit. Nullam mollis consequat ligula. Integer iaculis, enim sed cursus hendrerit, neque dolor hendrerit erat, dignissim egestas quam quam vel quam. Etiam tellus libero, molestie non, mattis in, venenatis sed, dui. Proin non nisl ut massa ullamcorper interdum. Aliquam erat volutpat. Sed gravida. Quisque quis magna. Quisque non metus. Nullam euismod suscipit elit. Vivamus quis risus. Phasellus ut lectus. Nunc velit sem, viverra sed, convallis eu, convallis a, nisl. Maecenas bibendum orci in enim. Sed orci. Nullam adipiscing pellentesque purus. Sed risus orci, consequat nec, ornare sed, condimentum semper, mi. Fusce hendrerit, justo non volutpat pretium, neque mauris placerat est, id pretium mauris libero id eros.<\\/p>\\n<p>Sed risus mi, vestibulum ac, tincidunt at, condimentum id, tortor. Donec non mauris sed leo auctor auctor. Nullam facilisis. Quisque eu ipsum. Donec quis sem. Morbi rutrum magna in justo. Vestibulum eu orci. Praesent placerat, ipsum eget bibendum vulputate, velit dolor ultrices metus, tempus congue est lorem a eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nam consectetuer erat et urna.<\\/p>\\n<\\/div>\",\"description_meta_tag\":\"bla bla bla\"}}',5,1,'2008-08-11 12:38:00'),(251,'post',4,'{\"Post\":{\"title\":\"Gonna tame the post edit\",\"content\":\"<p>Ola lala. Change some pictures.<\\/p>\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/tea43_v1_wide.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/The_night_is_coming-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',4,1,'2008-08-11 12:54:08'),(252,'post',4,'{\"Post\":{\"title\":\"Gonna tame the post edit\",\"content\":\"<p>Ola lala. 123<\\/p>\\r\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Good_Vibrations-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/The_night_is_coming-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',5,1,'2008-08-11 12:54:53'),(253,'post',21,'{\"Post\":{\"title\":\"Today I\'ve build a lot\"}}',1,1,'2008-08-11 18:01:03'),(254,'post',21,'{\"Post\":{\"title\":\"Today I\'ve build a lot\",\"content\":\"<p>It\'s true.<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-08-11 18:01:25'),(255,'page',157,'{\"Page\":{\"title\":\"test page\",\"content\":\"<p>I want candy!<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-08-12 16:43:05'),(256,'page',53,'{\"Page\":{\"title\":\"Feature tour\",\"content\":\"<h3>Ease of use<\\/h3>\\n<p>The administration interface is optimized for the ease of use. When editing a page or a post, the integrated WYSIWYG editor automatically resizes to fit the user\'s screen height.<\\/p>\\n<h3>File manager<\\/h3>\\n<p>Upload any file type. You can categorize your uploads using tags.<\\/p>\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Igaer-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Step_forward_little_tommy-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\\n<h3>Revisions<\\/h3>\\n<p>Every change you do to a page or a post is remembered and you can go back to it. No more lost content.<\\/p>\",\"description_meta_tag\":\"\"}}',13,1,'2008-08-17 06:21:26'),(257,'page',116,'{\"Page\":{\"title\":\"TODO, Enhancements\",\"content\":\"<ul>\\n<li>Add keyboard shortcuts - like alt-A go to index...etc.<br \\/><\\/li>\\n<li>Google sitemaps generation<\\/li>\\n<li>SWFupload<\\/li>\\n<li>Password strength check from Wordpress<\\/li>\\n<li>Shift click on list to select more items<\\/li>\\n<li>Pages list drag and drop<\\/li>\\n<li>JLM compression and caching<\\/li>\\n<li>File manager folders<\\/li>\\n<\\/ul>\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/The_night_is_coming-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',27,1,'2008-08-17 06:32:32'),(258,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>A new revision should be added to the rev list after AJAX save<\\/li>\\n<li>Shift+Tab from withing TinyMCE<\\/li>\\n<li>Image browser CSS rf &amp; IE7 fixing<\\/li>\\n<li>Image browser can be open multiple times and get\'s fcked up<\\/li>\\n<li>I deleted a comment an another one got deleted<\\/li>\\n<li>Preview does not render home template<\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',29,1,'2008-08-17 07:33:43'),(259,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>Image browser CSS rf &amp; IE7 fixing<\\/li>\\n<li>Image browser can be open multiple times and get\'s fcked up<\\/li>\\n<li>I deleted a comment an another one got deleted<\\/li>\\n<li>Preview does not render home template<\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',30,1,'2008-08-17 07:34:28'),(260,'post',1,'{\"Post\":{\"title\":\"There are not many posts out there\",\"content\":\"<div id=\\\"lipsum\\\">\\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In imperdiet odio in augue. Sed pharetra. Nullam faucibus odio. Nam rhoncus tristique augue. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer congue dapibus metus. Phasellus sed elit sodales orci iaculis tincidunt. Duis hendrerit, nulla eu hendrerit fermentum, diam sapien commodo enim, sed rutrum purus sapien sed pede. Phasellus vitae quam. Morbi aliquam, leo vitae consectetuer consectetuer, ligula diam volutpat eros, imperdiet egestas nulla tortor ac dui. Etiam feugiat, dui nec pharetra pharetra, erat augue vulputate sapien, ut tristique lacus felis at eros. Pellentesque eu erat. Nullam aliquet mollis dolor. Ut est orci, tempus pellentesque, semper sit amet, scelerisque in, quam. Aliquam consequat, orci nec ullamcorper condimentum, nibh ligula dictum nulla, eget pulvinar velit lacus sit amet nulla. Etiam semper faucibus mi. Aenean nunc sapien, venenatis vitae, dapibus sit amet, auctor non, lacus. Phasellus porttitor ante sit amet turpis. Vestibulum nec erat. Maecenas eros.<\\/p>\\n<p>Nullam quis nulla non sapien interdum varius. Cras hendrerit elementum leo. Fusce tincidunt, justo eu eleifend elementum, ante arcu blandit dolor, quis ullamcorper dui tellus sit amet quam. Vestibulum vulputate. Morbi mi odio, consectetuer ut, vulputate vitae, tristique ut, ipsum. Donec ipsum tortor, pulvinar a, pulvinar eget, commodo non, odio. Nullam dolor. Aliquam erat volutpat. Phasellus libero. Vivamus luctus lobortis libero. Ut ut elit. Sed elementum quam nec arcu. Nam id tellus non odio fermentum convallis. Nam a lacus.<\\/p>\\n<p>Phasellus ante arcu, gravida a, lobortis sit amet, volutpat non, velit. Nulla consectetuer quam gravida nulla. Integer eu purus. Morbi sit amet nunc. Mauris vehicula lacus ac lectus. Proin tortor nisl, faucibus non, molestie nec, tincidunt non, justo. Suspendisse massa lectus, hendrerit aliquam, elementum et, iaculis non, nunc. Etiam non dui. Morbi gravida massa sollicitudin ipsum. Suspendisse magna ante, facilisis ac, sagittis et, placerat et, diam. Fusce facilisis, nulla ac accumsan facilisis, mi nisi tristique quam, malesuada pulvinar neque leo ut augue. Mauris dui.<\\/p>\\n<p>Etiam nec risus at leo ullamcorper lobortis. In rhoncus massa ac velit. Nullam mollis consequat ligula. Integer iaculis, enim sed cursus hendrerit, neque dolor hendrerit erat, dignissim egestas quam quam vel quam. Etiam tellus libero, molestie non, mattis in, venenatis sed, dui. Proin non nisl ut massa ullamcorper interdum. Aliquam erat volutpat. Sed gravida. Quisque quis magna. Quisque non metus. Nullam euismod suscipit elit. Vivamus quis risus. Phasellus ut lectus. Nunc velit sem, viverra sed, convallis eu, convallis a, nisl. Maecenas bibendum orci in enim. Sed orci. Nullam adipiscing pellentesque purus. Sed risus orci, consequat nec, ornare sed, condimentum semper, mi. Fusce hendrerit, justo non volutpat pretium, neque mauris placerat est, id pretium mauris libero id eros.<\\/p>\\n<p>Sed risus mi, vestibulum ac, tincidunt at, condimentum id, tortor. Donec non mauris sed leo auctor auctor. Nullam facilisis. Quisque eu ipsum. Donec quis sem. Morbi rutrum magna in justo. Vestibulum eu orci. Praesent placerat, ipsum eget bibendum vulputate, velit dolor ultrices metus, tempus congue est lorem a eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nam consectetuer erat et urna.<\\/p>\\n<\\/div>\",\"description_meta_tag\":\"bla bla bla\"}}',6,1,'2008-08-17 09:22:37'),(261,'page',159,'{\"Page\":{\"title\":\"delete me\"}}',1,1,'2008-08-17 09:36:37'),(262,'page',159,'{\"Page\":{\"title\":\"delete me\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-08-17 09:36:51'),(263,'page',160,'{\"Page\":{\"title\":\"delete me too\"}}',1,1,'2008-08-17 09:36:58'),(264,'post',21,'{\"Post\":{\"title\":\"Today I\'ve build a lot\",\"content\":\"<p>It\'s<img src=\\\"\\/wildflower\\/img\\/thumb\\/Little_World-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/> true.<img src=\\\"\\/wildflower\\/img\\/thumb\\/Fantasia-1600x1200.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-08-17 15:49:43'),(265,'post',22,'{\"Post\":{\"title\":\"lol post\"}}',1,1,'2008-08-17 17:59:26'),(266,'post',23,'{\"Post\":{\"title\":\"loool post\"}}',1,1,'2008-08-17 17:59:34'),(267,'post',24,'{\"Post\":{\"title\":\"hmm\"}}',1,1,'2008-08-17 17:59:55'),(268,'post',25,'{\"Post\":{\"title\":\"test\"}}',1,1,'2008-08-17 18:02:01'),(269,'page',161,'{\"Page\":{\"title\":\"test432\"}}',1,1,'2008-08-17 18:02:07'),(270,'post',24,'{\"Post\":{\"title\":\"hmm\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-08-17 18:08:57'),(271,'post',24,'{\"Post\":{\"title\":\"hmm\",\"content\":\"<p>123<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-08-17 18:09:46'),(272,'post',24,'{\"Post\":{\"title\":\"hmm\",\"content\":\"<p>1234<\\/p>\",\"description_meta_tag\":\"\"}}',4,1,'2008-08-17 18:09:54'),(273,'post',22,'{\"Post\":{\"title\":\"lol post\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-08-17 18:11:44'),(274,'post',8,'{\"Post\":{\"title\":\"use Base\",\"content\":\"<p>1234<\\/p>\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Fantasia-1600x1200.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',4,1,'2008-08-17 18:12:31'),(275,'page',162,'{\"Page\":{\"title\":\"Page ABC\"}}',1,1,'2008-08-17 18:25:31'),(276,'page',162,'{\"Page\":{\"title\":\"Page ABC\",\"content\":\"<p>page abbbbcccc<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-08-17 18:25:42'),(277,'page',158,'{\"Page\":{\"title\":\"Wf is the best\",\"content\":\"<p>1234 54534 asdas<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-08-17 18:41:32'),(278,'post',23,'{\"Post\":{\"title\":\"loool post\",\"content\":\"<p>dasdas<\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-08-17 18:41:40'),(279,'post',26,'{\"Post\":{\"title\":\"lala lala la\"}}',1,1,'2008-08-17 18:53:46'),(280,'post',24,'{\"Post\":{\"title\":\"hmm\",\"content\":\"<p>1234<img src=\\\"\\/wildflower\\/img\\/thumb\\/The_night_is_coming-1400x1050.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',5,1,'2008-08-20 19:08:02'),(281,'page',161,'{\"Page\":{\"title\":\"test432\",\"content\":\"<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Good_Vibrations-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Fantasia-1600x1200.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-08-26 16:47:14'),(282,'post',8,'{\"Post\":{\"title\":\"use Base\",\"content\":\"<p>1234<\\/p>\\r\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Fantasia-1600x1200.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',5,1,'2008-08-26 19:19:24'),(283,'post',8,'{\"Post\":{\"title\":\"use Base\",\"content\":\"<p>1234<\\/p>\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/Fantasia-1600x1200.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',6,1,'2008-08-26 19:19:28'),(284,'post',2,'{\"Post\":{\"title\":\"Another new post\",\"content\":\"<p>And now we do this... 13456<\\/p>\",\"description_meta_tag\":\"\"}}',5,1,'2008-08-26 19:26:49'),(285,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>Image browser CSS rf &amp; IE7 fixing<\\/li>\\n<li>Image browser can be open multiple times and get\'s fcked up<\\/li>\\n<li>I deleted a comment an another one got deleted<\\/li>\\n<li>Preview does not render home template<\\/li>\\n<li>Deleting a comment a clicking cancel deletes the comment!<\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',31,1,'2008-08-28 11:02:35'),(286,'page',79,'{\"Page\":{\"title\":\"A page about nothing\",\"content\":\"<p>Hello hello hello.<\\/p>\\r\\n<p>This is a brand new site. Arial.<\\/p>\\r\\n<p><img src=\\\"\\/uploads\\/Step_forward_little_tommy-1400x1050.jpg\\\" alt=\\\"\\\" \\/>Yop...<\\/p>\\r\\n<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/All_falls_down-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\\r\\n<p>&nbsp;<\\/p>\",\"description_meta_tag\":\"\"}}',6,1,'2008-08-28 13:07:58'),(287,'page',83,'{\"Page\":{\"title\":\"Bugs\",\"content\":\"<ul>\\n<li>Post can be viewed even if draft<\\/li>\\n<li>Add new category parent select box shows parents that should not be available<\\/li>\\n<li>When trying to edit a non existent page an SQL error is shown<\\/li>\\n<li>Public search should not search in drafts<\\/li>\\n<li>Upload::create does not fill short_name<\\/li>\\n<li>Image browser CSS rf &amp; IE7 fixing<\\/li>\\n<li>Image browser can be open multiple times and get\'s fcked up<\\/li>\\n<li>I deleted a comment an another one got deleted<\\/li>\\n<li>Preview does not render home template<\\/li>\\n<li>Deleting a comment a clicking cancel deletes the comment!<\\/li>\\n<\\/ul>\\n<p>Opera bugs:<\\/p>\\n<ul>\\n<li>live search cancel...<\\/li>\\n<\\/ul>\",\"description_meta_tag\":\"\"}}',32,1,'2008-09-02 13:12:55'),(288,'page',54,'{\"Page\":{\"title\":\"Documentation\",\"content\":\"<p><em>This section is slowly being filled up. Please be patient.<\\/em><\\/p>\\r\\n<p>Since a new release of Wildflower is on the way, with a lot of core changes, <strong>the following<\\/strong> is intended for the code you can <a href=\\\"http:\\/\\/code.google.com\\/p\\/wildflower\\/source\\/checkout\\\">check out from Google Code<\\/a>.<\\/p>\\r\\n<h3>Who is it for?<\\/h3>\\r\\n<p>Everyone who is able to deploy Wordpress should be able to get Wildflower up and running. However to fully enjoy and benefit from the features of this CMS, you should be competent in these areas (or willing to learn):<\\/p>\\r\\n<ul>\\r\\n<li>Code separation. Understand the difference between view and bussiness logic.<\\/li>\\r\\n<li>RESTful architecture.<\\/li>\\r\\n<li>Unit testing.<\\/li>\\r\\n<li>The heart of Wildflower is the CakePHP framework.<\\/li>\\r\\n<\\/ul>\\r\\n<p>This means this system is not so much for a typical PHP hacker, but for a programmer that is willing to learn and adopt the best practices and takes his profession seriously. Did I mention doing things in Cake is so much fun?<\\/p>\\r\\n<h3>Requirements<\\/h3>\\r\\n<ul>\\r\\n<li>Apache web server with mod_rewrite<\\/li>\\r\\n<li>PHP 5.2+<\\/li>\\r\\n<li>MySQL 4.1+<\\/li>\\r\\n<li>If you want to use the <a href=\\\"http:\\/\\/code.google.com\\/p\\/ruckusing\\/\\\">Ruckusing database migrations<\\/a> you need PEAR\'s MDB2 and Log packages<br \\/><\\/li>\\r\\n<\\/ul>\\r\\n<h3>Fresh installation<\\/h3>\\r\\n<ol>\\r\\n<li>Extract the archive. Place the <em>wildflower<\\/em> directory inside your web servers documents folder.<\\/li>\\r\\n<li>Create a new MySQL database (<em>utf8_unicode_ci<\\/em> collation is strongly recommented) and into this new database import the SQL file <em>wildflower\\/config\\/sql\\/wildflower.sql<\\/em>.<\\/li>\\r\\n<li>Edit the <em>app\\/config\\/database.php<\\/em> file with your database connection details.<\\/li>\\r\\n<li>You\'ve got a working copy of this site. You can start working on your project by modifying the application inside the <em>app<\\/em> directory. When a new release of Wildflower comes, you simply replace the <em>cake<\\/em>, <em>vendors<\\/em> and <em>wildflower<\\/em> directories.<\\/li>\\r\\n<\\/ol>\\r\\n<h3>Installing to an existing CakePHP application<\\/h3>\\r\\n<ol>\\r\\n<li>Extract the archive and place the <em>wildflower\\/wildflower<\\/em> directory inside your application root.<\\/li>\\r\\n<li>Just include the Wildflower <em>bootstrap.php<\\/em> file located at <em>\\/wildflower\\/config\\/bootstrap.php<\\/em> in your <em>\\/app\\/config\\/bootstrap.php<\\/em>.<\\/li>\\r\\n<li>Load the SQL dump file <em>app\\/config\\/sql\\/wildflower.sql<\\/em>&nbsp;into your database.<\\/li>\\r\\n<li>Set up some routes. Check the <em>wildflower\\/config\\/routes.php<\\/em> file for the default WF routes.<br \\/><\\/li>\\r\\n<\\/ol>\\r\\n<h3>Basic principles<\\/h3>\\r\\n<p>A modern website usually consist of \\\"static\\\" pages, news or blog sections, contact form, provides RSS feeds and a number of features, specific to the site\'s aim or goal. The idea of Wildflower is to provide this common functionality, with a polished and user friendly interface and enable the programmer to effectively code the remaining specific features of the site, fully exploiting the PHP rapid development framework--CakePHP.<\\/p>\\r\\n<p>Wildflower uses the additional MVC paths feature of the CakePHP framework. It sits in it\'s own directory inside the application root. This allows the user to create application specific controllers, models or views in her <em>\\/app<\\/em> directory. By mirroring any view file from the wildflower\\/views folder inside app\\/views you can override the default Wildflower files. This is a great way to customize any aspect of the CMS, especially extending the admin interface with additional sections or customizing existing ones to the site\'s needs without touching the original Wildflower code.<\\/p>\\r\\n<h3>A real world example of building a site with some custom functionality<\\/h3>\\r\\n<p>Imagine you want to build a simple site with the following requirements:<\\/p>\\r\\n<ul>\\r\\n<li>Content managed \\\"static\\\" pages<\\/li>\\r\\n<li>Contact form<\\/li>\\r\\n<li>Home page with four boxes with different content and each content managed<\\/li>\\r\\n<\\/ul>\\r\\n<p>The first two requirements you\'ve got out of the box. For the third one we\'ll create a new section in the admin interface and build our own model\\/view\\/controller that will handle the custom functionality.<\\/p>\\r\\n<h4>Step 1: Create a new database table<\\/h4>\\r\\n<p>todo.<\\/p>\\r\\n<h4>Step 2: Create the MVC files<\\/h4>\\r\\n<p>For this simple example we actually don\'t need to create any model file, since CakePHP supports <a href=\\\"http:\\/\\/www.littlehart.net\\/atthekeyboard\\/2008\\/08\\/05\\/dynamic-models-in-cakephp-12\\/\\\">dynamic models<\\/a>. So let\'s create our controller. We\'ll create a file in <em>app\\/controllers\\/<\\/em> called <em>home_page_boxes_controller.php<\\/em> and put some code into it:<\\/p>\\r\\n<pre>&lt;?php<br \\/>class HomePageBoxesController extends AppController {<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function beforeFilter() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; parent::beforeFilter();<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;pageTitle = \'Home\';<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/><br \\/>&nbsp;&nbsp;&nbsp; function admin_index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function admin_update() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; foreach ($this-&gt;data[\'HomePageBox\'] as $name =&gt; $content) {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = explode(\'-\', $name);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $id = intval(array_pop($id));<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $data[\'HomePageBox\'] = array(\'id\' =&gt; $id, \'content\' =&gt; $content);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;create($data);<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;HomePageBox-&gt;save(); <br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;redirect(array(\'action\' =&gt; \'index\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>&nbsp;&nbsp;&nbsp; function index() {<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $boxes = $this-&gt;HomePageBox-&gt;find(\'all\', \'id IN (1, 2, 3, 4)\');<br \\/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $this-&gt;set(compact(\'boxes\'));<br \\/>&nbsp;&nbsp;&nbsp; }<br \\/>&nbsp;&nbsp;&nbsp; <br \\/>}<br \\/><\\/pre>\\r\\n<p>This code handles populating the the homepage and the admin section with data and updating (saving) new content in the admin section. Let\'s create the view files. Create a new folder called <em>home_page_boxes<\\/em> under <em>app\\/views\\/<\\/em> . Under this folder add <em>admin_index.ctp<\\/em> and <em>index.ctp<\\/em> files.<\\/p>\\r\\n<p><em>admin_index.ctp<\\/em> could look like this:<\\/p>\\r\\n<pre>&lt;h2&gt;Homepage Boxes&lt;\\/h2&gt;<br \\/><br \\/>&lt;?php<br \\/>    echo $form-&gt;create(\'HomePageBox\', array(\'action\' =&gt; \'update\'));<br \\/>    <br \\/>    for ($i = 0; $i &lt; 4; $i++) {<br \\/>        echo <br \\/>        $form-&gt;input(\\\"content-{$boxes[$i][\'HomePageBox\'][\'id\']}\\\", <br \\/>            array(\'type\' =&gt; \'textbox\', <br \\/>                    \'value\' =&gt; $boxes[$i][\'HomePageBox\'][\'content\'], <br \\/>                    \'label\' =&gt; \'Box \' . ($i + 1), \'between\' =&gt; \'&lt;br \\/&gt;\', \'class\' =&gt; \'box-fck\')),<br \\/>        $form-&gt;submit(\'Save\');<br \\/>    }<br \\/>    <br \\/>    echo $form-&gt;end();<br \\/>?&gt;<br \\/><\\/pre>\\r\\n<p>This will create an admin page with four TinyMCE editors each handling one box. Let\'s take a look at the <em>index.ctp<\\/em> file:<\\/p>\\r\\n<pre>&lt;?php foreach ($boxes as $box) { ?&gt;<br \\/><br \\/>&lt;div class=\\\"home-box\\\"&gt;<br \\/>    &lt;?php echo $box[\'HomePageBox\'][\'content\'] ?&gt;<br \\/>&lt;\\/div&gt;<br \\/><br \\/>&lt;?php } ?&gt;<br \\/><\\/pre>\\r\\n<p>This will display the four boxes and their content.<\\/p>\\r\\n<p>Now <strong>copy<\\/strong> the <em>\\/wildflower\\/views\\/layout\\/admin_default.ctp<\\/em> to <em>\\/app\\/views\\/layouts\\/<\\/em> . There you can modify the file and add a link to our new home page boxes admin screen to the admin main menu. I\'ll leave this step to you. Remember: <strong>Every Wildflower view file that you mirror inside your app\\/views will be used instead of the original<\\/strong>.<\\/p>\\r\\n<h4>Step 3: Routes<\\/h4>\\r\\n<p>Finally we need to let Cake know that we want to display the HomePageBoxesController::index() action when browsing to <em>your-site.com <\\/em>root. Modify the first two routes in <em>app\\/config\\/routes.php<\\/em> like this:<\\/p>\\r\\n<pre>Router::connect(\'\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/>Router::connect(\'\\/app\\/webroot\\/\', array(\'controller\' =&gt; \'home_page_boxes\', \'action\' =&gt; \'index\'));<br \\/><\\/pre>\\r\\n<p>Maybe you\'re wondering about the second route. On some server configurations Cake incorrectly detects the site root (\\/) as <em>\\/app\\/webroot<\\/em> . This fixes it. If you don\'t experience this problem (the home page works fine without the second route) you can remove the route.<\\/p>\\r\\n<p>As you can see, Wildflower enables you to use all the CakePHP power together with the out of the box functionality.<\\/p>\",\"description_meta_tag\":\"\"}}',36,1,'2008-09-09 21:01:36'),(289,'post',27,'{\"Post\":{\"title\":\"my new post\"}}',1,1,'2008-09-09 21:04:11'),(290,'post',28,'{\"Post\":{\"title\":\"my new post\"}}',1,1,'2008-09-09 21:06:33'),(291,'page',163,'{\"Page\":{\"title\":\"my new page\"}}',1,1,'2008-09-09 21:06:38'),(292,'post',29,'{\"Post\":{\"title\":\"safari\"}}',1,1,'2008-09-09 21:06:49'),(293,'post',25,'{\"Post\":{\"title\":\"test\",\"content\":\"<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Good_Vibrations-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\",\"description_meta_tag\":\"\"}}',2,1,'2008-09-13 13:23:31'),(294,'post',25,'{\"Post\":{\"title\":\"test\",\"content\":\"<p><img src=\\\"\\/wildflower\\/img\\/thumb\\/vetton_ru_501.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><img src=\\\"\\/wildflower\\/img\\/thumb\\/Good_Vibrations-1440x900.jpg\\/120\\/120\\/1\\\" alt=\\\"\\\" \\/><\\/p>\\n<p>Abcdedfgh.<\\/p>\",\"description_meta_tag\":\"\"}}',3,1,'2008-09-13 13:25:44'),(295,'post',27,'{\"Post\":{\"title\":\"my new post\",\"content\":\"\",\"description_meta_tag\":\"\"}}',2,1,'2008-09-13 13:29:02');
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schema_info`
--

DROP TABLE IF EXISTS `schema_info`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `schema_info` (
  `version` int(11) unsigned NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `schema_info`
--

LOCK TABLES `schema_info` WRITE;
/*!40000 ALTER TABLE `schema_info` DISABLE KEYS */;
INSERT INTO `schema_info` VALUES (9);
/*!40000 ALTER TABLE `schema_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) collate utf8_unicode_ci NOT NULL,
  `value` text collate utf8_unicode_ci NOT NULL,
  `description` varchar(255) collate utf8_unicode_ci default NULL,
  `type` enum('text','textbox','select','checkbox','radio','password') collate utf8_unicode_ci NOT NULL,
  `label` varchar(255) collate utf8_unicode_ci default NULL,
  `order` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'site_name','Wildflower','','text',NULL,1),(2,'description','A CakePHP CMS','','textbox',NULL,2),(3,'home_page_id','52','Page that will be shown when visiting the site root.','select','Home page',3),(4,'contact_email','klevo@klevo.sk','You`ll receive notifications when somebody posts a comment or uses the contact form on this email address.','text','Contact email address',4),(5,'google_analytics_code','','','textbox',NULL,10),(6,'wordpress_api_key','','','text',NULL,9),(7,'smtp_server','','','text',NULL,6),(8,'smtp_username','','','text',NULL,7),(9,'smtp_password','','','text',NULL,8),(11,'email_delivery','debug',NULL,'select',NULL,5),(12,'cache','off',NULL,'select','Page and post caching',11);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sitemaps`
--

DROP TABLE IF EXISTS `sitemaps`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `sitemaps` (
  `id` int(11) NOT NULL auto_increment,
  `lft` int(11) NOT NULL,
  `rght` int(11) NOT NULL,
  `parent_id` int(11) default NULL,
  `loc` varchar(255) collate utf8_unicode_ci NOT NULL,
  `lastmod` datetime default NULL,
  `changefreq` enum('always','hourly','daily','weekly','monthly','yearly','never') collate utf8_unicode_ci default NULL,
  `priority` float default NULL,
  PRIMARY KEY  (`id`),
  KEY `lft` (`lft`,`rght`,`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Google Sitemap protocol compatible sitemap';
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `sitemaps`
--

LOCK TABLES `sitemaps` WRITE;
/*!40000 ALTER TABLE `sitemaps` DISABLE KEYS */;
/*!40000 ALTER TABLE `sitemaps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tags` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_uploads`
--

DROP TABLE IF EXISTS `tags_uploads`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tags_uploads` (
  `upload_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  KEY `tag_id` (`tag_id`),
  KEY `upload_id` (`upload_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tags_uploads`
--

LOCK TABLES `tags_uploads` WRITE;
/*!40000 ALTER TABLE `tags_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `uploads`
--

DROP TABLE IF EXISTS `uploads`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `uploads` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) collate utf8_unicode_ci NOT NULL,
  `title` varchar(255) collate utf8_unicode_ci NOT NULL,
  `mime` varchar(20) collate utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `mime` (`mime`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `uploads`
--

LOCK TABLES `uploads` WRITE;
/*!40000 ALTER TABLE `uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `login` varchar(255) collate utf8_unicode_ci NOT NULL,
  `password` char(40) collate utf8_unicode_ci NOT NULL,
  `email` varchar(255) collate utf8_unicode_ci NOT NULL,
  `name` varchar(255) collate utf8_unicode_ci default NULL,
  `cookie` varchar(255) collate utf8_unicode_ci default NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `cookie` (`cookie`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'admin','24c05ce1409afb5dad4c5bddeb924a4bc3ea00f5','admin@localhost.sk','Mr Admin','6d60c0bf-2983-0cd4-2dcd-57a3007ad70c','2008-07-11 14:24:43','2008-09-13 13:26:42');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2008-09-13 12:03:53
