<?php

class GalleryController extends AppController 
{
   var $name = 'Gallery';
   var $components = array('Flickr');
   var $uses = array();

   function index($id = null)
   {
      $this->set('page', ClassRegistry::init('Page')->findBySlug('gallery'));
    	
      $flickrId = $this->_siteSettings['flickr_id'];
      if (empty($flickrId))
      {
         $this->Session->setFlash('The gallery is not setup.');
         return;
      }
      
      $photosets = $this->flickr->photosets_getList($flickrId);
      $this->set('sets', $photosets);
   }

   function view($id = null)
   {
      $this->set('info', $this->flickr->photosets_getInfo($id));
      $photos = $this->flickr->photosets_getPhotos($id);
      foreach ($photos['photoset']['photo'] as $item)
      {
         $thumbs[] = $this->flickr->photos_getInfo($item['id'], $item['secret']);
      }
      $this->set('thumbs', $thumbs);
   }
}

?>
