<?php
class DocumentsController extends AppController {

	var $name = 'Documents';
	public $components = array('Session', 'Email');
	public $helpers = array('Form', 'Html', 'List', 'Tree', 'Text', 'Time');

	function beforeFilter() {
		parent::beforeFilter();
		
		// Upload limit information
        $postMaxSize = ini_get('post_max_size');
        $uploadMaxSize = ini_get('upload_max_filesize');
        $size = $postMaxSize;
        if ($uploadMaxSize < $postMaxSize) {
            $size = $uploadMaxSize;
        }
        $size = str_replace('M', 'MB', $size);
        $limits = "Maximum allowed file size: $size";
        $this->set('uploadLimits', $limits);
	}
	
	
	/**
    * Users overview
    * 
    */
   function admin_index() {
       $documents = $this->Document->findAll();
       $this->set(compact('documents'));
   }
   

	function admin_create() 
	{   
	   if (!empty($this->data) &&
           is_uploaded_file($this->data['Document']['File']['tmp_name'])) {
          $fileData = fread(fopen($this->data['Document']['File']['tmp_name'], "r"),
                                   $this->data['Document']['File']['size']);

          $this->data['Document']['name'] = $this->data['Document']['File']['name'];
          $this->data['Document']['type'] = $this->data['Document']['File']['type'];
          $this->data['Document']['size'] = $this->data['Document']['File']['size'];
          $this->data['Document']['data'] = $fileData;

          $this->Document->save($this->data);
				
		  $this->redirect(array('action' => 'admin_index'));
      }
      
	}
	
	/**
    * Edit document
    *
    * @param int $id
    */
   function admin_edit($id = null) 
   {
       $this->data = $this->Document->findById($id);
   }
   
   function admin_update() 
   {
       if ($this->Document->save($this->data)) 
       {
           return $this->redirect(array('action' => 'index'));
       }
       $this->render('admin_edit');
   }
   
   function login() 
   {
      if (!empty($this->data))
      {
         if ($this->data['Document']['username'] == $this->_siteSettings['document_username'] 
            and $this->data['Document']['password'] == $this->_siteSettings['document_password'])
         {
            // Expires in an hour
            $this->Session->write('documents.token', time() + 60 * 60);
            $this->redirect(array('action' => 'index'));
         }
         else
         {
            $this->Session->setFlash('Invalid username or password');
         }
      }
   }
   
	function index() 
	{
	   $token = $this->Session->read('documents.token');
	   if ($token < time())
	   {
	      $this->redirect(array('action' => 'login'));
	   }
	   $conditions = array('OR' => array('visible' => 1, 'visible_until >= CURDATE()'));
      $documents = $this->Document->find('all', compact('conditions'));
      $this->set(compact('documents'));
	}
	
	function create() 
	{   
	   if (!empty($this->data) &&
           is_uploaded_file($this->data['Document']['File']['tmp_name'])) {
          $fileData = fread(fopen($this->data['Document']['File']['tmp_name'], "r"),
                                   $this->data['Document']['File']['size']);

          $this->data['Document']['name'] = $this->data['Document']['File']['name'];
          $this->data['Document']['type'] = $this->data['Document']['File']['type'];
          $this->data['Document']['size'] = $this->data['Document']['File']['size'];
          $this->data['Document']['data'] = $fileData;
          $this->data['Document']['visible'] = 1;

          $this->Document->save($this->data);
          $this->notify_admin();
      }
      
	  $this->redirect(array('action' => 'index'));
	}
	
	function download() 
	{
       Configure::write('debug', 0);
 	   $id = $this->params['id'];
       $file = $this->Document->findById($id);
       
       header('Content-type: ' . $file['Document']['type']);
       header('Content-length: ' . $file['Document']['size']); // some people reported problems with this line (see the comments), commenting out this line helped in those cases
       header('Content-Disposition: attachment; filename="'.$file['Document']['name'].'"');
       echo $file['Document']['data'];

       exit;
   }
   
   function notify_admin()
   {
   		$email = Configure::read('AppSettings.contact_email');
   		$this->Email->to = $email;
		$this->Email->from = $email;
		$this->Email->replyTo = $email;
		$this->Email->subject = Configure::read('AppSettings.site_name') . ' new document uploaded';
		$this->Email->sendAs = 'text';
		$this->Email->template = 'document_upload';
    		
		$this->set('document', $this->data['Document']['description']);

		$this->Email->delivery = Configure::read('AppSettings.email_delivery');
		if ($this->Email->delivery == 'smtp') 
		{
			$this->Email->smtpOptions = array(
				'username' => Configure::read('AppSettings.smtp_username'),
				'password' => Configure::read('AppSettings.smtp_password'),
				'host' => Configure::read('AppSettings.smtp_server'),
				'port' => 25, // @TODO add port to settings
				'timeout' => 30
        		);
    	}
    		
    	$this->Email->send();
	}
}
?>
