<?php
App::uses('AppController', 'Controller');
/**
 * Teams Controller
 *
 * @property Team $Team
 */
class TeamsController extends AppController {


/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Team->recursive = 0;
		$this->set('teams', $this->paginate());
	}

/**
 * view method
 *
 * @param string $id
 * @return void
 */
	public function view($id = null) 
	{
		$this->Team->id = $id;
		if (!$this->Team->exists()) 
		{
			throw new NotFoundException(__('Invalid team'));
		}
		$this->set('team', $this->Team->read(null, $id));
	}

/**
 * add method
 *
 * @return void
 */
	public function add() 
	{
		if ($this->request->is('post')) 
		{
			$this->Team->create();
			if ($this->Team->save($this->request->data)) 
			{
				$this->Session->setFlash(__('The team has been saved'));
				$this->redirect(array('action' => 'index'));
			} 
			else 
			{
				$this->Session->setFlash(__('The team could not be saved. Please, try again.'));
			}
		}
		$leagues = $this->Team->League->find('list');
		$this->set(compact('leagues'));
	}

/**
 * edit method
 *
 * @param string $id
 * @return void
 */
	public function edit($id = null) 
	{
		$this->Team->id = $id;
		if (!$this->Team->exists()) 
		{
			throw new NotFoundException(__('Invalid team'));
		}
		if ($this->request->is('post') || $this->request->is('put')) 
		{
			if ($this->Team->save($this->request->data)) 
			{
				$this->Session->setFlash(__('The team has been saved'));
				$this->redirect(array('action' => 'index'));
			} 
			else 
			{
				$this->Session->setFlash(__('The team could not be saved. Please, try again.'));
			}
		} 
		else 
		{
			$this->request->data = $this->Team->read(null, $id);
		}
		$leagues = $this->Team->League->find('list');
		$this->set(compact('leagues'));
	}

/**
 * delete method
 *
 * @param string $id
 * @return void
 */
	public function delete($id = null) 
	{
		if (!$this->request->is('post')) 
		{
			throw new MethodNotAllowedException();
		}
		$this->Team->id = $id;
		if (!$this->Team->exists()) 
		{
			throw new NotFoundException(__('Invalid team'));
		}
		if ($this->Team->delete()) 
		{
			$this->Session->setFlash(__('Team deleted'));
			$this->redirect(array('action' => 'index'));
		}
		$this->Session->setFlash(__('Team was not deleted'));
		$this->redirect(array('action' => 'index'));
	}
}
