<?php
class PlayersController extends AppController {

	var $name = 'Players';
	var $helpers = array('Pdf');
	
	/**
	 * Email list
	 */
	function emails($mark=null)
	{
	   $this->layout = '';
	   
	   $limit = 500;
	   $conditions = array("email LIKE '%@%'", 'email_sent IS NULL');
	   $order = array('email');
	   $fields = array('DISTINCT email');
	   $this->set('players', $this->Player->find('all', compact('fields', 'conditions', 'order', 'limit')));  
	}

   /**
    * List of players
    */
	function index()
	{
      $conditions = array();
		$league_id = $this->Auth->user('default_league_id');
		if (isset($this->params['url']['q']))
		{
         $conditions[] = array(
         'OR' => array(
            sprintf("Player.last_name LIKE '%%%s%%'", $this->params['url']['q']),
            sprintf("Player.first_name LIKE '%%%s%%'", $this->params['url']['q'])
         )
         );
		}
		if ($league_id)
		{		
			$conditions[] = array(
				'Player.league_id' => $league_id,
			);
		}
		if ($conditions)
      {
         $this->paginate = compact('conditions');
      }
		$this->set('players', $this->paginate());
		
      if ($this->RequestHandler->isAjax())
      {
         $this->layout = 'ajax';
         $this->render('/elements/player_table');
         return;
      }
	
	}

   /**
    * A read-only view of a player
    * @param $id
    */
	function view($id = null) {
		if (!$id) {
			$this->Session->setFlash(sprintf(__('Invalid %s', true), 'player'));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('player', $this->Player->read(null, $id));
	}

   /**
    * Add a new player
    */
	function add() 
	{
	   // Get league list
	   $this->loadModel('League');
	   $this->set('leagues', $this->League->find('list'));

		if (!empty($this->data)) 
		{
			$this->Player->create();
			if ($this->Player->save($this->data)) 
			{
				$this->Session->setFlash(sprintf(__('%s %s has been saved', true), $this->data['Player']['first_name'], $this->data['Player']['last_name']));
				//$this->redirect(array('action' => 'index'));
			} 
			else 
			{
				$this->Session->setFlash(sprintf(__('The %s could not be saved. Please, try again.', true), 'player'));
				return;
			}
		}
		
	   // Default city to riverton
	   unset($this->data);
	   $this->data['Player']['city'] = 'Riverton';
	   $this->data['Player']['zip'] = '84065';
	   $this->data['Player']['league_id'] = $this->Auth->user('default_league_id');
	}

   /**
    * Edit a player
    * @param $id
    */
	function edit($id = null) 
	{
	   // Get league list
	   $this->loadModel('League');
	   $this->set('leagues', $this->League->find('list'));

		if (!$id && empty($this->data)) 
		{
			$this->Session->setFlash(sprintf(__('Invalid %s', true), 'player'));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) 
		{
			if ($this->Player->save($this->data)) 
			{
				$this->Session->setFlash(sprintf(__('%s %s has been saved', true), $this->data['Player']['first_name'], $this->data['Player']['last_name']));
				$this->redirect(array('action' => 'index'));
			} 
			else 
			{
				$this->Session->setFlash(sprintf(__('The %s could not be saved. Please, try again.', true), 'player'));
			}
		}
		if (empty($this->data)) 
		{
			$this->data = $this->Player->read(null, $id);
			$this->data['Player']['birthdate'] = date('n/j/Y', strtotime($this->data['Player']['birthdate']));
		}
	}

   /**
    * Delete a player
    */
	function delete($id = null) 
	{
		if (!$id) {
			$this->Session->setFlash(sprintf(__('Invalid id for %s', true), 'player'));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->Player->delete($id)) {
			$this->Session->setFlash(sprintf(__('%s deleted', true), 'Player'));
			$this->redirect(array('action'=>'index'));
		}
		$this->Session->setFlash(sprintf(__('%s was not deleted', true), 'Player'));
		$this->redirect(array('action' => 'index'));
	}
	
	/**
	 * Ajax look up of last year's players.
	 */
	function search()
	{
      if ($this->RequestHandler->isAjax())
      {
         $this->layout = 'ajax';
      }
      
      $name = explode(' ', $this->params['url']['q']);
      
      $fields = array(
         'LastYearPlayer.first_name',
         'LastYearPlayer.last_name',
         'LastYearPlayer.birthdate',
         'LastYearPlayer.address',
         'LastYearPlayer.city',
         'LastYearPlayer.zip',
         'LastYearPlayer.dads_name',
         'LastYearPlayer.moms_name',
         'LastYearPlayer.day_phone',
         'LastYearPlayer.evening_phone',
         'LastYearPlayer.cell_phone',
         'LastYearPlayer.email',
         'LastYearPlayer.last_team'
         );
      $conditions = array();
      foreach ($name as $n)
      {
			$conditions[] = array(
				'OR' => array(
				sprintf("LastYearPlayer.last_name LIKE '%%%s%%'", $n),
				sprintf("LastYearPlayer.first_name LIKE '%%%s%%'", $n)
			));
		}
		$order = array('LastYearPlayer.last_name', 'LastYearPlayer.first_name');
		$limit = '';
		if (isset($this->params['url']['limit']))
		{
			$limit = $this->params['url']['limit'];
		}
		
		$this->loadModel('LastYearPlayer');
		$this->set('players', $this->LastYearPlayer->find('all', compact('fields', 'conditions', 'order', 'limit')));
	}
	
	/**
	 * List of players for tryout
	 */
	function tryout($type=null, $league_id=0)
	{
	   if (empty($league_id))
	   {
	      $league_id = $this->Auth->user('default_league_id');
	   }
	   if (!empty($this->data))
      {
         $league_id = $this->data['Player']['league_id'];
      }

      if ($league_id > 0)
      {
         $conditions = array('Player.league_id'=> $league_id, 'Player.tryout'=> 1);
         $order = array('last_name DESC', 'first_name DESC');
         $players = $this->Player->find('all', compact('conditions', 'order'));
         if ($type == 'number')
         {
            $number = 1;
            foreach ($players as $p)
            {
               $p['Player']['tryout_number'] = $number++;
               $this->Player->save($p);
            }
            $players = $this->Player->find('all', compact('conditions', 'order'));
         }
         $this->set('players', $players);
      }

      if ($type == 'csv')
      {
         // CSV file
         $this->set('title_for_layout', 'TryoutList.csv');
         $this->layout = 'csv';
         $this->render('tryout_csv');
      }
      else if ($type == 'pdf')
      {
         // PDF file
         $this->set('title_for_layout', 'TryoutList.pdf');
         $this->layout='pdf';
         $this->render('tryout_pdf');
      }
      else
      {
         $this->loadModel('League');
   	   $this->set('leagues', $this->League->find('list'));
      }
      
	}
	
	/**
	 * Roster list
	 */
	function rosters($type=null, $league_id=0)
	{
	   if (empty($league_id))
	   {
	      $league_id = $this->Auth->user('default_league_id');
	   }
	   if (!empty($this->data))
      {
         $league_id = $this->data['Player']['league_id'];
      }

      if ($league_id > 0)
      {
         $conditions = array('league_id' => $league_id);
         $order = array('last_team', 'last_name ');
         $allPlayers = $this->Player->find('all', compact('conditions', 'order'));
         foreach ($allPlayers as $p)
         {
            $players[trim($p['Player']['last_team'])][] = $p;
         }
         $this->set('players', $players);
         $this->set('league', $this->Player->League->findById($league_id));
      }
      
      if ($type == 'pdf')
      {
         // PDF file
         $this->set('title_for_layout', 'PlayerRoster.pdf');
         $this->layout = 'pdf';
         $this->render('roster_pdf');
      }
      else if ($type == 'lastname')
      {
         // PDF file
         $this->set('title_for_layout', 'LastnameList.txt');
         $this->layout = 'txt';
         $this->render('roster_txt');         
      }
      else
      {
         $this->loadModel('League');
   	   $this->set('leagues', $this->League->find('list'));
      }
   }
   
   function lastnames()
   {
      // Only Cal/Ripken
      $conditions = array('league_id < 7');
      $order = array('league_id', 'last_team', 'last_name ');
      $allPlayers = $this->Player->find('all', compact('conditions', 'order'));
      foreach ($allPlayers as $p)
      {
         $league = trim($p['League']['name']);
         if (empty($league))
         {
            $league = 'No Assigned League';
         }
         $team = trim($p['Player']['last_team']);
         if (empty($team))
         {
            $team = 'No Assigned Team';
         }
         $players[$league][$team][] = $p['Player']['last_name'];
      }
      $this->set('players', $players);
   }
   
   /**
    * Main draft page.
    *
    * @param integer $league_id
    */
   function draft($league_id=0)
   {
//      $this->layout = 'draft';
      $draft = 1;
      if (!empty($this->data))
      {
         $league_id = $this->data['Player']['league_id'];
      }
      if ($league_id > 0)
      {
         $conditions = array('league_id'=> $league_id, 'tryout'=> 1, 'picked'=> 0);
         $order = array('tryout_number', 'last_name', 'first_name');
         $this->Player->contain();
         $players = $this->Player->find('all', compact('conditions', 'order'));
         $this->set('players', $players);
         $this->set('teams', $this->_teams($league_id));
         $this->set('league_id', $league_id);
         $teamCounts = $this->Player->query("SELECT Player.last_team, COUNT(*) count FROM players Player WHERE Player.league_id='$league_id' AND last_team<>'' GROUP BY 1");
         $this->set('team_status', $teamCounts);
      }
      $leagues = $this->Player->League->find('list');
      $this->set(compact('leagues', 'draft'));
   }

   /**
    * Handles the ajax call to select a player from the draft.
    */
   function draft_choose()
   {
      $this->layout = '';
      $team = $this->params['url']['team'];
      $player_id = $this->params['url']['player'];
      $league_id = $this->params['url']['league'];

      // Add player to the team
      $player = $this->Player->findById($player_id);
      $player['Player']['last_team'] = $team;
      $player['Player']['picked'] = 1;
      $this->Player->save($player);

      $teamCounts = $this->Player->query("SELECT Player.last_team, COUNT(*) count FROM players Player WHERE Player.league_id='$league_id' AND last_team<>'' GROUP BY 1");
      $this->set('team_status', $teamCounts);
      $this->set('league_id', $league_id);
   }
   
   /**
    * Handles the ajax call to undo a selected player from the draft.
    */
   function draft_undo()
   {
      $this->layout = '';
      $player_id = $this->params['url']['player'];
      $league_id = $this->params['url']['league'];
      $player = $this->Player->findById($player_id);
      $player['Player']['last_team'] = '';
      $player['Player']['picked'] = 0;
      $this->Player->save($player);

      $teamCounts = $this->Player->query("SELECT Player.last_team, COUNT(*) count FROM players Player WHERE Player.league_id='$league_id' AND last_team<>'' GROUP BY 1");
      $this->set('team_status', $teamCounts);
      $this->set('league_id', $league_id);
   }
   
   /**
    * List the current players for a team
    *
    * @param unknown_type $league_id
    * @param unknown_type $teamName
    */
   function teamlist($league_id, $team_name)
   {
      $this->layout = '';
      $conditions = array('league_id'=> $league_id, 'last_team'=> $team_name);
      $order = array('last_name', 'first_name');
      $this->Player->contain();
      $players = $this->Player->find('all', compact('conditions', 'order'));
      $this->set('players', $players);
      $this->set('league_id', $league_id);
      $this->set('team_name', $team_name);
   }
   
   /**
    * Returns a list of teams for a league
    *
    * @param integer $league_id
    * @return array
    */
   function _teams($league_id)
   {
      $teams = array(
         // PeeWee
         4=> array(
            "Rockies"=> "1. Rockies - Jeremy Potter",
            "Marlins"=> "2. Marlins - Terry McBride",            
            "Pirates"=> "3. Pirates - Mike Okerlund",
            "Twins"=> "4. Twins - Kyle Nelson",
            "Yankees"=> "5. Yankees - Don Mortensen",
            "Dodgers"=> "6. Dodgers - Corey Lewis",
            "A's"=> "7. A's - Kevin Affleck",
            "Giants"=> "8. Giants - Cory Proulx",
            "Mariners"=> "9. Mariners - Bryan Jeppsen",
            "Diamond Backs"=> "10. Diamond Backs - Bart Street",
            "Indians"=> "11. Indians - Scott Ball",
            "Cardinals"=> "12. Cardinals - James Robinson",
            "Phillies"=> "13. Phillies - Dusty Poulson",
            "Angels"=> "14. Angels - Ray Wilkes",
            "Reds"=> "15. Reds - Ryan McClellan",
            "Red Sox"=> "16. Red Sox - Matt Dixon",
            "Astros"=> "17. Astros - Mike Stone",
            "Tigers"=> "18. Tigers - Mitch Curtis",
            ),
         // Minor
         // Angels, Reds, Twins, Giants, Indians, Pirates
         // Dodgers, D-Backs, Yankees, Cardinals, Royals, Astros
         5=> array(
            'Cardinals' => '1. Cardinals - Brent Oldroyd',
            'Twins' => '2. Twins - Trent Dansie',
            'Giants' => '3. Giants - Richard Goodrich',
            'Dodgers' => '4. Dodgers - Scott Linford',
            'Pirates' => '5. Pirates - Shawn Vernon',
            'D-Backs' => '6. D-Backs - Denny Barlow',
            'Royals' => '7. Royals - Ken Hart',
            'Yankees' => '8. Yankees - Mark Graham',            
            'Angels' => '9. Angels - Ed Day',
            'Indians' => '10. Indians - Shawn Bergon',
            'Reds' => '11. Reds - Gary Young',
            'Astros' => '12. Astros - Paul Beck',
            ),
         // Major
         6=> array(
            "White Sox"=> "1. White Sox - Jim Garn",
            "Cardinals"=> "2. Cardinals - Kyle Price",
            "Phillies"=> "3. Phillies - Chris King",
            "Giants"=> "4. Giants - Todd Nelson",            
            "Yankees"=> "5. Yankees - Dennis Pennington",
            "Orioles"=> "6. Orioles - Nick Trujillo",
            "Reds"=> "7. Reds - Jason Lee",
            "Rockies"=> "8. Rockies - Kris Tolley",
            "Mariners"=> "9. Mariners - Sean Holt",
            "Mets"=> "10. Mets - Mike Musser",
            ),
         7=> array(
            "Chris Smith"=> "1. Chris Smith",
            "Robert Prpich"=> "2. Robert Prpich",
            "Brad Van Skyhawk"=> "3. Brad Van Skyhawk",
            "Kathy Schroeder"=> "4. Kathy Schroeder",
            "Derek Bolton"=> "5. Derek Bolton",
            ),
         8=> array(
            "Randy Miles" => "1. Randy Miles",
            "Jeff Little" => "2. Jeff Little",
            "Dave Kemp" => "3. Dave Kemp",
            "Jeff Quinn" => "4. Jeff Quinn",
            "Kelly Dumont" => "5. Kelly Dumont",
            "Lynn Moore" => "6. Lynn Moore",
            "Terry Harper" => "7. Terry Harper",
            "Tad Campbell" => "8. Tad Campbell",
            )
         );
      if (isset($teams[$league_id]))
      {
         //ksort($teams[$league_id]);
         return $teams[$league_id];
      }
      
      $teams = $this->Player->query("SELECT Player.last_team FROM players Player WHERE Player.league_id='$league_id' AND last_team<>'' ORDER BY last_team");
      $set = Set::extract($teams, '{n}.Player.last_team');
      return array_combine($set, $set);
   }
   
}
