<?php
/**
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.cake.console.libs.templates.skel.views.layouts
 * @since         CakePHP(tm) v 0.10.0.1076
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<?php echo $this->Html->charset(); ?>
	<title>
		Riverton Baseball Admin
		<?php echo $title_for_layout; ?>
	</title>
	<?php
		echo $this->Html->meta('icon');

		echo $this->Html->css('cake.generic.css');
		
		echo $this->Html->script('http://ajax.googleapis.com/ajax/libs/jquery/1.4.1/jquery.min.js');
		echo $this->Html->script('jquery.min.js');

		echo $scripts_for_layout;
	?>
	<script type="text/javascript">
	$(function(){
      $("input:visible:first").focus().select();
	});
	</script>
</head>
<body>
	<div id="container">
		<div id="header">
			<h1>
			<?php echo $this->Html->link('Riverton Baseball Admin', '/') ?>
			<?php if (isset($username)) echo '(Logged in as ', $username, ')'; ?>
			</h1>
		</div>
		<div id="content">

		   <?php
				if ($this->Session->check('Message.flash')):
				   echo $this->Session->flash();
				endif;
				if ($this->Session->check('Message.auth')):
					echo $this->Session->flash('auth');
				endif;
			?>

			<?php echo $content_for_layout; ?>
			
			<?php if (isset($user_id) and !isset($draft)): ?>
			<div class="actions">
			<h3>Menu</h3>
			<ul>
				<li><?php echo $this->Html->link('New Player', array('controller' => 'players', 'action' => 'add'));?></li>
				<li><?php echo $this->Html->link('List Players', array('controller' => 'players', 'action' => 'index'));?></li>
				<li><?php echo $this->Html->link('Team Rosters', array('controller' => 'players', 'action' => 'rosters'));?></li>
				<li><?php echo $this->Html->link('Tryout List', array('controller' => 'players', 'action' => 'tryout'));?></li>
				<li><?php echo $this->Html->link('Allstar Tryout List', array('controller' => 'players', 'action' => 'allstar_tryout'));?></li>
				<?php if ($user_id == 1): ?>
   				<li><?php echo $this->Html->link('Draft', array('controller' => 'players', 'action' => 'draft'));?></li>
				   <li><?php echo $this->Html->link('Last Names', array('controller' => 'players', 'action' => 'lastnames'));?></li>
				<?php endif; ?>
	   		<li><?php echo $this->Html->link('Logout', array('controller' => 'users', 'action' => 'logout'));?></li>
			</ul>
			</div>
			<?php endif; ?>

		</div>
		<div id="footer">
			<?php echo $this->Html->link(
					$this->Html->image('cake.power.gif', array('alt'=> __('CakePHP: the rapid development php framework', true), 'border' => '0')),
					'http://www.cakephp.org/',
					array('target' => '_blank', 'escape' => false)
				);
			?>
		</div>
	</div>
	<?php echo $this->element('sql_dump'); ?>
</body>
</html>