<?php
/**
 * Short description for file.
 *
 * This file is application-wide controller file. You can put all
 * application-wide controller-related methods here.
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.app
 * @since         CakePHP(tm) v 0.2.9
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

/**
 * Short description for class.
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @package       cake
 * @subpackage    cake.app
 */
class AppController extends Controller 
{
   var $helpers = array('Session', 'Html', 'Form', 'Time', 'Js');
   var $components = array('Session', 'Auth', 'RequestHandler');
   
   function beforeFilter()
   {
      if ($this->Auth->user('id'))
      {
         $this->set('user_id', $this->Auth->user('id'));
         $this->set('username', $this->Auth->user('username'));
      }
   }
   
	/**
	 * Load model(s) in the list.
	 * @param $list - models to load
	 */
	function loadModel($list) 
	{
      if (is_array($list))
      {
         foreach ($list as $l)
         {
            $this->{$l} = ClassRegistry::Init($l);
         }
      }
      else
      {
         $this->{$list} = ClassRegistry::Init($list);
      }
   }

}
?>
