<script type="text/javascript">
$(function(){
   $('#PlayerName').keyup(function(){
      $.ajax({
         type: 'GET',
         dataType: 'html',
         url: '<?php echo $html->url('/players/index') ?>',
         cache: false,
         data: {q: $(this).val()},
         beforeSend: function(){
            $('#indicator').show();
         },
         success: function(htm){
            $('#view').html(htm);
            $('#indicator').hide();
         },
         timeout: 5000,
         error: function(x, txt, error){
            $('#indicator').hide();
            $('#view').html('<span style="color: red"><strong>' + txt + '. Please try again.</strong></span>')
         }
      });
   });
});
</script>         
<div class="players index">
	<h2><?php __('Players');?></h2>
   <?php if (!empty($players)): ?>
	<?php echo $this->Form->create('Player', array('url' => '/players/index')); ?>
   <?php echo $this->Form->input('name', array('label' => 'Player Filter (enter any part of name to filter results)')) ?>
   <noscript><?php echo $form->submit('Search') ?></noscript>
   <div style="display: none" id="indicator">
      <?php echo $this->Html->image('loading_animation_liferay.gif', array('alt'=> 'Indicator')) ?>
   </div>
   <?php echo $this->Form->end(); ?>
   <?php endif; ?>
   <div id="view">
   <?php echo $this->element('player_table'); ?>
   </div>
</div>
