<?php
class FieldsController extends AppController {

	var $name = 'Fields';
	var $helpers = array('Html', 'Form' );

	function index() {
		$this->Field->recursive = 0;
		$this->set('fields', $this->Field->findAll());
	}

	function view($id = null) {
		if(!$id) {
			$this->Session->setFlash('Invalid id for Field.');
			$this->redirect('/fields/index');
		}
		$this->set('field', $this->Field->read(null, $id));
	}

	function add() {
		if(empty($this->data)) {
			$this->render();
		} else {
			$this->cleanUpFields();
			if($this->Field->save($this->data)) {
				$this->Session->setFlash('The Field has been saved');
				$this->redirect('/fields/index');
			} else {
				$this->Session->setFlash('Please correct errors below.');
			}
		}
	}

	function edit($id = null) {
		if(empty($this->data)) {
			if(!$id) {
				$this->Session->setFlash('Invalid id for Field');
				$this->redirect('/fields/index');
			}
			$this->data = $this->Field->read(null, $id);
		} else {
			$this->cleanUpFields();
			if($this->Field->save($this->data)) {
				$this->Session->setFlash('The Field has been saved');
				$this->redirect('/fields/index');
			} else {
				$this->Session->setFlash('Please correct errors below.');
			}
		}
	}

	function delete($id = null) {
		if(!$id) {
			$this->Session->setFlash('Invalid id for Field');
			$this->redirect('/fields/index');
		}
		if($this->Field->del($id)) {
			$this->Session->setFlash('The Field deleted: id '.$id.'');
			$this->redirect('/fields/index');
		}
	}

}
?>