<?php

class GamesController extends AppController 
{

	var $name = 'Games';
	var $helpers = array('Html', 'Form', 'Time' );
	var $leagueList = array('tball'=> 1, 'rookie5'=> 2, 'rookie6'=> 3, 'peewee'=> 4, 'minor'=> 5, 'major'=> 6, 'prep'=> 7, 'baberuth'=> 8, 'baberuth18'=> 9);

	function index($league='', $full='') 
	{
      $this->pageTitle = 'Game Schedule';
      	   
       if ($league == 'baberuth18')
       {
       	  $this->redirect('http://www.leaguelineup.com/schedules.asp?cmenuid=6&url=utahbaberuthbaseball&sid=207260449');
       	  exit;
       }
       
	   if (empty($league))
	   {
	      $this->redirect('/game_schedule/');
	      exit();
	   }
	   
	   if (isset($this->leagueList[$league]))
	   {
	      $league = $this->leagueList[$league];
	   }
		$this->Game->recursive = 0;
		
		$flipLeague = array_flip($this->leagueList);
      $this->set('leagueAbbr', $flipLeague[$league]);
		if ($full == 'full')
		{
		   $this->set('games', $this->Game->findAll("League.id='$league'", null, 'Game.game_time, Game.field_id'));
		   $this->set('upcoming', 0);
		}
                else if ($full == 'csv')
                {
		   $this->set('games', $this->Game->findAll("League.id='$league'", null, 'Game.game_time, Game.field_id'));
                   $this->layout = 'csv';
                   $this->render('index_csv');
                   return;
                }
		else
		{
		   $this->set('games', $this->Game->findAll("League.id = '$league' AND Game.game_time >= CURRENT_DATE()", null, 'Game.game_time'));
		   $this->set('upcoming', 1);
		}
	}
	
   function thisweek()
   {
      $games = $this->Game->findAll("WEEK(Game.game_time) = WEEK(CURRENT_DATE()) AND Game.game_time >= CURRENT_DATE()", null, array('Game.league_id', 'Game.game_time'));
     if (empty($games))
     {
         $games = $this->Game->findAll("WEEK(Game.game_time) = WEEK(CURRENT_DATE())+1 AND Game.game_time >= CURRENT_DATE()", null, array('Game.league_id', 'Game.game_time'));
         $this->set('title', 'Opening Day Schedule');
     }
     else
     {
         $this->set('title', 'Schedule This Week');
     }

     if (isset($this->params['requested'])) 
     {
        return $games;
     } 
     $this->set('games', $games);
   }
	
   function makeup()
   {
      $games = $this->Game->findAll("Game.makeup = 1 AND Game.game_time >= CURRENT_DATE()", null, array('Game.league_id', 'Game.game_time'));
      if (isset($this->params['requested'])) 
      {
             return $games;
      } 
      $this->set('games', $games);
   }
}

?>
