<?php
class LeaguesController extends AppController {

	var $name = 'Leagues';
	var $helpers = array('Html', 'Form' );

	function index() {
		$this->League->recursive = 0;
		$this->set('leagues', $this->League->findAll());
	}

	function view($id = null) {
		if(!$id) {
			$this->Session->setFlash('Invalid id for League.');
			$this->redirect('/leagues/index');
		}
		$this->set('league', $this->League->read(null, $id));
	}

	function add() {
		if(empty($this->data)) {
			$this->render();
		} else {
			$this->cleanUpFields();
			if($this->League->save($this->data)) {
				$this->Session->setFlash('The League has been saved');
				$this->redirect('/leagues/index');
			} else {
				$this->Session->setFlash('Please correct errors below.');
			}
		}
	}

	function edit($id = null) {
		if(empty($this->data)) {
			if(!$id) {
				$this->Session->setFlash('Invalid id for League');
				$this->redirect('/leagues/index');
			}
			$this->data = $this->League->read(null, $id);
		} else {
			$this->cleanUpFields();
			if($this->League->save($this->data)) {
				$this->Session->setFlash('The League has been saved');
				$this->redirect('/leagues/index');
			} else {
				$this->Session->setFlash('Please correct errors below.');
			}
		}
	}

	function delete($id = null) {
		if(!$id) {
			$this->Session->setFlash('Invalid id for League');
			$this->redirect('/leagues/index');
		}
		if($this->League->del($id)) {
			$this->Session->setFlash('The League deleted: id '.$id.'');
			$this->redirect('/leagues/index');
		}
	}

}
?>