<?php

class RegController extends AppController
{
	var $uses = array();

	function eligibility()
	{
		$divList = array(
		3=> 'T-ball - $60',
		'T-ball - $60',
		'Rookie 5 - $70',
		'Rookie 6 - $75',
		'PeeWee 7-8 - $90',
		'PeeWee 7-8 - $90',
		'Minor 9-10 - $90',
		'Minor 9-10 - $90',
		'Major 11-12 - $90',
		'Major 11-12 - $90',
		'Babe Ruth Prep 13 - $145',
		'Babe Ruth 14-15 - $145',
		'Babe Ruth 14-15 - $145',
		'Babe Ruth 16-18 - $170',
		'Babe Ruth 16-18 - $170',
		'Babe Ruth 16-18 - $170',
		);
		
		if (!empty($this->params['data']['Reg']['birthday']))
		{
			$birthday = $this->params['data']['Reg']['birthday'];
			$tmpBirthday = strtotime($birthday);
			if ($tmpBirthday === false)
			{
				$this->set('division', 'Please enter a valid birthday.');
			}
			else
			{
				$arrBirthday = getdate($tmpBirthday);
				$year = $arrBirthday['year']; 
				$month = $arrBirthday['mon'];
				if ($month > 4)
				{
					$year++;
				}
				$age = date('Y') - $year;
				if (isset($divList[$age]))
				{
					$this->set('division', '<strong>Division:</strong> ' . $divList[$age]);
				}
				else
				{
					if ($age < 3)
					{
						$this->set('division', 'Sorry, you are not old enough to play.');
					}
					else
					{
						$this->set('division', 'Sorry, you are too old to play.');						
					}
				}
			}
		}
		else
		{
			$this->set('division', 'Please enter a birthday.');
		}
		$this->render('eligibility', 'ajax');
	}
}

?>