<?php
class TeamsController extends AppController
{

   var $name = 'Teams';
   var $helpers = array('Html', 'Form', 'Time', 'Text' );
   var $uses = array('Team', 'League', 'Game');
   var $leagueList = array('tball'=> 1, 'rookie5'=> 2, 'rookie6'=> 3, 'peewee'=> 4, 'minor'=> 5, 'major'=> 6, 'prep'=> 7, 'baberuth'=> 8, 'baberuth18'=> 9);

   function hitathon()
   {
      $this->Team->unbindModel(array('hasMany' => array('GameHome', 'GameAway')));
      $teams = $this->Team->findAll("Team.hitathon IS NOT NULL", null, array('Team.league_id', 'Team.hitathon'));
      $this->set('teams', $teams);
   }

   function view($leagueId = null, $teamId = null, $print = false)
   {
      if ($print == 'print')
      {
         $this->layout = 'print';
      }

      if (!$leagueId and !$teamId)
      {
         $this->Session->setFlash('Invalid id for Team.');
         $this->redirect('/');
         exit();
      }

      $this->Team->unbindModel(array('hasMany' => array('GameHome', 'GameAway')));
      $teamData = $this->Team->find("Team.team_id = '$teamId' AND Team.league_id = '$leagueId'");
      $leagueData = $this->League->read(null, $leagueId);
      $gameData = $this->Game->findAll("Game.league_id = '$leagueId' AND (Game.home_team = '$teamId' OR Game.away_team = '$teamId')", null, 'Game.game_time');
      $this->set('team', $teamData);
      $this->set('league', $leagueData);
      $this->set('games', $gameData);
   }

   function standings($leagueId = null)
   {
      $this->pageTitle = 'Team Standings';

      if (empty($leagueId))
      {
         $this->redirect('/schedule/');
         exit();
      }

      if (isset($this->leagueList[$leagueId]))
      {
         $leagueId = $this->leagueList[$leagueId];
      }

      $leagueData = $this->League->read(null, $leagueId);
      $this->set('league', $leagueData);
      $this->Team->unbindModel(array('hasMany' => array('GameHome', 'GameAway')));

      switch ($leagueId)
      {
         case 1: //tball
         case 2: //rookie 5
         case 3: //rookie 6
         break;

         case 4: //peewee
         $this->set('note', 'Last updated on Friday, June 10, 2011');
         $divData[0] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.team_id IN ('1','2','3','4','5','6','7','8','9')", null, 'wins/(wins+loses+ties) DESC, wins DESC, loses, ties, tiebreaker DESC, Team.name');
         $divData[1] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.team_id IN (10,11,12,13,14,15,16,17,18)", null, 'wins/(wins+loses+ties) DESC, wins DESC, loses, ties, tiebreaker DESC, Team.name');
         $divName[0] = 'Division One';
         $divName[1] = 'Division Two';
         $this->set('division', $divData);
         $this->set('divname', $divName);
         break;

         case 5: //minor
         $this->set('note', 'Last updated on Tuesday, June 7, 2011.');
         $divData[0] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.team_id IN ('1','2','3','4','5','6','7','8','9','10','11','12')", null, 'wins/(wins+loses+ties) DESC, wins DESC, loses, ties DESC, Team.name');
         $this->set('division', $divData);
         $this->set('divname', $divName);
         break;

         case 6: //major
         $this->set('note', 'Last updated on Tuesday, June 7, 2011.');
         $divData[0] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.team_id NOT LIKE 'ACCEL%'", null, 'wins/(wins+loses+ties) DESC, wins DESC, tiebreaker, Team.name');
         $this->set('division', $divData);
         break;
         
         case 7: //prep
         $this->set('note', 'Babe Ruth Standings are based on coaches feedback. Email the webmaster with your record.');
         $divData[0] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.name LIKE 'Riverton%'", null, 'wins/(wins+loses+ties) DESC, wins DESC, loses, ties DESC, Team.name');
         $divName[0] = 'Babe Ruth Prep';
         $this->set('division', $divData);
         $this->set('divname', $divName);
         $this->set('overall', true);
         break;
         
         case 8: //14-15
         $this->set('note', 'Last updated on Monday, June 13, 2011.');
         $divData[0] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.name LIKE 'Riverton%'", null, 'wins/(wins+loses+ties) DESC, wins DESC, loses, ties DESC, Team.name');
         $divName[0] = 'Babe Ruth 14-15';
         $this->set('division', $divData);
         $this->set('divname', $divName);
         $this->set('overall', true);
         break;

         case 9: //16-18
         $this->set('note', 'Last updated on Thursday, May 19, 2011.');
         $divData[0] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.name LIKE 'Riverton%'", null, 'wins/(wins+loses+ties) DESC, wins DESC, loses, ties DESC, Team.name');
         $divName[0] = 'Babe Ruth 16-18';
         $this->set('division', $divData);
         $this->set('divname', $divName);
         $this->set('overall', true);
         break;
      }
   }
   
   function admin($leagueId=null)
   {
      if (empty($leagueId))
      {
         $this->redirect('/schedule/');
         exit();
      }

      if (isset($this->leagueList[$leagueId]))
      {
         $leagueId = $this->leagueList[$leagueId];
      }

      $leagueData = $this->League->read(null, $leagueId);
      $this->set('league', $leagueData);
      $this->Team->unbindModel(array('hasMany' => array('GameHome', 'GameAway')));

      switch ($leagueId)
      {
         case 1: //tball
         case 2: //rookie 5
         case 3: //rookie 6
         break;

         case 4: //peewee
         $divData[0] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.team_id <= 9", null, 'wins DESC, ties DESC, loses, Team.name');
         $divData[1] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.team_id >= 10", null, 'wins DESC, ties DESC, loses, Team.name');
         $divName[0] = 'Division One';
         $divName[1] = 'Division Two';
         $this->set('division', $divData);
         $this->set('divname', $divName);
         break;

         case 5: //minor
         case 6: //major
         $divData[0] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.team_id <= 6", null, 'wins DESC, ties DESC, loses, Team.name');
         $divData[1] = $this->Team->findAll("Team.league_id = '$leagueId' AND Team.team_id >= 7", null, 'wins DESC, ties DESC, loses, Team.name');
         $divName[0] = 'National';
         $divName[1] = 'American';
         $this->set('division', $divData);
         $this->set('divname', $divName);
         break;

      }
      
   }
}
?>
