<?php
class Game extends AppModel {

	var $name = 'Game';

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
			'TeamHome' =>
				array('className' => 'Team',
						'foreignKey' => 'home_team',
						'conditions' => 'TeamHome.league_id=League.id',
						'fields' => '',
						'order' => '',
						'counterCache' => ''
				),

			'TeamAway' =>
				array('className' => 'Team',
						'foreignKey' => 'away_team',
						'conditions' => 'TeamAway.league_id=League.id',
						'fields' => '',
						'order' => '',
						'counterCache' => ''
				),

			'League' =>
				array('className' => 'League',
						'foreignKey' => 'league_id',
						'conditions' => '',
						'fields' => '',
						'order' => '',
						'counterCache' => ''
				),

			'Field' =>
				array('className' => 'Field',
						'foreignKey' => 'field_id',
						'conditions' => '',
						'fields' => '',
						'order' => '',
						'counterCache' => ''
				),

	);

    function afterFind($results)
    {
         foreach ($results as $key => $val)
         {
            if (isset($results[$key]['TeamHome']))
            {
               if (empty($results[$key]['TeamHome']['name']))
               {
                  $results[$key]['TeamHome']['name'] = $val['TeamHome']['team_id'] . ' - ' . $val['TeamHome']['coach'];
               }
            }
            if (isset($results[$key]['TeamAway']))
            {
               if (empty($results[$key]['TeamAway']['name']))
               {
                  $results[$key]['TeamAway']['name'] = $val['TeamAway']['team_id'] . ' - ' . $val['TeamAway']['coach'];
               }
            }
         }
        return $results;
    }
}
?>
