<?php
class Team extends AppModel {

	var $name = 'Team';
	var $primaryKey = 'team_id';

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
			'League' =>
				array('className' => 'League',
						'foreignKey' => 'league_id',
						'conditions' => '',
						'fields' => '',
						'order' => '',
						'counterCache' => ''
				),

	);
	
	var $hasMany = array(
			'GameHome' =>
				array('className' => 'Game',
						'foreignKey' => 'home_team',
						'conditions' => '',
						'fields' => '',
						'order' => '',
						'limit' => '',
						'offset' => '',
						'dependent' => '',
						'exclusive' => '',
						'finderQuery' => '',
						'counterQuery' => ''
				),
			'GameAway' =>
				array('className' => 'Game',
						'foreignKey' => 'away_team',
						'conditions' => '',
						'fields' => '',
						'order' => '',
						'limit' => '',
						'offset' => '',
						'dependent' => '',
						'exclusive' => '',
						'finderQuery' => '',
						'counterQuery' => ''
				),

	);

    function afterFind($results)
    {
         foreach ($results as $key => $val)
         {
            if (isset($results[$key]['Team']))
            {
               if (empty($results[$key]['Team']['name']))
               {
                  $results[$key]['Team']['name'] = $val['Team']['team_id'] . ' - ' . $val['Team']['coach'];
               }
            }
         }
        return $results;
    }
}
?>
