<?php

if (!is_admin()) {
	die ("Unauthorized.");
}

function cd_get_sponsor_select($sid=0) {
	global $wpdb;
		$cd_sponsors = $wpdb->get_results("SELECT sid,name FROM cd_ad_sponsor ORDER BY name ASC", OBJECT);
		if ($cd_sponsors) {
			$result = '<option value="">* Select Sponsor *</option>';
			foreach($cd_sponsors as $sponsor) {
				if ($sponsor->sid == $sid) {$sel = ' selected ';} else {$sel = ' ';}
				$result .= '<option'.$sel.'value="'.$sponsor->sid.'">'.$sponsor->name.'</option>';
			}
		} else {
			$result = false;
		}
		return $result;
}

function cd_get_program_select($sid=0,$pid=0) {
	global $wpdb;
	$cd_programs = $wpdb->get_results("SELECT p.pid, concat_ws( ' - ', b.name, p.name, p.type, z.zone ) AS txt FROM cd_ad_sponsor_banners AS b LEFT JOIN cd_ad_sponsor_program AS p ON p.pid = b.pid LEFT JOIN cd_ad_sponsor_zones AS z ON b.zone_id = z.zone_id WHERE b.sid = $sid ORDER BY b.name",OBJECT);
	if (!empty($cd_programs)) {
		foreach($cd_programs as $programs) {
			if ($pid == $programs->pid) {$sel = ' selected ';} else {$sel = ' ';}
			$result .= '<option'.$sel.'value="'.$programs->pid.'">'.$programs->txt.'</option>';
		}
	} else {
		$result = '<option selected value="">None Defined</option>';
	}
	return $result;
}

function cd_get_revenue_select($rid=0) {
	global $wpdb;
	$cd_revenue = $wpdb->get_results("SELECT rev_id, concat_ws( '-', name, description ) AS txt FROM cd_ad_sponsor_revenue ORDER BY rid,name ASC",OBJECT);
	if (!empty($cd_revenue)) {
		foreach($cd_revenue as $revenue) {
			if ($rid == $revenue->rev_id) {$sel = ' selected ';} else {$sel = ' ';}
			$result .= '<option'.$sel.'value="'.$revenue->rev_id.'">'.$revenue->txt.'</option>';
		}
	} else {
		$result = '<option selected value="">None Defined</option>';
	}
	return $result;
}

function cd_get_zone_select($zid=0) {
	global $wpdb, $blog_id;
	$cd_zone = $wpdb->get_results("SELECT zid, zone FROM cd_ad_sponsor_zones WHERE blog_id=$blog_id ORDER BY zid ASC",OBJECT);
	if (!empty($cd_zone)) {
		foreach($cd_zone as $zone) {
			if ($zid == $zone->zid) {$sel = ' selected ';} else {$sel = ' ';}
			$result .= '<option'.$sel.'value="'.$zone->zid.'">'.$zone->zone.'</option>';
		}
	} else {
		$result = '<option selected value="">None Defined</option>';
	}
	return $result;
}

function cd_get_program_name($pid) {
	global $wpdb;
	$result = $wpdb->get_row("SELECT concat_ws( '-',name, type , description ) AS txt FROM cd_ad_sponsor_program WHERE pid=$pid",OBJECT);
	return $result->txt;
}

function cd_get_category_select($cid="0") {
	global $wpdb;
	$qresults = $wpdb->get_results("SELECT ".$wpdb->prefix."terms.term_id, ".$wpdb->prefix."terms.name FROM ".$wpdb->prefix."terms LEFT JOIN ".$wpdb->prefix."term_taxonomy ON ".$wpdb->prefix."terms.term_id=".$wpdb->prefix."term_taxonomy.term_id WHERE ".$wpdb->prefix."term_taxonomy.taxonomy='category' order by ".$wpdb->prefix."terms.name",OBJECT);
	$result = '';
	if (!empty($qresults)) {
		$cat = explode(",",$cid);
		foreach($qresults as $category) {
			if (in_array($category->term_id,$cat)) {$sel = ' selected ';} else {$sel = ' ';}
			$result .= '<option'.$sel.'value="'.$category->term_id.'">'.$category->name.'</option>';
		}
	} else {
		$result = '<option selected value="1">Default Category</option>';
	}
	return $result;
}

function cd_get_category_list($cid) {
	global $wpdb;
	$cquery = "SELECT DISTINCT ".$wpdb->prefix."terms.name FROM ".$wpdb->prefix."terms LEFT JOIN ".$wpdb->prefix."term_taxonomy ON ".$wpdb->prefix."terms.term_id=".$wpdb->prefix."term_taxonomy.term_id WHERE ".$wpdb->prefix."term_taxonomy.term_id IN ($cid) order by ".$wpdb->prefix."terms.name";
	$result = '';
	$qresults = $wpdb->get_results($cquery,OBJECT);
	foreach($qresults as $category) {
		$result .= $category->name.", ";
	}
$result = trim($result,", ");
	return $result;
}


function cd_get_banner_select($bid=0) {
	global $wpdb;
	$cd_banner = $wpdb->get_results("SELECT bid,name,description FROM cd_ad_sponsor_banners ORDER BY bid ASC", OBJECT);
	$result = '';
	if ($cd_banner) {
		$result .= '<option value="">-- Select Zone --</option>';
		foreach($cd_zone as $zone) {
			if ($zone->zid == $zid) {$sel = ' selected ';} else {$sel = ' ';}
			$result .= '<option'.$sel.'value="'.$zone->bid.'">'.$zone->zone.'</option>';
		}
	} else {
		$result .= '<option selected value="">None Defined</option>';
	}
	return $result;
}

function cd_get_schedule_select($sid=0,$bid=0) {
	global $wpdb,$blog_id;
	$cd_schedules = $wpdb->get_results("SELECT b.bid, b.zone_id, concat_ws( ' - ', b.name, p.name, p.type ) AS txt FROM cd_ad_sponsor_banners AS b LEFT JOIN cd_ad_sponsor_program AS p ON p.pid = b.pid WHERE b.sid =$sid AND b.blog_id = $blog_id ORDER BY b.name",OBJECT);
	if (!empty($cd_schedules)) {
		foreach($cd_schedules as $schedule) {
			$zone = $wpdb->get_var("SELECT zone FROM cd_ad_sponsor_zones WHERE blog_id=$blog_id AND zid=$schedule->zone_id");
			if ($bid == $schedule->bid) {$sel = ' selected ';} else {$sel = ' ';}
			$result .= '<option'.$sel.'value="'.$schedule->bid.'">'.$schedule->txt.' - '.$zone.'</option>';
		}
	} else {
		$result = '<option selected value="">None Defined</option>';
	}
	return $result;
}

function cd_get_date_ellapsed($startdate) {

	$date1=explode("-", date("Y-m-d",strtotime($startdate)));
	$date2=explode("-", date("Y-m-d"));
	$start_date=gregoriantojd($date1[1], $date1[2], $date1[0]);
	$end_date=gregoriantojd($date2[1], $date2[2], $date2[0]);
	return $end_date - $start_date;
}


function cd_ajax_program() {
	global $wpdb;
	if(isset($_POST['sponsorid'])){
		$sponsor_id=$_POST['sponsorid'];
		$qresults = $wpdb->get_results("SELECT p.pid, concat_ws(' - ',p.site,p.name,p.type,p.description) AS txt FROM cd_ad_sponsor_program AS p WHERE p.sid=$sponsor_id ORDER BY p.site",OBJECT);
		$result = "";
		if (!empty($qresults)) {
			foreach($qresults as $programs) {
			$result .= "<option value='".$programs->pid."'>".$programs->txt."</option>";
			}
		} else {
			$result .= "<option value=''>* None Defined *</option>";
		}
	} else {
		$result .= "<option value=''>* Select Sponsor First *</option>";
	}
	echo $result;
	exit;
}


function cd_ajax_schedule() {
	global $wpdb,$blog_id;
	if(isset($_POST['sponsorid'])){
		$sponsor_id=$_POST['sponsorid'];
		$qresults = $wpdb->get_results("SELECT b.bid, b.zone_id, concat_ws( ' - ', b.name, p.name, p.type ) AS txt FROM cd_ad_sponsor_banners AS b LEFT JOIN cd_ad_sponsor_program AS p ON p.pid = b.pid WHERE b.sid =$sponsor_id AND b.blog_id = $blog_id ORDER BY b.name",OBJECT);
		$result = "";
		if (!empty($qresults)) {
			foreach($qresults as $programs) {
				$zone = $wpdb->get_var("SELECT zone FROM cd_ad_sponsor_zones WHERE blog_id=$blog_id AND zid=$programs->zone_id");
				$result .= "<option value='".$programs->bid."'>".$programs->txt." - ".$zone."</option>";
			}
		} else {
			$result = "<option value=''>* None Defined *</option>";
		}
	} else {
		$result = "<option value=''>* Select Sponsor First *</option>";
	}
	echo $result;
	exit;
}


function cd_ad_admin_footer() {
	echo '<div class="versions"><p>You can read more about the cd_ad_sponsor Plugin and its use on the <span class="b"><a href="http://coyotesdesigns.com" target="_blank" title="Coyotes Designs - Human Factors Engineering, Imagery, and General Brain Dumps">CoyotesDesigns.com</a></span> web site. All <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=6922896" title="Donations." target="_blank">Donations</a> are greatly appreciated!</p></div>';
}

?>