<?php

if (!is_admin()) {
	die ("Unauthorized.");
}

$cd_js = cd_get_plugin_dir()."/cd_ad_sponsor/js";
wp_register_script('cd_ad_sponsor', $cd_js . '/cd_ad_sponsor.js', array('jquery'));
wp_enqueue_script('cd_ad_sponsor',$cd_js."/cd_ad_sponsor.js");

add_action('wp_ajax_cd_ajax_program', 'cd_ajax_program');

function cd_ad_make_ads_menu() {
	global $wpdb,$blog_id;
	ob_start();
	if ( isset($_REQUEST['bid']) && $_REQUEST['bid'] ) {
	$cd_bid = (int)$_REQUEST['bid'];
	} else {
		$cd_bid = 0;
	}
	$op = $_GET['op'];
	echo '<div class="wrap">
	<div class="icon32"><img src="'.cd_get_plugin_dir().'/cd_ad_sponsor/images/cd_ad_32.png" width="30px" height="31px" border="0" /></div>
	<h2>'.__('Manage Banner Ads', 'cd_ad_sponsor').'</h2>';
	switch ($op) {
		case "add":
			if ($_POST['action'] == "addbanner") {
				if ($_POST['banner_name'] == '') {
					$cd_banner_name = "* Not Defined *";
				} else {
					$cd_banner_name = $wpdb->escape($_POST['banner_name']);
				}
				$cd_sid = $wpdb->escape($_POST['psid']);
				if (is_array($_POST['ad_categories'])) {
					$cd_cid = $wpdb->escape( implode( ",", $_POST['ad_categories'] ) );
				} else {
					$cd_cid = 1; //default wp category id
				}
				$cd_pid = $wpdb->escape($_POST['ppid']);
				$cd_rev_id = $wpdb->escape($_POST['rev_id']);
				$cd_zone_id = $wpdb->escape($_POST['zone_id']);
				$cd_site_link = $wpdb->escape($_POST['site_link']);
				$cd_ad_link = $wpdb->escape($_POST['ad_link']);
				$cd_alt_tag = $wpdb->escape($_POST['alt_tag']);
				$cd_script_link = $wpdb->escape($_POST['script_link']);
				if ($cd_banner_name != "" && $cd_pid != "" && $cd_zone_id != "" && $cd_sid >= '1') {
					$result = $wpdb->query("INSERT INTO cd_ad_sponsor_banners (bid,sid,cid,pid,blog_id,rev_id,zone_id,name,link,b_url,alt,s_link) VALUES (null,'$cd_sid','$cd_cid','$cd_pid','$blog_id','$cd_rev_id','$cd_zone_id','$cd_banner_name','$cd_site_link','$cd_ad_link','$cd_alt_tag','$cd_script_link')");
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Banner Ad &quot;'.$cd_banner_name.'&quot; created.</p></div>';
						cd_ad_banner_render();
						break;
					} else {
						echo '<div id="message" class="error fade"><p>Error creating banner ad.</p></div>';
					}
				} else {
					echo '<div id="message" class="error fade"><p>Sponsor, Program Type, Site, Categories, Revenu Type, and Zone are Required.</p></div>';
				}
			}
			echo '<h3>'.__('Add Banner', 'cd_ad_sponsor').'</h3>';
			echo '<p>Complete the following form to create a new banner ad. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="addbanner" id="addbanner">';
			echo '<table class="form-table">';
			echo '<tr class="form-field"><th scope="row">
			<label for="sid">Sponsor Name<sup class="req">*</sup></label></th>
			<td>';
			echo '<select name="psid" id="psid" style="width:200px;" >';
			$result = cd_get_sponsor_select($cd_sid);
			if ($result === false) {
				$savestatus = 'disabled';
				echo '<option value="">None Defined</option>';
			} else {
				echo $result;
			}
			echo '</select>';
			echo '<br /><span class="description">';
			if ($result === false) {
				echo '<b>You must first define a Sponsor.</b>';
			} else {
				echo 'Select the sponsor to associate with this ad.';
			}
			echo '</td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row">
			<label for="pid">Program Type<sup class="req">*</sup></label></th>
			<td>';
			echo '<select name="ppid" id="ppid" style="width:300px;">';
			echo '</select><span id="cd_loader"></span>';
			echo '<br /><span class="description">Select the Program Type associated with this banner.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="banner_name">Site Name<sup class="req">*</sup></label></th>';
			echo '<td><input name="banner_name" type="text" id="banner_name" value="'.$cd_banner_name.'" style="width:200px;" />
			<br /><span class="description">Enter the Site Name associated with this banner.</span></td></tr>';

			echo '<tr class="form-field"><th scope="row">
			<label for="ad_categories">Ad Categories<sup class="req">*</sup></label></th>
			<td>';
			echo '<select multiple size="8" name="ad_categories[]" id="ad_categories" style="width:200px;height:80px;">';
			echo cd_get_category_select($cd_cid);
			echo '</select>';
			echo '<br /><span class="description">Select the Categories to associate with this banner.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="rev_id">Revenue Type<sup class="req">*</sup></label></th>';
			echo '<td><select name="rev_id" id="rev_id" style="width:300px;">';
			echo cd_get_revenue_select();
			echo '</select>';
			echo '<br /><span class="description">Select the Revenue Type associated with this banner.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="zone_id">Zone<sup class="req">*</sup></label></th>';
			echo '<td><select name="zone_id" id="zone_id" style="width:300px;">';
			echo cd_get_zone_select();
			echo '</select>';
			echo '<br /><span class="description">Select the Zone to assign to this banner.</span></td></tr>'."\n";
			echo '</table><br />'."\n";


			echo '<h3>'.__('Image-based Banner Ad', 'cd_ad_sponsor').'</h3>';
			echo '<p>Complete the following to create an Image-based Ad. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<table class="form-table">';
			echo '<tr class="form-field"><th scope="row"><label for="site_link">Target URL</label></th><td><input name="site_link" type="text" id="site_link" value="'.$cd_site_link.'" style="width:400px;" /><br /><span class="description">Enter the target URI associated with this banner.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="alt_tag">Alt/Title Tag</label></th><td><input name="alt_tag" type="text" id="alt_tag" value="'.$cd_alt_tag.'" style="width:400px;" /><br /><span class="description">Enter the Alt/Title Tag for this banner image.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="ad_link">Banner URL</label></th><td><input name="ad_link" type="text" id="ad_link" value="'.$cd_ad_link.'" style="width:400px;" /><br /><span class="description">Enter the remote or sponsor-hosted URI for this banner image.</span></td></tr>'."\n";
			echo '</table>';

			echo '<h3>'.__('Script-based Banner Ad', 'cd_ad_sponsor').'</h3>';
			echo '<p>Complete the following to create a Script-based Ad.</p>';
			echo '<table class="form-table">';
			echo '<tr class="form-field"><th scope="row"><label for="script_link">Ad Script</label></th><td><textarea name="script_link" id="script_link" style="width:400px;height:100px;">'.$cd_script_link.'</textarea><br /><span class="description">Enter the sponsor script associated with this banner.</span></td></tr>'."\n";
			echo '</table>';

			echo '<p class="submit">
			<input name="plugin_uri" type="hidden" id="plugin_uri" value="'.cd_get_plugin_dir().'" />
			<input name="site_uri" type="hidden" id="site_uri" value="'.get_bloginfo('wpurl').'" />
			<input name="action" type="hidden" id="action" value="addbanner" />
			<input name="op" type="hidden" id="op" value="add" />
			<input name="addbanner" type="submit" id="addbanner" class="button" value="Save Changes" '.$savestatus.' /></p></form>';
			break;

		case "edit":
			if ($_POST['action'] == "editbanner") {
				if ($_POST['banner_name'] == '') {
					$cd_banner_name = "* Not Defined *";
				} else {
					$cd_banner_name = $wpdb->escape($_POST['banner_name']);
				}
				$cd_sid = $wpdb->escape($_POST['sid']);
				if (is_array($_POST['ad_categories'])) {
					$cd_cid = implode(",",$wpdb->escape($_POST['ad_categories']));
				} else {
					$cd_cid = null;
				}
				$cd_site_link = $wpdb->escape($_POST['site_link']);
				$cd_ad_link = $wpdb->escape($_POST['ad_link']);
				$cd_pid = $wpdb->escape($_POST['pid']);
				$cd_rev_id = $wpdb->escape($_POST['rev_id']);
				$cd_zone_id = $wpdb->escape($_POST['zone_id']);
				$cd_alt_tag = $wpdb->escape($_POST['alt_tag']);
				$cd_script_link = $wpdb->escape($_POST['script_link']);
				if ($cd_banner_name != "" && $cd_pid != "" && $cd_zone_id != "" && $cd_sid >= '1') {
					$result = $wpdb->query("UPDATE cd_ad_sponsor_banners SET sid='$cd_sid',cid='$cd_cid',pid='$cd_pid',rev_id='$cd_rev_id',zone_id='$cd_zone_id',name='$cd_banner_name',link='$cd_site_link',b_url='$cd_ad_link',alt='$cd_alt_tag',s_link='$cd_script_link' WHERE bid='$cd_bid'");
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Banner Ad &quot;'.$cd_banner_name.'&quot; updated.</p></div>';
						cd_ad_banner_render();
						break;
					} elseif ($result == 0) {
						echo '<div id="message" class="updated fade"><p>No Update required.</p></div>';
					cd_ad_banner_render();
						break;
					} else {
						echo '<div id="message" class="error fade"><p>Error updating banner ad.</p></div>';
					}
				} else {
					echo '<div id="message" class="error fade"><p>Program Type, Site, Categories, Revenu Type, and Zone are Required.</p></div>';
				}
			} else {
				$result = $wpdb->get_row("SELECT * FROM cd_ad_sponsor_banners WHERE bid='$cd_bid'");
				$cd_banner_name = stripslashes($result->name);
				$cd_sid = stripslashes($result->sid);
				$cd_pid = stripslashes($result->pid);
				$cd_cid = stripslashes($result->cid);
				$cd_rev_id = stripslashes($result->rev_id);
				$cd_zone_id = stripslashes($result->zone_id);
				$cd_site_link = stripslashes($result->link);
				$cd_ad_link = stripslashes($result->b_url);
				$cd_alt_tag = stripslashes($result->alt);
				$cd_script_link = stripslashes($result->s_link);
			}
			$cd_sponsor_name=$wpdb->get_var("SELECT name FROM cd_ad_sponsor WHERE sid=$cd_sid");
			echo '<h3>'.__('Edit Banner Details', 'cd_ad_sponsor').'</h3>';
			echo '<p>Modify the following information to change the banner ad details for <b><i>'.$cd_sponsor_name.'</i></b>. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="editbanner" id="editbanner">';
			echo '<table class="form-table">';
			echo '<tr class="form-field">
			<th scope="row"><label for="banner_name">Site Name<sup class="req">*</sup></label>
			<input name="action" type="hidden" id="action" value="editbanner" />
			<input name="sid" type="hidden" id="sid" value="'.$cd_sid.'" />
			<input name="op" type="hidden" id="op" value="edit" /></th>';

			echo '<td><input name="banner_name" type="text" id="banner_name" value="'.$cd_banner_name.'" style="width:200px;" />
			<br /><span class="description">Enter the Site Name associated with this banner.</span></td></tr>';

			echo '<tr class="form-field"><th scope="row">
			<label for="pid">Program Type<sup class="req">*</sup></label></th>
			<td>';
			echo '<select name="pid" id="pid" style="width:300px;">';
			echo cd_get_program_select($cd_sid,$cd_pid);
			echo '</select>';
			echo '<br /><span class="description">Select the Program Type to assign to this banner.</span></td></tr>'."\n";

		echo '<tr class="form-field"><th scope="row">
			<label for="ad_categories">Ad Categories<sup class="req">*</sup></label></th>
			<td>';
			echo '<select multiple size="8" name="ad_categories[]" id="ad_categories" style="width:200px;height:80px;">';
			echo cd_get_category_select($cd_cid);
			echo '</select>';
			echo '<br /><span class="description">Select the Categories to associate with this banner.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row">
			<label for="rev_id">Revenue Type<sup class="req">*</sup></label></th>
			<td>';
			echo '<select name="rev_id" id="rev_id" style="width:300px;">';
			echo cd_get_revenue_select($cd_rev_id);
			echo '</select>';
			echo '<br /><span class="description">Select the Revenue Type associated with this banner.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row">
			<label for="zone_id">Zone<sup class="req">*</sup></label></th>
			<td>';
			echo '<select name="zone_id" id="zone_id" style="width:300px;">';
			echo cd_get_zone_select($cd_zone_id);
			echo '</select>';
			echo '<br /><span class="description">Select the Zone to assign to this banner.</span></td></tr>'."\n";

			echo '</table><br />'."\n";

			echo '<h3>'.__('Image-based Banner Ad', 'cd_ad_sponsor').'</h3>';
			echo '<p>Change the following to modify the Image-based Ad.</p>';
			echo '<table class="form-table">';
			echo '<tr class="form-field"><th scope="row"><label for="site_link">Target URL</label></th><td><input name="site_link" type="text" id="site_link" value="'.$cd_site_link.'" style="width:400px;" /><br /><span class="description">Enter the target URI associated with this banner.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="alt_tag">Alt/Title Tag</label></th><td><input name="alt_tag" type="text" id="alt_tag" value="'.$cd_alt_tag.'" style="width:400px;" /><br /><span class="description">Enter the Alt/Title Tag for this banner image.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="ad_link">Banner URL</label></th><td><input name="ad_link" type="text" id="ad_link" value="'.$cd_ad_link.'" style="width:400px;" /><br /><span class="description">Enter the remote or sponsor-hosted URI for this banner image.</span></td></tr>'."\n";
			echo '</table>';


			echo '<h3>'.__('Script-based Banner Ad', 'cd_ad_sponsor').'</h3>';
			echo '<p>Change the following to modify the Script-based Ad.</p>';
		echo '<table class="form-table">';
			echo '<tr class="form-field"><th scope="row"><label for="script_link">Ad Script</label></th><td><textarea name="script_link" id="script_link" style="width:400px;height:100px;">'.$cd_script_link.'</textarea><br /><span class="description">Enter the sponsor script associated with this banner.</span></td></tr>'."\n";
			echo '</table>';

			echo '<p class="submit">
			<input name="editbanner" type="submit" id="editbanner" class="button" value="Save Changes" />
			</p></form>';
			break;

		default:
			cd_ad_banner_render();
	}
	echo '<br /><div style="clear:both;"></div></div>'."\n";
}

function cd_ad_banner_render() {
	global $wpdb,$blog_id;
	ob_start();
	echo '<p>The following table lists all currently defined Banner Ads for blog, <b><i>';
	echo bloginfo('name');
	echo '</i></b>, grouped by sponsor.</p>';
	echo '<div class="submit">
	<a class="button" href="admin.php?page=cd_ads_menu&op=add&bid=0" title="Add Banner">Add Banner</a></div>'."\n";
	echo '<div class="cd_render">';
	echo '<table class="widefat">
	<thead><tr>
	<th scope="col">'.__('Site Name', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Program Type', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Categories', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Revenue', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Zone', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Site Link', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Banner', 'cd_ad_sponsor').'</th>
	</tr></thead>
	<tbody>';

	$cd_sponsor_name = $wpdb->get_results("SELECT sid,name FROM cd_ad_sponsor ORDER BY name ASC",OBJECT);
	if (!empty($cd_sponsor_name)) {
		foreach($cd_sponsor_name as $sponsor_result) {
			$row_id='row'.$sponsor_result->sid;
			echo '<tr style="background-color:#FDFFBB;" class="parent" id="'.$row_id.'"><td colspan="7" style="font-size:12px;"><b><i>'.$sponsor_result->name.'</i></b></td></tr>';
			$cd_sponsor_ads = $wpdb->get_results("SELECT * FROM cd_ad_sponsor_banners WHERE sid='".$sponsor_result->sid."' AND blog_id='".$blog_id."' ORDER BY name ASC", OBJECT);
			if ($cd_sponsor_ads) {
				foreach($cd_sponsor_ads as $ad_result) {
					echo '<tr class="child-'.$row_id.'">';
					echo '<td><a href="admin.php?page=cd_ads_menu&op=edit&bid='.$ad_result->bid.'&sid='.$sponsor_result->sid.'" title="Edit banner '.$ad_result->name.' details">'.$ad_result->name.'</a></td>';
					echo '<td>'.cd_get_program_name($ad_result->pid).'</td>';
					echo '<td>'.cd_get_category_list($ad_result->cid).'</td>';
					echo '<td>'.$wpdb->get_var("SELECT name FROM cd_ad_sponsor_revenue WHERE rev_id=$ad_result->rev_id").'</td>';
					echo '<td>'.$wpdb->get_var("SELECT zone FROM cd_ad_sponsor_zones WHERE blog_id=$blog_id AND zid=$ad_result->zone_id").'</td>';
					if ( $ad_result->b_url != '' ) {
						echo '<td><div style="height:60px;width:180px;overflow:hidden;" title="'.stripslashes($ad_result->link).'">'.stripslashes($ad_result->link).'</div></td>';
						echo '<td><div style="height:30px;width:auto;"><img src="'.stripslashes($ad_result->b_url).'" alt="'.stripslashes($ad_result->b_url).'" height="30px" width="auto" /></div></td>';
					}else{
						echo '<td>SCRIPT-BASED AD</td>';
						echo '<td><div style="height:40px;width:auto;">'.stripslashes($ad_result->s_link).'</div></td>';
					}
					echo '</tr>'."\n";
				}
			} else {
				echo '<tr><td colspan="7"><b>No Sponsor Ads Found.</b></td>';
			}
		}
	} else {
		echo '<tr><td colspan="7"><b>No Sponsor Ads Found.</b></td>';
	}
	echo '</tbody></table></div>';
	echo '<div style="border-top:1px solid #E0E0FF;"><p>Banner Ads represent the image- or script-based advertisement for a specific site or product. Script-based Ads are usually obtained through Google, Amazon, etc. Image-based Ads have preference over any Script-based Ad definition. If both Image- and Script-based Ads are defined, the Image-based Ad is used.</p><p>Each site or product, however, may have one or more ads based on your program type participation. For example, you may have elected to participate in a &quot;Pay Per Sale&quot; program and a &quot;Revenue Sharing&quot; program for a specific product. Subsequently, each program type has a unique URL. You must define a Banner Ad for each program type you wish to display in the specified zone.</p>
	<p><b>Note:</b> If you are using WordPress<span style="font-size:12pt;">&#181;</span>, the Banner Ads apply to the currently active blog only. Banner Ads are Category dependent to prevent, for example, an ad for audio components appearing in a cooking utensil category. Unless, of course, that is what you intend. Script-based Ads, however, are determined by the sponsor. Therefore, you should select all categories when defining a script-based ad.</p>';
	cd_ad_admin_footer();
	echo '</div>';

}

